/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.MotionLayout;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.CharBuffer;

public class Debug {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpLayoutParams(ViewGroup.LayoutParams object, String string2) {
        Object object2 = new Throwable().getStackTrace()[1];
        Object object3 = new StringBuilder();
        ((StringBuilder)object3).append(".(");
        ((StringBuilder)object3).append(((StackTraceElement)object2).getFileName());
        ((StringBuilder)object3).append(":");
        ((StringBuilder)object3).append(((StackTraceElement)object2).getLineNumber());
        ((StringBuilder)object3).append(") ");
        ((StringBuilder)object3).append(string2);
        ((StringBuilder)object3).append("  ");
        string2 = ((StringBuilder)object3).toString();
        object2 = System.out;
        object3 = new StringBuilder();
        ((StringBuilder)object3).append(" >>>>>>>>>>>>>>>>>>. dump ");
        ((StringBuilder)object3).append(string2);
        ((StringBuilder)object3).append("  ");
        ((StringBuilder)object3).append(object.getClass().getName());
        ((PrintStream)object2).println(((StringBuilder)object3).toString());
        object2 = object.getClass().getFields();
        int n = 0;
        while (true) {
            if (n >= ((Field[])object2).length) {
                object = System.out;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append(" <<<<<<<<<<<<<<<<< dump ");
                ((StringBuilder)object2).append(string2);
                ((PrintStream)object).println(((StringBuilder)object2).toString());
                return;
            }
            Object object4 = object2[n];
            try {
                object3 = ((Field)object4).get(object);
                String string3 = ((Field)object4).getName();
                if (string3.contains("To") && !object3.toString().equals("-1")) {
                    PrintStream printStream = System.out;
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append(string2);
                    ((StringBuilder)object4).append("       ");
                    ((StringBuilder)object4).append(string3);
                    ((StringBuilder)object4).append(" ");
                    ((StringBuilder)object4).append(object3);
                    printStream.println(((StringBuilder)object4).toString());
                }
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpLayoutParams(ViewGroup viewGroup, String string2) {
        Field[] fieldArray = new Throwable().getStackTrace()[1];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".(");
        stringBuilder.append(fieldArray.getFileName());
        stringBuilder.append(":");
        stringBuilder.append(fieldArray.getLineNumber());
        stringBuilder.append(") ");
        stringBuilder.append(string2);
        stringBuilder.append("  ");
        String string3 = stringBuilder.toString();
        int n = viewGroup.getChildCount();
        fieldArray = System.out;
        Appendable appendable = new StringBuilder();
        ((StringBuilder)appendable).append(string2);
        ((StringBuilder)appendable).append(" children ");
        ((StringBuilder)appendable).append(n);
        fieldArray.println(((StringBuilder)appendable).toString());
        int n2 = 0;
        block2: while (n2 < n) {
            string2 = viewGroup.getChildAt(n2);
            fieldArray = System.out;
            appendable = new StringBuilder();
            ((StringBuilder)appendable).append(string3);
            ((StringBuilder)appendable).append("     ");
            ((StringBuilder)appendable).append(Debug.getName((View)string2));
            fieldArray.println(((StringBuilder)appendable).toString());
            string2 = string2.getLayoutParams();
            fieldArray = string2.getClass().getFields();
            int n3 = 0;
            while (true) {
                block7: {
                    if (n3 < fieldArray.length) {
                        Field field = fieldArray[n3];
                        Object object = field.get(string2);
                        if (field.getName().contains("To") && !object.toString().equals("-1")) {
                            appendable = System.out;
                            StringBuilder stringBuilder2 = new StringBuilder();
                            stringBuilder2.append(string3);
                            stringBuilder2.append("       ");
                            stringBuilder2.append(field.getName());
                            stringBuilder2.append(" ");
                            stringBuilder2.append(object);
                            ((PrintStream)appendable).println(stringBuilder2.toString());
                        }
                        break block7;
                    }
                    ++n2;
                    continue block2;
                    catch (IllegalAccessException illegalAccessException) {}
                }
                ++n3;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void dumpPoc(Object object) {
        Object object2 = new Throwable().getStackTrace()[1];
        Serializable serializable = new StringBuilder();
        ((StringBuilder)serializable).append(".(");
        ((StringBuilder)serializable).append(((StackTraceElement)object2).getFileName());
        ((StringBuilder)serializable).append(":");
        ((StringBuilder)serializable).append(((StackTraceElement)object2).getLineNumber());
        ((StringBuilder)serializable).append(")");
        object2 = ((StringBuilder)serializable).toString();
        serializable = object.getClass();
        PrintStream printStream = System.out;
        Object object3 = new StringBuilder();
        ((StringBuilder)object3).append((String)object2);
        ((StringBuilder)object3).append("------------- ");
        ((StringBuilder)object3).append(((Class)serializable).getName());
        ((StringBuilder)object3).append(" --------------------");
        printStream.println(((StringBuilder)object3).toString());
        object3 = ((Class)serializable).getFields();
        int n = 0;
        while (true) {
            if (n >= ((Field[])object3).length) {
                object3 = System.out;
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append("------------- ");
                ((StringBuilder)object).append(((Class)serializable).getSimpleName());
                ((StringBuilder)object).append(" --------------------");
                ((PrintStream)object3).println(((StringBuilder)object).toString());
                return;
            }
            Field field = object3[n];
            try {
                Object object4 = field.get(object);
                if (!(!field.getName().startsWith("layout_constraint") || object4 instanceof Integer && object4.toString().equals("-1") || object4 instanceof Integer && object4.toString().equals("0") || object4 instanceof Float && object4.toString().equals("1.0") || object4 instanceof Float && object4.toString().equals("0.5"))) {
                    printStream = System.out;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append((String)object2);
                    stringBuilder.append("    ");
                    stringBuilder.append(field.getName());
                    stringBuilder.append(" ");
                    stringBuilder.append(object4);
                    printStream.println(stringBuilder.toString());
                }
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getActionType(MotionEvent fieldArray) {
        int n = fieldArray.getAction();
        fieldArray = MotionEvent.class.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            try {
                if (Modifier.isStatic(field.getModifiers()) && field.getType().equals(Integer.TYPE) && field.getInt(null) == n) {
                    return field.getName();
                }
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++n2;
        }
        return "---";
    }

    public static String getCallFrom(int n) {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[n + 2];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".(");
        stringBuilder.append(stackTraceElement.getFileName());
        stringBuilder.append(":");
        stringBuilder.append(stackTraceElement.getLineNumber());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getLoc() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".(");
        stringBuilder.append(stackTraceElement.getFileName());
        stringBuilder.append(":");
        stringBuilder.append(stackTraceElement.getLineNumber());
        stringBuilder.append(") ");
        stringBuilder.append(stackTraceElement.getMethodName());
        stringBuilder.append("()");
        return stringBuilder.toString();
    }

    public static String getLocation() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".(");
        stringBuilder.append(stackTraceElement.getFileName());
        stringBuilder.append(":");
        stringBuilder.append(stackTraceElement.getLineNumber());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public static String getLocation2() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[2];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(".(");
        stringBuilder.append(stackTraceElement.getFileName());
        stringBuilder.append(":");
        stringBuilder.append(stackTraceElement.getLineNumber());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getName(Context context, int n) {
        if (n == -1) return "UNKNOWN";
        try {
            return context.getResources().getResourceEntryName(n);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("?");
            stringBuilder.append(n);
            return stringBuilder.toString();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getName(Context object, int[] nArray) {
        CharSequence charSequence;
        try {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(nArray.length);
            ((StringBuilder)charSequence).append("[");
            charSequence = ((StringBuilder)charSequence).toString();
            for (int i = 0; i < nArray.length; ++i) {
                CharSequence charSequence2 = new StringBuilder();
                charSequence2.append((String)charSequence);
                charSequence = i == 0 ? "" : " ";
                charSequence2.append((String)charSequence);
                charSequence2 = charSequence2.toString();
                try {
                    charSequence = object.getResources().getResourceEntryName(nArray[i]);
                }
                catch (Resources.NotFoundException notFoundException) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("? ");
                    ((StringBuilder)charSequence).append(nArray[i]);
                    ((StringBuilder)charSequence).append(" ");
                    charSequence = ((StringBuilder)charSequence).toString();
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence2);
                stringBuilder.append((String)charSequence);
                charSequence = stringBuilder.toString();
            }
        }
        catch (Exception exception) {
            Log.v((String)"DEBUG", (String)exception.toString());
            return "UNKNOWN";
        }
        {
            object = new StringBuilder();
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append("]");
            return ((StringBuilder)object).toString();
        }
    }

    public static String getName(View object) {
        try {
            object = object.getContext().getResources().getResourceEntryName(object.getId());
            return object;
        }
        catch (Exception exception) {
            return "UNKNOWN";
        }
    }

    public static String getState(MotionLayout motionLayout, int n) {
        return Debug.getState(motionLayout, n, -1);
    }

    public static String getState(MotionLayout object, int n, int n2) {
        if (n == -1) {
            return "UNDEFINED";
        }
        String string2 = object.getContext().getResources().getResourceEntryName(n);
        Object object2 = string2;
        if (n2 != -1) {
            object = string2;
            if (string2.length() > n2) {
                object = string2.replaceAll("([^_])[aeiou]+", "$1");
            }
            object2 = object;
            if (((String)object).length() > n2) {
                n = ((String)object).replaceAll("[^_]", "").length();
                object2 = object;
                if (n > 0) {
                    n = (((String)object).length() - n2) / n;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(CharBuffer.allocate(n).toString().replace('\u0000', '.'));
                    ((StringBuilder)object2).append("_");
                    object2 = ((String)object).replaceAll(((StringBuilder)object2).toString(), "_");
                }
            }
        }
        return object2;
    }

    public static void logStack(String string2, String string3, int n) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n2 = stackTraceElementArray.length;
        int n3 = 1;
        n2 = Math.min(n, n2 - 1);
        String string4 = " ";
        for (n = n3; n <= n2; ++n) {
            Object object = stackTraceElementArray[n];
            object = new StringBuilder();
            ((StringBuilder)object).append(".(");
            ((StringBuilder)object).append(stackTraceElementArray[n].getFileName());
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(stackTraceElementArray[n].getLineNumber());
            ((StringBuilder)object).append(") ");
            ((StringBuilder)object).append(stackTraceElementArray[n].getMethodName());
            object = ((StringBuilder)object).toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string4);
            stringBuilder.append(" ");
            string4 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(string3);
            stringBuilder.append(string4);
            stringBuilder.append((String)object);
            stringBuilder.append(string4);
            Log.v((String)string2, (String)stringBuilder.toString());
        }
    }

    public static void printStack(String string2, int n) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n2 = stackTraceElementArray.length;
        int n3 = 1;
        n2 = Math.min(n, n2 - 1);
        String string3 = " ";
        for (n = n3; n <= n2; ++n) {
            Object object = stackTraceElementArray[n];
            object = new StringBuilder();
            ((StringBuilder)object).append(".(");
            ((StringBuilder)object).append(stackTraceElementArray[n].getFileName());
            ((StringBuilder)object).append(":");
            ((StringBuilder)object).append(stackTraceElementArray[n].getLineNumber());
            ((StringBuilder)object).append(") ");
            object = ((StringBuilder)object).toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string3);
            stringBuilder.append(" ");
            string3 = stringBuilder.toString();
            PrintStream printStream = System.out;
            stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(string3);
            stringBuilder.append((String)object);
            stringBuilder.append(string3);
            printStream.println(stringBuilder.toString());
        }
    }
}

