/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.motion.utils.ViewOscillator;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;
import java.util.HashSet;

public class KeyCycle
extends Key {
    public static final int KEY_TYPE = 4;
    static final String NAME = "KeyCycle";
    public static final int SHAPE_BOUNCE = 6;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    private static final String TAG = "KeyCycle";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_PHASE = "wavePhase";
    public static final String WAVE_SHAPE = "waveShape";
    private float mAlpha;
    private int mCurveFit = 0;
    private String mCustomWaveShape = null;
    private float mElevation;
    private float mProgress;
    private float mRotation;
    private float mRotationX;
    private float mRotationY;
    private float mScaleX;
    private float mScaleY;
    private String mTransitionEasing = null;
    private float mTransitionPathRotate;
    private float mTranslationX;
    private float mTranslationY;
    private float mTranslationZ;
    private float mWaveOffset = 0.0f;
    private float mWavePeriod = Float.NaN;
    private float mWavePhase = 0.0f;
    private int mWaveShape = -1;
    private int mWaveVariesBy = -1;

    public KeyCycle() {
        this.mProgress = Float.NaN;
        this.mAlpha = Float.NaN;
        this.mElevation = Float.NaN;
        this.mRotation = Float.NaN;
        this.mTransitionPathRotate = Float.NaN;
        this.mRotationX = Float.NaN;
        this.mRotationY = Float.NaN;
        this.mScaleX = Float.NaN;
        this.mScaleY = Float.NaN;
        this.mTranslationX = Float.NaN;
        this.mTranslationY = Float.NaN;
        this.mTranslationZ = Float.NaN;
        this.mType = 4;
        this.mCustomConstraints = new HashMap();
    }

    static /* synthetic */ float access$1002(KeyCycle keyCycle, float f) {
        keyCycle.mRotation = f;
        return f;
    }

    static /* synthetic */ String access$102(KeyCycle keyCycle, String string2) {
        keyCycle.mTransitionEasing = string2;
        return string2;
    }

    static /* synthetic */ float access$1102(KeyCycle keyCycle, float f) {
        keyCycle.mRotationX = f;
        return f;
    }

    static /* synthetic */ float access$1202(KeyCycle keyCycle, float f) {
        keyCycle.mRotationY = f;
        return f;
    }

    static /* synthetic */ float access$1302(KeyCycle keyCycle, float f) {
        keyCycle.mTransitionPathRotate = f;
        return f;
    }

    static /* synthetic */ float access$1402(KeyCycle keyCycle, float f) {
        keyCycle.mScaleX = f;
        return f;
    }

    static /* synthetic */ float access$1502(KeyCycle keyCycle, float f) {
        keyCycle.mScaleY = f;
        return f;
    }

    static /* synthetic */ float access$1602(KeyCycle keyCycle, float f) {
        keyCycle.mTranslationX = f;
        return f;
    }

    static /* synthetic */ float access$1702(KeyCycle keyCycle, float f) {
        keyCycle.mTranslationY = f;
        return f;
    }

    static /* synthetic */ float access$1802(KeyCycle keyCycle, float f) {
        keyCycle.mTranslationZ = f;
        return f;
    }

    static /* synthetic */ float access$1902(KeyCycle keyCycle, float f) {
        keyCycle.mProgress = f;
        return f;
    }

    static /* synthetic */ float access$2002(KeyCycle keyCycle, float f) {
        keyCycle.mWavePhase = f;
        return f;
    }

    static /* synthetic */ int access$202(KeyCycle keyCycle, int n) {
        keyCycle.mCurveFit = n;
        return n;
    }

    static /* synthetic */ String access$302(KeyCycle keyCycle, String string2) {
        keyCycle.mCustomWaveShape = string2;
        return string2;
    }

    static /* synthetic */ int access$402(KeyCycle keyCycle, int n) {
        keyCycle.mWaveShape = n;
        return n;
    }

    static /* synthetic */ float access$502(KeyCycle keyCycle, float f) {
        keyCycle.mWavePeriod = f;
        return f;
    }

    static /* synthetic */ float access$602(KeyCycle keyCycle, float f) {
        keyCycle.mWaveOffset = f;
        return f;
    }

    static /* synthetic */ int access$702(KeyCycle keyCycle, int n) {
        keyCycle.mWaveVariesBy = n;
        return n;
    }

    static /* synthetic */ float access$802(KeyCycle keyCycle, float f) {
        keyCycle.mAlpha = f;
        return f;
    }

    static /* synthetic */ float access$902(KeyCycle keyCycle, float f) {
        keyCycle.mElevation = f;
        return f;
    }

    public void addCycleValues(HashMap<String, ViewOscillator> hashMap) {
        for (String string2 : hashMap.keySet()) {
            ViewOscillator viewOscillator;
            if (string2.startsWith("CUSTOM")) {
                ViewOscillator viewOscillator2;
                Object object = string2.substring(7);
                if ((object = (ConstraintAttribute)this.mCustomConstraints.get(object)) == null || ((ConstraintAttribute)object).getType() != ConstraintAttribute.AttributeType.FLOAT_TYPE || (viewOscillator2 = hashMap.get(string2)) == null) continue;
                viewOscillator2.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, this.mWaveVariesBy, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, ((ConstraintAttribute)object).getValueToInterpolate(), object);
                continue;
            }
            float f = this.getValue(string2);
            if (Float.isNaN(f) || (viewOscillator = hashMap.get(string2)) == null) continue;
            viewOscillator.setPoint(this.mFramePosition, this.mWaveShape, this.mCustomWaveShape, this.mWaveVariesBy, this.mWavePeriod, this.mWaveOffset, this.mWavePhase, f);
        }
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> hashMap) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("add ");
        stringBuilder.append(hashMap.size());
        stringBuilder.append(" values");
        Debug.logStack("KeyCycle", stringBuilder.toString(), 2);
        block32: for (String string2 : hashMap.keySet()) {
            Object object = hashMap.get(string2);
            if (object == null) continue;
            string2.hashCode();
            int n = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 1530034690: {
                    if (!string2.equals(WAVE_PHASE)) break;
                    n = 13;
                    break;
                }
                case 156108012: {
                    if (!string2.equals(WAVE_OFFSET)) break;
                    n = 12;
                    break;
                }
                case 92909918: {
                    if (!string2.equals("alpha")) break;
                    n = 11;
                    break;
                }
                case 37232917: {
                    if (!string2.equals("transitionPathRotate")) break;
                    n = 10;
                    break;
                }
                case -4379043: {
                    if (!string2.equals("elevation")) break;
                    n = 9;
                    break;
                }
                case -40300674: {
                    if (!string2.equals("rotation")) break;
                    n = 8;
                    break;
                }
                case -908189617: {
                    if (!string2.equals("scaleY")) break;
                    n = 7;
                    break;
                }
                case -908189618: {
                    if (!string2.equals("scaleX")) break;
                    n = 6;
                    break;
                }
                case -1001078227: {
                    if (!string2.equals("progress")) break;
                    n = 5;
                    break;
                }
                case -1225497655: {
                    if (!string2.equals("translationZ")) break;
                    n = 4;
                    break;
                }
                case -1225497656: {
                    if (!string2.equals("translationY")) break;
                    n = 3;
                    break;
                }
                case -1225497657: {
                    if (!string2.equals("translationX")) break;
                    n = 2;
                    break;
                }
                case -1249320805: {
                    if (!string2.equals("rotationY")) break;
                    n = 1;
                    break;
                }
                case -1249320806: {
                    if (!string2.equals("rotationX")) break;
                    n = 0;
                }
            }
            switch (n) {
                default: {
                    if (string2.startsWith("CUSTOM")) continue block32;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("  UNKNOWN  ");
                    ((StringBuilder)object).append(string2);
                    Log.v((String)"WARNING KeyCycle", (String)((StringBuilder)object).toString());
                    continue block32;
                }
                case 13: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mWavePhase);
                    continue block32;
                }
                case 12: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mWaveOffset);
                    continue block32;
                }
                case 11: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mAlpha);
                    continue block32;
                }
                case 10: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mTransitionPathRotate);
                    continue block32;
                }
                case 9: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mElevation);
                    continue block32;
                }
                case 8: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mRotation);
                    continue block32;
                }
                case 7: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mScaleY);
                    continue block32;
                }
                case 6: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mScaleX);
                    continue block32;
                }
                case 5: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mProgress);
                    continue block32;
                }
                case 4: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mTranslationZ);
                    continue block32;
                }
                case 3: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mTranslationY);
                    continue block32;
                }
                case 2: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mTranslationX);
                    continue block32;
                }
                case 1: {
                    ((SplineSet)object).setPoint(this.mFramePosition, this.mRotationY);
                    continue block32;
                }
                case 0: 
            }
            ((SplineSet)object).setPoint(this.mFramePosition, this.mRotationX);
        }
    }

    @Override
    public Key clone() {
        return new KeyCycle().copy(this);
    }

    @Override
    public Key copy(Key key) {
        super.copy(key);
        key = (KeyCycle)key;
        this.mTransitionEasing = ((KeyCycle)key).mTransitionEasing;
        this.mCurveFit = ((KeyCycle)key).mCurveFit;
        this.mWaveShape = ((KeyCycle)key).mWaveShape;
        this.mCustomWaveShape = ((KeyCycle)key).mCustomWaveShape;
        this.mWavePeriod = ((KeyCycle)key).mWavePeriod;
        this.mWaveOffset = ((KeyCycle)key).mWaveOffset;
        this.mWavePhase = ((KeyCycle)key).mWavePhase;
        this.mProgress = ((KeyCycle)key).mProgress;
        this.mWaveVariesBy = ((KeyCycle)key).mWaveVariesBy;
        this.mAlpha = ((KeyCycle)key).mAlpha;
        this.mElevation = ((KeyCycle)key).mElevation;
        this.mRotation = ((KeyCycle)key).mRotation;
        this.mTransitionPathRotate = ((KeyCycle)key).mTransitionPathRotate;
        this.mRotationX = ((KeyCycle)key).mRotationX;
        this.mRotationY = ((KeyCycle)key).mRotationY;
        this.mScaleX = ((KeyCycle)key).mScaleX;
        this.mScaleY = ((KeyCycle)key).mScaleY;
        this.mTranslationX = ((KeyCycle)key).mTranslationX;
        this.mTranslationY = ((KeyCycle)key).mTranslationY;
        this.mTranslationZ = ((KeyCycle)key).mTranslationZ;
        return this;
    }

    @Override
    public void getAttributeNames(HashSet<String> hashSet) {
        if (!Float.isNaN(this.mAlpha)) {
            hashSet.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            hashSet.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            hashSet.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            hashSet.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            hashSet.add("rotationY");
        }
        if (!Float.isNaN(this.mScaleX)) {
            hashSet.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            hashSet.add("scaleY");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            hashSet.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            hashSet.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            hashSet.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            hashSet.add("translationZ");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String string2 : this.mCustomConstraints.keySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CUSTOM,");
                stringBuilder.append(string2);
                hashSet.add(stringBuilder.toString());
            }
        }
    }

    public float getValue(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1530034690: {
                if (!string2.equals(WAVE_PHASE)) break;
                n2 = 13;
                break;
            }
            case 156108012: {
                if (!string2.equals(WAVE_OFFSET)) break;
                n2 = 12;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 11;
                break;
            }
            case 37232917: {
                if (!string2.equals("transitionPathRotate")) break;
                n2 = 10;
                break;
            }
            case -4379043: {
                if (!string2.equals("elevation")) break;
                n2 = 9;
                break;
            }
            case -40300674: {
                if (!string2.equals("rotation")) break;
                n2 = 8;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 7;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 6;
                break;
            }
            case -1001078227: {
                if (!string2.equals("progress")) break;
                n2 = 5;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 4;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 3;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 2;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 1;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                if (!string2.startsWith("CUSTOM")) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("  UNKNOWN  ");
                    stringBuilder.append(string2);
                    Log.v((String)"WARNING! KeyCycle", (String)stringBuilder.toString());
                }
                return Float.NaN;
            }
            case 13: {
                return this.mWavePhase;
            }
            case 12: {
                return this.mWaveOffset;
            }
            case 11: {
                return this.mAlpha;
            }
            case 10: {
                return this.mTransitionPathRotate;
            }
            case 9: {
                return this.mElevation;
            }
            case 8: {
                return this.mRotation;
            }
            case 7: {
                return this.mScaleY;
            }
            case 6: {
                return this.mScaleX;
            }
            case 5: {
                return this.mProgress;
            }
            case 4: {
                return this.mTranslationZ;
            }
            case 3: {
                return this.mTranslationY;
            }
            case 2: {
                return this.mTranslationX;
            }
            case 1: {
                return this.mRotationY;
            }
            case 0: 
        }
        return this.mRotationX;
    }

    @Override
    public void load(Context context, AttributeSet attributeSet) {
        Loader.read(this, context.obtainStyledAttributes(attributeSet, R.styleable.KeyCycle));
    }

    @Override
    public void setValue(String string2, Object object) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1532805160: {
                if (!string2.equals(WAVE_SHAPE)) break;
                n2 = 17;
                break;
            }
            case 1530034690: {
                if (!string2.equals(WAVE_PHASE)) break;
                n2 = 16;
                break;
            }
            case 579057826: {
                if (!string2.equals("curveFit")) break;
                n2 = 15;
                break;
            }
            case 184161818: {
                if (!string2.equals(WAVE_PERIOD)) break;
                n2 = 14;
                break;
            }
            case 156108012: {
                if (!string2.equals(WAVE_OFFSET)) break;
                n2 = 13;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 12;
                break;
            }
            case 37232917: {
                if (!string2.equals("transitionPathRotate")) break;
                n2 = 11;
                break;
            }
            case -4379043: {
                if (!string2.equals("elevation")) break;
                n2 = 10;
                break;
            }
            case -40300674: {
                if (!string2.equals("rotation")) break;
                n2 = 9;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 8;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 7;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 6;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 5;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 4;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 3;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 2;
                break;
            }
            case -1812823328: {
                if (!string2.equals("transitionEasing")) break;
                n2 = 1;
                break;
            }
            case -1913008125: {
                if (!string2.equals("motionProgress")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 17: {
                if (object instanceof Integer) {
                    this.mWaveShape = this.toInt(object);
                    break;
                }
                this.mWaveShape = 7;
                this.mCustomWaveShape = object.toString();
                break;
            }
            case 16: {
                this.mWavePhase = this.toFloat(object);
                break;
            }
            case 15: {
                this.mCurveFit = this.toInt(object);
                break;
            }
            case 14: {
                this.mWavePeriod = this.toFloat(object);
                break;
            }
            case 13: {
                this.mWaveOffset = this.toFloat(object);
                break;
            }
            case 12: {
                this.mAlpha = this.toFloat(object);
                break;
            }
            case 11: {
                this.mTransitionPathRotate = this.toFloat(object);
                break;
            }
            case 10: {
                this.mElevation = this.toFloat(object);
                break;
            }
            case 9: {
                this.mRotation = this.toFloat(object);
                break;
            }
            case 8: {
                this.mScaleY = this.toFloat(object);
                break;
            }
            case 7: {
                this.mScaleX = this.toFloat(object);
                break;
            }
            case 6: {
                this.mTranslationZ = this.toFloat(object);
                break;
            }
            case 5: {
                this.mTranslationY = this.toFloat(object);
                break;
            }
            case 4: {
                this.mTranslationX = this.toFloat(object);
                break;
            }
            case 3: {
                this.mRotationY = this.toFloat(object);
                break;
            }
            case 2: {
                this.mRotationX = this.toFloat(object);
                break;
            }
            case 1: {
                this.mTransitionEasing = object.toString();
                break;
            }
            case 0: {
                this.mProgress = this.toFloat(object);
            }
        }
    }

    private static class Loader {
        private static final int ANDROID_ALPHA = 9;
        private static final int ANDROID_ELEVATION = 10;
        private static final int ANDROID_ROTATION = 11;
        private static final int ANDROID_ROTATION_X = 12;
        private static final int ANDROID_ROTATION_Y = 13;
        private static final int ANDROID_SCALE_X = 15;
        private static final int ANDROID_SCALE_Y = 16;
        private static final int ANDROID_TRANSLATION_X = 17;
        private static final int ANDROID_TRANSLATION_Y = 18;
        private static final int ANDROID_TRANSLATION_Z = 19;
        private static final int CURVE_FIT = 4;
        private static final int FRAME_POSITION = 2;
        private static final int PROGRESS = 20;
        private static final int TARGET_ID = 1;
        private static final int TRANSITION_EASING = 3;
        private static final int TRANSITION_PATH_ROTATE = 14;
        private static final int WAVE_OFFSET = 7;
        private static final int WAVE_PERIOD = 6;
        private static final int WAVE_PHASE = 21;
        private static final int WAVE_SHAPE = 5;
        private static final int WAVE_VARIES_BY = 8;
        private static SparseIntArray mAttrMap;

        static {
            SparseIntArray sparseIntArray;
            mAttrMap = sparseIntArray = new SparseIntArray();
            sparseIntArray.append(R.styleable.KeyCycle_motionTarget, 1);
            mAttrMap.append(R.styleable.KeyCycle_framePosition, 2);
            mAttrMap.append(R.styleable.KeyCycle_transitionEasing, 3);
            mAttrMap.append(R.styleable.KeyCycle_curveFit, 4);
            mAttrMap.append(R.styleable.KeyCycle_waveShape, 5);
            mAttrMap.append(R.styleable.KeyCycle_wavePeriod, 6);
            mAttrMap.append(R.styleable.KeyCycle_waveOffset, 7);
            mAttrMap.append(R.styleable.KeyCycle_waveVariesBy, 8);
            mAttrMap.append(R.styleable.KeyCycle_android_alpha, 9);
            mAttrMap.append(R.styleable.KeyCycle_android_elevation, 10);
            mAttrMap.append(R.styleable.KeyCycle_android_rotation, 11);
            mAttrMap.append(R.styleable.KeyCycle_android_rotationX, 12);
            mAttrMap.append(R.styleable.KeyCycle_android_rotationY, 13);
            mAttrMap.append(R.styleable.KeyCycle_transitionPathRotate, 14);
            mAttrMap.append(R.styleable.KeyCycle_android_scaleX, 15);
            mAttrMap.append(R.styleable.KeyCycle_android_scaleY, 16);
            mAttrMap.append(R.styleable.KeyCycle_android_translationX, 17);
            mAttrMap.append(R.styleable.KeyCycle_android_translationY, 18);
            mAttrMap.append(R.styleable.KeyCycle_android_translationZ, 19);
            mAttrMap.append(R.styleable.KeyCycle_motionProgress, 20);
            mAttrMap.append(R.styleable.KeyCycle_wavePhase, 21);
        }

        private Loader() {
        }

        private static void read(KeyCycle keyCycle, TypedArray typedArray) {
            int n = typedArray.getIndexCount();
            block23: for (int i = 0; i < n; ++i) {
                int n2 = typedArray.getIndex(i);
                switch (mAttrMap.get(n2)) {
                    default: {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("unused attribute 0x");
                        stringBuilder.append(Integer.toHexString(n2));
                        stringBuilder.append("   ");
                        stringBuilder.append(mAttrMap.get(n2));
                        Log.e((String)"KeyCycle", (String)stringBuilder.toString());
                        continue block23;
                    }
                    case 21: {
                        KeyCycle.access$2002(keyCycle, typedArray.getFloat(n2, keyCycle.mWavePhase) / 360.0f);
                        continue block23;
                    }
                    case 20: {
                        KeyCycle.access$1902(keyCycle, typedArray.getFloat(n2, keyCycle.mProgress));
                        continue block23;
                    }
                    case 19: {
                        if (Build.VERSION.SDK_INT < 21) continue block23;
                        KeyCycle.access$1802(keyCycle, typedArray.getDimension(n2, keyCycle.mTranslationZ));
                        continue block23;
                    }
                    case 18: {
                        KeyCycle.access$1702(keyCycle, typedArray.getDimension(n2, keyCycle.mTranslationY));
                        continue block23;
                    }
                    case 17: {
                        KeyCycle.access$1602(keyCycle, typedArray.getDimension(n2, keyCycle.mTranslationX));
                        continue block23;
                    }
                    case 16: {
                        KeyCycle.access$1502(keyCycle, typedArray.getFloat(n2, keyCycle.mScaleY));
                        continue block23;
                    }
                    case 15: {
                        KeyCycle.access$1402(keyCycle, typedArray.getFloat(n2, keyCycle.mScaleX));
                        continue block23;
                    }
                    case 14: {
                        KeyCycle.access$1302(keyCycle, typedArray.getFloat(n2, keyCycle.mTransitionPathRotate));
                        continue block23;
                    }
                    case 13: {
                        KeyCycle.access$1202(keyCycle, typedArray.getFloat(n2, keyCycle.mRotationY));
                        continue block23;
                    }
                    case 12: {
                        KeyCycle.access$1102(keyCycle, typedArray.getFloat(n2, keyCycle.mRotationX));
                        continue block23;
                    }
                    case 11: {
                        KeyCycle.access$1002(keyCycle, typedArray.getFloat(n2, keyCycle.mRotation));
                        continue block23;
                    }
                    case 10: {
                        KeyCycle.access$902(keyCycle, typedArray.getDimension(n2, keyCycle.mElevation));
                        continue block23;
                    }
                    case 9: {
                        KeyCycle.access$802(keyCycle, typedArray.getFloat(n2, keyCycle.mAlpha));
                        continue block23;
                    }
                    case 8: {
                        KeyCycle.access$702(keyCycle, typedArray.getInt(n2, keyCycle.mWaveVariesBy));
                        continue block23;
                    }
                    case 7: {
                        if (typedArray.peekValue((int)n2).type == 5) {
                            KeyCycle.access$602(keyCycle, typedArray.getDimension(n2, keyCycle.mWaveOffset));
                            continue block23;
                        }
                        KeyCycle.access$602(keyCycle, typedArray.getFloat(n2, keyCycle.mWaveOffset));
                        continue block23;
                    }
                    case 6: {
                        KeyCycle.access$502(keyCycle, typedArray.getFloat(n2, keyCycle.mWavePeriod));
                        continue block23;
                    }
                    case 5: {
                        if (typedArray.peekValue((int)n2).type == 3) {
                            KeyCycle.access$302(keyCycle, typedArray.getString(n2));
                            KeyCycle.access$402(keyCycle, 7);
                            continue block23;
                        }
                        KeyCycle.access$402(keyCycle, typedArray.getInt(n2, keyCycle.mWaveShape));
                        continue block23;
                    }
                    case 4: {
                        KeyCycle.access$202(keyCycle, typedArray.getInteger(n2, keyCycle.mCurveFit));
                        continue block23;
                    }
                    case 3: {
                        KeyCycle.access$102(keyCycle, typedArray.getString(n2));
                        continue block23;
                    }
                    case 2: {
                        keyCycle.mFramePosition = typedArray.getInt(n2, keyCycle.mFramePosition);
                        continue block23;
                    }
                    case 1: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            keyCycle.mTargetId = typedArray.getResourceId(n2, keyCycle.mTargetId);
                            if (keyCycle.mTargetId != -1) continue block23;
                            keyCycle.mTargetString = typedArray.getString(n2);
                            continue block23;
                        }
                        if (typedArray.peekValue((int)n2).type == 3) {
                            keyCycle.mTargetString = typedArray.getString(n2);
                            continue block23;
                        }
                        keyCycle.mTargetId = typedArray.getResourceId(n2, keyCycle.mTargetId);
                    }
                }
            }
        }
    }
}

