/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.util.Log;
import android.util.Xml;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyAttributes;
import androidx.constraintlayout.motion.widget.KeyCycle;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.KeyTimeCycle;
import androidx.constraintlayout.motion.widget.KeyTrigger;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintLayout;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class KeyFrames {
    private static final String CUSTOM_ATTRIBUTE = "CustomAttribute";
    private static final String CUSTOM_METHOD = "CustomMethod";
    private static final String TAG = "KeyFrames";
    public static final int UNSET = -1;
    static HashMap<String, Constructor<? extends Key>> sKeyMakers;
    private HashMap<Integer, ArrayList<Key>> mFramesMap = new HashMap();

    static {
        HashMap hashMap = new HashMap();
        sKeyMakers = hashMap;
        try {
            hashMap.put("KeyAttribute", KeyAttributes.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyPosition", KeyPosition.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyCycle", KeyCycle.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyTimeCycle", KeyTimeCycle.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyTrigger", KeyTrigger.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)TAG, (String)"unable to load", (Throwable)noSuchMethodException);
        }
    }

    public KeyFrames() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyFrames(Context context, XmlPullParser xmlPullParser) {
        Constructor<? extends Key> constructor = null;
        try {
            int n = xmlPullParser.getEventType();
            while (n != 1) {
                Constructor<? extends Key> constructor2;
                block17: {
                    Object object;
                    block23: {
                        block22: {
                            block19: {
                                block20: {
                                    block18: {
                                        block21: {
                                            if (n == 2) break block21;
                                            if (n != 3) {
                                                constructor2 = constructor;
                                                break block17;
                                            } else {
                                                constructor2 = constructor;
                                                if ("KeyFrameSet".equals(xmlPullParser.getName())) {
                                                    return;
                                                }
                                            }
                                            break block17;
                                        }
                                        object = xmlPullParser.getName();
                                        boolean bl = sKeyMakers.containsKey(object);
                                        if (!bl) break block22;
                                        constructor2 = sKeyMakers.get(object);
                                        if (constructor2 == null) break block18;
                                        constructor2 = constructor2.newInstance(new Object[0]);
                                        try {
                                            ((Key)((Object)constructor2)).load(context, Xml.asAttributeSet((XmlPullParser)xmlPullParser));
                                            this.addKey((Key)((Object)constructor2));
                                            constructor = constructor2;
                                            break block19;
                                        }
                                        catch (Exception exception) {
                                            constructor = constructor2;
                                            break block20;
                                        }
                                    }
                                    try {
                                        constructor2 = new Constructor<Key>();
                                        ((StringBuilder)((Object)constructor2)).append("Keymaker for ");
                                        ((StringBuilder)((Object)constructor2)).append((String)object);
                                        ((StringBuilder)((Object)constructor2)).append(" not found");
                                        NullPointerException nullPointerException = new NullPointerException(((StringBuilder)((Object)constructor2)).toString());
                                        throw nullPointerException;
                                    }
                                    catch (Exception exception) {
                                        object = exception;
                                    }
                                }
                                Log.e((String)TAG, (String)"unable to create ", (Throwable)object);
                            }
                            constructor2 = constructor;
                            break block17;
                        }
                        if (!((String)object).equalsIgnoreCase(CUSTOM_ATTRIBUTE)) break block23;
                        constructor2 = constructor;
                        if (constructor != null) {
                            constructor2 = constructor;
                            if (((Key)((Object)constructor)).mCustomConstraints != null) {
                                ConstraintAttribute.parse(context, xmlPullParser, ((Key)((Object)constructor)).mCustomConstraints);
                                constructor2 = constructor;
                            }
                        }
                        break block17;
                    }
                    constructor2 = constructor;
                    if (((String)object).equalsIgnoreCase(CUSTOM_METHOD)) {
                        constructor2 = constructor;
                        if (constructor != null) {
                            constructor2 = constructor;
                            if (((Key)((Object)constructor)).mCustomConstraints != null) {
                                ConstraintAttribute.parse(context, xmlPullParser, ((Key)((Object)constructor)).mCustomConstraints);
                                constructor2 = constructor;
                            }
                        }
                    }
                }
                n = xmlPullParser.next();
                constructor = constructor2;
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    static String name(int n, Context context) {
        return context.getResources().getResourceEntryName(n);
    }

    public void addAllFrames(MotionController motionController) {
        ArrayList<Key> arrayList = this.mFramesMap.get(-1);
        if (arrayList != null) {
            motionController.addKeys(arrayList);
        }
    }

    public void addFrames(MotionController motionController) {
        ArrayList<Key> arrayList = this.mFramesMap.get(motionController.mId);
        if (arrayList != null) {
            motionController.addKeys(arrayList);
        }
        if ((arrayList = this.mFramesMap.get(-1)) != null) {
            for (Key key : arrayList) {
                if (!key.matches(((ConstraintLayout.LayoutParams)motionController.mView.getLayoutParams()).constraintTag)) continue;
                motionController.addKey(key);
            }
        }
    }

    public void addKey(Key key) {
        ArrayList<Key> arrayList;
        if (!this.mFramesMap.containsKey(key.mTargetId)) {
            this.mFramesMap.put(key.mTargetId, new ArrayList());
        }
        if ((arrayList = this.mFramesMap.get(key.mTargetId)) != null) {
            arrayList.add(key);
        }
    }

    public ArrayList<Key> getKeyFramesForView(int n) {
        return this.mFramesMap.get(n);
    }

    public Set<Integer> getKeys() {
        return this.mFramesMap.keySet();
    }
}

