/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import androidx.constraintlayout.core.motion.utils.TimeCycleSplineSet;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.utils.ViewTimeCycle;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class KeyTimeCycle
extends Key {
    public static final int KEY_TYPE = 3;
    static final String NAME = "KeyTimeCycle";
    public static final int SHAPE_BOUNCE = 6;
    public static final int SHAPE_COS_WAVE = 5;
    public static final int SHAPE_REVERSE_SAW_WAVE = 4;
    public static final int SHAPE_SAW_WAVE = 3;
    public static final int SHAPE_SIN_WAVE = 0;
    public static final int SHAPE_SQUARE_WAVE = 1;
    public static final int SHAPE_TRIANGLE_WAVE = 2;
    private static final String TAG = "KeyTimeCycle";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_SHAPE = "waveShape";
    private float mAlpha = Float.NaN;
    private int mCurveFit = -1;
    private String mCustomWaveShape = null;
    private float mElevation = Float.NaN;
    private float mProgress;
    private float mRotation = Float.NaN;
    private float mRotationX = Float.NaN;
    private float mRotationY = Float.NaN;
    private float mScaleX;
    private float mScaleY;
    private String mTransitionEasing;
    private float mTransitionPathRotate = Float.NaN;
    private float mTranslationX;
    private float mTranslationY;
    private float mTranslationZ;
    private float mWaveOffset = 0.0f;
    private float mWavePeriod;
    private int mWaveShape = 0;

    public KeyTimeCycle() {
        this.mScaleX = Float.NaN;
        this.mScaleY = Float.NaN;
        this.mTranslationX = Float.NaN;
        this.mTranslationY = Float.NaN;
        this.mTranslationZ = Float.NaN;
        this.mProgress = Float.NaN;
        this.mWavePeriod = Float.NaN;
        this.mType = 3;
        this.mCustomConstraints = new HashMap();
    }

    static /* synthetic */ float access$002(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mAlpha = f;
        return f;
    }

    static /* synthetic */ float access$1002(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mRotationY = f;
        return f;
    }

    static /* synthetic */ float access$102(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mElevation = f;
        return f;
    }

    static /* synthetic */ String access$1102(KeyTimeCycle keyTimeCycle, String string2) {
        keyTimeCycle.mTransitionEasing = string2;
        return string2;
    }

    static /* synthetic */ float access$1202(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mScaleY = f;
        return f;
    }

    static /* synthetic */ float access$1302(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mTransitionPathRotate = f;
        return f;
    }

    static /* synthetic */ float access$1402(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mTranslationX = f;
        return f;
    }

    static /* synthetic */ float access$1502(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mTranslationY = f;
        return f;
    }

    static /* synthetic */ float access$1602(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mTranslationZ = f;
        return f;
    }

    static /* synthetic */ float access$1702(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mProgress = f;
        return f;
    }

    static /* synthetic */ float access$202(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mRotation = f;
        return f;
    }

    static /* synthetic */ int access$302(KeyTimeCycle keyTimeCycle, int n) {
        keyTimeCycle.mCurveFit = n;
        return n;
    }

    static /* synthetic */ String access$402(KeyTimeCycle keyTimeCycle, String string2) {
        keyTimeCycle.mCustomWaveShape = string2;
        return string2;
    }

    static /* synthetic */ int access$502(KeyTimeCycle keyTimeCycle, int n) {
        keyTimeCycle.mWaveShape = n;
        return n;
    }

    static /* synthetic */ float access$602(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mWavePeriod = f;
        return f;
    }

    static /* synthetic */ float access$702(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mWaveOffset = f;
        return f;
    }

    static /* synthetic */ float access$802(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mScaleX = f;
        return f;
    }

    static /* synthetic */ float access$902(KeyTimeCycle keyTimeCycle, float f) {
        keyTimeCycle.mRotationX = f;
        return f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addTimeValues(HashMap<String, ViewTimeCycle> hashMap) {
        Iterator<String> iterator = hashMap.keySet().iterator();
        block42: while (iterator.hasNext()) {
            String string2 = iterator.next();
            Object object = hashMap.get(string2);
            if (object == null) continue;
            boolean bl = string2.startsWith("CUSTOM");
            int n = 7;
            if (bl) {
                String string3 = string2.substring(7);
                ConstraintAttribute constraintAttribute = (ConstraintAttribute)this.mCustomConstraints.get(string3);
                if (constraintAttribute == null) continue;
                ((ViewTimeCycle.CustomSet)object).setPoint(this.mFramePosition, constraintAttribute, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                continue;
            }
            string2.hashCode();
            int n2 = -1;
            switch (string2.hashCode()) {
                case 92909918: {
                    if (!string2.equals("alpha")) break;
                    n2 = 1;
                    break;
                }
                case 37232917: {
                    if (!string2.equals("transitionPathRotate")) break;
                    n2 = 2;
                    break;
                }
                case -4379043: {
                    if (!string2.equals("elevation")) break;
                    n2 = 3;
                    break;
                }
                case -40300674: {
                    if (!string2.equals("rotation")) break;
                    n2 = 4;
                    break;
                }
                case -908189617: {
                    if (!string2.equals("scaleY")) break;
                    n2 = 5;
                    break;
                }
                case -908189618: {
                    if (!string2.equals("scaleX")) break;
                    n2 = 6;
                    break;
                }
                case -1001078227: {
                    if (!string2.equals("progress")) break;
                    n2 = 7;
                    break;
                }
                case -1225497655: {
                    if (!string2.equals("translationZ")) break;
                    n2 = 8;
                    break;
                }
                case -1225497656: {
                    if (!string2.equals("translationY")) break;
                    n2 = 9;
                    break;
                }
                case -1225497657: {
                    if (!string2.equals("translationX")) break;
                    n2 = 10;
                    break;
                }
                case -1249320805: {
                    if (!string2.equals("rotationY")) break;
                    n2 = 11;
                    break;
                }
                case -1249320806: {
                    if (!string2.equals("rotationX")) break;
                    n2 = 12;
                    break;
                }
            }
            switch (n2) {
                default: {
                    n = -1;
                    break;
                }
                case 1: {
                    n = 11;
                    break;
                }
                case 2: {
                    n = 10;
                    break;
                }
                case 3: {
                    n = 9;
                    break;
                }
                case 4: {
                    n = 8;
                    break;
                }
                case 6: {
                    n = 6;
                    break;
                }
                case 7: {
                    n = 5;
                    break;
                }
                case 8: {
                    n = 4;
                    break;
                }
                case 9: {
                    n = 3;
                    break;
                }
                case 10: {
                    n = 2;
                    break;
                }
                case 11: {
                    n = 1;
                    break;
                }
                case 12: {
                    n = 0;
                    break;
                }
                case 5: 
            }
            switch (n) {
                default: {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("UNKNOWN addValues \"");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("\"");
                    Log.e((String)"KeyTimeCycles", (String)((StringBuilder)object).toString());
                    continue block42;
                }
                case 11: {
                    if (Float.isNaN(this.mAlpha)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mAlpha, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 10: {
                    if (Float.isNaN(this.mTransitionPathRotate)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mTransitionPathRotate, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 9: {
                    if (Float.isNaN(this.mElevation)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mElevation, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 8: {
                    if (Float.isNaN(this.mRotation)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mRotation, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 7: {
                    if (Float.isNaN(this.mScaleY)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mScaleY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 6: {
                    if (Float.isNaN(this.mScaleX)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mScaleX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 5: {
                    if (Float.isNaN(this.mProgress)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mProgress, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 4: {
                    if (Float.isNaN(this.mTranslationZ)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mTranslationZ, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 3: {
                    if (Float.isNaN(this.mTranslationY)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mTranslationY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 2: {
                    if (Float.isNaN(this.mTranslationX)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mTranslationX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 1: {
                    if (Float.isNaN(this.mRotationY)) continue block42;
                    ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mRotationY, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
                    continue block42;
                }
                case 0: 
            }
            if (Float.isNaN(this.mRotationX)) continue;
            ((TimeCycleSplineSet)object).setPoint(this.mFramePosition, this.mRotationX, this.mWavePeriod, this.mWaveShape, this.mWaveOffset);
        }
        return;
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> hashMap) {
        throw new IllegalArgumentException(" KeyTimeCycles do not support SplineSet");
    }

    @Override
    public Key clone() {
        return new KeyTimeCycle().copy(this);
    }

    @Override
    public Key copy(Key key) {
        super.copy(key);
        key = (KeyTimeCycle)key;
        this.mTransitionEasing = ((KeyTimeCycle)key).mTransitionEasing;
        this.mCurveFit = ((KeyTimeCycle)key).mCurveFit;
        this.mWaveShape = ((KeyTimeCycle)key).mWaveShape;
        this.mWavePeriod = ((KeyTimeCycle)key).mWavePeriod;
        this.mWaveOffset = ((KeyTimeCycle)key).mWaveOffset;
        this.mProgress = ((KeyTimeCycle)key).mProgress;
        this.mAlpha = ((KeyTimeCycle)key).mAlpha;
        this.mElevation = ((KeyTimeCycle)key).mElevation;
        this.mRotation = ((KeyTimeCycle)key).mRotation;
        this.mTransitionPathRotate = ((KeyTimeCycle)key).mTransitionPathRotate;
        this.mRotationX = ((KeyTimeCycle)key).mRotationX;
        this.mRotationY = ((KeyTimeCycle)key).mRotationY;
        this.mScaleX = ((KeyTimeCycle)key).mScaleX;
        this.mScaleY = ((KeyTimeCycle)key).mScaleY;
        this.mTranslationX = ((KeyTimeCycle)key).mTranslationX;
        this.mTranslationY = ((KeyTimeCycle)key).mTranslationY;
        this.mTranslationZ = ((KeyTimeCycle)key).mTranslationZ;
        return this;
    }

    @Override
    public void getAttributeNames(HashSet<String> hashSet) {
        if (!Float.isNaN(this.mAlpha)) {
            hashSet.add("alpha");
        }
        if (!Float.isNaN(this.mElevation)) {
            hashSet.add("elevation");
        }
        if (!Float.isNaN(this.mRotation)) {
            hashSet.add("rotation");
        }
        if (!Float.isNaN(this.mRotationX)) {
            hashSet.add("rotationX");
        }
        if (!Float.isNaN(this.mRotationY)) {
            hashSet.add("rotationY");
        }
        if (!Float.isNaN(this.mTranslationX)) {
            hashSet.add("translationX");
        }
        if (!Float.isNaN(this.mTranslationY)) {
            hashSet.add("translationY");
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            hashSet.add("translationZ");
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            hashSet.add("transitionPathRotate");
        }
        if (!Float.isNaN(this.mScaleX)) {
            hashSet.add("scaleX");
        }
        if (!Float.isNaN(this.mScaleY)) {
            hashSet.add("scaleY");
        }
        if (!Float.isNaN(this.mProgress)) {
            hashSet.add("progress");
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String string2 : this.mCustomConstraints.keySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CUSTOM,");
                stringBuilder.append(string2);
                hashSet.add(stringBuilder.toString());
            }
        }
    }

    @Override
    public void load(Context context, AttributeSet attributeSet) {
        Loader.read(this, context.obtainStyledAttributes(attributeSet, R.styleable.KeyTimeCycle));
    }

    @Override
    public void setInterpolation(HashMap<String, Integer> hashMap) {
        if (this.mCurveFit == -1) {
            return;
        }
        if (!Float.isNaN(this.mAlpha)) {
            hashMap.put("alpha", this.mCurveFit);
        }
        if (!Float.isNaN(this.mElevation)) {
            hashMap.put("elevation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotation)) {
            hashMap.put("rotation", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationX)) {
            hashMap.put("rotationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mRotationY)) {
            hashMap.put("rotationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationX)) {
            hashMap.put("translationX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationY)) {
            hashMap.put("translationY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTranslationZ)) {
            hashMap.put("translationZ", this.mCurveFit);
        }
        if (!Float.isNaN(this.mTransitionPathRotate)) {
            hashMap.put("transitionPathRotate", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            hashMap.put("scaleX", this.mCurveFit);
        }
        if (!Float.isNaN(this.mScaleX)) {
            hashMap.put("scaleY", this.mCurveFit);
        }
        if (!Float.isNaN(this.mProgress)) {
            hashMap.put("progress", this.mCurveFit);
        }
        if (this.mCustomConstraints.size() > 0) {
            for (String string2 : this.mCustomConstraints.keySet()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("CUSTOM,");
                stringBuilder.append(string2);
                hashMap.put(stringBuilder.toString(), this.mCurveFit);
            }
        }
    }

    @Override
    public void setValue(String string2, Object object) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1532805160: {
                if (!string2.equals(WAVE_SHAPE)) break;
                n2 = 16;
                break;
            }
            case 579057826: {
                if (!string2.equals("curveFit")) break;
                n2 = 15;
                break;
            }
            case 184161818: {
                if (!string2.equals(WAVE_PERIOD)) break;
                n2 = 14;
                break;
            }
            case 156108012: {
                if (!string2.equals(WAVE_OFFSET)) break;
                n2 = 13;
                break;
            }
            case 92909918: {
                if (!string2.equals("alpha")) break;
                n2 = 12;
                break;
            }
            case 37232917: {
                if (!string2.equals("transitionPathRotate")) break;
                n2 = 11;
                break;
            }
            case -4379043: {
                if (!string2.equals("elevation")) break;
                n2 = 10;
                break;
            }
            case -40300674: {
                if (!string2.equals("rotation")) break;
                n2 = 9;
                break;
            }
            case -908189617: {
                if (!string2.equals("scaleY")) break;
                n2 = 8;
                break;
            }
            case -908189618: {
                if (!string2.equals("scaleX")) break;
                n2 = 7;
                break;
            }
            case -1225497655: {
                if (!string2.equals("translationZ")) break;
                n2 = 6;
                break;
            }
            case -1225497656: {
                if (!string2.equals("translationY")) break;
                n2 = 5;
                break;
            }
            case -1225497657: {
                if (!string2.equals("translationX")) break;
                n2 = 4;
                break;
            }
            case -1249320805: {
                if (!string2.equals("rotationY")) break;
                n2 = 3;
                break;
            }
            case -1249320806: {
                if (!string2.equals("rotationX")) break;
                n2 = 2;
                break;
            }
            case -1812823328: {
                if (!string2.equals("transitionEasing")) break;
                n2 = 1;
                break;
            }
            case -1913008125: {
                if (!string2.equals("motionProgress")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 16: {
                if (object instanceof Integer) {
                    this.mWaveShape = this.toInt(object);
                    break;
                }
                this.mWaveShape = 7;
                this.mCustomWaveShape = object.toString();
                break;
            }
            case 15: {
                this.mCurveFit = this.toInt(object);
                break;
            }
            case 14: {
                this.mWavePeriod = this.toFloat(object);
                break;
            }
            case 13: {
                this.mWaveOffset = this.toFloat(object);
                break;
            }
            case 12: {
                this.mAlpha = this.toFloat(object);
                break;
            }
            case 11: {
                this.mTransitionPathRotate = this.toFloat(object);
                break;
            }
            case 10: {
                this.mElevation = this.toFloat(object);
                break;
            }
            case 9: {
                this.mRotation = this.toFloat(object);
                break;
            }
            case 8: {
                this.mScaleY = this.toFloat(object);
                break;
            }
            case 7: {
                this.mScaleX = this.toFloat(object);
                break;
            }
            case 6: {
                this.mTranslationZ = this.toFloat(object);
                break;
            }
            case 5: {
                this.mTranslationY = this.toFloat(object);
                break;
            }
            case 4: {
                this.mTranslationX = this.toFloat(object);
                break;
            }
            case 3: {
                this.mRotationY = this.toFloat(object);
                break;
            }
            case 2: {
                this.mRotationX = this.toFloat(object);
                break;
            }
            case 1: {
                this.mTransitionEasing = object.toString();
                break;
            }
            case 0: {
                this.mProgress = this.toFloat(object);
            }
        }
    }

    private static class Loader {
        private static final int ANDROID_ALPHA = 1;
        private static final int ANDROID_ELEVATION = 2;
        private static final int ANDROID_ROTATION = 4;
        private static final int ANDROID_ROTATION_X = 5;
        private static final int ANDROID_ROTATION_Y = 6;
        private static final int ANDROID_SCALE_X = 7;
        private static final int ANDROID_SCALE_Y = 14;
        private static final int ANDROID_TRANSLATION_X = 15;
        private static final int ANDROID_TRANSLATION_Y = 16;
        private static final int ANDROID_TRANSLATION_Z = 17;
        private static final int CURVE_FIT = 13;
        private static final int FRAME_POSITION = 12;
        private static final int PROGRESS = 18;
        private static final int TARGET_ID = 10;
        private static final int TRANSITION_EASING = 9;
        private static final int TRANSITION_PATH_ROTATE = 8;
        private static final int WAVE_OFFSET = 21;
        private static final int WAVE_PERIOD = 20;
        private static final int WAVE_SHAPE = 19;
        private static SparseIntArray mAttrMap;

        static {
            SparseIntArray sparseIntArray;
            mAttrMap = sparseIntArray = new SparseIntArray();
            sparseIntArray.append(R.styleable.KeyTimeCycle_android_alpha, 1);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_elevation, 2);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_rotation, 4);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_rotationX, 5);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_rotationY, 6);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_scaleX, 7);
            mAttrMap.append(R.styleable.KeyTimeCycle_transitionPathRotate, 8);
            mAttrMap.append(R.styleable.KeyTimeCycle_transitionEasing, 9);
            mAttrMap.append(R.styleable.KeyTimeCycle_motionTarget, 10);
            mAttrMap.append(R.styleable.KeyTimeCycle_framePosition, 12);
            mAttrMap.append(R.styleable.KeyTimeCycle_curveFit, 13);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_scaleY, 14);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_translationX, 15);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_translationY, 16);
            mAttrMap.append(R.styleable.KeyTimeCycle_android_translationZ, 17);
            mAttrMap.append(R.styleable.KeyTimeCycle_motionProgress, 18);
            mAttrMap.append(R.styleable.KeyTimeCycle_wavePeriod, 20);
            mAttrMap.append(R.styleable.KeyTimeCycle_waveOffset, 21);
            mAttrMap.append(R.styleable.KeyTimeCycle_waveShape, 19);
        }

        private Loader() {
        }

        public static void read(KeyTimeCycle keyTimeCycle, TypedArray typedArray) {
            int n = typedArray.getIndexCount();
            block21: for (int i = 0; i < n; ++i) {
                int n2 = typedArray.getIndex(i);
                switch (mAttrMap.get(n2)) {
                    default: {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("unused attribute 0x");
                        stringBuilder.append(Integer.toHexString(n2));
                        stringBuilder.append("   ");
                        stringBuilder.append(mAttrMap.get(n2));
                        Log.e((String)"KeyTimeCycle", (String)stringBuilder.toString());
                        continue block21;
                    }
                    case 21: {
                        if (typedArray.peekValue((int)n2).type == 5) {
                            KeyTimeCycle.access$702(keyTimeCycle, typedArray.getDimension(n2, keyTimeCycle.mWaveOffset));
                            continue block21;
                        }
                        KeyTimeCycle.access$702(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mWaveOffset));
                        continue block21;
                    }
                    case 20: {
                        KeyTimeCycle.access$602(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mWavePeriod));
                        continue block21;
                    }
                    case 19: {
                        if (typedArray.peekValue((int)n2).type == 3) {
                            KeyTimeCycle.access$402(keyTimeCycle, typedArray.getString(n2));
                            KeyTimeCycle.access$502(keyTimeCycle, 7);
                            continue block21;
                        }
                        KeyTimeCycle.access$502(keyTimeCycle, typedArray.getInt(n2, keyTimeCycle.mWaveShape));
                        continue block21;
                    }
                    case 18: {
                        KeyTimeCycle.access$1702(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mProgress));
                        continue block21;
                    }
                    case 17: {
                        if (Build.VERSION.SDK_INT < 21) continue block21;
                        KeyTimeCycle.access$1602(keyTimeCycle, typedArray.getDimension(n2, keyTimeCycle.mTranslationZ));
                        continue block21;
                    }
                    case 16: {
                        KeyTimeCycle.access$1502(keyTimeCycle, typedArray.getDimension(n2, keyTimeCycle.mTranslationY));
                        continue block21;
                    }
                    case 15: {
                        KeyTimeCycle.access$1402(keyTimeCycle, typedArray.getDimension(n2, keyTimeCycle.mTranslationX));
                        continue block21;
                    }
                    case 14: {
                        KeyTimeCycle.access$1202(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mScaleY));
                        continue block21;
                    }
                    case 13: {
                        KeyTimeCycle.access$302(keyTimeCycle, typedArray.getInteger(n2, keyTimeCycle.mCurveFit));
                        continue block21;
                    }
                    case 12: {
                        keyTimeCycle.mFramePosition = typedArray.getInt(n2, keyTimeCycle.mFramePosition);
                        continue block21;
                    }
                    case 10: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            keyTimeCycle.mTargetId = typedArray.getResourceId(n2, keyTimeCycle.mTargetId);
                            if (keyTimeCycle.mTargetId != -1) continue block21;
                            keyTimeCycle.mTargetString = typedArray.getString(n2);
                            continue block21;
                        }
                        if (typedArray.peekValue((int)n2).type == 3) {
                            keyTimeCycle.mTargetString = typedArray.getString(n2);
                            continue block21;
                        }
                        keyTimeCycle.mTargetId = typedArray.getResourceId(n2, keyTimeCycle.mTargetId);
                        continue block21;
                    }
                    case 9: {
                        KeyTimeCycle.access$1102(keyTimeCycle, typedArray.getString(n2));
                        continue block21;
                    }
                    case 8: {
                        KeyTimeCycle.access$1302(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mTransitionPathRotate));
                        continue block21;
                    }
                    case 7: {
                        KeyTimeCycle.access$802(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mScaleX));
                        continue block21;
                    }
                    case 6: {
                        KeyTimeCycle.access$1002(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mRotationY));
                        continue block21;
                    }
                    case 5: {
                        KeyTimeCycle.access$902(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mRotationX));
                        continue block21;
                    }
                    case 4: {
                        KeyTimeCycle.access$202(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mRotation));
                        continue block21;
                    }
                    case 2: {
                        KeyTimeCycle.access$102(keyTimeCycle, typedArray.getDimension(n2, keyTimeCycle.mElevation));
                        continue block21;
                    }
                    case 1: {
                        KeyTimeCycle.access$002(keyTimeCycle, typedArray.getFloat(n2, keyTimeCycle.mAlpha));
                    }
                }
            }
        }
    }
}

