/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.R;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;

public class KeyTrigger
extends Key {
    public static final String CROSS = "CROSS";
    public static final int KEY_TYPE = 5;
    static final String NAME = "KeyTrigger";
    public static final String NEGATIVE_CROSS = "negativeCross";
    public static final String POSITIVE_CROSS = "positiveCross";
    public static final String POST_LAYOUT = "postLayout";
    private static final String TAG = "KeyTrigger";
    public static final String TRIGGER_COLLISION_ID = "triggerCollisionId";
    public static final String TRIGGER_COLLISION_VIEW = "triggerCollisionView";
    public static final String TRIGGER_ID = "triggerID";
    public static final String TRIGGER_RECEIVER = "triggerReceiver";
    public static final String TRIGGER_SLACK = "triggerSlack";
    public static final String VIEW_TRANSITION_ON_CROSS = "viewTransitionOnCross";
    public static final String VIEW_TRANSITION_ON_NEGATIVE_CROSS = "viewTransitionOnNegativeCross";
    public static final String VIEW_TRANSITION_ON_POSITIVE_CROSS = "viewTransitionOnPositiveCross";
    RectF mCollisionRect;
    private String mCross = null;
    private int mCurveFit = -1;
    private boolean mFireCrossReset = true;
    private float mFireLastPos;
    private boolean mFireNegativeReset = true;
    private boolean mFirePositiveReset = true;
    private float mFireThreshold;
    HashMap<String, Method> mMethodHashMap;
    private String mNegativeCross = null;
    private String mPositiveCross = null;
    private boolean mPostLayout = false;
    RectF mTargetRect;
    private int mTriggerCollisionId;
    private View mTriggerCollisionView = null;
    private int mTriggerID;
    private int mTriggerReceiver = UNSET;
    float mTriggerSlack = 0.1f;
    int mViewTransitionOnCross;
    int mViewTransitionOnNegativeCross;
    int mViewTransitionOnPositiveCross;

    public KeyTrigger() {
        this.mTriggerID = UNSET;
        this.mTriggerCollisionId = UNSET;
        this.mFireThreshold = Float.NaN;
        this.mViewTransitionOnNegativeCross = UNSET;
        this.mViewTransitionOnPositiveCross = UNSET;
        this.mViewTransitionOnCross = UNSET;
        this.mCollisionRect = new RectF();
        this.mTargetRect = new RectF();
        this.mMethodHashMap = new HashMap();
        this.mType = 5;
        this.mCustomConstraints = new HashMap();
    }

    static /* synthetic */ float access$002(KeyTrigger keyTrigger, float f) {
        keyTrigger.mFireThreshold = f;
        return f;
    }

    static /* synthetic */ String access$102(KeyTrigger keyTrigger, String string2) {
        keyTrigger.mNegativeCross = string2;
        return string2;
    }

    static /* synthetic */ String access$202(KeyTrigger keyTrigger, String string2) {
        keyTrigger.mPositiveCross = string2;
        return string2;
    }

    static /* synthetic */ String access$302(KeyTrigger keyTrigger, String string2) {
        keyTrigger.mCross = string2;
        return string2;
    }

    static /* synthetic */ int access$402(KeyTrigger keyTrigger, int n) {
        keyTrigger.mTriggerID = n;
        return n;
    }

    static /* synthetic */ int access$502(KeyTrigger keyTrigger, int n) {
        keyTrigger.mTriggerCollisionId = n;
        return n;
    }

    static /* synthetic */ boolean access$602(KeyTrigger keyTrigger, boolean bl) {
        keyTrigger.mPostLayout = bl;
        return bl;
    }

    static /* synthetic */ int access$702(KeyTrigger keyTrigger, int n) {
        keyTrigger.mTriggerReceiver = n;
        return n;
    }

    private void fire(String string2, View view) {
        Method method;
        Method method2;
        if (string2 == null) {
            return;
        }
        if (string2.startsWith(".")) {
            this.fireCustom(string2, view);
            return;
        }
        if (this.mMethodHashMap.containsKey(string2)) {
            method = method2 = this.mMethodHashMap.get(string2);
            if (method2 == null) {
                return;
            }
        } else {
            method = null;
        }
        method2 = method;
        if (method == null) {
            try {
                method2 = view.getClass().getMethod(string2, new Class[0]);
                this.mMethodHashMap.put(string2, method2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.mMethodHashMap.put(string2, null);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not find method \"");
                stringBuilder.append(string2);
                stringBuilder.append("\"on class ");
                stringBuilder.append(view.getClass().getSimpleName());
                stringBuilder.append(" ");
                stringBuilder.append(Debug.getName(view));
                Log.e((String)"KeyTrigger", (String)stringBuilder.toString());
                return;
            }
        }
        try {
            method2.invoke((Object)view, new Object[0]);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Exception in call \"");
            stringBuilder.append(this.mCross);
            stringBuilder.append("\"on class ");
            stringBuilder.append(view.getClass().getSimpleName());
            stringBuilder.append(" ");
            stringBuilder.append(Debug.getName(view));
            Log.e((String)"KeyTrigger", (String)stringBuilder.toString());
        }
    }

    private void fireCustom(String object, View view) {
        boolean bl = ((String)object).length() == 1;
        String string2 = object;
        if (!bl) {
            string2 = ((String)object).substring(1).toLowerCase(Locale.ROOT);
        }
        for (String string3 : this.mCustomConstraints.keySet()) {
            Object object2 = string3.toLowerCase(Locale.ROOT);
            if (!bl && !((String)object2).matches(string2) || (object2 = (ConstraintAttribute)this.mCustomConstraints.get(string3)) == null) continue;
            ((ConstraintAttribute)object2).applyCustom(view);
        }
    }

    private void setUpRect(RectF rectF, View view, boolean bl) {
        rectF.top = view.getTop();
        rectF.bottom = view.getBottom();
        rectF.left = view.getLeft();
        rectF.right = view.getRight();
        if (bl) {
            view.getMatrix().mapRect(rectF);
        }
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> hashMap) {
    }

    @Override
    public Key clone() {
        return new KeyTrigger().copy(this);
    }

    /*
     * Unable to fully structure code
     */
    public void conditionallyFire(float var1_1, View var2_2) {
        block28: {
            block34: {
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block26: {
                                        block27: {
                                            if (this.mTriggerCollisionId == KeyTrigger.UNSET) break block26;
                                            if (this.mTriggerCollisionView == null) {
                                                this.mTriggerCollisionView = ((ViewGroup)var2_2.getParent()).findViewById(this.mTriggerCollisionId);
                                            }
                                            this.setUpRect(this.mCollisionRect, this.mTriggerCollisionView, this.mPostLayout);
                                            this.setUpRect(this.mTargetRect, var2_2, this.mPostLayout);
                                            if (!this.mCollisionRect.intersect(this.mTargetRect)) break block27;
                                            if (this.mFireCrossReset) {
                                                this.mFireCrossReset = false;
                                                var3_3 = true;
                                            } else {
                                                var3_3 = false;
                                            }
                                            if (this.mFirePositiveReset) {
                                                this.mFirePositiveReset = false;
                                                var4_4 = true;
                                            } else {
                                                var4_4 = false;
                                            }
                                            this.mFireNegativeReset = true;
                                            var5_5 = false;
                                            break block28;
                                        }
                                        if (!this.mFireCrossReset) {
                                            this.mFireCrossReset = true;
                                            var3_3 = true;
                                        } else {
                                            var3_3 = false;
                                        }
                                        if (this.mFireNegativeReset) {
                                            this.mFireNegativeReset = false;
                                            var5_5 = true;
                                        } else {
                                            var5_5 = false;
                                        }
                                        this.mFirePositiveReset = true;
                                        ** GOTO lbl70
                                    }
                                    if (!this.mFireCrossReset) break block29;
                                    var6_6 = this.mFireThreshold;
                                    if (!((var1_1 - var6_6) * (this.mFireLastPos - var6_6) < 0.0f)) break block30;
                                    this.mFireCrossReset = false;
                                    var3_3 = true;
                                    break block31;
                                }
                                if (Math.abs(var1_1 - this.mFireThreshold) > this.mTriggerSlack) {
                                    this.mFireCrossReset = true;
                                }
                            }
                            var3_3 = false;
                        }
                        if (!this.mFireNegativeReset) break block32;
                        var6_6 = this.mFireThreshold;
                        var7_7 = var1_1 - var6_6;
                        if (!((this.mFireLastPos - var6_6) * var7_7 < 0.0f) || !(var7_7 < 0.0f)) break block33;
                        this.mFireNegativeReset = false;
                        var5_5 = true;
                        break block34;
                    }
                    if (Math.abs(var1_1 - this.mFireThreshold) > this.mTriggerSlack) {
                        this.mFireNegativeReset = true;
                    }
                }
                var5_5 = false;
            }
            if (this.mFirePositiveReset) {
                var6_6 = this.mFireThreshold;
                var7_7 = var1_1 - var6_6;
                if ((this.mFireLastPos - var6_6) * var7_7 < 0.0f && var7_7 > 0.0f) {
                    this.mFirePositiveReset = false;
                    var4_4 = true;
                } else {
                    var4_4 = false;
                }
            } else {
                if (Math.abs(var1_1 - this.mFireThreshold) > this.mTriggerSlack) {
                    this.mFirePositiveReset = true;
                }
lbl70:
                // 4 sources

                var4_4 = false;
            }
        }
        this.mFireLastPos = var1_1;
        if (var5_5 || var3_3 || var4_4) {
            ((MotionLayout)var2_2.getParent()).fireTrigger(this.mTriggerID, var4_4, var1_1);
        }
        var8_8 = this.mTriggerReceiver == KeyTrigger.UNSET ? var2_2 : ((MotionLayout)var2_2.getParent()).findViewById(this.mTriggerReceiver);
        if (var5_5) {
            var9_9 = this.mNegativeCross;
            if (var9_9 != null) {
                this.fire(var9_9, var8_8);
            }
            if (this.mViewTransitionOnNegativeCross != KeyTrigger.UNSET) {
                ((MotionLayout)var2_2.getParent()).viewTransition(this.mViewTransitionOnNegativeCross, new View[]{var8_8});
            }
        }
        if (var4_4) {
            var9_9 = this.mPositiveCross;
            if (var9_9 != null) {
                this.fire(var9_9, var8_8);
            }
            if (this.mViewTransitionOnPositiveCross != KeyTrigger.UNSET) {
                ((MotionLayout)var2_2.getParent()).viewTransition(this.mViewTransitionOnPositiveCross, new View[]{var8_8});
            }
        }
        if (var3_3) {
            var9_9 = this.mCross;
            if (var9_9 != null) {
                this.fire(var9_9, var8_8);
            }
            if (this.mViewTransitionOnCross != KeyTrigger.UNSET) {
                ((MotionLayout)var2_2.getParent()).viewTransition(this.mViewTransitionOnCross, new View[]{var8_8});
            }
        }
    }

    @Override
    public Key copy(Key key) {
        super.copy(key);
        key = (KeyTrigger)key;
        this.mCurveFit = ((KeyTrigger)key).mCurveFit;
        this.mCross = ((KeyTrigger)key).mCross;
        this.mTriggerReceiver = ((KeyTrigger)key).mTriggerReceiver;
        this.mNegativeCross = ((KeyTrigger)key).mNegativeCross;
        this.mPositiveCross = ((KeyTrigger)key).mPositiveCross;
        this.mTriggerID = ((KeyTrigger)key).mTriggerID;
        this.mTriggerCollisionId = ((KeyTrigger)key).mTriggerCollisionId;
        this.mTriggerCollisionView = ((KeyTrigger)key).mTriggerCollisionView;
        this.mTriggerSlack = ((KeyTrigger)key).mTriggerSlack;
        this.mFireCrossReset = ((KeyTrigger)key).mFireCrossReset;
        this.mFireNegativeReset = ((KeyTrigger)key).mFireNegativeReset;
        this.mFirePositiveReset = ((KeyTrigger)key).mFirePositiveReset;
        this.mFireThreshold = ((KeyTrigger)key).mFireThreshold;
        this.mFireLastPos = ((KeyTrigger)key).mFireLastPos;
        this.mPostLayout = ((KeyTrigger)key).mPostLayout;
        this.mCollisionRect = ((KeyTrigger)key).mCollisionRect;
        this.mTargetRect = ((KeyTrigger)key).mTargetRect;
        this.mMethodHashMap = ((KeyTrigger)key).mMethodHashMap;
        return this;
    }

    @Override
    public void getAttributeNames(HashSet<String> hashSet) {
    }

    int getCurveFit() {
        return this.mCurveFit;
    }

    @Override
    public void load(Context context, AttributeSet attributeSet) {
        Loader.read(this, context.obtainStyledAttributes(attributeSet, R.styleable.KeyTrigger), context);
    }

    @Override
    public void setValue(String string2, Object object) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1535404999: {
                if (!string2.equals(TRIGGER_RECEIVER)) break;
                n2 = 11;
                break;
            }
            case 1401391082: {
                if (!string2.equals(POST_LAYOUT)) break;
                n2 = 10;
                break;
            }
            case 1301930599: {
                if (!string2.equals(VIEW_TRANSITION_ON_CROSS)) break;
                n2 = 9;
                break;
            }
            case 364489912: {
                if (!string2.equals(TRIGGER_SLACK)) break;
                n2 = 8;
                break;
            }
            case 64397344: {
                if (!string2.equals(CROSS)) break;
                n2 = 7;
                break;
            }
            case -9754574: {
                if (!string2.equals(VIEW_TRANSITION_ON_NEGATIVE_CROSS)) break;
                n2 = 6;
                break;
            }
            case -76025313: {
                if (!string2.equals(TRIGGER_COLLISION_VIEW)) break;
                n2 = 5;
                break;
            }
            case -638126837: {
                if (!string2.equals(NEGATIVE_CROSS)) break;
                n2 = 4;
                break;
            }
            case -648752941: {
                if (!string2.equals(TRIGGER_ID)) break;
                n2 = 3;
                break;
            }
            case -786670827: {
                if (!string2.equals(TRIGGER_COLLISION_ID)) break;
                n2 = 2;
                break;
            }
            case -966421266: {
                if (!string2.equals(VIEW_TRANSITION_ON_POSITIVE_CROSS)) break;
                n2 = 1;
                break;
            }
            case -1594793529: {
                if (!string2.equals(POSITIVE_CROSS)) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 11: {
                this.mTriggerReceiver = this.toInt(object);
                break;
            }
            case 10: {
                this.mPostLayout = this.toBoolean(object);
                break;
            }
            case 9: {
                this.mViewTransitionOnCross = this.toInt(object);
                break;
            }
            case 8: {
                this.mTriggerSlack = this.toFloat(object);
                break;
            }
            case 7: {
                this.mCross = object.toString();
                break;
            }
            case 6: {
                this.mViewTransitionOnNegativeCross = this.toInt(object);
                break;
            }
            case 5: {
                this.mTriggerCollisionView = (View)object;
                break;
            }
            case 4: {
                this.mNegativeCross = object.toString();
                break;
            }
            case 3: {
                this.mTriggerID = this.toInt(object);
                break;
            }
            case 2: {
                this.mTriggerCollisionId = this.toInt(object);
                break;
            }
            case 1: {
                this.mViewTransitionOnPositiveCross = this.toInt(object);
                break;
            }
            case 0: {
                this.mPositiveCross = object.toString();
            }
        }
    }

    private static class Loader {
        private static final int COLLISION = 9;
        private static final int CROSS = 4;
        private static final int FRAME_POS = 8;
        private static final int NEGATIVE_CROSS = 1;
        private static final int POSITIVE_CROSS = 2;
        private static final int POST_LAYOUT = 10;
        private static final int TARGET_ID = 7;
        private static final int TRIGGER_ID = 6;
        private static final int TRIGGER_RECEIVER = 11;
        private static final int TRIGGER_SLACK = 5;
        private static final int VT_CROSS = 12;
        private static final int VT_NEGATIVE_CROSS = 13;
        private static final int VT_POSITIVE_CROSS = 14;
        private static SparseIntArray mAttrMap;

        static {
            SparseIntArray sparseIntArray;
            mAttrMap = sparseIntArray = new SparseIntArray();
            sparseIntArray.append(R.styleable.KeyTrigger_framePosition, 8);
            mAttrMap.append(R.styleable.KeyTrigger_onCross, 4);
            mAttrMap.append(R.styleable.KeyTrigger_onNegativeCross, 1);
            mAttrMap.append(R.styleable.KeyTrigger_onPositiveCross, 2);
            mAttrMap.append(R.styleable.KeyTrigger_motionTarget, 7);
            mAttrMap.append(R.styleable.KeyTrigger_triggerId, 6);
            mAttrMap.append(R.styleable.KeyTrigger_triggerSlack, 5);
            mAttrMap.append(R.styleable.KeyTrigger_motion_triggerOnCollision, 9);
            mAttrMap.append(R.styleable.KeyTrigger_motion_postLayoutCollision, 10);
            mAttrMap.append(R.styleable.KeyTrigger_triggerReceiver, 11);
            mAttrMap.append(R.styleable.KeyTrigger_viewTransitionOnCross, 12);
            mAttrMap.append(R.styleable.KeyTrigger_viewTransitionOnNegativeCross, 13);
            mAttrMap.append(R.styleable.KeyTrigger_viewTransitionOnPositiveCross, 14);
        }

        private Loader() {
        }

        public static void read(KeyTrigger keyTrigger, TypedArray typedArray, Context object) {
            int n = typedArray.getIndexCount();
            block15: for (int i = 0; i < n; ++i) {
                int n2 = typedArray.getIndex(i);
                switch (mAttrMap.get(n2)) {
                    default: {
                        object = new StringBuilder();
                        ((StringBuilder)object).append("unused attribute 0x");
                        ((StringBuilder)object).append(Integer.toHexString(n2));
                        ((StringBuilder)object).append("   ");
                        ((StringBuilder)object).append(mAttrMap.get(n2));
                        Log.e((String)"KeyTrigger", (String)((StringBuilder)object).toString());
                        continue block15;
                    }
                    case 14: {
                        keyTrigger.mViewTransitionOnPositiveCross = typedArray.getResourceId(n2, keyTrigger.mViewTransitionOnPositiveCross);
                        continue block15;
                    }
                    case 13: {
                        keyTrigger.mViewTransitionOnNegativeCross = typedArray.getResourceId(n2, keyTrigger.mViewTransitionOnNegativeCross);
                        continue block15;
                    }
                    case 12: {
                        keyTrigger.mViewTransitionOnCross = typedArray.getResourceId(n2, keyTrigger.mViewTransitionOnCross);
                        continue block15;
                    }
                    case 11: {
                        KeyTrigger.access$702(keyTrigger, typedArray.getResourceId(n2, keyTrigger.mTriggerReceiver));
                        continue block15;
                    }
                    case 10: {
                        KeyTrigger.access$602(keyTrigger, typedArray.getBoolean(n2, keyTrigger.mPostLayout));
                        continue block15;
                    }
                    case 9: {
                        KeyTrigger.access$502(keyTrigger, typedArray.getResourceId(n2, keyTrigger.mTriggerCollisionId));
                        continue block15;
                    }
                    case 8: {
                        keyTrigger.mFramePosition = typedArray.getInteger(n2, keyTrigger.mFramePosition);
                        KeyTrigger.access$002(keyTrigger, ((float)keyTrigger.mFramePosition + 0.5f) / 100.0f);
                        continue block15;
                    }
                    case 7: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            keyTrigger.mTargetId = typedArray.getResourceId(n2, keyTrigger.mTargetId);
                            if (keyTrigger.mTargetId != -1) continue block15;
                            keyTrigger.mTargetString = typedArray.getString(n2);
                            continue block15;
                        }
                        if (typedArray.peekValue((int)n2).type == 3) {
                            keyTrigger.mTargetString = typedArray.getString(n2);
                            continue block15;
                        }
                        keyTrigger.mTargetId = typedArray.getResourceId(n2, keyTrigger.mTargetId);
                        continue block15;
                    }
                    case 6: {
                        KeyTrigger.access$402(keyTrigger, typedArray.getResourceId(n2, keyTrigger.mTriggerID));
                        continue block15;
                    }
                    case 5: {
                        keyTrigger.mTriggerSlack = typedArray.getFloat(n2, keyTrigger.mTriggerSlack);
                        continue block15;
                    }
                    case 4: {
                        KeyTrigger.access$302(keyTrigger, typedArray.getString(n2));
                        continue block15;
                    }
                    case 2: {
                        KeyTrigger.access$202(keyTrigger, typedArray.getString(n2));
                        continue block15;
                    }
                    case 1: {
                        KeyTrigger.access$102(keyTrigger, typedArray.getString(n2));
                    }
                }
            }
        }
    }
}

