/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import androidx.constraintlayout.core.motion.utils.CurveFit;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.motion.utils.KeyCycleOscillator;
import androidx.constraintlayout.core.motion.utils.SplineSet;
import androidx.constraintlayout.core.motion.utils.VelocityMatrix;
import androidx.constraintlayout.motion.utils.CustomSupport;
import androidx.constraintlayout.motion.utils.ViewOscillator;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.utils.ViewState;
import androidx.constraintlayout.motion.utils.ViewTimeCycle;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyAttributes;
import androidx.constraintlayout.motion.widget.KeyCycle;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.KeyPositionBase;
import androidx.constraintlayout.motion.widget.KeyTimeCycle;
import androidx.constraintlayout.motion.widget.KeyTrigger;
import androidx.constraintlayout.motion.widget.MotionConstrainedPoint;
import androidx.constraintlayout.motion.widget.MotionPaths;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MotionController {
    static final int BOUNCE = 4;
    private static final boolean DEBUG = false;
    public static final int DRAW_PATH_AS_CONFIGURED = 4;
    public static final int DRAW_PATH_BASIC = 1;
    public static final int DRAW_PATH_CARTESIAN = 3;
    public static final int DRAW_PATH_NONE = 0;
    public static final int DRAW_PATH_RECTANGLE = 5;
    public static final int DRAW_PATH_RELATIVE = 2;
    public static final int DRAW_PATH_SCREEN = 6;
    static final int EASE_IN = 1;
    static final int EASE_IN_OUT = 0;
    static final int EASE_OUT = 2;
    private static final boolean FAVOR_FIXED_SIZE_VIEWS = false;
    public static final int HORIZONTAL_PATH_X = 2;
    public static final int HORIZONTAL_PATH_Y = 3;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    private static final int INTERPOLATOR_UNDEFINED = -3;
    static final int LINEAR = 3;
    static final int OVERSHOOT = 5;
    public static final int PATH_PERCENT = 0;
    public static final int PATH_PERPENDICULAR = 1;
    public static final int ROTATION_LEFT = 2;
    public static final int ROTATION_RIGHT = 1;
    private static final int SPLINE_STRING = -1;
    private static final String TAG = "MotionController";
    public static final int VERTICAL_PATH_X = 4;
    public static final int VERTICAL_PATH_Y = 5;
    private int MAX_DIMENSION = 4;
    String[] attributeTable;
    private CurveFit mArcSpline;
    private int[] mAttributeInterpolatorCount;
    private String[] mAttributeNames;
    private HashMap<String, ViewSpline> mAttributesMap;
    String mConstraintTag;
    float mCurrentCenterX;
    float mCurrentCenterY;
    private int mCurveFitType = -1;
    private HashMap<String, ViewOscillator> mCycleMap;
    private MotionPaths mEndMotionPath;
    private MotionConstrainedPoint mEndPoint;
    boolean mForceMeasure = false;
    int mId;
    private double[] mInterpolateData;
    private int[] mInterpolateVariables;
    private double[] mInterpolateVelocity;
    private ArrayList<Key> mKeyList;
    private KeyTrigger[] mKeyTriggers;
    private ArrayList<MotionPaths> mMotionPaths;
    float mMotionStagger;
    private boolean mNoMovement = false;
    private int mPathMotionArc;
    private Interpolator mQuantizeMotionInterpolator = null;
    private float mQuantizeMotionPhase;
    private int mQuantizeMotionSteps;
    private CurveFit[] mSpline;
    float mStaggerOffset = 0.0f;
    float mStaggerScale = 1.0f;
    private MotionPaths mStartMotionPath;
    private MotionConstrainedPoint mStartPoint;
    Rect mTempRect = new Rect();
    private HashMap<String, ViewTimeCycle> mTimeCycleAttributesMap;
    private int mTransformPivotTarget;
    private View mTransformPivotView = null;
    private float[] mValuesBuff;
    private float[] mVelocity;
    View mView;

    MotionController(View view) {
        this.mStartMotionPath = new MotionPaths();
        this.mEndMotionPath = new MotionPaths();
        this.mStartPoint = new MotionConstrainedPoint();
        this.mEndPoint = new MotionConstrainedPoint();
        this.mMotionStagger = Float.NaN;
        this.mValuesBuff = new float[4];
        this.mMotionPaths = new ArrayList();
        this.mVelocity = new float[1];
        this.mKeyList = new ArrayList();
        this.mPathMotionArc = Key.UNSET;
        this.mTransformPivotTarget = Key.UNSET;
        this.mQuantizeMotionSteps = Key.UNSET;
        this.mQuantizeMotionPhase = Float.NaN;
        this.setView(view);
    }

    private float getAdjustedPosition(float f, float[] fArray) {
        float f2;
        float f3;
        float f4 = 0.0f;
        float f5 = 1.0f;
        if (fArray != null) {
            fArray[0] = 1.0f;
            f3 = f;
        } else {
            float f6 = this.mStaggerScale;
            f3 = f;
            if ((double)f6 != 1.0) {
                float f7 = this.mStaggerOffset;
                f2 = f;
                if (f < f7) {
                    f2 = 0.0f;
                }
                f3 = f2;
                if (f2 > f7) {
                    f3 = f2;
                    if ((double)f2 < 1.0) {
                        f3 = Math.min((f2 - f7) * f6, 1.0f);
                    }
                }
            }
        }
        Easing easing = this.mStartMotionPath.mKeyFrameEasing;
        f = Float.NaN;
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        f2 = f4;
        while (iterator.hasNext()) {
            MotionPaths motionPaths = iterator.next();
            if (motionPaths.mKeyFrameEasing == null) continue;
            if (motionPaths.time < f3) {
                easing = motionPaths.mKeyFrameEasing;
                f2 = motionPaths.time;
                continue;
            }
            if (!Float.isNaN(f)) continue;
            f = motionPaths.time;
        }
        f4 = f3;
        if (easing != null) {
            if (Float.isNaN(f)) {
                f = f5;
            }
            double d = (f3 - f2) / (f -= f2);
            f4 = f = (float)easing.get(d) * f + f2;
            if (fArray != null) {
                fArray[0] = (float)easing.getDiff(d);
                f4 = f;
            }
        }
        return f4;
    }

    private static Interpolator getInterpolator(Context context, int n, String string2, int n2) {
        if (n != -2) {
            if (n != -1) {
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            if (n != 4) {
                                if (n != 5) {
                                    return null;
                                }
                                return new OvershootInterpolator();
                            }
                            return new BounceInterpolator();
                        }
                        return new DecelerateInterpolator();
                    }
                    return new AccelerateInterpolator();
                }
                return new AccelerateDecelerateInterpolator();
            }
            return new Interpolator(Easing.getInterpolator(string2)){
                final /* synthetic */ Easing val$easing;
                {
                    this.val$easing = easing;
                }

                public float getInterpolation(float f) {
                    return (float)this.val$easing.get(f);
                }
            };
        }
        return AnimationUtils.loadInterpolator((Context)context, (int)n2);
    }

    private float getPreCycleDistance() {
        double d;
        float[] fArray = new float[2];
        float f = 1.0f / (float)99;
        double d2 = d = 0.0;
        float f2 = 0.0f;
        for (int i = 0; i < 100; ++i) {
            float f3;
            float f4 = (float)i * f;
            double d3 = f4;
            Easing easing = this.mStartMotionPath.mKeyFrameEasing;
            Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
            float f5 = Float.NaN;
            float f6 = 0.0f;
            while (iterator.hasNext()) {
                MotionPaths motionPaths = iterator.next();
                Easing easing2 = easing;
                f3 = f5;
                float f7 = f6;
                if (motionPaths.mKeyFrameEasing != null) {
                    if (motionPaths.time < f4) {
                        easing2 = motionPaths.mKeyFrameEasing;
                        f7 = motionPaths.time;
                        f3 = f5;
                    } else {
                        easing2 = easing;
                        f3 = f5;
                        f7 = f6;
                        if (Float.isNaN(f5)) {
                            f3 = motionPaths.time;
                            f7 = f6;
                            easing2 = easing;
                        }
                    }
                }
                easing = easing2;
                f5 = f3;
                f6 = f7;
            }
            if (easing != null) {
                f3 = f5;
                if (Float.isNaN(f5)) {
                    f3 = 1.0f;
                }
                f5 = f3 - f6;
                d3 = (float)easing.get((f4 - f6) / f5) * f5 + f6;
            }
            this.mSpline[0].getPos(d3, this.mInterpolateData);
            this.mStartMotionPath.getCenter(d3, this.mInterpolateVariables, this.mInterpolateData, fArray, 0);
            if (i > 0) {
                f2 = (float)((double)f2 + Math.hypot(d2 - (double)fArray[1], d - (double)fArray[0]));
            }
            d = fArray[0];
            d2 = fArray[1];
        }
        return f2;
    }

    private void insertKey(MotionPaths motionPaths) {
        int n = Collections.binarySearch(this.mMotionPaths, motionPaths);
        if (n == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" KeyPath position \"");
            stringBuilder.append(motionPaths.position);
            stringBuilder.append("\" outside of range");
            Log.e((String)TAG, (String)stringBuilder.toString());
        }
        this.mMotionPaths.add(-n - 1, motionPaths);
    }

    private void readView(MotionPaths motionPaths) {
        motionPaths.setBounds((int)this.mView.getX(), (int)this.mView.getY(), this.mView.getWidth(), this.mView.getHeight());
    }

    public void addKey(Key key) {
        this.mKeyList.add(key);
    }

    void addKeys(ArrayList<Key> arrayList) {
        this.mKeyList.addAll(arrayList);
    }

    void buildBounds(float[] fArray, int n) {
        float f = 1.0f / (float)(n - 1);
        HashMap<String, ViewSpline> hashMap = this.mAttributesMap;
        if (hashMap != null) {
            hashMap = hashMap.get("translationX");
        }
        hashMap = this.mAttributesMap;
        if (hashMap != null) {
            hashMap = (SplineSet)hashMap.get("translationY");
        }
        hashMap = this.mCycleMap;
        if (hashMap != null) {
            hashMap = (ViewOscillator)hashMap.get("translationX");
        }
        hashMap = this.mCycleMap;
        if (hashMap != null) {
            hashMap = (ViewOscillator)hashMap.get("translationY");
        }
        for (int i = 0; i < n; ++i) {
            float f2;
            float f3 = (float)i * f;
            float f4 = this.mStaggerScale;
            float f5 = 0.0f;
            float f6 = f3;
            if (f4 != 1.0f) {
                float f7 = this.mStaggerOffset;
                f2 = f3;
                if (f3 < f7) {
                    f2 = 0.0f;
                }
                f6 = f2;
                if (f2 > f7) {
                    f6 = f2;
                    if ((double)f2 < 1.0) {
                        f6 = Math.min((f2 - f7) * f4, 1.0f);
                    }
                }
            }
            double d = f6;
            hashMap = this.mStartMotionPath.mKeyFrameEasing;
            f2 = Float.NaN;
            Object object = this.mMotionPaths.iterator();
            f3 = f5;
            while (object.hasNext()) {
                MotionPaths motionPaths = object.next();
                if (motionPaths.mKeyFrameEasing == null) continue;
                if (motionPaths.time < f6) {
                    hashMap = motionPaths.mKeyFrameEasing;
                    f3 = motionPaths.time;
                    continue;
                }
                if (!Float.isNaN(f2)) continue;
                f2 = motionPaths.time;
            }
            if (hashMap != null) {
                f5 = f2;
                if (Float.isNaN(f2)) {
                    f5 = 1.0f;
                }
                f2 = f5 - f3;
                d = (float)((Easing)((Object)hashMap)).get((f6 - f3) / f2) * f2 + f3;
            }
            this.mSpline[0].getPos(d, this.mInterpolateData);
            hashMap = this.mArcSpline;
            if (hashMap != null && ((Object)(object = (Object)this.mInterpolateData)).length > 0) {
                ((CurveFit)((Object)hashMap)).getPos(d, (double[])object);
            }
            this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, fArray, i * 2);
        }
    }

    int buildKeyBounds(float[] fArray, int[] nArray) {
        if (fArray != null) {
            int n;
            double[] dArray = this.mSpline[0].getTimePoints();
            if (nArray != null) {
                Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    nArray[n] = iterator.next().mMode;
                    ++n;
                }
            }
            int n2 = 0;
            for (n = 0; n < dArray.length; ++n) {
                this.mSpline[0].getPos(dArray[n], this.mInterpolateData);
                this.mStartMotionPath.getBounds(this.mInterpolateVariables, this.mInterpolateData, fArray, n2);
                n2 += 2;
            }
            return n2 / 2;
        }
        return 0;
    }

    int buildKeyFrames(float[] fArray, int[] nArray) {
        if (fArray != null) {
            int n;
            double[] dArray = this.mSpline[0].getTimePoints();
            if (nArray != null) {
                Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
                n = 0;
                while (iterator.hasNext()) {
                    nArray[n] = iterator.next().mMode;
                    ++n;
                }
            }
            int n2 = 0;
            for (n = 0; n < dArray.length; ++n) {
                this.mSpline[0].getPos(dArray[n], this.mInterpolateData);
                this.mStartMotionPath.getCenter(dArray[n], this.mInterpolateVariables, this.mInterpolateData, fArray, n2);
                n2 += 2;
            }
            return n2 / 2;
        }
        return 0;
    }

    void buildPath(float[] fArray, int n) {
        float f = 1.0f / (float)(n - 1);
        Object object = this.mAttributesMap;
        ViewOscillator viewOscillator = null;
        object = object == null ? null : (SplineSet)((HashMap)object).get("translationX");
        Object object2 = this.mAttributesMap;
        object2 = object2 == null ? null : (SplineSet)((HashMap)object2).get("translationY");
        Object object3 = this.mCycleMap;
        object3 = object3 == null ? null : ((HashMap)object3).get("translationX");
        HashMap<String, ViewOscillator> hashMap = this.mCycleMap;
        if (hashMap != null) {
            viewOscillator = hashMap.get("translationY");
        }
        for (int i = 0; i < n; ++i) {
            float f2;
            float f3;
            float f4 = (float)i * f;
            float f5 = this.mStaggerScale;
            float f6 = f4;
            if (f5 != 1.0f) {
                f3 = this.mStaggerOffset;
                f2 = f4;
                if (f4 < f3) {
                    f2 = 0.0f;
                }
                f6 = f2;
                if (f2 > f3) {
                    f6 = f2;
                    if ((double)f2 < 1.0) {
                        f6 = Math.min((f2 - f3) * f5, 1.0f);
                    }
                }
            }
            double d = f6;
            Object object4 = this.mStartMotionPath.mKeyFrameEasing;
            f2 = Float.NaN;
            Object object5 = this.mMotionPaths.iterator();
            f4 = 0.0f;
            while (object5.hasNext()) {
                MotionPaths motionPaths = object5.next();
                hashMap = object4;
                f3 = f2;
                f5 = f4;
                if (motionPaths.mKeyFrameEasing != null) {
                    if (motionPaths.time < f6) {
                        hashMap = motionPaths.mKeyFrameEasing;
                        f5 = motionPaths.time;
                        f3 = f2;
                    } else {
                        hashMap = object4;
                        f3 = f2;
                        f5 = f4;
                        if (Float.isNaN(f2)) {
                            f3 = motionPaths.time;
                            f5 = f4;
                            hashMap = object4;
                        }
                    }
                }
                object4 = hashMap;
                f2 = f3;
                f4 = f5;
            }
            if (object4 != null) {
                f5 = f2;
                if (Float.isNaN(f2)) {
                    f5 = 1.0f;
                }
                f2 = f5 - f4;
                d = (float)((Easing)object4).get((f6 - f4) / f2) * f2 + f4;
            }
            this.mSpline[0].getPos(d, this.mInterpolateData);
            hashMap = this.mArcSpline;
            if (hashMap != null && ((Object)(object4 = (Object)this.mInterpolateData)).length > 0) {
                ((CurveFit)((Object)hashMap)).getPos(d, (double[])object4);
            }
            object4 = this.mStartMotionPath;
            hashMap = (HashMap<String, ViewOscillator>)this.mInterpolateVariables;
            object5 = this.mInterpolateData;
            int n2 = i * 2;
            ((MotionPaths)object4).getCenter(d, (int[])hashMap, (double[])object5, fArray, n2);
            if (object3 != null) {
                fArray[n2] = fArray[n2] + ((KeyCycleOscillator)object3).get(f6);
            } else if (object != null) {
                fArray[n2] = fArray[n2] + ((SplineSet)object).get(f6);
            }
            if (viewOscillator != null) {
                fArray[++n2] = fArray[n2] + viewOscillator.get(f6);
                continue;
            }
            if (object2 == null) continue;
            fArray[++n2] = fArray[n2] + ((SplineSet)object2).get(f6);
        }
    }

    void buildRect(float f, float[] fArray, int n) {
        f = this.getAdjustedPosition(f, null);
        this.mSpline[0].getPos((double)f, this.mInterpolateData);
        this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, fArray, n);
    }

    void buildRectangles(float[] fArray, int n) {
        float f = 1.0f / (float)(n - 1);
        for (int i = 0; i < n; ++i) {
            float f2 = this.getAdjustedPosition((float)i * f, null);
            this.mSpline[0].getPos((double)f2, this.mInterpolateData);
            this.mStartMotionPath.getRect(this.mInterpolateVariables, this.mInterpolateData, fArray, i * 8);
        }
    }

    void endTrigger(boolean bl) {
        if ("button".equals(Debug.getName(this.mView)) && this.mKeyTriggers != null) {
            Object object;
            for (int i = 0; i < ((KeyTrigger[])(object = this.mKeyTriggers)).length; ++i) {
                object = object[i];
                float f = bl ? -100.0f : 100.0f;
                ((KeyTrigger)object).conditionallyFire(f, this.mView);
            }
        }
    }

    public int getAnimateRelativeTo() {
        return this.mStartMotionPath.mAnimateRelativeTo;
    }

    int getAttributeValues(String object, float[] fArray, int n) {
        if ((object = (SplineSet)this.mAttributesMap.get(object)) == null) {
            return -1;
        }
        for (n = 0; n < fArray.length; ++n) {
            fArray[n] = ((SplineSet)object).get(n / (fArray.length - 1));
        }
        return fArray.length;
    }

    public void getCenter(double d, float[] fArray, float[] fArray2) {
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        this.mSpline[0].getPos(d, dArray);
        this.mSpline[0].getSlope(d, dArray2);
        Arrays.fill(fArray2, 0.0f);
        this.mStartMotionPath.getCenter(d, this.mInterpolateVariables, dArray, fArray, dArray2, fArray2);
    }

    public float getCenterX() {
        return this.mCurrentCenterX;
    }

    public float getCenterY() {
        return this.mCurrentCenterY;
    }

    void getDpDt(float f, float f2, float f3, float[] fArray) {
        f = this.getAdjustedPosition(f, this.mVelocity);
        Object object = this.mSpline;
        if (object != null) {
            double[] dArray;
            object = object[0];
            double d = f;
            ((CurveFit)object).getSlope(d, this.mInterpolateVelocity);
            this.mSpline[0].getPos(d, this.mInterpolateData);
            f = this.mVelocity[0];
            for (int i = 0; i < (dArray = this.mInterpolateVelocity).length; ++i) {
                dArray[i] = dArray[i] * (double)f;
            }
            object = this.mArcSpline;
            if (object != null) {
                dArray = this.mInterpolateData;
                if (dArray.length > 0) {
                    ((CurveFit)object).getPos(d, dArray);
                    this.mArcSpline.getSlope(d, this.mInterpolateVelocity);
                    this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
                }
                return;
            }
            this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, dArray, this.mInterpolateData);
            return;
        }
        float f4 = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float f5 = this.mEndMotionPath.y - this.mStartMotionPath.y;
        f = this.mEndMotionPath.width;
        float f6 = this.mStartMotionPath.width;
        float f7 = this.mEndMotionPath.height;
        float f8 = this.mStartMotionPath.height;
        fArray[0] = f4 * (1.0f - f2) + (f - f6 + f4) * f2;
        fArray[1] = f5 * (1.0f - f3) + (f7 - f8 + f5) * f3;
    }

    public int getDrawPath() {
        int n = this.mStartMotionPath.mDrawPath;
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        while (iterator.hasNext()) {
            n = Math.max(n, iterator.next().mDrawPath);
        }
        return Math.max(n, this.mEndMotionPath.mDrawPath);
    }

    public float getFinalHeight() {
        return this.mEndMotionPath.height;
    }

    public float getFinalWidth() {
        return this.mEndMotionPath.width;
    }

    public float getFinalX() {
        return this.mEndMotionPath.x;
    }

    public float getFinalY() {
        return this.mEndMotionPath.y;
    }

    MotionPaths getKeyFrame(int n) {
        return this.mMotionPaths.get(n);
    }

    public int getKeyFrameInfo(int n, int[] nArray) {
        float[] fArray = new float[2];
        Iterator<Key> iterator = this.mKeyList.iterator();
        int n2 = 0;
        int n3 = 0;
        while (iterator.hasNext()) {
            Key key = iterator.next();
            if (key.mType != n && n == -1) continue;
            nArray[n3] = 0;
            int n4 = n3 + 1;
            nArray[n4] = key.mType;
            nArray[++n4] = key.mFramePosition;
            float f = (float)key.mFramePosition / 100.0f;
            Object object = this.mSpline[0];
            double d = f;
            ((CurveFit)object).getPos(d, this.mInterpolateData);
            this.mStartMotionPath.getCenter(d, this.mInterpolateVariables, this.mInterpolateData, fArray, 0);
            nArray[++n4] = Float.floatToIntBits(fArray[0]);
            int n5 = n4 + 1;
            nArray[n5] = Float.floatToIntBits(fArray[1]);
            n4 = n5;
            if (key instanceof KeyPosition) {
                object = (KeyPosition)key;
                n4 = n5 + 1;
                nArray[n4] = ((KeyPosition)object).mPositionType;
                nArray[++n4] = Float.floatToIntBits(((KeyPosition)object).mPercentX);
                nArray[++n4] = Float.floatToIntBits(((KeyPosition)object).mPercentY);
            }
            nArray[n3] = ++n4 - n3;
            ++n2;
            n3 = n4;
        }
        return n2;
    }

    float getKeyFrameParameter(int n, float f, float f2) {
        float f3 = this.mEndMotionPath.x - this.mStartMotionPath.x;
        float f4 = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float f5 = this.mStartMotionPath.x;
        float f6 = this.mStartMotionPath.width / 2.0f;
        float f7 = this.mStartMotionPath.y;
        float f8 = this.mStartMotionPath.height / 2.0f;
        float f9 = (float)Math.hypot(f3, f4);
        if ((double)f9 < 1.0E-7) {
            return Float.NaN;
        }
        if ((float)Math.hypot(f -= f5 + f6, f2 -= f7 + f8) == 0.0f) {
            return 0.0f;
        }
        f8 = f * f3 + f2 * f4;
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) {
                            if (n != 5) {
                                return 0.0f;
                            }
                            return f2 / f4;
                        }
                        return f / f4;
                    }
                    return f2 / f3;
                }
                return f / f3;
            }
            return (float)Math.sqrt(f9 * f9 - f8 * f8);
        }
        return f8 / f9;
    }

    public int getKeyFramePositions(int[] nArray, float[] fArray) {
        Iterator<Key> iterator = this.mKeyList.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object = iterator.next();
            nArray[n] = ((Key)object).mFramePosition + ((Key)object).mType * 1000;
            float f = (float)((Key)object).mFramePosition / 100.0f;
            object = this.mSpline[0];
            double d = f;
            ((CurveFit)object).getPos(d, this.mInterpolateData);
            this.mStartMotionPath.getCenter(d, this.mInterpolateVariables, this.mInterpolateData, fArray, n2);
            n2 += 2;
            ++n;
        }
        return n;
    }

    double[] getPos(double d) {
        double[] dArray;
        this.mSpline[0].getPos(d, this.mInterpolateData);
        CurveFit curveFit = this.mArcSpline;
        if (curveFit != null && (dArray = this.mInterpolateData).length > 0) {
            curveFit.getPos(d, dArray);
        }
        return this.mInterpolateData;
    }

    KeyPositionBase getPositionKeyframe(int n, int n2, float f, float f2) {
        RectF rectF = new RectF();
        rectF.left = this.mStartMotionPath.x;
        rectF.top = this.mStartMotionPath.y;
        rectF.right = rectF.left + this.mStartMotionPath.width;
        rectF.bottom = rectF.top + this.mStartMotionPath.height;
        RectF rectF2 = new RectF();
        rectF2.left = this.mEndMotionPath.x;
        rectF2.top = this.mEndMotionPath.y;
        rectF2.right = rectF2.left + this.mEndMotionPath.width;
        rectF2.bottom = rectF2.top + this.mEndMotionPath.height;
        for (Key key : this.mKeyList) {
            if (!(key instanceof KeyPositionBase) || !((KeyPositionBase)(key = (KeyPositionBase)key)).intersects(n, n2, rectF, rectF2, f, f2)) continue;
            return key;
        }
        return null;
    }

    void getPostLayoutDvDp(float f, int n, int n2, float f2, float f3, float[] fArray) {
        float f4 = this.getAdjustedPosition(f, this.mVelocity);
        Object object = this.mAttributesMap;
        ViewOscillator viewOscillator = null;
        object = object == null ? null : (SplineSet)((HashMap)object).get("translationX");
        Object object2 = this.mAttributesMap;
        object2 = object2 == null ? null : (SplineSet)((HashMap)object2).get("translationY");
        Object object3 = this.mAttributesMap;
        object3 = object3 == null ? null : (SplineSet)((HashMap)object3).get("rotation");
        Object object4 = this.mAttributesMap;
        object4 = object4 == null ? null : (SplineSet)((HashMap)object4).get("scaleX");
        Object object5 = this.mAttributesMap;
        object5 = object5 == null ? null : (SplineSet)((HashMap)object5).get("scaleY");
        Object object6 = this.mCycleMap;
        object6 = object6 == null ? null : ((HashMap)object6).get("translationX");
        Object object7 = this.mCycleMap;
        object7 = object7 == null ? null : ((HashMap)object7).get("translationY");
        Object object8 = this.mCycleMap;
        object8 = object8 == null ? null : ((HashMap)object8).get("rotation");
        Object object9 = this.mCycleMap;
        object9 = object9 == null ? null : ((HashMap)object9).get("scaleX");
        HashMap<String, ViewOscillator> hashMap = this.mCycleMap;
        if (hashMap != null) {
            viewOscillator = hashMap.get("scaleY");
        }
        hashMap = new VelocityMatrix();
        ((VelocityMatrix)((Object)hashMap)).clear();
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((SplineSet)object3, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((SplineSet)object, (SplineSet)object2, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((SplineSet)object4, (SplineSet)object5, f4);
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((KeyCycleOscillator)object8, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((KeyCycleOscillator)object6, (KeyCycleOscillator)object7, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((KeyCycleOscillator)object9, viewOscillator, f4);
        CurveFit[] curveFitArray = this.mArcSpline;
        if (curveFitArray != null) {
            object = this.mInterpolateData;
            if (((Object)object).length > 0) {
                double d = f4;
                curveFitArray.getPos(d, (double[])object);
                this.mArcSpline.getSlope(d, this.mInterpolateVelocity);
                this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, this.mInterpolateVelocity, this.mInterpolateData);
            }
            ((VelocityMatrix)((Object)hashMap)).applyTransform(f2, f3, n, n2, fArray);
            return;
        }
        curveFitArray = this.mSpline;
        if (curveFitArray != null) {
            f = this.getAdjustedPosition(f4, this.mVelocity);
            object = this.mSpline[0];
            double d = f;
            ((CurveFit)object).getSlope(d, this.mInterpolateVelocity);
            this.mSpline[0].getPos(d, this.mInterpolateData);
            f = this.mVelocity[0];
            for (int i = 0; i < ((Object)(object = (Object)this.mInterpolateVelocity)).length; ++i) {
                object[i] = object[i] * (double)f;
            }
            this.mStartMotionPath.setDpDt(f2, f3, fArray, this.mInterpolateVariables, (double[])object, this.mInterpolateData);
            ((VelocityMatrix)((Object)hashMap)).applyTransform(f2, f3, n, n2, fArray);
            return;
        }
        float f5 = this.mEndMotionPath.x - this.mStartMotionPath.x;
        f = this.mEndMotionPath.y - this.mStartMotionPath.y;
        float f6 = this.mEndMotionPath.width;
        float f7 = this.mStartMotionPath.width;
        float f8 = this.mEndMotionPath.height;
        float f9 = this.mStartMotionPath.height;
        fArray[0] = f5 * (1.0f - f2) + (f6 - f7 + f5) * f2;
        fArray[1] = f * (1.0f - f3) + (f8 - f9 + f) * f3;
        ((VelocityMatrix)((Object)hashMap)).clear();
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((SplineSet)object3, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((SplineSet)object, (SplineSet)object2, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((SplineSet)object4, (SplineSet)object5, f4);
        ((VelocityMatrix)((Object)hashMap)).setRotationVelocity((KeyCycleOscillator)object8, f4);
        ((VelocityMatrix)((Object)hashMap)).setTranslationVelocity((KeyCycleOscillator)object6, (KeyCycleOscillator)object7, f4);
        ((VelocityMatrix)((Object)hashMap)).setScaleVelocity((KeyCycleOscillator)object9, viewOscillator, f4);
        ((VelocityMatrix)((Object)hashMap)).applyTransform(f2, f3, n, n2, fArray);
    }

    public float getStartHeight() {
        return this.mStartMotionPath.height;
    }

    public float getStartWidth() {
        return this.mStartMotionPath.width;
    }

    public float getStartX() {
        return this.mStartMotionPath.x;
    }

    public float getStartY() {
        return this.mStartMotionPath.y;
    }

    public int getTransformPivotTarget() {
        return this.mTransformPivotTarget;
    }

    public View getView() {
        return this.mView;
    }

    boolean interpolate(View view, float f, long l, KeyCache object) {
        boolean bl;
        int n;
        float f2;
        Object object2;
        boolean bl2;
        Object object32;
        Object object42;
        float f3;
        float f4;
        float f5;
        f = f5 = this.getAdjustedPosition(f, null);
        if (this.mQuantizeMotionSteps != Key.UNSET) {
            f4 = 1.0f / (float)this.mQuantizeMotionSteps;
            f3 = (float)Math.floor(f5 / f4);
            f = f5 = f5 % f4 / f4;
            if (!Float.isNaN(this.mQuantizeMotionPhase)) {
                f = (f5 + this.mQuantizeMotionPhase) % 1.0f;
            }
            f = (object42 = this.mQuantizeMotionInterpolator) != null ? object42.getInterpolation(f) : ((double)f > 0.5 ? 1.0f : 0.0f);
            f = f * f4 + f3 * f4;
        }
        if ((object42 = this.mAttributesMap) != null) {
            object42 = ((HashMap)object42).values().iterator();
            while (object42.hasNext()) {
                ((ViewSpline)object42.next()).setProperty(view, f);
            }
        }
        if ((object42 = this.mTimeCycleAttributesMap) != null) {
            object32 = ((HashMap)object42).values().iterator();
            object42 = null;
            bl2 = false;
            while (object32.hasNext()) {
                object2 = (ViewTimeCycle)object32.next();
                if (object2 instanceof ViewTimeCycle.PathRotate) {
                    object42 = (ViewTimeCycle.PathRotate)object2;
                    continue;
                }
                bl2 |= ((ViewTimeCycle)object2).setProperty(view, f, l, (KeyCache)object);
            }
        } else {
            object42 = null;
            bl2 = false;
        }
        if ((object32 = this.mSpline) != null) {
            object32 = object32[0];
            double d = f;
            object32.getPos(d, this.mInterpolateData);
            this.mSpline[0].getSlope(d, this.mInterpolateVelocity);
            object2 = this.mArcSpline;
            if (object2 != null && ((CurveFit[])(object32 = (Object)this.mInterpolateData)).length > 0) {
                ((CurveFit)object2).getPos(d, (double[])object32);
                this.mArcSpline.getSlope(d, this.mInterpolateVelocity);
            }
            if (!this.mNoMovement) {
                this.mStartMotionPath.setView(f, view, this.mInterpolateVariables, this.mInterpolateData, this.mInterpolateVelocity, null, this.mForceMeasure);
                this.mForceMeasure = false;
            }
            if (this.mTransformPivotTarget != Key.UNSET) {
                if (this.mTransformPivotView == null) {
                    this.mTransformPivotView = ((View)view.getParent()).findViewById(this.mTransformPivotTarget);
                }
                if ((object32 = this.mTransformPivotView) != null) {
                    f2 = (float)(object32.getTop() + this.mTransformPivotView.getBottom()) / 2.0f;
                    f3 = (float)(this.mTransformPivotView.getLeft() + this.mTransformPivotView.getRight()) / 2.0f;
                    if (view.getRight() - view.getLeft() > 0 && view.getBottom() - view.getTop() > 0) {
                        f5 = view.getLeft();
                        f4 = view.getTop();
                        view.setPivotX(f3 - f5);
                        view.setPivotY(f2 - f4);
                    }
                }
            }
            if ((object32 = this.mAttributesMap) != null) {
                for (Object object32 : object32.values()) {
                    double[] dArray;
                    if (!(object32 instanceof ViewSpline.PathRotate) || (dArray = this.mInterpolateVelocity).length <= 1) continue;
                    ((ViewSpline.PathRotate)object32).setPathRotate(view, f, dArray[0], dArray[1]);
                }
            }
            if (object42 != null) {
                object32 = this.mInterpolateVelocity;
                bl2 |= ((ViewTimeCycle.PathRotate)object42).setPathRotate(view, (KeyCache)object, f, l, (double)object32[0], (double)object32[1]);
            }
            for (n = 1; n < ((CurveFit[])(object = this.mSpline)).length; ++n) {
                object[n].getPos(d, this.mValuesBuff);
                CustomSupport.setInterpolatedValue(this.mStartMotionPath.attributes.get(this.mAttributeNames[n - 1]), view, this.mValuesBuff);
            }
            if (this.mStartPoint.mVisibilityMode == 0) {
                if (f <= 0.0f) {
                    view.setVisibility(this.mStartPoint.visibility);
                } else if (f >= 1.0f) {
                    view.setVisibility(this.mEndPoint.visibility);
                } else if (this.mEndPoint.visibility != this.mStartPoint.visibility) {
                    view.setVisibility(0);
                }
            }
            bl = bl2;
            if (this.mKeyTriggers != null) {
                n = 0;
                while (true) {
                    object = this.mKeyTriggers;
                    bl = bl2;
                    if (n < ((Object)object).length) {
                        ((KeyTrigger)object[n]).conditionallyFire(f, view);
                        ++n;
                        continue;
                    }
                    break;
                }
            }
        } else {
            float f6 = this.mStartMotionPath.x;
            float f7 = this.mEndMotionPath.x;
            float f8 = this.mStartMotionPath.x;
            float f9 = this.mStartMotionPath.y;
            float f10 = this.mEndMotionPath.y;
            float f11 = this.mStartMotionPath.y;
            float f12 = this.mStartMotionPath.width;
            f5 = this.mEndMotionPath.width;
            f2 = this.mStartMotionPath.width;
            f3 = this.mStartMotionPath.height;
            float f13 = this.mEndMotionPath.height;
            f4 = this.mStartMotionPath.height;
            f8 = f6 + (f7 - f8) * f + 0.5f;
            int n2 = (int)f8;
            f10 = f9 + (f10 - f11) * f + 0.5f;
            int n3 = (int)f10;
            n = (int)(f8 + (f12 + (f5 - f2) * f));
            int n4 = (int)(f10 + (f3 + (f13 - f4) * f));
            if (this.mEndMotionPath.width != this.mStartMotionPath.width || this.mEndMotionPath.height != this.mStartMotionPath.height || this.mForceMeasure) {
                view.measure(View.MeasureSpec.makeMeasureSpec((int)(n - n2), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n4 - n3), (int)0x40000000));
                this.mForceMeasure = false;
            }
            view.layout(n2, n3, n, n4);
            bl = bl2;
        }
        if ((object = this.mCycleMap) != null) {
            for (Object object42 : ((HashMap)object).values()) {
                if (object42 instanceof ViewOscillator.PathRotateSet) {
                    object42 = (ViewOscillator.PathRotateSet)object42;
                    object32 = this.mInterpolateVelocity;
                    ((ViewOscillator.PathRotateSet)object42).setPathRotate(view, f, (double)object32[0], (double)object32[1]);
                    continue;
                }
                ((ViewOscillator)object42).setProperty(view, f);
            }
        }
        return bl;
    }

    String name() {
        return this.mView.getContext().getResources().getResourceEntryName(this.mView.getId());
    }

    void positionKeyframe(View view, KeyPositionBase keyPositionBase, float f, float f2, String[] stringArray, float[] fArray) {
        RectF rectF = new RectF();
        rectF.left = this.mStartMotionPath.x;
        rectF.top = this.mStartMotionPath.y;
        rectF.right = rectF.left + this.mStartMotionPath.width;
        rectF.bottom = rectF.top + this.mStartMotionPath.height;
        RectF rectF2 = new RectF();
        rectF2.left = this.mEndMotionPath.x;
        rectF2.top = this.mEndMotionPath.y;
        rectF2.right = rectF2.left + this.mEndMotionPath.width;
        rectF2.bottom = rectF2.top + this.mEndMotionPath.height;
        keyPositionBase.positionAttributes(view, rectF, rectF2, f, f2, stringArray, fArray);
    }

    public void remeasure() {
        this.mForceMeasure = true;
    }

    void rotate(Rect rect, Rect rect2, int n, int n2, int n3) {
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        n = rect.left;
                        n3 = rect.right;
                        rect2.left = n2 - (rect.bottom + rect.top + rect.width()) / 2;
                        rect2.top = (n + n3 - rect.height()) / 2;
                        rect2.right = rect2.left + rect.width();
                        rect2.bottom = rect2.top + rect.height();
                    }
                } else {
                    n = rect.left + rect.right;
                    n2 = rect.top;
                    n2 = rect.bottom;
                    rect2.left = rect.height() / 2 + rect.top - n / 2;
                    rect2.top = n3 - (n + rect.height()) / 2;
                    rect2.right = rect2.left + rect.width();
                    rect2.bottom = rect2.top + rect.height();
                }
            } else {
                n = rect.left;
                n3 = rect.right;
                rect2.left = n2 - (rect.top + rect.bottom + rect.width()) / 2;
                rect2.top = (n + n3 - rect.height()) / 2;
                rect2.right = rect2.left + rect.width();
                rect2.bottom = rect2.top + rect.height();
            }
        } else {
            n2 = rect.left;
            n = rect.right;
            rect2.left = (rect.top + rect.bottom - rect.width()) / 2;
            rect2.top = n3 - (n2 + n + rect.height()) / 2;
            rect2.right = rect2.left + rect.width();
            rect2.bottom = rect2.top + rect.height();
        }
    }

    void setBothStates(View view) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.mNoMovement = true;
        this.mStartMotionPath.setBounds(view.getX(), view.getY(), view.getWidth(), view.getHeight());
        this.mEndMotionPath.setBounds(view.getX(), view.getY(), view.getWidth(), view.getHeight());
        this.mStartPoint.setState(view);
        this.mEndPoint.setState(view);
    }

    public void setDrawPath(int n) {
        this.mStartMotionPath.mDrawPath = n;
    }

    void setEndState(Rect rect, ConstraintSet constraintSet, int n, int n2) {
        int n3 = constraintSet.mRotate;
        Rect rect2 = rect;
        if (n3 != 0) {
            this.rotate(rect, this.mTempRect, n3, n, n2);
            rect2 = this.mTempRect;
        }
        this.mEndMotionPath.time = 1.0f;
        this.mEndMotionPath.position = 1.0f;
        this.readView(this.mEndMotionPath);
        this.mEndMotionPath.setBounds(rect2.left, rect2.top, rect2.width(), rect2.height());
        this.mEndMotionPath.applyParameters(constraintSet.getParameters(this.mId));
        this.mEndPoint.setState(rect2, constraintSet, n3, this.mId);
    }

    public void setPathMotionArc(int n) {
        this.mPathMotionArc = n;
    }

    void setStartCurrentState(View view) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.mStartMotionPath.setBounds(view.getX(), view.getY(), view.getWidth(), view.getHeight());
        this.mStartPoint.setState(view);
    }

    void setStartState(Rect rect, ConstraintSet constraintSet, int n, int n2) {
        int n3 = constraintSet.mRotate;
        if (n3 != 0) {
            this.rotate(rect, this.mTempRect, n3, n, n2);
        }
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        this.readView(this.mStartMotionPath);
        this.mStartMotionPath.setBounds(rect.left, rect.top, rect.width(), rect.height());
        ConstraintSet.Constraint constraint = constraintSet.getParameters(this.mId);
        this.mStartMotionPath.applyParameters(constraint);
        this.mMotionStagger = constraint.motion.mMotionStagger;
        this.mStartPoint.setState(rect, constraintSet, n3, this.mId);
        this.mTransformPivotTarget = constraint.transform.transformPivotTarget;
        this.mQuantizeMotionSteps = constraint.motion.mQuantizeMotionSteps;
        this.mQuantizeMotionPhase = constraint.motion.mQuantizeMotionPhase;
        this.mQuantizeMotionInterpolator = MotionController.getInterpolator(this.mView.getContext(), constraint.motion.mQuantizeInterpolatorType, constraint.motion.mQuantizeInterpolatorString, constraint.motion.mQuantizeInterpolatorID);
    }

    public void setStartState(ViewState viewState, View view, int n, int n2, int n3) {
        this.mStartMotionPath.time = 0.0f;
        this.mStartMotionPath.position = 0.0f;
        Rect rect = new Rect();
        if (n != 1) {
            if (n == 2) {
                int n4 = viewState.left;
                n2 = viewState.right;
                rect.left = n3 - (viewState.top + viewState.bottom + viewState.width()) / 2;
                rect.top = (n4 + n2 - viewState.height()) / 2;
                rect.right = rect.left + viewState.width();
                rect.bottom = rect.top + viewState.height();
            }
        } else {
            n3 = viewState.left;
            int n5 = viewState.right;
            rect.left = (viewState.top + viewState.bottom - viewState.width()) / 2;
            rect.top = n2 - (n3 + n5 + viewState.height()) / 2;
            rect.right = rect.left + viewState.width();
            rect.bottom = rect.top + viewState.height();
        }
        this.mStartMotionPath.setBounds(rect.left, rect.top, rect.width(), rect.height());
        this.mStartPoint.setState(rect, view, n, viewState.rotation);
    }

    public void setTransformPivotTarget(int n) {
        this.mTransformPivotTarget = n;
        this.mTransformPivotView = null;
    }

    public void setView(View view) {
        this.mView = view;
        this.mId = view.getId();
        if ((view = view.getLayoutParams()) instanceof ConstraintLayout.LayoutParams) {
            this.mConstraintTag = ((ConstraintLayout.LayoutParams)view).getConstraintTag();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setup(int n, int n2, float f, long l) {
        String[] stringArray;
        int[] nArray;
        int n3;
        String[] stringArray2;
        String string2;
        void var12_82;
        Object object;
        Object object2;
        new HashSet();
        Object object4 = new HashSet();
        HashSet<String> object52 = new HashSet<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Serializable serializable = new HashMap<String, Integer>();
        if (this.mPathMotionArc != Key.UNSET) {
            this.mStartMotionPath.mPathMotionArc = this.mPathMotionArc;
        }
        this.mStartPoint.different(this.mEndPoint, object52);
        ArrayList<Key> arrayList = this.mKeyList;
        if (arrayList != null) {
            object2 = arrayList.iterator();
            Object var10_22 = null;
            while (true) {
                void var10_23;
                void var12_76 = var10_23;
                if (object2.hasNext()) {
                    object = object2.next();
                    if (object instanceof KeyPosition) {
                        KeyPosition keyPosition = (KeyPosition)object;
                        this.insertKey(new MotionPaths(n, n2, keyPosition, this.mStartMotionPath, this.mEndMotionPath));
                        if (keyPosition.mCurveFit == Key.UNSET) continue;
                        this.mCurveFitType = keyPosition.mCurveFit;
                        continue;
                    }
                    if (object instanceof KeyCycle) {
                        ((Key)object).getAttributeNames(hashSet);
                        continue;
                    }
                    if (object instanceof KeyTimeCycle) {
                        ((Key)object).getAttributeNames((HashSet<String>)object4);
                        continue;
                    }
                    if (object instanceof KeyTrigger) {
                        void var12_80;
                        void var12_78 = var10_23;
                        if (var10_23 == null) {
                            ArrayList arrayList2 = new ArrayList();
                        }
                        var12_80.add((KeyTrigger)object);
                        void var10_24 = var12_80;
                        continue;
                    }
                    ((Key)object).setInterpolation((HashMap<String, Integer>)serializable);
                    ((Key)object).getAttributeNames(object52);
                    continue;
                }
                break;
            }
        } else {
            Object var12_81 = null;
        }
        if (var12_82 != null) {
            this.mKeyTriggers = var12_82.toArray(new KeyTrigger[0]);
        }
        if (!object52.isEmpty()) {
            this.mAttributesMap = new HashMap();
            object2 = object52.iterator();
            while (object2.hasNext()) {
                void var10_30;
                String string3 = (String)object2.next();
                if (string3.startsWith("CUSTOM,")) {
                    object = new SparseArray();
                    string2 = string3.split(",")[1];
                    for (Key key : this.mKeyList) {
                        ConstraintAttribute constraintAttribute;
                        if (key.mCustomConstraints == null || (constraintAttribute = key.mCustomConstraints.get(string2)) == null) continue;
                        object.append(key.mFramePosition, (Object)constraintAttribute);
                    }
                    ViewSpline viewSpline = ViewSpline.makeCustomSpline(string3, (SparseArray<ConstraintAttribute>)object);
                } else {
                    ViewSpline viewSpline = ViewSpline.makeSpline(string3);
                }
                if (var10_30 == null) continue;
                var10_30.setType(string3);
                this.mAttributesMap.put(string3, (ViewSpline)var10_30);
            }
            ArrayList<Key> arrayList3 = this.mKeyList;
            if (arrayList3 != null) {
                for (Key key : arrayList3) {
                    if (!(key instanceof KeyAttributes)) continue;
                    key.addValues(this.mAttributesMap);
                }
            }
            this.mStartPoint.addValues(this.mAttributesMap, 0);
            this.mEndPoint.addValues(this.mAttributesMap, 100);
            for (String string4 : this.mAttributesMap.keySet()) {
                n = ((HashMap)serializable).containsKey(string4) && (object2 = ((HashMap)serializable).get(string4)) != null ? (Integer)object2 : 0;
                SplineSet splineSet = this.mAttributesMap.get(string4);
                if (splineSet == null) continue;
                splineSet.setup(n);
            }
        }
        if (!((HashSet)object4).isEmpty()) {
            if (this.mTimeCycleAttributesMap == null) {
                this.mTimeCycleAttributesMap = new HashMap();
            }
            Iterator iterator = ((HashSet)object4).iterator();
            while (iterator.hasNext()) {
                void var10_40;
                object4 = (String)iterator.next();
                if (this.mTimeCycleAttributesMap.containsKey(object4)) continue;
                if (((String)object4).startsWith("CUSTOM,")) {
                    string2 = new SparseArray();
                    String string5 = ((String)object4).split(",")[1];
                    for (Key key : this.mKeyList) {
                        if (key.mCustomConstraints == null || (object = key.mCustomConstraints.get(string5)) == null) continue;
                        string2.append(key.mFramePosition, object);
                    }
                    ViewTimeCycle viewTimeCycle = ViewTimeCycle.makeCustomSpline((String)object4, (SparseArray<ConstraintAttribute>)string2);
                } else {
                    ViewTimeCycle viewTimeCycle = ViewTimeCycle.makeSpline((String)object4, l);
                }
                if (var10_40 == null) continue;
                var10_40.setType((String)object4);
                this.mTimeCycleAttributesMap.put((String)object4, (ViewTimeCycle)var10_40);
            }
            ArrayList<Key> arrayList4 = this.mKeyList;
            if (arrayList4 != null) {
                for (Key key : arrayList4) {
                    if (!(key instanceof KeyTimeCycle)) continue;
                    ((KeyTimeCycle)key).addTimeValues(this.mTimeCycleAttributesMap);
                }
            }
            for (String string6 : this.mTimeCycleAttributesMap.keySet()) {
                n = ((HashMap)serializable).containsKey(string6) ? ((HashMap)serializable).get(string6) : 0;
                this.mTimeCycleAttributesMap.get(string6).setup(n);
            }
        }
        int n4 = this.mMotionPaths.size() + 2;
        object4 = new MotionPaths[n4];
        object4[0] = this.mStartMotionPath;
        object4[n4 - 1] = this.mEndMotionPath;
        if (this.mMotionPaths.size() > 0 && this.mCurveFitType == -1) {
            this.mCurveFitType = 0;
        }
        Iterator<MotionPaths> iterator = this.mMotionPaths.iterator();
        n = 1;
        while (iterator.hasNext()) {
            object4[n] = iterator.next();
            ++n;
        }
        object2 = new HashSet();
        for (String string7 : this.mEndMotionPath.attributes.keySet()) {
            if (!this.mStartMotionPath.attributes.containsKey(string7)) continue;
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append("CUSTOM,");
            ((StringBuilder)serializable).append(string7);
            if (object52.contains(((StringBuilder)serializable).toString())) continue;
            ((HashSet)object2).add(string7);
        }
        String[] stringArray3 = ((HashSet)object2).toArray(new String[0]);
        this.mAttributeNames = stringArray3;
        this.mAttributeInterpolatorCount = new int[stringArray3.length];
        block11: for (n = 0; n < (stringArray2 = this.mAttributeNames).length; ++n) {
            String string8 = stringArray2[n];
            this.mAttributeInterpolatorCount[n] = 0;
            for (n2 = 0; n2 < n4; ++n2) {
                ConstraintAttribute constraintAttribute;
                if (!((MotionPaths)object4[n2]).attributes.containsKey(string8) || (constraintAttribute = ((MotionPaths)object4[n2]).attributes.get(string8)) == null) continue;
                int[] nArray2 = this.mAttributeInterpolatorCount;
                nArray2[n] = nArray2[n] + constraintAttribute.numberOfInterpolatedValues();
                continue block11;
            }
        }
        boolean bl = ((MotionPaths)object4[0]).mPathMotionArc != Key.UNSET;
        int n5 = 18 + this.mAttributeNames.length;
        boolean[] blArray = new boolean[n5];
        for (n = 1; n < n4; ++n) {
            ((MotionPaths)object4[n]).different((MotionPaths)object4[n - 1], blArray, this.mAttributeNames, bl);
        }
        n = 0;
        for (n2 = 1; n2 < n5; ++n2) {
            n3 = n;
            if (blArray[n2]) {
                n3 = n + 1;
            }
            n = n3;
        }
        this.mInterpolateVariables = new int[n];
        n = Math.max(2, n);
        this.mInterpolateData = new double[n];
        this.mInterpolateVelocity = new double[n];
        n3 = 0;
        for (n2 = 1; n2 < n5; ++n2) {
            n = n3;
            if (blArray[n2]) {
                this.mInterpolateVariables[n3] = n2;
                n = n3 + 1;
            }
            n3 = n;
        }
        object2 = new double[n4][this.mInterpolateVariables.length];
        object = new double[n4];
        for (n = 0; n < n4; ++n) {
            ((MotionPaths)object4[n]).fillStandard((double[])object2[n], this.mInterpolateVariables);
            object[n] = (double)((MotionPaths)object4[n]).time;
        }
        for (n = 0; n < (nArray = this.mInterpolateVariables).length; ++n) {
            if (nArray[n] >= MotionPaths.names.length) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(MotionPaths.names[this.mInterpolateVariables[n]]);
            stringBuilder.append(" [");
            String string9 = stringBuilder.toString();
            for (n2 = 0; n2 < n4; ++n2) {
                void var10_59;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append((String)var10_59);
                stringBuilder2.append((double)object2[n2][n]);
                String string10 = stringBuilder2.toString();
            }
        }
        this.mSpline = new CurveFit[this.mAttributeNames.length + 1];
        n = 0;
        while (n < (stringArray = this.mAttributeNames).length) {
            void var10_65;
            void var12_105;
            String string11 = stringArray[n];
            Object var12_104 = null;
            n2 = 0;
            Object var10_64 = null;
            for (n3 = 0; n3 < n4; ++n3) {
                void var7_13;
                serializable = var12_105;
                n5 = n2;
                void var7_9 = var10_65;
                if (((MotionPaths)object4[n3]).hasCustomData(string11)) {
                    void var12_107;
                    void var7_12;
                    void var7_10 = var10_65;
                    if (var10_65 == null) {
                        double[] dArray = new double[n4];
                        double[][] dArray2 = new double[n4][((MotionPaths)object4[n3]).getCustomDataCount(string11)];
                    }
                    var12_107[n2] = ((MotionPaths)object4[n3]).time;
                    ((MotionPaths)object4[n3]).getCustomData(string11, (double[])var7_12[n2], 0);
                    n5 = n2 + 1;
                    serializable = var12_107;
                }
                Serializable serializable2 = serializable;
                n2 = n5;
                void var10_66 = var7_13;
            }
            double[] dArray = Arrays.copyOf((double[])var12_105, n2);
            double[][] dArray3 = (double[][])Arrays.copyOf(var10_65, n2);
            CurveFit[] curveFitArray = this.mSpline;
            curveFitArray[++n] = CurveFit.get(this.mCurveFitType, dArray, dArray3);
        }
        this.mSpline[0] = CurveFit.get(this.mCurveFitType, (double[])object, (double[][])object2);
        if (((MotionPaths)object4[0]).mPathMotionArc != Key.UNSET) {
            int[] nArray3 = new int[n4];
            double[] dArray = new double[n4];
            double[][] dArray4 = new double[n4][2];
            for (n = 0; n < n4; ++n) {
                nArray3[n] = ((MotionPaths)object4[n]).mPathMotionArc;
                dArray[n] = ((MotionPaths)object4[n]).time;
                dArray4[n][0] = ((MotionPaths)object4[n]).x;
                dArray4[n][1] = ((MotionPaths)object4[n]).y;
            }
            this.mArcSpline = CurveFit.getArc(nArray3, dArray, dArray4);
        }
        float f2 = Float.NaN;
        this.mCycleMap = new HashMap();
        if (this.mKeyList != null) {
            for (String string12 : hashSet) {
                ViewOscillator viewOscillator = ViewOscillator.makeSpline(string12);
                if (viewOscillator == null) continue;
                f = f2;
                if (viewOscillator.variesByPath()) {
                    f = f2;
                    if (Float.isNaN(f2)) {
                        f = this.getPreCycleDistance();
                    }
                }
                viewOscillator.setType(string12);
                this.mCycleMap.put(string12, viewOscillator);
                f2 = f;
            }
            for (Key key : this.mKeyList) {
                if (!(key instanceof KeyCycle)) continue;
                ((KeyCycle)key).addCycleValues(this.mCycleMap);
            }
            Iterator<ViewOscillator> iterator2 = this.mCycleMap.values().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().setup(f2);
            }
        }
    }

    public void setupRelative(MotionController motionController) {
        this.mStartMotionPath.setupRelative(motionController, motionController.mStartMotionPath);
        this.mEndMotionPath.setupRelative(motionController, motionController.mEndMotionPath);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" start: x: ");
        stringBuilder.append(this.mStartMotionPath.x);
        stringBuilder.append(" y: ");
        stringBuilder.append(this.mStartMotionPath.y);
        stringBuilder.append(" end: x: ");
        stringBuilder.append(this.mEndMotionPath.x);
        stringBuilder.append(" y: ");
        stringBuilder.append(this.mEndMotionPath.y);
        return stringBuilder.toString();
    }
}

