/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionHelperInterface;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;

public class MotionHelper
extends ConstraintHelper
implements MotionHelperInterface {
    private float mProgress;
    private boolean mUseOnHide = false;
    private boolean mUseOnShow = false;
    protected View[] views;

    public MotionHelper(Context context) {
        super(context);
    }

    public MotionHelper(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(attributeSet);
    }

    public MotionHelper(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(attributeSet);
    }

    @Override
    public float getProgress() {
        return this.mProgress;
    }

    @Override
    protected void init(AttributeSet attributeSet) {
        super.init(attributeSet);
        if (attributeSet != null) {
            attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.MotionHelper);
            int n = attributeSet.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = attributeSet.getIndex(i);
                if (n2 == R.styleable.MotionHelper_onShow) {
                    this.mUseOnShow = attributeSet.getBoolean(n2, this.mUseOnShow);
                    continue;
                }
                if (n2 != R.styleable.MotionHelper_onHide) continue;
                this.mUseOnHide = attributeSet.getBoolean(n2, this.mUseOnHide);
            }
            attributeSet.recycle();
        }
    }

    @Override
    public boolean isDecorator() {
        return false;
    }

    @Override
    public boolean isUseOnHide() {
        return this.mUseOnHide;
    }

    @Override
    public boolean isUsedOnShow() {
        return this.mUseOnShow;
    }

    @Override
    public void onFinishedMotionScene(MotionLayout motionLayout) {
    }

    @Override
    public void onPostDraw(Canvas canvas) {
    }

    @Override
    public void onPreDraw(Canvas canvas) {
    }

    @Override
    public void onPreSetup(MotionLayout motionLayout, HashMap<View, MotionController> hashMap) {
    }

    @Override
    public void onTransitionChange(MotionLayout motionLayout, int n, int n2, float f) {
    }

    @Override
    public void onTransitionCompleted(MotionLayout motionLayout, int n) {
    }

    @Override
    public void onTransitionStarted(MotionLayout motionLayout, int n, int n2) {
    }

    @Override
    public void onTransitionTrigger(MotionLayout motionLayout, int n, boolean bl, float f) {
    }

    @Override
    public void setProgress(float f) {
        int n;
        this.mProgress = f;
        int n2 = this.mCount;
        int n3 = 0;
        if (n2 > 0) {
            this.views = this.getViews((ConstraintLayout)this.getParent());
            for (n = n3; n < this.mCount; ++n) {
                this.setProgress(this.views[n], f);
            }
        } else {
            ViewGroup viewGroup = (ViewGroup)this.getParent();
            n3 = viewGroup.getChildCount();
            for (n = 0; n < n3; ++n) {
                View view = viewGroup.getChildAt(n);
                if (view instanceof MotionHelper) continue;
                this.setProgress(view, f);
            }
        }
    }

    public void setProgress(View view, float f) {
    }
}

