/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.TextView;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Flow;
import androidx.constraintlayout.core.widgets.Guideline;
import androidx.constraintlayout.core.widgets.Helper;
import androidx.constraintlayout.core.widgets.HelperWidget;
import androidx.constraintlayout.core.widgets.Placeholder;
import androidx.constraintlayout.core.widgets.VirtualLayout;
import androidx.constraintlayout.core.widgets.WidgetContainer;
import androidx.constraintlayout.motion.utils.StopLogic;
import androidx.constraintlayout.motion.utils.ViewState;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.DesignTool;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionHelper;
import androidx.constraintlayout.motion.widget.MotionInterpolator;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.motion.widget.TouchResponse;
import androidx.constraintlayout.widget.Barrier;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.Constraints;
import androidx.constraintlayout.widget.R;
import androidx.core.view.NestedScrollingParent3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class MotionLayout
extends ConstraintLayout
implements NestedScrollingParent3 {
    private static final boolean DEBUG = false;
    public static final int DEBUG_SHOW_NONE = 0;
    public static final int DEBUG_SHOW_PATH = 2;
    public static final int DEBUG_SHOW_PROGRESS = 1;
    private static final float EPSILON = 1.0E-5f;
    public static boolean IS_IN_EDIT_MODE = false;
    static final int MAX_KEY_FRAMES = 50;
    static final String TAG = "MotionLayout";
    public static final int TOUCH_UP_COMPLETE = 0;
    public static final int TOUCH_UP_COMPLETE_TO_END = 2;
    public static final int TOUCH_UP_COMPLETE_TO_START = 1;
    public static final int TOUCH_UP_DECELERATE = 4;
    public static final int TOUCH_UP_DECELERATE_AND_COMPLETE = 5;
    public static final int TOUCH_UP_NEVER_TO_END = 7;
    public static final int TOUCH_UP_NEVER_TO_START = 6;
    public static final int TOUCH_UP_STOP = 3;
    public static final int VELOCITY_LAYOUT = 1;
    public static final int VELOCITY_POST_LAYOUT = 0;
    public static final int VELOCITY_STATIC_LAYOUT = 3;
    public static final int VELOCITY_STATIC_POST_LAYOUT = 2;
    boolean firstDown = true;
    private float lastPos;
    private float lastY;
    private long mAnimationStartTime = 0L;
    private int mBeginState = -1;
    private RectF mBoundsCheck;
    int mCurrentState = -1;
    int mDebugPath = 0;
    private DecelerateInterpolator mDecelerateLogic;
    private ArrayList<MotionHelper> mDecoratorsHelpers = null;
    private boolean mDelayedApply = false;
    private DesignTool mDesignTool;
    DevModeDraw mDevModeDraw;
    private int mEndState = -1;
    int mEndWrapHeight;
    int mEndWrapWidth;
    HashMap<View, MotionController> mFrameArrayList = new HashMap();
    private int mFrames = 0;
    int mHeightMeasureMode;
    private boolean mInLayout = false;
    private boolean mInRotation = false;
    boolean mInTransition = false;
    boolean mIndirectTransition = false;
    private boolean mInteractionEnabled = true;
    Interpolator mInterpolator;
    private Matrix mInverseMatrix = null;
    boolean mIsAnimating = false;
    private boolean mKeepAnimating = false;
    private KeyCache mKeyCache;
    private long mLastDrawTime = -1L;
    private float mLastFps = 0.0f;
    private int mLastHeightMeasureSpec = 0;
    int mLastLayoutHeight;
    int mLastLayoutWidth;
    float mLastVelocity = 0.0f;
    private int mLastWidthMeasureSpec = 0;
    private float mListenerPosition = 0.0f;
    private int mListenerState = 0;
    protected boolean mMeasureDuringTransition = false;
    Model mModel;
    private boolean mNeedsFireTransitionCompleted = false;
    int mOldHeight;
    int mOldWidth;
    private Runnable mOnComplete = null;
    private ArrayList<MotionHelper> mOnHideHelpers = null;
    private ArrayList<MotionHelper> mOnShowHelpers = null;
    float mPostInterpolationPosition;
    HashMap<View, ViewState> mPreRotate;
    private int mPreRotateHeight;
    private int mPreRotateWidth;
    private int mPreviouseRotation;
    Interpolator mProgressInterpolator = null;
    private View mRegionView = null;
    int mRotatMode = 0;
    MotionScene mScene;
    private int[] mScheduledTransitionTo = null;
    int mScheduledTransitions = 0;
    float mScrollTargetDT;
    float mScrollTargetDX;
    float mScrollTargetDY;
    long mScrollTargetTime;
    int mStartWrapHeight;
    int mStartWrapWidth;
    private StateCache mStateCache;
    private StopLogic mStopLogic = new StopLogic();
    Rect mTempRect;
    private boolean mTemporalInterpolator = false;
    ArrayList<Integer> mTransitionCompleted;
    private float mTransitionDuration = 1.0f;
    float mTransitionGoalPosition = 0.0f;
    private boolean mTransitionInstantly;
    float mTransitionLastPosition = 0.0f;
    private long mTransitionLastTime;
    private TransitionListener mTransitionListener;
    private CopyOnWriteArrayList<TransitionListener> mTransitionListeners = null;
    float mTransitionPosition = 0.0f;
    TransitionState mTransitionState;
    boolean mUndergoingMotion = false;
    int mWidthMeasureMode;

    public MotionLayout(Context context) {
        super(context);
        this.mDecelerateLogic = new DecelerateInterpolator();
        this.mKeyCache = new KeyCache();
        this.mPreRotate = new HashMap();
        this.mTempRect = new Rect();
        this.mTransitionState = TransitionState.UNDEFINED;
        this.mModel = new Model();
        this.mBoundsCheck = new RectF();
        this.mTransitionCompleted = new ArrayList();
        this.init(null);
    }

    public MotionLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mDecelerateLogic = new DecelerateInterpolator();
        this.mKeyCache = new KeyCache();
        this.mPreRotate = new HashMap();
        this.mTempRect = new Rect();
        this.mTransitionState = TransitionState.UNDEFINED;
        this.mModel = new Model();
        this.mBoundsCheck = new RectF();
        this.mTransitionCompleted = new ArrayList();
        this.init(attributeSet);
    }

    public MotionLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mDecelerateLogic = new DecelerateInterpolator();
        this.mKeyCache = new KeyCache();
        this.mPreRotate = new HashMap();
        this.mTempRect = new Rect();
        this.mTransitionState = TransitionState.UNDEFINED;
        this.mModel = new Model();
        this.mBoundsCheck = new RectF();
        this.mTransitionCompleted = new ArrayList();
        this.init(attributeSet);
    }

    static /* synthetic */ boolean access$302(MotionLayout motionLayout, boolean bl) {
        motionLayout.mInRotation = bl;
        return bl;
    }

    private boolean callTransformedTouchEvent(View view, MotionEvent motionEvent, float f, float f2) {
        Matrix matrix = view.getMatrix();
        if (matrix.isIdentity()) {
            motionEvent.offsetLocation(f, f2);
            boolean bl = view.onTouchEvent(motionEvent);
            motionEvent.offsetLocation(-f, -f2);
            return bl;
        }
        motionEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent.offsetLocation(f, f2);
        if (this.mInverseMatrix == null) {
            this.mInverseMatrix = new Matrix();
        }
        matrix.invert(this.mInverseMatrix);
        motionEvent.transform(this.mInverseMatrix);
        boolean bl = view.onTouchEvent(motionEvent);
        motionEvent.recycle();
        return bl;
    }

    private void checkStructure() {
        Object object = this.mScene;
        if (object == null) {
            Log.e((String)TAG, (String)"CHECK: motion scene not set! set \"app:layoutDescription=\"@xml/file\"");
            return;
        }
        int n = ((MotionScene)object).getStartId();
        object = this.mScene;
        this.checkStructure(n, ((MotionScene)object).getConstraintSet(((MotionScene)object).getStartId()));
        SparseIntArray sparseIntArray = new SparseIntArray();
        SparseIntArray sparseIntArray2 = new SparseIntArray();
        for (MotionScene.Transition transition : this.mScene.getDefinedTransitions()) {
            StringBuilder stringBuilder;
            if (transition == this.mScene.mCurrentTransition) {
                Log.v((String)TAG, (String)"CHECK: CURRENT");
            }
            this.checkStructure(transition);
            n = transition.getStartConstraintSetId();
            int n2 = transition.getEndConstraintSetId();
            String object2 = Debug.getName(this.getContext(), n);
            CharSequence charSequence = Debug.getName(this.getContext(), n2);
            if (sparseIntArray.get(n) == n2) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("CHECK: two transitions with the same start and end ");
                stringBuilder.append(object2);
                stringBuilder.append("->");
                stringBuilder.append((String)charSequence);
                Log.e((String)TAG, (String)stringBuilder.toString());
            }
            if (sparseIntArray2.get(n2) == n) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("CHECK: you can't have reverse transitions");
                stringBuilder.append(object2);
                stringBuilder.append("->");
                stringBuilder.append((String)charSequence);
                Log.e((String)TAG, (String)stringBuilder.toString());
            }
            sparseIntArray.put(n, n2);
            sparseIntArray2.put(n2, n);
            if (this.mScene.getConstraintSet(n) == null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(" no such constraintSetStart ");
                ((StringBuilder)charSequence).append(object2);
                Log.e((String)TAG, (String)((StringBuilder)charSequence).toString());
            }
            if (this.mScene.getConstraintSet(n2) != null) continue;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(" no such constraintSetEnd ");
            ((StringBuilder)charSequence).append(object2);
            Log.e((String)TAG, (String)((StringBuilder)charSequence).toString());
        }
    }

    private void checkStructure(int n, ConstraintSet constraintSet) {
        Object object;
        Object object2;
        String string2 = Debug.getName(this.getContext(), n);
        int n2 = this.getChildCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            object2 = this.getChildAt(n);
            int n4 = object2.getId();
            if (n4 == -1) {
                object = new StringBuilder();
                ((StringBuilder)object).append("CHECK: ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" ALL VIEWS SHOULD HAVE ID's ");
                ((StringBuilder)object).append(object2.getClass().getName());
                ((StringBuilder)object).append(" does not!");
                Log.w((String)TAG, (String)((StringBuilder)object).toString());
            }
            if (constraintSet.getConstraint(n4) != null) continue;
            object = new StringBuilder();
            ((StringBuilder)object).append("CHECK: ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" NO CONSTRAINTS for ");
            ((StringBuilder)object).append(Debug.getName((View)object2));
            Log.w((String)TAG, (String)((StringBuilder)object).toString());
        }
        object = constraintSet.getKnownIds();
        for (n = n3; n < ((int[])object).length; ++n) {
            StringBuilder stringBuilder;
            n3 = object[n];
            object2 = Debug.getName(this.getContext(), n3);
            if (this.findViewById((int)object[n]) == null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("CHECK: ");
                stringBuilder.append(string2);
                stringBuilder.append(" NO View matches id ");
                stringBuilder.append((String)object2);
                Log.w((String)TAG, (String)stringBuilder.toString());
            }
            if (constraintSet.getHeight(n3) == -1) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("CHECK: ");
                stringBuilder.append(string2);
                stringBuilder.append("(");
                stringBuilder.append((String)object2);
                stringBuilder.append(") no LAYOUT_HEIGHT");
                Log.w((String)TAG, (String)stringBuilder.toString());
            }
            if (constraintSet.getWidth(n3) != -1) continue;
            stringBuilder = new StringBuilder();
            stringBuilder.append("CHECK: ");
            stringBuilder.append(string2);
            stringBuilder.append("(");
            stringBuilder.append((String)object2);
            stringBuilder.append(") no LAYOUT_HEIGHT");
            Log.w((String)TAG, (String)stringBuilder.toString());
        }
    }

    private void checkStructure(MotionScene.Transition transition) {
        if (transition.getStartConstraintSetId() == transition.getEndConstraintSetId()) {
            Log.e((String)TAG, (String)"CHECK: start and end constraint set should not be the same!");
        }
    }

    private void computeCurrentPositions() {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            MotionController motionController = this.mFrameArrayList.get(view);
            if (motionController == null) continue;
            motionController.setStartCurrentState(view);
        }
    }

    private void debugPos() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" ");
            stringBuilder.append(Debug.getLocation());
            stringBuilder.append(" ");
            stringBuilder.append(Debug.getName((View)this));
            stringBuilder.append(" ");
            stringBuilder.append(Debug.getName(this.getContext(), this.mCurrentState));
            stringBuilder.append(" ");
            stringBuilder.append(Debug.getName(view));
            stringBuilder.append(view.getLeft());
            stringBuilder.append(" ");
            stringBuilder.append(view.getTop());
            Log.v((String)TAG, (String)stringBuilder.toString());
        }
    }

    private void evaluateLayout() {
        int n;
        float f;
        int n2;
        float f2;
        Object object;
        long l;
        block14: {
            block13: {
                float f3 = Math.signum(this.mTransitionGoalPosition - this.mTransitionLastPosition);
                l = this.getNanoTime();
                object = this.mInterpolator;
                float f4 = !(object instanceof StopLogic) ? (float)(l - this.mTransitionLastTime) * f3 * 1.0E-9f / this.mTransitionDuration : 0.0f;
                f2 = this.mTransitionLastPosition + f4;
                if (this.mTransitionInstantly) {
                    f2 = this.mTransitionGoalPosition;
                }
                n2 = 0;
                float f5 = f3 - 0.0f;
                f = f5 == 0.0f ? 0 : (f5 > 0.0f ? 1 : -1);
                if (f > 0 && f2 >= this.mTransitionGoalPosition || f3 <= 0.0f && f2 <= this.mTransitionGoalPosition) {
                    f2 = this.mTransitionGoalPosition;
                    n = 1;
                } else {
                    n = 0;
                }
                f4 = f2;
                if (object != null) {
                    f4 = f2;
                    if (n == 0) {
                        f4 = this.mTemporalInterpolator ? object.getInterpolation((float)(l - this.mAnimationStartTime) * 1.0E-9f) : object.getInterpolation(f2);
                    }
                }
                if (f > 0 && f4 >= this.mTransitionGoalPosition) break block13;
                f2 = f4;
                if (!(f3 <= 0.0f)) break block14;
                f2 = f4;
                if (!(f4 <= this.mTransitionGoalPosition)) break block14;
            }
            f2 = this.mTransitionGoalPosition;
        }
        this.mPostInterpolationPosition = f2;
        f = this.getChildCount();
        l = this.getNanoTime();
        object = this.mProgressInterpolator;
        if (object == null) {
            n = n2;
        } else {
            f2 = object.getInterpolation(f2);
            n = n2;
        }
        while (n < f) {
            View view = this.getChildAt(n);
            object = this.mFrameArrayList.get(view);
            if (object != null) {
                ((MotionController)object).interpolate(view, f2, l, this.mKeyCache);
            }
            ++n;
        }
        if (this.mMeasureDuringTransition) {
            this.requestLayout();
        }
    }

    private void fireTransitionChange() {
        Object object;
        if ((this.mTransitionListener != null || (object = this.mTransitionListeners) != null && !((CopyOnWriteArrayList)object).isEmpty()) && this.mListenerPosition != this.mTransitionPosition) {
            float f;
            if (this.mListenerState != -1) {
                object = this.mTransitionListener;
                if (object != null) {
                    object.onTransitionStarted(this, this.mBeginState, this.mEndState);
                }
                if ((object = this.mTransitionListeners) != null) {
                    object = ((CopyOnWriteArrayList)object).iterator();
                    while (object.hasNext()) {
                        object.next().onTransitionStarted(this, this.mBeginState, this.mEndState);
                    }
                }
                this.mIsAnimating = true;
            }
            this.mListenerState = -1;
            this.mListenerPosition = f = this.mTransitionPosition;
            object = this.mTransitionListener;
            if (object != null) {
                object.onTransitionChange(this, this.mBeginState, this.mEndState, f);
            }
            if ((object = this.mTransitionListeners) != null) {
                object = ((CopyOnWriteArrayList)object).iterator();
                while (object.hasNext()) {
                    ((TransitionListener)object.next()).onTransitionChange(this, this.mBeginState, this.mEndState, this.mTransitionPosition);
                }
            }
            this.mIsAnimating = true;
        }
    }

    private void fireTransitionStarted(MotionLayout motionLayout, int n, int n2) {
        Object object = this.mTransitionListener;
        if (object != null) {
            object.onTransitionStarted(this, n, n2);
        }
        if ((object = this.mTransitionListeners) != null) {
            object = ((CopyOnWriteArrayList)object).iterator();
            while (object.hasNext()) {
                ((TransitionListener)object.next()).onTransitionStarted(motionLayout, n, n2);
            }
        }
    }

    private boolean handlesTouchEvent(float f, float f2, View view, MotionEvent motionEvent) {
        boolean bl;
        block4: {
            bl = view instanceof ViewGroup;
            boolean bl2 = true;
            if (bl) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = viewGroup.getChildCount() - 1; i >= 0; --i) {
                    View view2 = viewGroup.getChildAt(i);
                    if (!this.handlesTouchEvent((float)view2.getLeft() + f - (float)view.getScrollX(), (float)view2.getTop() + f2 - (float)view.getScrollY(), view2, motionEvent)) continue;
                    bl = true;
                    break;
                }
            } else {
                bl = false;
            }
            if (bl) break block4;
            this.mBoundsCheck.set(f, f2, (float)view.getRight() + f - (float)view.getLeft(), (float)view.getBottom() + f2 - (float)view.getTop());
            if ((motionEvent.getAction() != 0 || this.mBoundsCheck.contains(motionEvent.getX(), motionEvent.getY())) && this.callTransformedTouchEvent(view, motionEvent, -f, -f2)) {
                bl = bl2;
            }
        }
        return bl;
    }

    private void init(AttributeSet object) {
        IS_IN_EDIT_MODE = this.isInEditMode();
        if (object != null) {
            object = this.getContext().obtainStyledAttributes((AttributeSet)object, R.styleable.MotionLayout);
            int n = object.getIndexCount();
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                boolean bl2;
                int n2 = object.getIndex(i);
                if (n2 == R.styleable.MotionLayout_layoutDescription) {
                    n2 = object.getResourceId(n2, -1);
                    this.mScene = new MotionScene(this.getContext(), this, n2);
                    bl2 = bl;
                } else if (n2 == R.styleable.MotionLayout_currentState) {
                    this.mCurrentState = object.getResourceId(n2, -1);
                    bl2 = bl;
                } else if (n2 == R.styleable.MotionLayout_motionProgress) {
                    this.mTransitionGoalPosition = object.getFloat(n2, 0.0f);
                    this.mInTransition = true;
                    bl2 = bl;
                } else if (n2 == R.styleable.MotionLayout_applyMotionScene) {
                    bl2 = object.getBoolean(n2, bl);
                } else if (n2 == R.styleable.MotionLayout_showPaths) {
                    bl2 = bl;
                    if (this.mDebugPath == 0) {
                        n2 = object.getBoolean(n2, false) ? 2 : 0;
                        this.mDebugPath = n2;
                        bl2 = bl;
                    }
                } else {
                    bl2 = bl;
                    if (n2 == R.styleable.MotionLayout_motionDebug) {
                        this.mDebugPath = object.getInt(n2, 0);
                        bl2 = bl;
                    }
                }
                bl = bl2;
            }
            object.recycle();
            if (this.mScene == null) {
                Log.e((String)TAG, (String)"WARNING NO app:layoutDescription tag");
            }
            if (!bl) {
                this.mScene = null;
            }
        }
        if (this.mDebugPath != 0) {
            this.checkStructure();
        }
        if (this.mCurrentState == -1 && (object = this.mScene) != null) {
            this.mCurrentState = ((MotionScene)object).getStartId();
            this.mBeginState = this.mScene.getStartId();
            this.mEndState = this.mScene.getEndId();
        }
    }

    private void processTransitionCompleted() {
        Object object;
        if (this.mTransitionListener == null && ((object = this.mTransitionListeners) == null || ((CopyOnWriteArrayList)object).isEmpty())) {
            return;
        }
        this.mIsAnimating = false;
        for (Integer n : this.mTransitionCompleted) {
            Object object2 = this.mTransitionListener;
            if (object2 != null) {
                object2.onTransitionCompleted(this, n);
            }
            if ((object2 = this.mTransitionListeners) == null) continue;
            object2 = ((CopyOnWriteArrayList)object2).iterator();
            while (object2.hasNext()) {
                ((TransitionListener)object2.next()).onTransitionCompleted(this, n);
            }
        }
        this.mTransitionCompleted.clear();
    }

    private void setupMotionViews() {
        block21: {
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            block20: {
                Object object2;
                Object object3;
                n4 = this.getChildCount();
                this.mModel.build();
                int n5 = 1;
                this.mInTransition = true;
                object = new SparseArray();
                int n6 = 0;
                int n7 = 0;
                for (n3 = 0; n3 < n4; ++n3) {
                    object3 = this.getChildAt(n3);
                    object.put(object3.getId(), (Object)this.mFrameArrayList.get(object3));
                }
                int n8 = this.getWidth();
                int n9 = this.getHeight();
                n2 = this.mScene.gatPathMotionArc();
                if (n2 != -1) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        object = this.mFrameArrayList.get(this.getChildAt(n3));
                        if (object == null) continue;
                        ((MotionController)object).setPathMotionArc(n2);
                    }
                }
                object = new SparseBooleanArray();
                object3 = new int[this.mFrameArrayList.size()];
                n3 = 0;
                for (n = 0; n < n4; ++n) {
                    object2 = this.getChildAt(n);
                    object2 = this.mFrameArrayList.get(object2);
                    n2 = n3;
                    if (((MotionController)object2).getAnimateRelativeTo() != -1) {
                        object.put(((MotionController)object2).getAnimateRelativeTo(), true);
                        object3[n3] = (View)((MotionController)object2).getAnimateRelativeTo();
                        n2 = n3 + 1;
                    }
                    n3 = n2;
                }
                if (this.mDecoratorsHelpers != null) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = this.mFrameArrayList.get(this.findViewById((int)object3[n2]));
                        if (object2 == null) continue;
                        this.mScene.getKeyFrames((MotionController)object2);
                    }
                    object2 = this.mDecoratorsHelpers.iterator();
                    while (object2.hasNext()) {
                        ((MotionHelper)object2.next()).onPreSetup(this, this.mFrameArrayList);
                    }
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = this.mFrameArrayList.get(this.findViewById((int)object3[n2]));
                        if (object2 == null) continue;
                        ((MotionController)object2).setup(n8, n9, this.mTransitionDuration, this.getNanoTime());
                    }
                } else {
                    for (n2 = 0; n2 < n3; ++n2) {
                        object2 = this.mFrameArrayList.get(this.findViewById((int)object3[n2]));
                        if (object2 == null) continue;
                        this.mScene.getKeyFrames((MotionController)object2);
                        ((MotionController)object2).setup(n8, n9, this.mTransitionDuration, this.getNanoTime());
                    }
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    object2 = this.getChildAt(n3);
                    object3 = this.mFrameArrayList.get(object2);
                    if (object.get(object2.getId()) || object3 == null) continue;
                    this.mScene.getKeyFrames((MotionController)object3);
                    ((MotionController)object3).setup(n8, n9, this.mTransitionDuration, this.getNanoTime());
                }
                f6 = this.mScene.getStaggered();
                if (f6 == 0.0f) break block21;
                n3 = (double)f6 < 0.0 ? 1 : 0;
                f5 = Math.abs(f6);
                f4 = -3.4028235E38f;
                f3 = Float.MAX_VALUE;
                f2 = Float.MAX_VALUE;
                f6 = -3.4028235E38f;
                for (n2 = 0; n2 < n4; ++n2) {
                    object = this.mFrameArrayList.get(this.getChildAt(n2));
                    if (!Float.isNaN(((MotionController)object).mMotionStagger)) {
                        n2 = n5;
                        break block20;
                    }
                    f = ((MotionController)object).getFinalX();
                    float f7 = ((MotionController)object).getFinalY();
                    f = n3 != 0 ? f7 - f : f7 + f;
                    f2 = Math.min(f2, f);
                    f6 = Math.max(f6, f);
                }
                n2 = 0;
            }
            if (n2 != 0) {
                n = 0;
                f = f3;
                f2 = f4;
                while (true) {
                    if (n >= n4) break;
                    object = this.mFrameArrayList.get(this.getChildAt(n));
                    f4 = f2;
                    f6 = f;
                    if (!Float.isNaN(((MotionController)object).mMotionStagger)) {
                        f6 = Math.min(f, ((MotionController)object).mMotionStagger);
                        f4 = Math.max(f2, ((MotionController)object).mMotionStagger);
                    }
                    ++n;
                    f2 = f4;
                    f = f6;
                }
                for (n2 = n7; n2 < n4; ++n2) {
                    object = this.mFrameArrayList.get(this.getChildAt(n2));
                    if (Float.isNaN(((MotionController)object).mMotionStagger)) continue;
                    ((MotionController)object).mStaggerScale = 1.0f / (1.0f - f5);
                    ((MotionController)object).mStaggerOffset = n3 != 0 ? f5 - (f2 - ((MotionController)object).mMotionStagger) / (f2 - f) * f5 : f5 - (((MotionController)object).mMotionStagger - f) * f5 / (f2 - f);
                }
            } else {
                for (n = n6; n < n4; ++n) {
                    object = this.mFrameArrayList.get(this.getChildAt(n));
                    f = ((MotionController)object).getFinalX();
                    f4 = ((MotionController)object).getFinalY();
                    f = n3 != 0 ? f4 - f : f4 + f;
                    ((MotionController)object).mStaggerScale = 1.0f / (1.0f - f5);
                    ((MotionController)object).mStaggerOffset = f5 - (f - f2) * f5 / (f6 - f2);
                }
            }
        }
    }

    private Rect toRect(ConstraintWidget constraintWidget) {
        this.mTempRect.top = constraintWidget.getY();
        this.mTempRect.left = constraintWidget.getX();
        this.mTempRect.right = constraintWidget.getWidth() + this.mTempRect.left;
        this.mTempRect.bottom = constraintWidget.getHeight() + this.mTempRect.top;
        return this.mTempRect;
    }

    private static boolean willJump(float f, float f2, float f3) {
        boolean bl = true;
        boolean bl2 = true;
        if (f > 0.0f) {
            float f4 = f / f3;
            if (!(f2 + (f * f4 - f3 * f4 * f4 / 2.0f) > 1.0f)) {
                bl2 = false;
            }
            return bl2;
        }
        float f5 = -f / f3;
        bl2 = f2 + (f * f5 + f3 * f5 * f5 / 2.0f) < 0.0f ? bl : false;
        return bl2;
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        if (this.mTransitionListeners == null) {
            this.mTransitionListeners = new CopyOnWriteArrayList();
        }
        this.mTransitionListeners.add(transitionListener);
    }

    void animateTo(float f) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return;
        }
        float f2 = this.mTransitionLastPosition;
        float f3 = this.mTransitionPosition;
        if (f2 != f3 && this.mTransitionInstantly) {
            this.mTransitionLastPosition = f3;
        }
        if ((f2 = this.mTransitionLastPosition) == f) {
            return;
        }
        this.mTemporalInterpolator = false;
        this.mTransitionGoalPosition = f;
        this.mTransitionDuration = (float)motionScene.getDuration() / 1000.0f;
        this.setProgress(this.mTransitionGoalPosition);
        this.mInterpolator = null;
        this.mProgressInterpolator = this.mScene.getInterpolator();
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = this.getNanoTime();
        this.mInTransition = true;
        this.mTransitionPosition = f2;
        this.mTransitionLastPosition = f2;
        this.invalidate();
    }

    public boolean applyViewTransition(int n, MotionController motionController) {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            return motionScene.applyViewTransition(n, motionController);
        }
        return false;
    }

    public ConstraintSet cloneConstraintSet(int n) {
        Object object = this.mScene;
        if (object == null) {
            return null;
        }
        object = ((MotionScene)object).getConstraintSet(n);
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone((ConstraintSet)object);
        return constraintSet;
    }

    void disableAutoTransition(boolean bl) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return;
        }
        motionScene.disableAutoTransition(bl);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        ArrayList<MotionHelper> arrayList = this.mDecoratorsHelpers;
        if (arrayList != null) {
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                ((MotionHelper)arrayList.next()).onPreDraw(canvas);
            }
        }
        this.evaluate(false);
        arrayList = this.mScene;
        if (arrayList != null && ((MotionScene)((Object)arrayList)).mViewTransitionController != null) {
            this.mScene.mViewTransitionController.animate();
        }
        super.dispatchDraw(canvas);
        if (this.mScene == null) {
            return;
        }
        if ((this.mDebugPath & 1) == 1 && !this.isInEditMode()) {
            ++this.mFrames;
            long l = this.getNanoTime();
            long l2 = this.mLastDrawTime;
            if (l2 != -1L) {
                if ((l2 = l - l2) > 200000000L) {
                    this.mLastFps = (float)((int)((float)this.mFrames / ((float)l2 * 1.0E-9f) * 100.0f)) / 100.0f;
                    this.mFrames = 0;
                    this.mLastDrawTime = l;
                }
            } else {
                this.mLastDrawTime = l;
            }
            Paint paint = new Paint();
            paint.setTextSize(42.0f);
            float f = (float)((int)(this.getProgress() * 1000.0f)) / 10.0f;
            arrayList = new StringBuilder();
            ((StringBuilder)((Object)arrayList)).append(this.mLastFps);
            ((StringBuilder)((Object)arrayList)).append(" fps ");
            ((StringBuilder)((Object)arrayList)).append(Debug.getState(this, this.mBeginState));
            ((StringBuilder)((Object)arrayList)).append(" -> ");
            arrayList = ((StringBuilder)((Object)arrayList)).toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)((Object)arrayList));
            stringBuilder.append(Debug.getState(this, this.mEndState));
            stringBuilder.append(" (progress: ");
            stringBuilder.append(f);
            stringBuilder.append(" ) state=");
            int n = this.mCurrentState;
            arrayList = n == -1 ? "undefined" : Debug.getState(this, n);
            stringBuilder.append((String)((Object)arrayList));
            arrayList = stringBuilder.toString();
            paint.setColor(-16777216);
            canvas.drawText((String)((Object)arrayList), 11.0f, (float)(this.getHeight() - 29), paint);
            paint.setColor(-7864184);
            canvas.drawText((String)((Object)arrayList), 10.0f, (float)(this.getHeight() - 30), paint);
        }
        if (this.mDebugPath > 1) {
            if (this.mDevModeDraw == null) {
                this.mDevModeDraw = new DevModeDraw();
            }
            this.mDevModeDraw.draw(canvas, this.mFrameArrayList, this.mScene.getDuration(), this.mDebugPath);
        }
        if ((arrayList = this.mDecoratorsHelpers) != null) {
            arrayList = arrayList.iterator();
            while (arrayList.hasNext()) {
                ((MotionHelper)arrayList.next()).onPostDraw(canvas);
            }
        }
    }

    public void enableTransition(int n, boolean bl) {
        MotionScene.Transition transition = this.getTransition(n);
        if (bl) {
            transition.setEnabled(true);
            return;
        }
        if (transition == this.mScene.mCurrentTransition) {
            for (MotionScene.Transition transition2 : this.mScene.getTransitionsWithState(this.mCurrentState)) {
                if (!transition2.isEnabled()) continue;
                this.mScene.mCurrentTransition = transition2;
                break;
            }
        }
        transition.setEnabled(false);
    }

    public void enableViewTransition(int n, boolean bl) {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            motionScene.enableViewTransition(n, bl);
        }
    }

    void endTrigger(boolean bl) {
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getChildAt(i);
            if ((object = this.mFrameArrayList.get(object)) == null) continue;
            ((MotionController)object).endTrigger(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void evaluate(boolean bl) {
        int n;
        block63: {
            int n2;
            block62: {
                int n3;
                int n4;
                float f;
                block61: {
                    block51: {
                        block60: {
                            StopLogic stopLogic;
                            float f2;
                            float f3;
                            Object object;
                            long l;
                            float f4;
                            int n5;
                            block56: {
                                block59: {
                                    block58: {
                                        block57: {
                                            block54: {
                                                block55: {
                                                    block52: {
                                                        block53: {
                                                            float f5;
                                                            float f6;
                                                            block50: {
                                                                if (this.mTransitionLastTime == -1L) {
                                                                    this.mTransitionLastTime = this.getNanoTime();
                                                                }
                                                                if ((f = this.mTransitionLastPosition) > 0.0f && f < 1.0f) {
                                                                    this.mCurrentState = -1;
                                                                }
                                                                boolean bl2 = this.mKeepAnimating;
                                                                n4 = 1;
                                                                n3 = 1;
                                                                n5 = 0;
                                                                n = 0;
                                                                if (bl2) break block50;
                                                                n2 = n5;
                                                                if (!this.mInTransition) break block51;
                                                                if (bl) break block50;
                                                                n2 = n5;
                                                                if (this.mTransitionGoalPosition == f) break block51;
                                                            }
                                                            f4 = Math.signum(this.mTransitionGoalPosition - f);
                                                            l = this.getNanoTime();
                                                            object = this.mInterpolator;
                                                            f3 = !(object instanceof MotionInterpolator) ? (float)(l - this.mTransitionLastTime) * f4 * 1.0E-9f / this.mTransitionDuration : 0.0f;
                                                            f = this.mTransitionLastPosition + f3;
                                                            if (this.mTransitionInstantly) {
                                                                f = this.mTransitionGoalPosition;
                                                            }
                                                            if ((n5 = (int)((f6 = f4 - 0.0f) == 0.0f ? 0 : (f6 > 0.0f ? 1 : -1))) > 0 && f >= this.mTransitionGoalPosition || f4 <= 0.0f && f <= this.mTransitionGoalPosition) {
                                                                f = this.mTransitionGoalPosition;
                                                                this.mInTransition = false;
                                                                n2 = 1;
                                                            } else {
                                                                n2 = 0;
                                                            }
                                                            this.mTransitionLastPosition = f;
                                                            this.mTransitionPosition = f;
                                                            this.mTransitionLastTime = l;
                                                            if (object == null || n2 != 0) break block52;
                                                            if (!this.mTemporalInterpolator) break block53;
                                                            f2 = object.getInterpolation((float)(l - this.mAnimationStartTime) * 1.0E-9f);
                                                            object = this.mInterpolator;
                                                            stopLogic = this.mStopLogic;
                                                            n2 = object == stopLogic ? (stopLogic.isStopped() ? 2 : 1) : 0;
                                                            this.mTransitionLastPosition = f2;
                                                            this.mTransitionLastTime = l;
                                                            object = this.mInterpolator;
                                                            f = f2;
                                                            if (!(object instanceof MotionInterpolator)) break block54;
                                                            this.mLastVelocity = f5 = ((MotionInterpolator)object).getVelocity();
                                                            if (Math.abs(f5) * this.mTransitionDuration <= 1.0E-5f && n2 == 2) {
                                                                this.mInTransition = false;
                                                            }
                                                            f3 = f2;
                                                            if (f5 > 0.0f) {
                                                                f3 = f2;
                                                                if (f2 >= 1.0f) {
                                                                    this.mTransitionLastPosition = 1.0f;
                                                                    this.mInTransition = false;
                                                                    f3 = 1.0f;
                                                                }
                                                            }
                                                            f = f3;
                                                            if (f5 < 0.0f) {
                                                                f = f3;
                                                                if (f3 <= 0.0f) {
                                                                    this.mTransitionLastPosition = 0.0f;
                                                                    this.mInTransition = false;
                                                                    f = 0.0f;
                                                                }
                                                            }
                                                            break block54;
                                                        }
                                                        f2 = object.getInterpolation(f);
                                                        object = this.mInterpolator;
                                                        this.mLastVelocity = object instanceof MotionInterpolator ? ((MotionInterpolator)object).getVelocity() : (object.getInterpolation(f + f3) - f2) * f4 / f3;
                                                        f = f2;
                                                        break block55;
                                                    }
                                                    this.mLastVelocity = f3;
                                                }
                                                n2 = 0;
                                            }
                                            if (Math.abs(this.mLastVelocity) > 1.0E-5f) {
                                                this.setState(TransitionState.MOVING);
                                            }
                                            f3 = f;
                                            if (n2 == 1) break block56;
                                            if (n5 > 0 && f >= this.mTransitionGoalPosition) break block57;
                                            f2 = f;
                                            if (!(f4 <= 0.0f)) break block58;
                                            f2 = f;
                                            if (!(f <= this.mTransitionGoalPosition)) break block58;
                                        }
                                        f2 = this.mTransitionGoalPosition;
                                        this.mInTransition = false;
                                    }
                                    if (f2 >= 1.0f) break block59;
                                    f3 = f2;
                                    if (!(f2 <= 0.0f)) break block56;
                                }
                                this.mInTransition = false;
                                this.setState(TransitionState.FINISHED);
                                f3 = f2;
                            }
                            int n6 = this.getChildCount();
                            this.mKeepAnimating = false;
                            l = this.getNanoTime();
                            this.mPostInterpolationPosition = f3;
                            object = this.mProgressInterpolator;
                            f = object == null ? f3 : object.getInterpolation(f3);
                            object = this.mProgressInterpolator;
                            if (object != null) {
                                this.mLastVelocity = f2 = object.getInterpolation(f4 / this.mTransitionDuration + f3);
                                this.mLastVelocity = f2 - this.mProgressInterpolator.getInterpolation(f3);
                            }
                            for (n2 = 0; n2 < n6; ++n2) {
                                stopLogic = this.getChildAt(n2);
                                object = this.mFrameArrayList.get(stopLogic);
                                if (object == null) continue;
                                bl = this.mKeepAnimating;
                                this.mKeepAnimating = ((MotionController)object).interpolate((View)stopLogic, f, l, this.mKeyCache) | bl;
                            }
                            n2 = n5 > 0 && f3 >= this.mTransitionGoalPosition || f4 <= 0.0f && f3 <= this.mTransitionGoalPosition ? 1 : 0;
                            if (!this.mKeepAnimating && !this.mInTransition && n2 != 0) {
                                this.setState(TransitionState.FINISHED);
                            }
                            if (this.mMeasureDuringTransition) {
                                this.requestLayout();
                            }
                            this.mKeepAnimating = n2 ^ 1 | this.mKeepAnimating;
                            n2 = n;
                            if (f3 <= 0.0f) {
                                n6 = this.mBeginState;
                                n2 = n;
                                if (n6 != -1) {
                                    n2 = n;
                                    if (this.mCurrentState != n6) {
                                        this.mCurrentState = n6;
                                        this.mScene.getConstraintSet(n6).applyCustomAttributes(this);
                                        this.setState(TransitionState.FINISHED);
                                        n2 = 1;
                                    }
                                }
                            }
                            n = n2;
                            if ((double)f3 >= 1.0) {
                                int n7 = this.mCurrentState;
                                n6 = this.mEndState;
                                n = n2;
                                if (n7 != n6) {
                                    this.mCurrentState = n6;
                                    this.mScene.getConstraintSet(n6).applyCustomAttributes(this);
                                    this.setState(TransitionState.FINISHED);
                                    n = 1;
                                }
                            }
                            if (!this.mKeepAnimating && !this.mInTransition) {
                                if (n5 > 0 && f3 == 1.0f || f4 < 0.0f && f3 == 0.0f) {
                                    this.setState(TransitionState.FINISHED);
                                }
                            } else {
                                this.invalidate();
                            }
                            n2 = n;
                            if (this.mKeepAnimating) break block51;
                            n2 = n;
                            if (this.mInTransition) break block51;
                            if (n5 > 0 && f3 == 1.0f) break block60;
                            n2 = n;
                            if (!(f4 < 0.0f)) break block51;
                            n2 = n;
                            if (f3 != 0.0f) break block51;
                        }
                        this.onNewStateAttachHandlers();
                        n2 = n;
                    }
                    if (!((f = this.mTransitionLastPosition) >= 1.0f)) break block61;
                    n4 = this.mCurrentState;
                    n = this.mEndState;
                    if (n4 != n) {
                        n2 = n3;
                    }
                    this.mCurrentState = n;
                    break block62;
                }
                n = n2;
                if (!(f <= 0.0f)) break block63;
                n3 = this.mCurrentState;
                n = this.mBeginState;
                if (n3 != n) {
                    n2 = n4;
                }
                this.mCurrentState = n;
            }
            n = n2;
        }
        this.mNeedsFireTransitionCompleted |= n;
        if (n != 0 && !this.mInLayout) {
            this.requestLayout();
        }
        this.mTransitionPosition = this.mTransitionLastPosition;
    }

    protected void fireTransitionCompleted() {
        Object object;
        if ((this.mTransitionListener != null || (object = this.mTransitionListeners) != null && !((CopyOnWriteArrayList)object).isEmpty()) && this.mListenerState == -1) {
            int n;
            this.mListenerState = this.mCurrentState;
            if (!this.mTransitionCompleted.isEmpty()) {
                object = this.mTransitionCompleted;
                n = ((ArrayList)object).get(((ArrayList)object).size() - 1);
            } else {
                n = -1;
            }
            int n2 = this.mCurrentState;
            if (n != n2 && n2 != -1) {
                this.mTransitionCompleted.add(n2);
            }
        }
        this.processTransitionCompleted();
        object = this.mOnComplete;
        if (object != null) {
            object.run();
        }
        if ((object = (Object)this.mScheduledTransitionTo) != null && this.mScheduledTransitions > 0) {
            this.transitionToState((int)object[0]);
            object = this.mScheduledTransitionTo;
            System.arraycopy(object, 1, object, 0, ((Object)object).length - 1);
            --this.mScheduledTransitions;
        }
    }

    public void fireTrigger(int n, boolean bl, float f) {
        Object object = this.mTransitionListener;
        if (object != null) {
            object.onTransitionTrigger(this, n, bl, f);
        }
        if ((object = this.mTransitionListeners) != null) {
            object = ((CopyOnWriteArrayList)object).iterator();
            while (object.hasNext()) {
                ((TransitionListener)object.next()).onTransitionTrigger(this, n, bl, f);
            }
        }
    }

    void getAnchorDpDt(int n, float f, float f2, float f3, float[] object) {
        Object object2 = this.mFrameArrayList;
        Object object3 = this.getViewById(n);
        if ((object2 = ((HashMap)object2).get(object3)) != null) {
            ((MotionController)object2).getDpDt(f, f2, f3, (float[])object);
            f2 = object3.getY();
            this.lastPos = f;
            this.lastY = f2;
        } else {
            if (object3 == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("");
                ((StringBuilder)object).append(n);
                object = ((StringBuilder)object).toString();
            } else {
                object = object3.getContext().getResources().getResourceName(n);
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("WARNING could not find view id ");
            ((StringBuilder)object3).append((String)object);
            Log.w((String)TAG, (String)((StringBuilder)object3).toString());
        }
    }

    public ConstraintSet getConstraintSet(int n) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return null;
        }
        return motionScene.getConstraintSet(n);
    }

    public int[] getConstraintSetIds() {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return null;
        }
        return motionScene.getConstraintSetIds();
    }

    String getConstraintSetNames(int n) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return null;
        }
        return motionScene.lookUpConstraintName(n);
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public void getDebugMode(boolean bl) {
        int n = bl ? 2 : 1;
        this.mDebugPath = n;
        this.invalidate();
    }

    public ArrayList<MotionScene.Transition> getDefinedTransitions() {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return null;
        }
        return motionScene.getDefinedTransitions();
    }

    public DesignTool getDesignTool() {
        if (this.mDesignTool == null) {
            this.mDesignTool = new DesignTool(this);
        }
        return this.mDesignTool;
    }

    public int getEndState() {
        return this.mEndState;
    }

    MotionController getMotionController(int n) {
        return this.mFrameArrayList.get(this.findViewById(n));
    }

    protected long getNanoTime() {
        return System.nanoTime();
    }

    public float getProgress() {
        return this.mTransitionLastPosition;
    }

    public MotionScene getScene() {
        return this.mScene;
    }

    public int getStartState() {
        return this.mBeginState;
    }

    public float getTargetPosition() {
        return this.mTransitionGoalPosition;
    }

    public MotionScene.Transition getTransition(int n) {
        return this.mScene.getTransitionById(n);
    }

    public Bundle getTransitionState() {
        if (this.mStateCache == null) {
            this.mStateCache = new StateCache();
        }
        this.mStateCache.recordState();
        return this.mStateCache.getTransitionState();
    }

    public long getTransitionTimeMs() {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            this.mTransitionDuration = (float)motionScene.getDuration() / 1000.0f;
        }
        return (long)(this.mTransitionDuration * 1000.0f);
    }

    public float getVelocity() {
        return this.mLastVelocity;
    }

    public void getViewVelocity(View view, float f, float f2, float[] fArray, int n) {
        Object object;
        float f3 = this.mLastVelocity;
        float f4 = this.mTransitionLastPosition;
        if (this.mInterpolator != null) {
            f3 = Math.signum(this.mTransitionGoalPosition - f4);
            float f5 = this.mInterpolator.getInterpolation(this.mTransitionLastPosition + 1.0E-5f);
            f4 = this.mInterpolator.getInterpolation(this.mTransitionLastPosition);
            f3 = f3 * ((f5 - f4) / 1.0E-5f) / this.mTransitionDuration;
        }
        if ((object = this.mInterpolator) instanceof MotionInterpolator) {
            f3 = ((MotionInterpolator)object).getVelocity();
        }
        object = this.mFrameArrayList.get(view);
        if ((n & 1) == 0) {
            ((MotionController)object).getPostLayoutDvDp(f4, view.getWidth(), view.getHeight(), f, f2, fArray);
        } else {
            ((MotionController)object).getDpDt(f4, f, f2, fArray);
        }
        if (n < 2) {
            fArray[0] = fArray[0] * f3;
            fArray[1] = fArray[1] * f3;
        }
    }

    public boolean isAttachedToWindow() {
        if (Build.VERSION.SDK_INT >= 19) {
            return super.isAttachedToWindow();
        }
        boolean bl = this.getWindowToken() != null;
        return bl;
    }

    public boolean isDelayedApplicationOfInitialState() {
        return this.mDelayedApply;
    }

    public boolean isInRotation() {
        return this.mInRotation;
    }

    public boolean isInteractionEnabled() {
        return this.mInteractionEnabled;
    }

    public boolean isViewTransitionEnabled(int n) {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            return motionScene.isViewTransitionEnabled(n);
        }
        return false;
    }

    public void jumpToState(int n) {
        if (!this.isAttachedToWindow()) {
            this.mCurrentState = n;
        }
        if (this.mBeginState == n) {
            this.setProgress(0.0f);
        } else if (this.mEndState == n) {
            this.setProgress(1.0f);
        } else {
            this.setTransition(n, n);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loadLayoutDescription(int n) {
        Object object;
        block14: {
            if (n == 0) {
                this.mScene = null;
                return;
            }
            object = new MotionScene(this.getContext(), this, n);
            this.mScene = object;
            if (this.mCurrentState == -1) {
                this.mCurrentState = ((MotionScene)object).getStartId();
                this.mBeginState = this.mScene.getStartId();
                this.mEndState = this.mScene.getEndId();
            }
            if (Build.VERSION.SDK_INT < 19 || this.isAttachedToWindow()) break block14;
            this.mScene = null;
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 17) {
                object = this.getDisplay();
                n = object == null ? 0 : object.getRotation();
                this.mPreviouseRotation = n;
            }
            if ((object = this.mScene) != null) {
                object = ((MotionScene)object).getConstraintSet(this.mCurrentState);
                this.mScene.readFallback(this);
                Object object2 = this.mDecoratorsHelpers;
                if (object2 != null) {
                    object2 = ((ArrayList)object2).iterator();
                    while (object2.hasNext()) {
                        ((MotionHelper)object2.next()).onFinishedMotionScene(this);
                    }
                }
                if (object != null) {
                    ((ConstraintSet)object).applyTo(this);
                }
                this.mBeginState = this.mCurrentState;
            }
            this.onNewStateAttachHandlers();
            object = this.mStateCache;
            if (object == null) {
                object = this.mScene;
                if (object == null) return;
                if (((MotionScene)object).mCurrentTransition == null) return;
                if (this.mScene.mCurrentTransition.getAutoTransition() != 4) return;
                this.transitionToEnd();
                this.setState(TransitionState.SETUP);
                this.setState(TransitionState.MOVING);
                return;
            }
            if (this.mDelayedApply) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        MotionLayout.this.mStateCache.apply();
                    }
                };
                this.post((Runnable)object);
                return;
            }
            ((StateCache)object).apply();
            return;
        }
        catch (Exception exception) {
            try {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("unable to parse MotionScene file", exception);
                throw illegalArgumentException;
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("unable to parse MotionScene file", exception2);
            }
        }
    }

    int lookUpConstraintId(String string2) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return 0;
        }
        return motionScene.lookUpConstraintId(string2);
    }

    protected MotionTracker obtainVelocityTracker() {
        return MyTracker.obtain();
    }

    protected void onAttachedToWindow() {
        int n;
        Object object;
        super.onAttachedToWindow();
        if (Build.VERSION.SDK_INT >= 17 && (object = this.getDisplay()) != null) {
            this.mPreviouseRotation = object.getRotation();
        }
        if ((object = this.mScene) != null && (n = this.mCurrentState) != -1) {
            object = ((MotionScene)object).getConstraintSet(n);
            this.mScene.readFallback(this);
            Object object2 = this.mDecoratorsHelpers;
            if (object2 != null) {
                object2 = ((ArrayList)object2).iterator();
                while (object2.hasNext()) {
                    ((MotionHelper)object2.next()).onFinishedMotionScene(this);
                }
            }
            if (object != null) {
                ((ConstraintSet)object).applyTo(this);
            }
            this.mBeginState = this.mCurrentState;
        }
        this.onNewStateAttachHandlers();
        object = this.mStateCache;
        if (object != null) {
            if (this.mDelayedApply) {
                this.post(new Runnable(){

                    @Override
                    public void run() {
                        MotionLayout.this.mStateCache.apply();
                    }
                });
            } else {
                ((StateCache)object).apply();
            }
        } else {
            object = this.mScene;
            if (object != null && ((MotionScene)object).mCurrentTransition != null && this.mScene.mCurrentTransition.getAutoTransition() == 4) {
                this.transitionToEnd();
                this.setState(TransitionState.SETUP);
                this.setState(TransitionState.MOVING);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        Object object = this.mScene;
        if (object != null && this.mInteractionEnabled) {
            TouchResponse touchResponse;
            if (((MotionScene)object).mViewTransitionController != null) {
                this.mScene.mViewTransitionController.touchEvent(motionEvent);
            }
            if ((object = this.mScene.mCurrentTransition) != null && ((MotionScene.Transition)object).isEnabled() && (touchResponse = ((MotionScene.Transition)object).getTouchResponse()) != null) {
                if (motionEvent.getAction() == 0 && (object = touchResponse.getTouchRegion(this, new RectF())) != null && !object.contains(motionEvent.getX(), motionEvent.getY())) {
                    return false;
                }
                int n = touchResponse.getTouchRegionId();
                if (n != -1) {
                    object = this.mRegionView;
                    if (object == null || object.getId() != n) {
                        this.mRegionView = this.findViewById(n);
                    }
                    if ((object = this.mRegionView) != null) {
                        this.mBoundsCheck.set((float)object.getLeft(), (float)this.mRegionView.getTop(), (float)this.mRegionView.getRight(), (float)this.mRegionView.getBottom());
                        if (this.mBoundsCheck.contains(motionEvent.getX(), motionEvent.getY()) && !this.handlesTouchEvent(this.mRegionView.getLeft(), this.mRegionView.getTop(), this.mRegionView, motionEvent)) {
                            return this.onTouchEvent(motionEvent);
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mInLayout = true;
        if (this.mScene == null) {
            super.onLayout(bl, n, n2, n3, n4);
            this.mInLayout = false;
            return;
        }
        n = n3 - n;
        n2 = n4 - n2;
        try {
            if (this.mLastLayoutWidth != n || this.mLastLayoutHeight != n2) {
                this.rebuildScene();
                this.evaluate(true);
            }
            this.mLastLayoutWidth = n;
            this.mLastLayoutHeight = n2;
            this.mOldWidth = n;
            this.mOldHeight = n2;
            return;
        }
        finally {
            this.mInLayout = false;
        }
    }

    @Override
    protected void onMeasure(int n, int n2) {
        if (this.mScene == null) {
            super.onMeasure(n, n2);
            return;
        }
        int n3 = this.mLastWidthMeasureSpec;
        int n4 = 0;
        n3 = n3 == n && this.mLastHeightMeasureSpec == n2 ? 0 : 1;
        if (this.mNeedsFireTransitionCompleted) {
            this.mNeedsFireTransitionCompleted = false;
            this.onNewStateAttachHandlers();
            this.processTransitionCompleted();
            n3 = 1;
        }
        if (this.mDirtyHierarchy) {
            n3 = 1;
        }
        this.mLastWidthMeasureSpec = n;
        this.mLastHeightMeasureSpec = n2;
        int n5 = this.mScene.getStartId();
        int n6 = this.mScene.getEndId();
        if ((n3 != 0 || this.mModel.isNotConfiguredWith(n5, n6)) && this.mBeginState != -1) {
            super.onMeasure(n, n2);
            this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(n5), this.mScene.getConstraintSet(n6));
            this.mModel.reEvaluateState();
            this.mModel.setMeasuredId(n5, n6);
            n = n4;
        } else {
            if (n3 != 0) {
                super.onMeasure(n, n2);
            }
            n = 1;
        }
        if (this.mMeasureDuringTransition || n != 0) {
            n2 = this.getPaddingTop();
            n3 = this.getPaddingBottom();
            n = this.getPaddingLeft();
            n4 = this.getPaddingRight();
            n = this.mLayoutWidget.getWidth() + (n + n4);
            n2 = this.mLayoutWidget.getHeight() + (n2 + n3);
            n3 = this.mWidthMeasureMode;
            if (n3 == Integer.MIN_VALUE || n3 == 0) {
                n = this.mStartWrapWidth;
                n = (int)((float)n + this.mPostInterpolationPosition * (float)(this.mEndWrapWidth - n));
                this.requestLayout();
            }
            if ((n3 = this.mHeightMeasureMode) == Integer.MIN_VALUE || n3 == 0) {
                n2 = this.mStartWrapHeight;
                n2 = (int)((float)n2 + this.mPostInterpolationPosition * (float)(this.mEndWrapHeight - n2));
                this.requestLayout();
            }
            this.setMeasuredDimension(n, n2);
        }
        this.evaluateLayout();
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return false;
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        return false;
    }

    @Override
    public void onNestedPreScroll(final View view, int n, int n2, int[] nArray, int n3) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return;
        }
        MotionScene.Transition transition = motionScene.mCurrentTransition;
        if (transition != null && transition.isEnabled()) {
            float f;
            float f2;
            float f3;
            TouchResponse touchResponse;
            boolean bl = transition.isEnabled();
            int n4 = -1;
            if (bl && (touchResponse = transition.getTouchResponse()) != null && (n3 = touchResponse.getTouchRegionId()) != -1 && view.getId() != n3) {
                return;
            }
            if (motionScene.getMoveWhenScrollAtTop()) {
                touchResponse = transition.getTouchResponse();
                n3 = n4;
                if (touchResponse != null) {
                    n3 = n4;
                    if ((touchResponse.getFlags() & 4) != 0) {
                        n3 = n2;
                    }
                }
                if (((f3 = this.mTransitionPosition) == 1.0f || f3 == 0.0f) && view.canScrollVertically(n3)) {
                    return;
                }
            }
            if (transition.getTouchResponse() != null && (transition.getTouchResponse().getFlags() & 1) != 0) {
                f2 = motionScene.getProgressDirection(n, n2);
                f3 = this.mTransitionLastPosition;
                if (f3 <= 0.0f && f2 < 0.0f || f3 >= 1.0f && f2 > 0.0f) {
                    if (Build.VERSION.SDK_INT >= 21) {
                        view.setNestedScrollingEnabled(false);
                        view.post(new Runnable(){

                            @Override
                            public void run() {
                                view.setNestedScrollingEnabled(true);
                            }
                        });
                    }
                    return;
                }
            }
            f2 = this.mTransitionPosition;
            long l = this.getNanoTime();
            this.mScrollTargetDX = f = (float)n;
            this.mScrollTargetDY = f3 = (float)n2;
            this.mScrollTargetDT = (float)((double)(l - this.mScrollTargetTime) * 1.0E-9);
            this.mScrollTargetTime = l;
            motionScene.processScrollMove(f, f3);
            if (f2 != this.mTransitionPosition) {
                nArray[0] = n;
                nArray[1] = n2;
            }
            this.evaluate(false);
            if (nArray[0] != 0 || nArray[1] != 0) {
                this.mUndergoingMotion = true;
            }
        }
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4, int n5) {
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        if (this.mUndergoingMotion || n != 0 || n2 != 0) {
            nArray[0] = nArray[0] + n3;
            nArray[1] = nArray[1] + n4;
        }
        this.mUndergoingMotion = false;
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n, int n2) {
        this.mScrollTargetTime = this.getNanoTime();
        this.mScrollTargetDT = 0.0f;
        this.mScrollTargetDX = 0.0f;
        this.mScrollTargetDY = 0.0f;
    }

    void onNewStateAttachHandlers() {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            return;
        }
        if (motionScene.autoTransition(this, this.mCurrentState)) {
            this.requestLayout();
            return;
        }
        int n = this.mCurrentState;
        if (n != -1) {
            this.mScene.addOnClickListeners(this, n);
        }
        if (this.mScene.supportTouch()) {
            this.mScene.setupTouch();
        }
    }

    public void onRtlPropertiesChanged(int n) {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            motionScene.setRtl(this.isRtl());
        }
    }

    @Override
    public boolean onStartNestedScroll(View object, View view, int n, int n2) {
        object = this.mScene;
        return object != null && object.mCurrentTransition != null && this.mScene.mCurrentTransition.getTouchResponse() != null && (this.mScene.mCurrentTransition.getTouchResponse().getFlags() & 2) == 0;
        {
        }
    }

    @Override
    public void onStopNestedScroll(View object, int n) {
        float f;
        object = this.mScene;
        if (object != null && (f = this.mScrollTargetDT) != 0.0f) {
            ((MotionScene)object).processScrollUp(this.mScrollTargetDX / f, this.mScrollTargetDY / f);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        Object object = this.mScene;
        if (object != null && this.mInteractionEnabled && ((MotionScene)object).supportTouch()) {
            object = this.mScene.mCurrentTransition;
            if (object != null && !((MotionScene.Transition)object).isEnabled()) {
                return super.onTouchEvent(motionEvent);
            }
            this.mScene.processTouchEvent(motionEvent, this.getCurrentState(), this);
            if (this.mScene.mCurrentTransition.isTransitionFlag(4)) {
                return this.mScene.mCurrentTransition.getTouchResponse().isDragStarted();
            }
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    @Override
    public void onViewAdded(View view) {
        super.onViewAdded(view);
        if (view instanceof MotionHelper) {
            view = (MotionHelper)view;
            if (this.mTransitionListeners == null) {
                this.mTransitionListeners = new CopyOnWriteArrayList();
            }
            this.mTransitionListeners.add((TransitionListener)view);
            if (view.isUsedOnShow()) {
                if (this.mOnShowHelpers == null) {
                    this.mOnShowHelpers = new ArrayList();
                }
                this.mOnShowHelpers.add((MotionHelper)view);
            }
            if (view.isUseOnHide()) {
                if (this.mOnHideHelpers == null) {
                    this.mOnHideHelpers = new ArrayList();
                }
                this.mOnHideHelpers.add((MotionHelper)view);
            }
            if (view.isDecorator()) {
                if (this.mDecoratorsHelpers == null) {
                    this.mDecoratorsHelpers = new ArrayList();
                }
                this.mDecoratorsHelpers.add((MotionHelper)view);
            }
        }
    }

    @Override
    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        ArrayList<MotionHelper> arrayList = this.mOnShowHelpers;
        if (arrayList != null) {
            arrayList.remove(view);
        }
        if ((arrayList = this.mOnHideHelpers) != null) {
            arrayList.remove(view);
        }
    }

    @Override
    protected void parseLayoutDescription(int n) {
        this.mConstraintLayoutSpec = null;
    }

    @Deprecated
    public void rebuildMotion() {
        Log.e((String)TAG, (String)"This method is deprecated. Please call rebuildScene() instead.");
        this.rebuildScene();
    }

    public void rebuildScene() {
        this.mModel.reEvaluateState();
        this.invalidate();
    }

    public boolean removeTransitionListener(TransitionListener transitionListener) {
        CopyOnWriteArrayList<TransitionListener> copyOnWriteArrayList = this.mTransitionListeners;
        if (copyOnWriteArrayList == null) {
            return false;
        }
        return copyOnWriteArrayList.remove(transitionListener);
    }

    @Override
    public void requestLayout() {
        MotionScene motionScene;
        if (!this.mMeasureDuringTransition && this.mCurrentState == -1 && (motionScene = this.mScene) != null && motionScene.mCurrentTransition != null) {
            int n = this.mScene.mCurrentTransition.getLayoutDuringTransition();
            if (n == 0) {
                return;
            }
            if (n == 2) {
                int n2 = this.getChildCount();
                for (n = 0; n < n2; ++n) {
                    motionScene = this.getChildAt(n);
                    this.mFrameArrayList.get(motionScene).remeasure();
                }
                return;
            }
        }
        super.requestLayout();
    }

    public void rotateTo(int n, int n2) {
        int n3 = 1;
        this.mInRotation = true;
        this.mPreRotateWidth = this.getWidth();
        this.mPreRotateHeight = this.getHeight();
        int n4 = this.getDisplay().getRotation();
        if ((n4 + 1) % 4 <= (this.mPreviouseRotation + 1) % 4) {
            n3 = 2;
        }
        this.mRotatMode = n3;
        this.mPreviouseRotation = n4;
        n4 = this.getChildCount();
        for (n3 = 0; n3 < n4; ++n3) {
            ViewState viewState;
            View view = this.getChildAt(n3);
            ViewState viewState2 = viewState = this.mPreRotate.get(view);
            if (viewState == null) {
                viewState2 = new ViewState();
                this.mPreRotate.put(view, viewState2);
            }
            viewState2.getState(view);
        }
        this.mBeginState = -1;
        this.mEndState = n;
        this.mScene.setTransition(-1, n);
        this.mModel.initFrom(this.mLayoutWidget, null, this.mScene.getConstraintSet(this.mEndState));
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.invalidate();
        this.transitionToEnd(new Runnable(){

            @Override
            public void run() {
                MotionLayout.access$302(MotionLayout.this, false);
            }
        });
        if (n2 > 0) {
            this.mTransitionDuration = (float)n2 / 1000.0f;
        }
    }

    public void scheduleTransitionTo(int n) {
        if (this.getCurrentState() == -1) {
            this.transitionToState(n);
        } else {
            int[] nArray = this.mScheduledTransitionTo;
            if (nArray == null) {
                this.mScheduledTransitionTo = new int[4];
            } else if (nArray.length <= this.mScheduledTransitions) {
                this.mScheduledTransitionTo = Arrays.copyOf(nArray, nArray.length * 2);
            }
            nArray = this.mScheduledTransitionTo;
            int n2 = this.mScheduledTransitions;
            this.mScheduledTransitions = n2 + 1;
            nArray[n2] = n;
        }
    }

    public void setDebugMode(int n) {
        this.mDebugPath = n;
        this.invalidate();
    }

    public void setDelayedApplicationOfInitialState(boolean bl) {
        this.mDelayedApply = bl;
    }

    public void setInteractionEnabled(boolean bl) {
        this.mInteractionEnabled = bl;
    }

    public void setInterpolatedProgress(float f) {
        if (this.mScene != null) {
            this.setState(TransitionState.MOVING);
            Interpolator interpolator2 = this.mScene.getInterpolator();
            if (interpolator2 != null) {
                this.setProgress(interpolator2.getInterpolation(f));
                return;
            }
        }
        this.setProgress(f);
    }

    public void setOnHide(float f) {
        ArrayList<MotionHelper> arrayList = this.mOnHideHelpers;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.mOnHideHelpers.get(i).setProgress(f);
            }
        }
    }

    public void setOnShow(float f) {
        ArrayList<MotionHelper> arrayList = this.mOnShowHelpers;
        if (arrayList != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.mOnShowHelpers.get(i).setProgress(f);
            }
        }
    }

    public void setProgress(float f) {
        float f2 = f - 0.0f;
        float f3 = f2 == 0.0f ? 0 : (f2 < 0.0f ? -1 : 1);
        if (f3 < 0 || f > 1.0f) {
            Log.w((String)TAG, (String)"Warning! Progress is defined for values between 0.0 and 1.0 inclusive");
        }
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setProgress(f);
            return;
        }
        if (f3 <= 0) {
            if (this.mTransitionLastPosition == 1.0f && this.mCurrentState == this.mEndState) {
                this.setState(TransitionState.MOVING);
            }
            this.mCurrentState = this.mBeginState;
            if (this.mTransitionLastPosition == 0.0f) {
                this.setState(TransitionState.FINISHED);
            }
        } else if (f >= 1.0f) {
            if (this.mTransitionLastPosition == 0.0f && this.mCurrentState == this.mBeginState) {
                this.setState(TransitionState.MOVING);
            }
            this.mCurrentState = this.mEndState;
            if (this.mTransitionLastPosition == 1.0f) {
                this.setState(TransitionState.FINISHED);
            }
        } else {
            this.mCurrentState = -1;
            this.setState(TransitionState.MOVING);
        }
        if (this.mScene == null) {
            return;
        }
        this.mTransitionInstantly = true;
        this.mTransitionGoalPosition = f;
        this.mTransitionPosition = f;
        this.mTransitionLastTime = -1L;
        this.mAnimationStartTime = -1L;
        this.mInterpolator = null;
        this.mInTransition = true;
        this.invalidate();
    }

    public void setProgress(float f, float f2) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setProgress(f);
            this.mStateCache.setVelocity(f2);
            return;
        }
        this.setProgress(f);
        this.setState(TransitionState.MOVING);
        this.mLastVelocity = f2;
        float f3 = 1.0f;
        float f4 = f2 - 0.0f;
        float f5 = f4 == 0.0f ? 0 : (f4 > 0.0f ? 1 : -1);
        if (f5 != false) {
            if (f5 <= 0) {
                f3 = 0.0f;
            }
            this.animateTo(f3);
        } else if (f != 0.0f && f != 1.0f) {
            if (!(f > 0.5f)) {
                f3 = 0.0f;
            }
            this.animateTo(f3);
        }
    }

    public void setScene(MotionScene motionScene) {
        this.mScene = motionScene;
        motionScene.setRtl(this.isRtl());
        this.rebuildScene();
    }

    void setStartState(int n) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setStartState(n);
            this.mStateCache.setEndState(n);
            return;
        }
        this.mCurrentState = n;
    }

    @Override
    public void setState(int n, int n2, int n3) {
        this.setState(TransitionState.SETUP);
        this.mCurrentState = n;
        this.mBeginState = -1;
        this.mEndState = -1;
        if (this.mConstraintLayoutSpec != null) {
            this.mConstraintLayoutSpec.updateConstraints(n, n2, n3);
        } else {
            MotionScene motionScene = this.mScene;
            if (motionScene != null) {
                motionScene.getConstraintSet(n).applyTo(this);
            }
        }
    }

    void setState(TransitionState transitionState) {
        int n;
        if (transitionState == TransitionState.FINISHED && this.mCurrentState == -1) {
            return;
        }
        TransitionState transitionState2 = this.mTransitionState;
        this.mTransitionState = transitionState;
        if (transitionState2 == TransitionState.MOVING && transitionState == TransitionState.MOVING) {
            this.fireTransitionChange();
        }
        if ((n = 5.$SwitchMap$androidx$constraintlayout$motion$widget$MotionLayout$TransitionState[transitionState2.ordinal()]) != 1 && n != 2) {
            if (n == 3 && transitionState == TransitionState.FINISHED) {
                this.fireTransitionCompleted();
            }
        } else {
            if (transitionState == TransitionState.MOVING) {
                this.fireTransitionChange();
            }
            if (transitionState == TransitionState.FINISHED) {
                this.fireTransitionCompleted();
            }
        }
    }

    public void setTransition(int n) {
        if (this.mScene != null) {
            Object object = this.getTransition(n);
            this.mBeginState = ((MotionScene.Transition)object).getStartConstraintSetId();
            this.mEndState = ((MotionScene.Transition)object).getEndConstraintSetId();
            if (!this.isAttachedToWindow()) {
                if (this.mStateCache == null) {
                    this.mStateCache = new StateCache();
                }
                this.mStateCache.setStartState(this.mBeginState);
                this.mStateCache.setEndState(this.mEndState);
                return;
            }
            float f = Float.NaN;
            n = this.mCurrentState;
            int n2 = this.mBeginState;
            float f2 = 0.0f;
            if (n == n2) {
                f = 0.0f;
            } else if (n == this.mEndState) {
                f = 1.0f;
            }
            this.mScene.setTransition((MotionScene.Transition)object);
            this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
            this.rebuildScene();
            if (this.mTransitionLastPosition != f) {
                if (f == 0.0f) {
                    this.endTrigger(true);
                    this.mScene.getConstraintSet(this.mBeginState).applyTo(this);
                } else if (f == 1.0f) {
                    this.endTrigger(false);
                    this.mScene.getConstraintSet(this.mEndState).applyTo(this);
                }
            }
            if (!Float.isNaN(f)) {
                f2 = f;
            }
            this.mTransitionLastPosition = f2;
            if (Float.isNaN(f)) {
                object = new StringBuilder();
                ((StringBuilder)object).append(Debug.getLocation());
                ((StringBuilder)object).append(" transitionToStart ");
                Log.v((String)TAG, (String)((StringBuilder)object).toString());
                this.transitionToStart();
            } else {
                this.setProgress(f);
            }
        }
    }

    public void setTransition(int n, int n2) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setStartState(n);
            this.mStateCache.setEndState(n2);
            return;
        }
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            this.mBeginState = n;
            this.mEndState = n2;
            motionScene.setTransition(n, n2);
            this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(n), this.mScene.getConstraintSet(n2));
            this.rebuildScene();
            this.mTransitionLastPosition = 0.0f;
            this.transitionToStart();
        }
    }

    protected void setTransition(MotionScene.Transition transition) {
        this.mScene.setTransition(transition);
        this.setState(TransitionState.SETUP);
        if (this.mCurrentState == this.mScene.getEndId()) {
            this.mTransitionLastPosition = 1.0f;
            this.mTransitionPosition = 1.0f;
            this.mTransitionGoalPosition = 1.0f;
        } else {
            this.mTransitionLastPosition = 0.0f;
            this.mTransitionPosition = 0.0f;
            this.mTransitionGoalPosition = 0.0f;
        }
        long l = transition.isTransitionFlag(1) ? -1L : this.getNanoTime();
        this.mTransitionLastTime = l;
        int n = this.mScene.getStartId();
        int n2 = this.mScene.getEndId();
        if (n == this.mBeginState && n2 == this.mEndState) {
            return;
        }
        this.mBeginState = n;
        this.mEndState = n2;
        this.mScene.setTransition(n, n2);
        this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
        this.mModel.setMeasuredId(this.mBeginState, this.mEndState);
        this.mModel.reEvaluateState();
        this.rebuildScene();
    }

    public void setTransitionDuration(int n) {
        MotionScene motionScene = this.mScene;
        if (motionScene == null) {
            Log.e((String)TAG, (String)"MotionScene not defined");
            return;
        }
        motionScene.setDuration(n);
    }

    public void setTransitionListener(TransitionListener transitionListener) {
        this.mTransitionListener = transitionListener;
    }

    public void setTransitionState(Bundle bundle) {
        if (this.mStateCache == null) {
            this.mStateCache = new StateCache();
        }
        this.mStateCache.setTransitionState(bundle);
        if (this.isAttachedToWindow()) {
            this.mStateCache.apply();
        }
    }

    public String toString() {
        Context context = this.getContext();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Debug.getName(context, this.mBeginState));
        stringBuilder.append("->");
        stringBuilder.append(Debug.getName(context, this.mEndState));
        stringBuilder.append(" (pos:");
        stringBuilder.append(this.mTransitionLastPosition);
        stringBuilder.append(" Dpos/Dt:");
        stringBuilder.append(this.mLastVelocity);
        return stringBuilder.toString();
    }

    public void touchAnimateTo(int n, float f, float f2) {
        block12: {
            block9: {
                block10: {
                    block11: {
                        if (this.mScene == null) {
                            return;
                        }
                        if (this.mTransitionLastPosition == f) {
                            return;
                        }
                        this.mTemporalInterpolator = true;
                        this.mAnimationStartTime = this.getNanoTime();
                        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
                        this.mTransitionGoalPosition = f;
                        this.mInTransition = true;
                        if (n == 0 || n == 1 || n == 2) break block9;
                        if (n == 4) break block10;
                        if (n == 5) break block11;
                        if (n == 6 || n == 7) break block9;
                        break block12;
                    }
                    if (MotionLayout.willJump(f2, this.mTransitionLastPosition, this.mScene.getMaxAcceleration())) {
                        this.mDecelerateLogic.config(f2, this.mTransitionLastPosition, this.mScene.getMaxAcceleration());
                        this.mInterpolator = this.mDecelerateLogic;
                    } else {
                        this.mStopLogic.config(this.mTransitionLastPosition, f, f2, this.mTransitionDuration, this.mScene.getMaxAcceleration(), this.mScene.getMaxVelocity());
                        this.mLastVelocity = 0.0f;
                        n = this.mCurrentState;
                        this.mTransitionGoalPosition = f;
                        this.mCurrentState = n;
                        this.mInterpolator = this.mStopLogic;
                    }
                    break block12;
                }
                this.mDecelerateLogic.config(f2, this.mTransitionLastPosition, this.mScene.getMaxAcceleration());
                this.mInterpolator = this.mDecelerateLogic;
                break block12;
            }
            if (n != 1 && n != 7) {
                if (n == 2 || n == 6) {
                    f = 1.0f;
                }
            } else {
                f = 0.0f;
            }
            if (this.mScene.getAutoCompleteMode() == 0) {
                this.mStopLogic.config(this.mTransitionLastPosition, f, f2, this.mTransitionDuration, this.mScene.getMaxAcceleration(), this.mScene.getMaxVelocity());
            } else {
                this.mStopLogic.springConfig(this.mTransitionLastPosition, f, f2, this.mScene.getSpringMass(), this.mScene.getSpringStiffiness(), this.mScene.getSpringDamping(), this.mScene.getSpringStopThreshold(), this.mScene.getSpringBoundary());
            }
            n = this.mCurrentState;
            this.mTransitionGoalPosition = f;
            this.mCurrentState = n;
            this.mInterpolator = this.mStopLogic;
        }
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = this.getNanoTime();
        this.invalidate();
    }

    public void touchSpringTo(float f, float f2) {
        if (this.mScene == null) {
            return;
        }
        if (this.mTransitionLastPosition == f) {
            return;
        }
        this.mTemporalInterpolator = true;
        this.mAnimationStartTime = this.getNanoTime();
        this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        this.mTransitionGoalPosition = f;
        this.mInTransition = true;
        this.mStopLogic.springConfig(this.mTransitionLastPosition, f, f2, this.mScene.getSpringMass(), this.mScene.getSpringStiffiness(), this.mScene.getSpringDamping(), this.mScene.getSpringStopThreshold(), this.mScene.getSpringBoundary());
        int n = this.mCurrentState;
        this.mTransitionGoalPosition = f;
        this.mCurrentState = n;
        this.mInterpolator = this.mStopLogic;
        this.mTransitionInstantly = false;
        this.mAnimationStartTime = this.getNanoTime();
        this.invalidate();
    }

    public void transitionToEnd() {
        this.animateTo(1.0f);
        this.mOnComplete = null;
    }

    public void transitionToEnd(Runnable runnable) {
        this.animateTo(1.0f);
        this.mOnComplete = runnable;
    }

    public void transitionToStart() {
        this.animateTo(0.0f);
    }

    public void transitionToState(int n) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setEndState(n);
            return;
        }
        this.transitionToState(n, -1, -1);
    }

    public void transitionToState(int n, int n2) {
        if (!this.isAttachedToWindow()) {
            if (this.mStateCache == null) {
                this.mStateCache = new StateCache();
            }
            this.mStateCache.setEndState(n);
            return;
        }
        this.transitionToState(n, -1, -1, n2);
    }

    public void transitionToState(int n, int n2, int n3) {
        this.transitionToState(n, n2, n3, -1);
    }

    public void transitionToState(int n, int n2, int n3, int n4) {
        float f;
        Object object = this.mScene;
        int n5 = n;
        if (object != null) {
            n5 = n;
            if (((MotionScene)object).mStateSet != null) {
                n2 = this.mScene.mStateSet.convertToConstraintSet(this.mCurrentState, n, n2, n3);
                n5 = n;
                if (n2 != -1) {
                    n5 = n2;
                }
            }
        }
        if ((n = this.mCurrentState) == n5) {
            return;
        }
        if (this.mBeginState == n5) {
            this.animateTo(0.0f);
            if (n4 > 0) {
                this.mTransitionDuration = (float)n4 / 1000.0f;
            }
            return;
        }
        if (this.mEndState == n5) {
            this.animateTo(1.0f);
            if (n4 > 0) {
                this.mTransitionDuration = (float)n4 / 1000.0f;
            }
            return;
        }
        this.mEndState = n5;
        if (n != -1) {
            this.setTransition(n, n5);
            this.animateTo(1.0f);
            this.mTransitionLastPosition = 0.0f;
            this.transitionToEnd();
            if (n4 > 0) {
                this.mTransitionDuration = (float)n4 / 1000.0f;
            }
            return;
        }
        n3 = 0;
        this.mTemporalInterpolator = false;
        this.mTransitionGoalPosition = 1.0f;
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.mTransitionLastTime = this.getNanoTime();
        this.mAnimationStartTime = this.getNanoTime();
        this.mTransitionInstantly = false;
        this.mInterpolator = null;
        if (n4 == -1) {
            this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        }
        this.mBeginState = -1;
        this.mScene.setTransition(-1, this.mEndState);
        SparseArray sparseArray = new SparseArray();
        if (n4 == 0) {
            this.mTransitionDuration = (float)this.mScene.getDuration() / 1000.0f;
        } else if (n4 > 0) {
            this.mTransitionDuration = (float)n4 / 1000.0f;
        }
        n4 = this.getChildCount();
        this.mFrameArrayList.clear();
        for (n = 0; n < n4; ++n) {
            View view = this.getChildAt(n);
            object = new MotionController(view);
            this.mFrameArrayList.put(view, (MotionController)object);
            sparseArray.put(view.getId(), (Object)this.mFrameArrayList.get(view));
        }
        this.mInTransition = true;
        this.mModel.initFrom(this.mLayoutWidget, null, this.mScene.getConstraintSet(n5));
        this.rebuildScene();
        this.mModel.build();
        this.computeCurrentPositions();
        n2 = this.getWidth();
        n5 = this.getHeight();
        if (this.mDecoratorsHelpers != null) {
            for (n = 0; n < n4; ++n) {
                object = this.mFrameArrayList.get(this.getChildAt(n));
                if (object == null) continue;
                this.mScene.getKeyFrames((MotionController)object);
            }
            object = this.mDecoratorsHelpers.iterator();
            while (object.hasNext()) {
                ((MotionHelper)object.next()).onPreSetup(this, this.mFrameArrayList);
            }
            for (n = 0; n < n4; ++n) {
                object = this.mFrameArrayList.get(this.getChildAt(n));
                if (object == null) continue;
                ((MotionController)object).setup(n2, n5, this.mTransitionDuration, this.getNanoTime());
            }
        } else {
            for (n = 0; n < n4; ++n) {
                object = this.mFrameArrayList.get(this.getChildAt(n));
                if (object == null) continue;
                this.mScene.getKeyFrames((MotionController)object);
                ((MotionController)object).setup(n2, n5, this.mTransitionDuration, this.getNanoTime());
            }
        }
        if ((f = this.mScene.getStaggered()) != 0.0f) {
            float f2;
            float f3 = Float.MAX_VALUE;
            float f4 = -3.4028235E38f;
            n2 = 0;
            while (true) {
                if (n2 >= n4) break;
                object = this.mFrameArrayList.get(this.getChildAt(n2));
                f2 = ((MotionController)object).getFinalX();
                f2 = ((MotionController)object).getFinalY() + f2;
                f3 = Math.min(f3, f2);
                f4 = Math.max(f4, f2);
                ++n2;
            }
            for (n = n3; n < n4; ++n) {
                object = this.mFrameArrayList.get(this.getChildAt(n));
                float f5 = ((MotionController)object).getFinalX();
                f2 = ((MotionController)object).getFinalY();
                ((MotionController)object).mStaggerScale = 1.0f / (1.0f - f);
                ((MotionController)object).mStaggerOffset = f - (f5 + f2 - f3) * f / (f4 - f3);
            }
        }
        this.mTransitionPosition = 0.0f;
        this.mTransitionLastPosition = 0.0f;
        this.mInTransition = true;
        this.invalidate();
    }

    public void updateState() {
        this.mModel.initFrom(this.mLayoutWidget, this.mScene.getConstraintSet(this.mBeginState), this.mScene.getConstraintSet(this.mEndState));
        this.rebuildScene();
    }

    public void updateState(int n, ConstraintSet constraintSet) {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            motionScene.setConstraintSet(n, constraintSet);
        }
        this.updateState();
        if (this.mCurrentState == n) {
            constraintSet.applyTo(this);
        }
    }

    public void updateStateAnimate(int n, ConstraintSet object, int n2) {
        if (this.mScene == null) {
            return;
        }
        if (this.mCurrentState == n) {
            this.updateState(R.id.view_transition, this.getConstraintSet(n));
            this.setState(R.id.view_transition, -1, -1);
            this.updateState(n, (ConstraintSet)object);
            object = new MotionScene.Transition(-1, this.mScene, R.id.view_transition, n);
            ((MotionScene.Transition)object).setDuration(n2);
            this.setTransition((MotionScene.Transition)object);
            this.transitionToEnd();
        }
    }

    public void viewTransition(int n, View ... viewArray) {
        MotionScene motionScene = this.mScene;
        if (motionScene != null) {
            motionScene.viewTransition(n, viewArray);
        } else {
            Log.e((String)TAG, (String)" no motionScene");
        }
    }

    class DecelerateInterpolator
    extends MotionInterpolator {
        float currentP = 0.0f;
        float initalV = 0.0f;
        float maxA;

        DecelerateInterpolator() {
        }

        public void config(float f, float f2, float f3) {
            this.initalV = f;
            this.currentP = f2;
            this.maxA = f3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public float getInterpolation(float f) {
            float f2;
            float f3 = this.initalV;
            if (f3 > 0.0f) {
                float f4 = this.maxA;
                f2 = f;
                if (f3 / f4 < f) {
                    f2 = f3 / f4;
                }
                MotionLayout.this.mLastVelocity = f3 - f4 * f2;
                f = this.initalV * f2 - this.maxA * f2 * f2 / 2.0f;
                f2 = this.currentP;
                return f + f2;
            }
            float f5 = -f3;
            float f6 = this.maxA;
            f2 = f;
            if (f5 / f6 < f) {
                f2 = -f3 / f6;
            }
            MotionLayout.this.mLastVelocity = f3 + f6 * f2;
            f = this.initalV * f2 + this.maxA * f2 * f2 / 2.0f;
            f2 = this.currentP;
            return f + f2;
        }

        @Override
        public float getVelocity() {
            return MotionLayout.this.mLastVelocity;
        }
    }

    private class DevModeDraw {
        private static final int DEBUG_PATH_TICKS_PER_MS = 16;
        final int DIAMOND_SIZE;
        final int GRAPH_COLOR;
        final int KEYFRAME_COLOR;
        final int RED_COLOR;
        final int SHADOW_COLOR;
        Rect mBounds = new Rect();
        DashPathEffect mDashPathEffect;
        Paint mFillPaint;
        int mKeyFrameCount;
        float[] mKeyFramePoints;
        Paint mPaint;
        Paint mPaintGraph;
        Paint mPaintKeyframes;
        Path mPath;
        int[] mPathMode;
        float[] mPoints;
        boolean mPresentationMode = false;
        private float[] mRectangle;
        int mShadowTranslate = 1;
        Paint mTextPaint;

        public DevModeDraw() {
            Paint paint;
            this.RED_COLOR = -21965;
            this.KEYFRAME_COLOR = -2067046;
            this.GRAPH_COLOR = -13391360;
            this.SHADOW_COLOR = 0x77000000;
            this.DIAMOND_SIZE = 10;
            this.mPaint = paint = new Paint();
            paint.setAntiAlias(true);
            this.mPaint.setColor(-21965);
            this.mPaint.setStrokeWidth(2.0f);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaintKeyframes = paint = new Paint();
            paint.setAntiAlias(true);
            this.mPaintKeyframes.setColor(-2067046);
            this.mPaintKeyframes.setStrokeWidth(2.0f);
            this.mPaintKeyframes.setStyle(Paint.Style.STROKE);
            this.mPaintGraph = paint = new Paint();
            paint.setAntiAlias(true);
            this.mPaintGraph.setColor(-13391360);
            this.mPaintGraph.setStrokeWidth(2.0f);
            this.mPaintGraph.setStyle(Paint.Style.STROKE);
            this.mTextPaint = paint = new Paint();
            paint.setAntiAlias(true);
            this.mTextPaint.setColor(-13391360);
            this.mTextPaint.setTextSize(MotionLayout.this.getContext().getResources().getDisplayMetrics().density * 12.0f);
            this.mRectangle = new float[8];
            MotionLayout.this = new Paint();
            this.mFillPaint = MotionLayout.this;
            MotionLayout.this.setAntiAlias(true);
            MotionLayout.this = new DashPathEffect(new float[]{4.0f, 8.0f}, 0.0f);
            this.mDashPathEffect = MotionLayout.this;
            this.mPaintGraph.setPathEffect((PathEffect)MotionLayout.this);
            this.mKeyFramePoints = new float[100];
            this.mPathMode = new int[50];
            if (this.mPresentationMode) {
                this.mPaint.setStrokeWidth(8.0f);
                this.mFillPaint.setStrokeWidth(8.0f);
                this.mPaintKeyframes.setStrokeWidth(8.0f);
                this.mShadowTranslate = 4;
            }
        }

        private void drawBasicPath(Canvas canvas) {
            canvas.drawLines(this.mPoints, this.mPaint);
        }

        private void drawPathAsConfigured(Canvas canvas) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < this.mKeyFrameCount; ++i) {
                int[] nArray = this.mPathMode;
                if (nArray[i] == 1) {
                    bl = true;
                }
                if (nArray[i] != 0) continue;
                bl2 = true;
            }
            if (bl) {
                this.drawPathRelative(canvas);
            }
            if (bl2) {
                this.drawPathCartesian(canvas);
            }
        }

        private void drawPathCartesian(Canvas canvas) {
            float[] fArray = this.mPoints;
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[fArray.length - 2];
            float f4 = fArray[fArray.length - 1];
            canvas.drawLine(Math.min(f, f3), Math.max(f2, f4), Math.max(f, f3), Math.max(f2, f4), this.mPaintGraph);
            canvas.drawLine(Math.min(f, f3), Math.min(f2, f4), Math.min(f, f3), Math.max(f2, f4), this.mPaintGraph);
        }

        private void drawPathCartesianTicks(Canvas canvas, float f, float f2) {
            Object object = this.mPoints;
            float f3 = object[0];
            float f4 = object[1];
            float f5 = object[((float[])object).length - 2];
            float f6 = object[((float[])object).length - 1];
            float f7 = Math.min(f3, f5);
            float f8 = Math.max(f4, f6);
            float f9 = f - Math.min(f3, f5);
            float f10 = Math.max(f4, f6) - f2;
            object = new StringBuilder();
            ((StringBuilder)object).append("");
            ((StringBuilder)object).append((float)((int)((double)(f9 * 100.0f / Math.abs(f5 - f3)) + 0.5)) / 100.0f);
            object = ((StringBuilder)object).toString();
            this.getTextBounds((String)object, this.mTextPaint);
            canvas.drawText((String)object, f9 / 2.0f - (float)(this.mBounds.width() / 2) + f7, f2 - 20.0f, this.mTextPaint);
            canvas.drawLine(f, f2, Math.min(f3, f5), f2, this.mPaintGraph);
            object = new StringBuilder();
            ((StringBuilder)object).append("");
            ((StringBuilder)object).append((float)((int)((double)(f10 * 100.0f / Math.abs(f6 - f4)) + 0.5)) / 100.0f);
            object = ((StringBuilder)object).toString();
            this.getTextBounds((String)object, this.mTextPaint);
            canvas.drawText((String)object, f + 5.0f, f8 - (f10 / 2.0f - (float)(this.mBounds.height() / 2)), this.mTextPaint);
            canvas.drawLine(f, f2, f, Math.max(f4, f6), this.mPaintGraph);
        }

        private void drawPathRelative(Canvas canvas) {
            float[] fArray = this.mPoints;
            canvas.drawLine(fArray[0], fArray[1], fArray[fArray.length - 2], fArray[fArray.length - 1], this.mPaintGraph);
        }

        private void drawPathRelativeTicks(Canvas canvas, float f, float f2) {
            Object object = this.mPoints;
            float f3 = object[0];
            float f4 = object[1];
            float f5 = object[((float[])object).length - 2];
            float f6 = object[((float[])object).length - 1];
            float f7 = (float)Math.hypot(f3 - f5, f4 - f6);
            float f8 = f5 - f3;
            f5 = ((f - f3) * f8 + (f2 - f4) * (f6 -= f4)) / (f7 * f7);
            f6 = f4 + f5 * f6;
            object = new Path();
            object.moveTo(f, f2);
            object.lineTo(f3 += f8 * f5, f6);
            f4 = (float)Math.hypot(f3 - f, f6 - f2);
            CharSequence charSequence = new StringBuilder();
            charSequence.append("");
            charSequence.append((float)((int)(f4 * 100.0f / f7)) / 100.0f);
            charSequence = charSequence.toString();
            this.getTextBounds((String)charSequence, this.mTextPaint);
            canvas.drawTextOnPath((String)charSequence, (Path)object, f4 / 2.0f - (float)(this.mBounds.width() / 2), -20.0f, this.mTextPaint);
            canvas.drawLine(f, f2, f3, f6, this.mPaintGraph);
        }

        private void drawPathScreenTicks(Canvas canvas, float f, float f2, int n, int n2) {
            CharSequence charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append((float)((int)((double)((f - (float)(n / 2)) * 100.0f / (float)(MotionLayout.this.getWidth() - n)) + 0.5)) / 100.0f);
            charSequence = ((StringBuilder)charSequence).toString();
            this.getTextBounds((String)charSequence, this.mTextPaint);
            canvas.drawText((String)charSequence, f / 2.0f - (float)(this.mBounds.width() / 2) + 0.0f, f2 - 20.0f, this.mTextPaint);
            canvas.drawLine(f, f2, Math.min(0.0f, 1.0f), f2, this.mPaintGraph);
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append((float)((int)((double)((f2 - (float)(n2 / 2)) * 100.0f / (float)(MotionLayout.this.getHeight() - n2)) + 0.5)) / 100.0f);
            charSequence = ((StringBuilder)charSequence).toString();
            this.getTextBounds((String)charSequence, this.mTextPaint);
            canvas.drawText((String)charSequence, f + 5.0f, 0.0f - (f2 / 2.0f - (float)(this.mBounds.height() / 2)), this.mTextPaint);
            canvas.drawLine(f, f2, f, Math.max(0.0f, 1.0f), this.mPaintGraph);
        }

        private void drawRectangle(Canvas canvas, MotionController motionController) {
            this.mPath.reset();
            for (int i = 0; i <= 50; ++i) {
                motionController.buildRect((float)i / (float)50, this.mRectangle, 0);
                Object object = this.mPath;
                Object object2 = this.mRectangle;
                object.moveTo(object2[0], object2[1]);
                object2 = this.mPath;
                object = this.mRectangle;
                object2.lineTo((float)object[2], (float)object[3]);
                object = this.mPath;
                object2 = this.mRectangle;
                object.lineTo(object2[4], object2[5]);
                object = this.mPath;
                object2 = this.mRectangle;
                object.lineTo(object2[6], object2[7]);
                this.mPath.close();
            }
            this.mPaint.setColor(0x44000000);
            canvas.translate(2.0f, 2.0f);
            canvas.drawPath(this.mPath, this.mPaint);
            canvas.translate(-2.0f, -2.0f);
            this.mPaint.setColor(-65536);
            canvas.drawPath(this.mPath, this.mPaint);
        }

        private void drawTicks(Canvas canvas, int n, int n2, MotionController object) {
            int n3;
            int n4;
            if (((MotionController)object).mView != null) {
                n4 = ((MotionController)object).mView.getWidth();
                n3 = ((MotionController)object).mView.getHeight();
            } else {
                n4 = 0;
                n3 = 0;
            }
            for (int i = 1; i < n2 - 1; ++i) {
                if (n == 4 && this.mPathMode[i - 1] == 0) continue;
                Object[] objectArray = this.mKeyFramePoints;
                int n5 = i * 2;
                float f = objectArray[n5];
                float f2 = objectArray[n5 + 1];
                this.mPath.reset();
                this.mPath.moveTo(f, f2 + 10.0f);
                this.mPath.lineTo(f + 10.0f, f2);
                this.mPath.lineTo(f, f2 - 10.0f);
                this.mPath.lineTo(f - 10.0f, f2);
                this.mPath.close();
                n5 = i - 1;
                ((MotionController)object).getKeyFrame(n5);
                if (n == 4) {
                    objectArray = this.mPathMode;
                    if (objectArray[n5] == true) {
                        this.drawPathRelativeTicks(canvas, f - 0.0f, f2 - 0.0f);
                    } else if (objectArray[n5] == false) {
                        this.drawPathCartesianTicks(canvas, f - 0.0f, f2 - 0.0f);
                    } else if (objectArray[n5] == 2) {
                        this.drawPathScreenTicks(canvas, f - 0.0f, f2 - 0.0f, n4, n3);
                    }
                    canvas.drawPath(this.mPath, this.mFillPaint);
                }
                if (n == 2) {
                    this.drawPathRelativeTicks(canvas, f - 0.0f, f2 - 0.0f);
                }
                if (n == 3) {
                    this.drawPathCartesianTicks(canvas, f - 0.0f, f2 - 0.0f);
                }
                if (n == 6) {
                    this.drawPathScreenTicks(canvas, f - 0.0f, f2 - 0.0f, n4, n3);
                }
                canvas.drawPath(this.mPath, this.mFillPaint);
            }
            object = this.mPoints;
            if (((Object)object).length > 1) {
                canvas.drawCircle((float)object[0], (float)object[1], 8.0f, this.mPaintKeyframes);
                object = this.mPoints;
                canvas.drawCircle((float)object[((Object)object).length - 2], (float)object[((Object)object).length - 1], 8.0f, this.mPaintKeyframes);
            }
        }

        private void drawTranslation(Canvas canvas, float f, float f2, float f3, float f4) {
            canvas.drawRect(f, f2, f3, f4, this.mPaintGraph);
            canvas.drawLine(f, f2, f3, f4, this.mPaintGraph);
        }

        /*
         * WARNING - void declaration
         */
        public void draw(Canvas canvas, HashMap<View, MotionController> object3, int n, int n2) {
            if (object3 != null && ((HashMap)object3).size() != 0) {
                void var4_6;
                canvas.save();
                if (!MotionLayout.this.isInEditMode() && (var4_6 & 1) == 2) {
                    Object object = new StringBuilder();
                    ((StringBuilder)object).append(MotionLayout.this.getContext().getResources().getResourceName(MotionLayout.this.mEndState));
                    ((StringBuilder)object).append(":");
                    ((StringBuilder)object).append(MotionLayout.this.getProgress());
                    object = ((StringBuilder)object).toString();
                    canvas.drawText((String)object, 10.0f, (float)(MotionLayout.this.getHeight() - 30), this.mTextPaint);
                    canvas.drawText((String)object, 11.0f, (float)(MotionLayout.this.getHeight() - 29), this.mPaint);
                }
                for (MotionController motionController : ((HashMap)object3).values()) {
                    void var3_5;
                    int n3;
                    int n4 = n3 = motionController.getDrawPath();
                    if (var4_6 > 0) {
                        n4 = n3;
                        if (n3 == 0) {
                            n4 = 1;
                        }
                    }
                    if (n4 == 0) continue;
                    this.mKeyFrameCount = motionController.buildKeyFrames(this.mKeyFramePoints, this.mPathMode);
                    if (n4 < 1) continue;
                    void var8_10 = var3_5 / 16;
                    float[] fArray = this.mPoints;
                    if (fArray == null || fArray.length != var8_10 * 2) {
                        this.mPoints = new float[var8_10 * 2];
                        this.mPath = new Path();
                    }
                    n3 = this.mShadowTranslate;
                    canvas.translate((float)n3, (float)n3);
                    this.mPaint.setColor(0x77000000);
                    this.mFillPaint.setColor(0x77000000);
                    this.mPaintKeyframes.setColor(0x77000000);
                    this.mPaintGraph.setColor(0x77000000);
                    motionController.buildPath(this.mPoints, (int)var8_10);
                    this.drawAll(canvas, n4, this.mKeyFrameCount, motionController);
                    this.mPaint.setColor(-21965);
                    this.mPaintKeyframes.setColor(-2067046);
                    this.mFillPaint.setColor(-2067046);
                    this.mPaintGraph.setColor(-13391360);
                    n3 = this.mShadowTranslate;
                    canvas.translate((float)(-n3), (float)(-n3));
                    this.drawAll(canvas, n4, this.mKeyFrameCount, motionController);
                    if (n4 != 5) continue;
                    this.drawRectangle(canvas, motionController);
                }
                canvas.restore();
            }
        }

        public void drawAll(Canvas canvas, int n, int n2, MotionController motionController) {
            if (n == 4) {
                this.drawPathAsConfigured(canvas);
            }
            if (n == 2) {
                this.drawPathRelative(canvas);
            }
            if (n == 3) {
                this.drawPathCartesian(canvas);
            }
            this.drawBasicPath(canvas);
            this.drawTicks(canvas, n, n2, motionController);
        }

        void getTextBounds(String string2, Paint paint) {
            paint.getTextBounds(string2, 0, string2.length(), this.mBounds);
        }
    }

    class Model {
        ConstraintSet mEnd = null;
        int mEndId;
        ConstraintWidgetContainer mLayoutEnd;
        ConstraintWidgetContainer mLayoutStart = new ConstraintWidgetContainer();
        ConstraintSet mStart = null;
        int mStartId;

        Model() {
            this.mLayoutEnd = new ConstraintWidgetContainer();
        }

        private void computeStartEndSize(int n, int n2) {
            int n3 = MotionLayout.this.getOptimizationLevel();
            if (MotionLayout.this.mCurrentState == MotionLayout.this.getStartState()) {
                MotionLayout motionLayout = MotionLayout.this;
                Object object = this.mLayoutEnd;
                Object object2 = this.mEnd;
                int n4 = object2 != null && ((ConstraintSet)object2).mRotate != 0 ? n2 : n;
                object2 = this.mEnd;
                int n5 = object2 != null && ((ConstraintSet)object2).mRotate != 0 ? n : n2;
                motionLayout.resolveSystem((ConstraintWidgetContainer)object, n3, n4, n5);
                object = this.mStart;
                if (object != null) {
                    motionLayout = MotionLayout.this;
                    object2 = this.mLayoutStart;
                    n4 = ((ConstraintSet)object).mRotate == 0 ? n : n2;
                    if (this.mStart.mRotate == 0) {
                        n = n2;
                    }
                    motionLayout.resolveSystem((ConstraintWidgetContainer)object2, n3, n4, n);
                }
            } else {
                int n6;
                Object object;
                MotionLayout motionLayout;
                Object object3 = this.mStart;
                if (object3 != null) {
                    motionLayout = MotionLayout.this;
                    object = this.mLayoutStart;
                    n6 = ((ConstraintSet)object3).mRotate == 0 ? n : n2;
                    int n7 = this.mStart.mRotate == 0 ? n2 : n;
                    motionLayout.resolveSystem((ConstraintWidgetContainer)object, n3, n6, n7);
                }
                motionLayout = MotionLayout.this;
                object3 = this.mLayoutEnd;
                object = this.mEnd;
                n6 = object != null && ((ConstraintSet)object).mRotate != 0 ? n2 : n;
                object = this.mEnd;
                if (object == null || ((ConstraintSet)object).mRotate == 0) {
                    n = n2;
                }
                motionLayout.resolveSystem((ConstraintWidgetContainer)object3, n3, n6, n);
            }
        }

        private void debugLayout(String object, ConstraintWidgetContainer constraintWidgetContainer) {
            Object object2 = (View)constraintWidgetContainer.getCompanionWidget();
            CharSequence charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append(" ");
            ((StringBuilder)charSequence).append(Debug.getName(object2));
            object2 = ((StringBuilder)charSequence).toString();
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append("  ========= ");
            ((StringBuilder)object).append(constraintWidgetContainer);
            Log.v((String)MotionLayout.TAG, (String)((StringBuilder)object).toString());
            int n = constraintWidgetContainer.getChildren().size();
            for (int i = 0; i < n; ++i) {
                object = new StringBuilder();
                ((StringBuilder)object).append((String)object2);
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(i);
                ((StringBuilder)object).append("] ");
                String string2 = ((StringBuilder)object).toString();
                ConstraintWidget constraintWidget = constraintWidgetContainer.getChildren().get(i);
                CharSequence charSequence2 = new StringBuilder();
                charSequence2.append("");
                object = constraintWidget.mTop.mTarget;
                charSequence = "_";
                object = object != null ? "T" : "_";
                charSequence2.append((String)object);
                object = charSequence2.toString();
                charSequence2 = new StringBuilder();
                charSequence2.append((String)object);
                object = constraintWidget.mBottom.mTarget != null ? "B" : "_";
                charSequence2.append((String)object);
                object = charSequence2.toString();
                charSequence2 = new StringBuilder();
                charSequence2.append((String)object);
                object = constraintWidget.mLeft.mTarget != null ? "L" : "_";
                charSequence2.append((String)object);
                object = charSequence2.toString();
                charSequence2 = new StringBuilder();
                charSequence2.append((String)object);
                object = charSequence;
                if (constraintWidget.mRight.mTarget != null) {
                    object = "R";
                }
                charSequence2.append((String)object);
                charSequence2 = charSequence2.toString();
                View view = (View)constraintWidget.getCompanionWidget();
                charSequence = Debug.getName(view);
                object = charSequence;
                if (view instanceof TextView) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append((String)charSequence);
                    ((StringBuilder)object).append("(");
                    ((StringBuilder)object).append((Object)((TextView)view).getText());
                    ((StringBuilder)object).append(")");
                    object = ((StringBuilder)object).toString();
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append("  ");
                ((StringBuilder)charSequence).append((String)object);
                ((StringBuilder)charSequence).append(" ");
                ((StringBuilder)charSequence).append(constraintWidget);
                ((StringBuilder)charSequence).append(" ");
                ((StringBuilder)charSequence).append((String)charSequence2);
                Log.v((String)MotionLayout.TAG, (String)((StringBuilder)charSequence).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append((String)object2);
            ((StringBuilder)object).append(" done. ");
            Log.v((String)MotionLayout.TAG, (String)((StringBuilder)object).toString());
        }

        private void debugLayoutParam(String string2, ConstraintLayout.LayoutParams object) {
            CharSequence charSequence = new StringBuilder();
            charSequence.append(" ");
            CharSequence charSequence2 = object.startToStart != -1 ? "SS" : "__";
            charSequence.append((String)charSequence2);
            charSequence2 = charSequence.toString();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            int n = object.startToEnd;
            charSequence = "|__";
            charSequence2 = n != -1 ? "|SE" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.endToStart != -1 ? "|ES" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.endToEnd != -1 ? "|EE" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.leftToLeft != -1 ? "|LL" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.leftToRight != -1 ? "|LR" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.rightToLeft != -1 ? "|RL" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.rightToRight != -1 ? "|RR" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.topToTop != -1 ? "|TT" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.topToBottom != -1 ? "|TB" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = object.bottomToTop != -1 ? "|BT" : "|__";
            stringBuilder.append((String)charSequence2);
            charSequence2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence2);
            charSequence2 = charSequence;
            if (object.bottomToBottom != -1) {
                charSequence2 = "|BB";
            }
            stringBuilder.append((String)charSequence2);
            object = stringBuilder.toString();
            charSequence2 = new StringBuilder();
            ((StringBuilder)charSequence2).append(string2);
            ((StringBuilder)charSequence2).append((String)object);
            Log.v((String)MotionLayout.TAG, (String)((StringBuilder)charSequence2).toString());
        }

        private void debugWidget(String string2, ConstraintWidget constraintWidget) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(" ");
            Object object = constraintWidget.mTop.mTarget;
            String string3 = "B";
            CharSequence charSequence = "__";
            if (object != null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("T");
                object = constraintWidget.mTop.mTarget.mType == ConstraintAnchor.Type.TOP ? "T" : "B";
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
            } else {
                object = "__";
            }
            stringBuilder2.append((String)object);
            object = stringBuilder2.toString();
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append((String)object);
            if (constraintWidget.mBottom.mTarget != null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("B");
                object = string3;
                if (constraintWidget.mBottom.mTarget.mType == ConstraintAnchor.Type.TOP) {
                    object = "T";
                }
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
            } else {
                object = "__";
            }
            stringBuilder2.append((String)object);
            object = stringBuilder2.toString();
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append((String)object);
            object = constraintWidget.mLeft.mTarget;
            string3 = "R";
            if (object != null) {
                stringBuilder = new StringBuilder();
                stringBuilder.append("L");
                object = constraintWidget.mLeft.mTarget.mType == ConstraintAnchor.Type.LEFT ? "L" : "R";
                stringBuilder.append((String)object);
                object = stringBuilder.toString();
            } else {
                object = "__";
            }
            stringBuilder2.append((String)object);
            object = stringBuilder2.toString();
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append((String)object);
            object = charSequence;
            if (constraintWidget.mRight.mTarget != null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("R");
                object = string3;
                if (constraintWidget.mRight.mTarget.mType == ConstraintAnchor.Type.LEFT) {
                    object = "L";
                }
                ((StringBuilder)charSequence).append((String)object);
                object = ((StringBuilder)charSequence).toString();
            }
            stringBuilder2.append((String)object);
            charSequence = stringBuilder2.toString();
            object = new StringBuilder();
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append((String)charSequence);
            ((StringBuilder)object).append(" ---  ");
            ((StringBuilder)object).append(constraintWidget);
            Log.v((String)MotionLayout.TAG, (String)((StringBuilder)object).toString());
        }

        private void setupConstraintWidget(ConstraintWidgetContainer constraintWidgetContainer, ConstraintSet object) {
            SparseArray sparseArray = new SparseArray();
            Constraints.LayoutParams layoutParams = new Constraints.LayoutParams(-2, -2);
            sparseArray.clear();
            sparseArray.put(0, (Object)constraintWidgetContainer);
            sparseArray.put(MotionLayout.this.getId(), (Object)constraintWidgetContainer);
            if (object != null && ((ConstraintSet)object).mRotate != 0) {
                MotionLayout object22 = MotionLayout.this;
                object22.resolveSystem(this.mLayoutEnd, object22.getOptimizationLevel(), View.MeasureSpec.makeMeasureSpec((int)MotionLayout.this.getHeight(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)MotionLayout.this.getWidth(), (int)0x40000000));
            }
            for (ConstraintWidget constraintWidget : constraintWidgetContainer.getChildren()) {
                sparseArray.put(((View)constraintWidget.getCompanionWidget()).getId(), (Object)constraintWidget);
            }
            for (ConstraintWidget constraintWidget : constraintWidgetContainer.getChildren()) {
                View view = (View)constraintWidget.getCompanionWidget();
                ((ConstraintSet)object).applyToLayoutParams(view.getId(), layoutParams);
                constraintWidget.setWidth(((ConstraintSet)object).getWidth(view.getId()));
                constraintWidget.setHeight(((ConstraintSet)object).getHeight(view.getId()));
                if (view instanceof ConstraintHelper) {
                    ((ConstraintSet)object).applyToHelper((ConstraintHelper)view, constraintWidget, layoutParams, (SparseArray<ConstraintWidget>)sparseArray);
                    if (view instanceof Barrier) {
                        ((Barrier)view).validateParams();
                    }
                }
                if (Build.VERSION.SDK_INT >= 17) {
                    layoutParams.resolveLayoutDirection(MotionLayout.this.getLayoutDirection());
                } else {
                    layoutParams.resolveLayoutDirection(0);
                }
                MotionLayout.this.applyConstraintsFromLayoutParams(false, view, constraintWidget, layoutParams, (SparseArray<ConstraintWidget>)sparseArray);
                if (((ConstraintSet)object).getVisibilityMode(view.getId()) == 1) {
                    constraintWidget.setVisibility(view.getVisibility());
                    continue;
                }
                constraintWidget.setVisibility(((ConstraintSet)object).getVisibility(view.getId()));
            }
            for (ConstraintWidget constraintWidget : constraintWidgetContainer.getChildren()) {
                if (!(constraintWidget instanceof VirtualLayout)) continue;
                object = (ConstraintHelper)((Object)constraintWidget.getCompanionWidget());
                Helper helper = (Helper)((Object)constraintWidget);
                ((ConstraintHelper)((Object)object)).updatePreLayout(constraintWidgetContainer, helper, (SparseArray<ConstraintWidget>)sparseArray);
                ((VirtualLayout)helper).captureWidgets();
            }
        }

        public void build() {
            int n;
            MotionController motionController;
            Object object;
            int n2;
            int n3 = MotionLayout.this.getChildCount();
            MotionLayout.this.mFrameArrayList.clear();
            SparseArray sparseArray = new SparseArray();
            int[] nArray = new int[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                object = MotionLayout.this.getChildAt(n2);
                motionController = new MotionController((View)object);
                nArray[n2] = n = object.getId();
                sparseArray.put(n, (Object)motionController);
                MotionLayout.this.mFrameArrayList.put((View)object, motionController);
            }
            for (n2 = 0; n2 < n3; ++n2) {
                Object object2;
                motionController = MotionLayout.this.getChildAt(n2);
                object = MotionLayout.this.mFrameArrayList.get(motionController);
                if (object == null) continue;
                if (this.mStart != null) {
                    object2 = this.getWidget(this.mLayoutStart, (View)motionController);
                    if (object2 != null) {
                        ((MotionController)object).setStartState(MotionLayout.this.toRect((ConstraintWidget)object2), this.mStart, MotionLayout.this.getWidth(), MotionLayout.this.getHeight());
                    } else if (MotionLayout.this.mDebugPath != 0) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append(Debug.getLocation());
                        ((StringBuilder)object2).append("no widget for  ");
                        ((StringBuilder)object2).append(Debug.getName((View)motionController));
                        ((StringBuilder)object2).append(" (");
                        ((StringBuilder)object2).append(motionController.getClass().getName());
                        ((StringBuilder)object2).append(")");
                        Log.e((String)MotionLayout.TAG, (String)((StringBuilder)object2).toString());
                    }
                } else if (MotionLayout.this.mInRotation) {
                    ((MotionController)object).setStartState(MotionLayout.this.mPreRotate.get(motionController), (View)motionController, MotionLayout.this.mRotatMode, MotionLayout.this.mPreRotateWidth, MotionLayout.this.mPreRotateHeight);
                }
                if (this.mEnd == null) continue;
                object2 = this.getWidget(this.mLayoutEnd, (View)motionController);
                if (object2 != null) {
                    ((MotionController)object).setEndState(MotionLayout.this.toRect((ConstraintWidget)object2), this.mEnd, MotionLayout.this.getWidth(), MotionLayout.this.getHeight());
                    continue;
                }
                if (MotionLayout.this.mDebugPath == 0) continue;
                object = new StringBuilder();
                ((StringBuilder)object).append(Debug.getLocation());
                ((StringBuilder)object).append("no widget for  ");
                ((StringBuilder)object).append(Debug.getName((View)motionController));
                ((StringBuilder)object).append(" (");
                ((StringBuilder)object).append(motionController.getClass().getName());
                ((StringBuilder)object).append(")");
                Log.e((String)MotionLayout.TAG, (String)((StringBuilder)object).toString());
            }
            for (n2 = 0; n2 < n3; ++n2) {
                motionController = (MotionController)sparseArray.get(nArray[n2]);
                n = motionController.getAnimateRelativeTo();
                if (n == -1) continue;
                motionController.setupRelative((MotionController)sparseArray.get(n));
            }
        }

        /*
         * WARNING - void declaration
         */
        void copy(ConstraintWidgetContainer constraintWidget3, ConstraintWidgetContainer object) {
            Iterator<ConstraintWidget> iterator;
            ArrayList<ConstraintWidget> arrayList = ((WidgetContainer)constraintWidget3).getChildren();
            HashMap<ConstraintWidget, ConstraintWidget> hashMap = new HashMap<ConstraintWidget, ConstraintWidget>();
            hashMap.put(constraintWidget3, (ConstraintWidget)((Object)iterator));
            ((WidgetContainer)((Object)iterator)).getChildren().clear();
            ((ConstraintWidget)((Object)iterator)).copy(constraintWidget3, hashMap);
            for (ConstraintWidget constraintWidget : arrayList) {
                void var1_9;
                if (constraintWidget instanceof androidx.constraintlayout.core.widgets.Barrier) {
                    androidx.constraintlayout.core.widgets.Barrier barrier = new androidx.constraintlayout.core.widgets.Barrier();
                } else if (constraintWidget instanceof Guideline) {
                    Guideline guideline = new Guideline();
                } else if (constraintWidget instanceof Flow) {
                    Flow flow = new Flow();
                } else if (constraintWidget instanceof Placeholder) {
                    Placeholder placeholder = new Placeholder();
                } else if (constraintWidget instanceof Helper) {
                    HelperWidget helperWidget = new HelperWidget();
                } else {
                    ConstraintWidget constraintWidget2 = new ConstraintWidget();
                }
                ((WidgetContainer)((Object)iterator)).add((ConstraintWidget)var1_9);
                hashMap.put(constraintWidget, (ConstraintWidget)var1_9);
            }
            for (ConstraintWidget constraintWidget : arrayList) {
                hashMap.get(constraintWidget).copy(constraintWidget, hashMap);
            }
        }

        ConstraintWidget getWidget(ConstraintWidgetContainer constraintWidget, View view) {
            if (constraintWidget.getCompanionWidget() == view) {
                return constraintWidget;
            }
            ArrayList<ConstraintWidget> arrayList = ((WidgetContainer)constraintWidget).getChildren();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                constraintWidget = arrayList.get(i);
                if (constraintWidget.getCompanionWidget() != view) continue;
                return constraintWidget;
            }
            return null;
        }

        void initFrom(ConstraintWidgetContainer constraintWidgetContainer, ConstraintSet constraintSet, ConstraintSet constraintSet2) {
            this.mStart = constraintSet;
            this.mEnd = constraintSet2;
            this.mLayoutStart = new ConstraintWidgetContainer();
            this.mLayoutEnd = new ConstraintWidgetContainer();
            this.mLayoutStart.setMeasurer(MotionLayout.this.mLayoutWidget.getMeasurer());
            this.mLayoutEnd.setMeasurer(MotionLayout.this.mLayoutWidget.getMeasurer());
            this.mLayoutStart.removeAllChildren();
            this.mLayoutEnd.removeAllChildren();
            this.copy(MotionLayout.this.mLayoutWidget, this.mLayoutStart);
            this.copy(MotionLayout.this.mLayoutWidget, this.mLayoutEnd);
            if ((double)MotionLayout.this.mTransitionLastPosition > 0.5) {
                if (constraintSet != null) {
                    this.setupConstraintWidget(this.mLayoutStart, constraintSet);
                }
                this.setupConstraintWidget(this.mLayoutEnd, constraintSet2);
            } else {
                this.setupConstraintWidget(this.mLayoutEnd, constraintSet2);
                if (constraintSet != null) {
                    this.setupConstraintWidget(this.mLayoutStart, constraintSet);
                }
            }
            this.mLayoutStart.setRtl(MotionLayout.this.isRtl());
            this.mLayoutStart.updateHierarchy();
            this.mLayoutEnd.setRtl(MotionLayout.this.isRtl());
            this.mLayoutEnd.updateHierarchy();
            constraintWidgetContainer = MotionLayout.this.getLayoutParams();
            if (constraintWidgetContainer != null) {
                if (((ViewGroup.LayoutParams)constraintWidgetContainer).width == -2) {
                    this.mLayoutStart.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                    this.mLayoutEnd.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
                if (((ViewGroup.LayoutParams)constraintWidgetContainer).height == -2) {
                    this.mLayoutStart.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                    this.mLayoutEnd.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
        }

        public boolean isNotConfiguredWith(int n, int n2) {
            boolean bl = n != this.mStartId || n2 != this.mEndId;
            return bl;
        }

        public void measure(int n, int n2) {
            boolean bl;
            int n3 = View.MeasureSpec.getMode((int)n);
            int n4 = View.MeasureSpec.getMode((int)n2);
            MotionLayout.this.mWidthMeasureMode = n3;
            MotionLayout.this.mHeightMeasureMode = n4;
            MotionLayout.this.getOptimizationLevel();
            this.computeStartEndSize(n, n2);
            n4 = MotionLayout.this.getParent() instanceof MotionLayout && n3 == 0x40000000 && n4 == 0x40000000 ? 0 : 1;
            if (n4 != 0) {
                this.computeStartEndSize(n, n2);
                MotionLayout.this.mStartWrapWidth = this.mLayoutStart.getWidth();
                MotionLayout.this.mStartWrapHeight = this.mLayoutStart.getHeight();
                MotionLayout.this.mEndWrapWidth = this.mLayoutEnd.getWidth();
                MotionLayout.this.mEndWrapHeight = this.mLayoutEnd.getHeight();
                MotionLayout motionLayout = MotionLayout.this;
                bl = motionLayout.mStartWrapWidth != MotionLayout.this.mEndWrapWidth || MotionLayout.this.mStartWrapHeight != MotionLayout.this.mEndWrapHeight;
                motionLayout.mMeasureDuringTransition = bl;
            }
            n4 = MotionLayout.this.mStartWrapWidth;
            n3 = MotionLayout.this.mStartWrapHeight;
            if (MotionLayout.this.mWidthMeasureMode == Integer.MIN_VALUE || MotionLayout.this.mWidthMeasureMode == 0) {
                n4 = (int)((float)MotionLayout.this.mStartWrapWidth + MotionLayout.this.mPostInterpolationPosition * (float)(MotionLayout.this.mEndWrapWidth - MotionLayout.this.mStartWrapWidth));
            }
            if (MotionLayout.this.mHeightMeasureMode == Integer.MIN_VALUE || MotionLayout.this.mHeightMeasureMode == 0) {
                n3 = (int)((float)MotionLayout.this.mStartWrapHeight + MotionLayout.this.mPostInterpolationPosition * (float)(MotionLayout.this.mEndWrapHeight - MotionLayout.this.mStartWrapHeight));
            }
            bl = this.mLayoutStart.isWidthMeasuredTooSmall() || this.mLayoutEnd.isWidthMeasuredTooSmall();
            boolean bl2 = this.mLayoutStart.isHeightMeasuredTooSmall() || this.mLayoutEnd.isHeightMeasuredTooSmall();
            MotionLayout.this.resolveMeasuredDimension(n, n2, n4, n3, bl, bl2);
        }

        public void reEvaluateState() {
            this.measure(MotionLayout.this.mLastWidthMeasureSpec, MotionLayout.this.mLastHeightMeasureSpec);
            MotionLayout.this.setupMotionViews();
        }

        public void setMeasuredId(int n, int n2) {
            this.mStartId = n;
            this.mEndId = n2;
        }
    }

    protected static interface MotionTracker {
        public void addMovement(MotionEvent var1);

        public void clear();

        public void computeCurrentVelocity(int var1);

        public void computeCurrentVelocity(int var1, float var2);

        public float getXVelocity();

        public float getXVelocity(int var1);

        public float getYVelocity();

        public float getYVelocity(int var1);

        public void recycle();
    }

    private static class MyTracker
    implements MotionTracker {
        private static MyTracker me = new MyTracker();
        VelocityTracker tracker;

        private MyTracker() {
        }

        public static MyTracker obtain() {
            MyTracker.me.tracker = VelocityTracker.obtain();
            return me;
        }

        @Override
        public void addMovement(MotionEvent motionEvent) {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                velocityTracker.addMovement(motionEvent);
            }
        }

        @Override
        public void clear() {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                velocityTracker.clear();
            }
        }

        @Override
        public void computeCurrentVelocity(int n) {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                velocityTracker.computeCurrentVelocity(n);
            }
        }

        @Override
        public void computeCurrentVelocity(int n, float f) {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                velocityTracker.computeCurrentVelocity(n, f);
            }
        }

        @Override
        public float getXVelocity() {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                return velocityTracker.getXVelocity();
            }
            return 0.0f;
        }

        @Override
        public float getXVelocity(int n) {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                return velocityTracker.getXVelocity(n);
            }
            return 0.0f;
        }

        @Override
        public float getYVelocity() {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                return velocityTracker.getYVelocity();
            }
            return 0.0f;
        }

        @Override
        public float getYVelocity(int n) {
            if (this.tracker != null) {
                return this.getYVelocity(n);
            }
            return 0.0f;
        }

        @Override
        public void recycle() {
            VelocityTracker velocityTracker = this.tracker;
            if (velocityTracker != null) {
                velocityTracker.recycle();
                this.tracker = null;
            }
        }
    }

    class StateCache {
        final String KeyEndState;
        final String KeyProgress;
        final String KeyStartState;
        final String KeyVelocity;
        int endState = -1;
        float mProgress = Float.NaN;
        float mVelocity = Float.NaN;
        int startState = -1;

        StateCache() {
            this.KeyProgress = "motion.progress";
            this.KeyVelocity = "motion.velocity";
            this.KeyStartState = "motion.StartState";
            this.KeyEndState = "motion.EndState";
        }

        void apply() {
            int n = this.startState;
            if (n != -1 || this.endState != -1) {
                if (n == -1) {
                    MotionLayout.this.transitionToState(this.endState);
                } else {
                    int n2 = this.endState;
                    if (n2 == -1) {
                        MotionLayout.this.setState(n, -1, -1);
                    } else {
                        MotionLayout.this.setTransition(n, n2);
                    }
                }
                MotionLayout.this.setState(TransitionState.SETUP);
            }
            if (Float.isNaN(this.mVelocity)) {
                if (Float.isNaN(this.mProgress)) {
                    return;
                }
                MotionLayout.this.setProgress(this.mProgress);
                return;
            }
            MotionLayout.this.setProgress(this.mProgress, this.mVelocity);
            this.mProgress = Float.NaN;
            this.mVelocity = Float.NaN;
            this.startState = -1;
            this.endState = -1;
        }

        public Bundle getTransitionState() {
            Bundle bundle = new Bundle();
            bundle.putFloat("motion.progress", this.mProgress);
            bundle.putFloat("motion.velocity", this.mVelocity);
            bundle.putInt("motion.StartState", this.startState);
            bundle.putInt("motion.EndState", this.endState);
            return bundle;
        }

        public void recordState() {
            this.endState = MotionLayout.this.mEndState;
            this.startState = MotionLayout.this.mBeginState;
            this.mVelocity = MotionLayout.this.getVelocity();
            this.mProgress = MotionLayout.this.getProgress();
        }

        public void setEndState(int n) {
            this.endState = n;
        }

        public void setProgress(float f) {
            this.mProgress = f;
        }

        public void setStartState(int n) {
            this.startState = n;
        }

        public void setTransitionState(Bundle bundle) {
            this.mProgress = bundle.getFloat("motion.progress");
            this.mVelocity = bundle.getFloat("motion.velocity");
            this.startState = bundle.getInt("motion.StartState");
            this.endState = bundle.getInt("motion.EndState");
        }

        public void setVelocity(float f) {
            this.mVelocity = f;
        }
    }

    public static interface TransitionListener {
        public void onTransitionChange(MotionLayout var1, int var2, int var3, float var4);

        public void onTransitionCompleted(MotionLayout var1, int var2);

        public void onTransitionStarted(MotionLayout var1, int var2, int var3);

        public void onTransitionTrigger(MotionLayout var1, int var2, boolean var3, float var4);
    }

    static final class TransitionState
    extends Enum<TransitionState> {
        private static final /* synthetic */ TransitionState[] $VALUES;
        public static final /* enum */ TransitionState FINISHED;
        public static final /* enum */ TransitionState MOVING;
        public static final /* enum */ TransitionState SETUP;
        public static final /* enum */ TransitionState UNDEFINED;

        static {
            TransitionState transitionState;
            TransitionState transitionState2;
            TransitionState transitionState3;
            TransitionState transitionState4;
            UNDEFINED = transitionState4 = new TransitionState();
            SETUP = transitionState3 = new TransitionState();
            MOVING = transitionState2 = new TransitionState();
            FINISHED = transitionState = new TransitionState();
            $VALUES = new TransitionState[]{transitionState4, transitionState3, transitionState2, transitionState};
        }

        public static TransitionState valueOf(String string2) {
            return Enum.valueOf(TransitionState.class, string2);
        }

        public static TransitionState[] values() {
            return (TransitionState[])$VALUES.clone();
        }
    }
}

