/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.view.View;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.motion.widget.FloatLayout;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintSet;
import java.util.Arrays;
import java.util.LinkedHashMap;

class MotionPaths
implements Comparable<MotionPaths> {
    static final int CARTESIAN = 0;
    public static final boolean DEBUG = false;
    static final int OFF_HEIGHT = 4;
    static final int OFF_PATH_ROTATE = 5;
    static final int OFF_POSITION = 0;
    static final int OFF_WIDTH = 3;
    static final int OFF_X = 1;
    static final int OFF_Y = 2;
    public static final boolean OLD_WAY = false;
    static final int PERPENDICULAR = 1;
    static final int SCREEN = 2;
    public static final String TAG = "MotionPaths";
    static String[] names = new String[]{"position", "x", "y", "width", "height", "pathRotate"};
    LinkedHashMap<String, ConstraintAttribute> attributes;
    float height;
    int mAnimateCircleAngleTo;
    int mAnimateRelativeTo;
    int mDrawPath = 0;
    Easing mKeyFrameEasing;
    int mMode = 0;
    int mPathMotionArc;
    float mPathRotate = Float.NaN;
    float mProgress = Float.NaN;
    float mRelativeAngle;
    MotionController mRelativeToController = null;
    double[] mTempDelta;
    double[] mTempValue;
    float position;
    float time;
    float width;
    float x;
    float y;

    public MotionPaths() {
        this.mPathMotionArc = Key.UNSET;
        this.mAnimateRelativeTo = Key.UNSET;
        this.mRelativeAngle = Float.NaN;
        this.attributes = new LinkedHashMap();
        this.mTempValue = new double[18];
        this.mTempDelta = new double[18];
    }

    public MotionPaths(int n, int n2, KeyPosition keyPosition, MotionPaths motionPaths, MotionPaths motionPaths2) {
        this.mPathMotionArc = Key.UNSET;
        this.mAnimateRelativeTo = Key.UNSET;
        this.mRelativeAngle = Float.NaN;
        this.attributes = new LinkedHashMap();
        this.mTempValue = new double[18];
        this.mTempDelta = new double[18];
        if (motionPaths.mAnimateRelativeTo != Key.UNSET) {
            this.initPolar(n, n2, keyPosition, motionPaths, motionPaths2);
            return;
        }
        int n3 = keyPosition.mPositionType;
        if (n3 != 1) {
            if (n3 != 2) {
                this.initCartesian(keyPosition, motionPaths, motionPaths2);
                return;
            }
            this.initScreen(n, n2, keyPosition, motionPaths, motionPaths2);
            return;
        }
        this.initPath(keyPosition, motionPaths, motionPaths2);
    }

    private boolean diff(float f, float f2) {
        boolean bl = Float.isNaN(f);
        boolean bl2 = true;
        boolean bl3 = true;
        if (!bl && !Float.isNaN(f2)) {
            if (!(Math.abs(f - f2) > 1.0E-6f)) {
                bl3 = false;
            }
            return bl3;
        }
        bl3 = Float.isNaN(f) != Float.isNaN(f2) ? bl2 : false;
        return bl3;
    }

    private static final float xRotate(float f, float f2, float f3, float f4, float f5, float f6) {
        return (f5 - f3) * f2 - (f6 - f4) * f + f3;
    }

    private static final float yRotate(float f, float f2, float f3, float f4, float f5, float f6) {
        return (f5 - f3) * f + (f6 - f4) * f2 + f4;
    }

    public void applyParameters(ConstraintSet.Constraint constraint) {
        this.mKeyFrameEasing = Easing.getInterpolator(constraint.motion.mTransitionEasing);
        this.mPathMotionArc = constraint.motion.mPathMotionArc;
        this.mAnimateRelativeTo = constraint.motion.mAnimateRelativeTo;
        this.mPathRotate = constraint.motion.mPathRotate;
        this.mDrawPath = constraint.motion.mDrawPath;
        this.mAnimateCircleAngleTo = constraint.motion.mAnimateCircleAngleTo;
        this.mProgress = constraint.propertySet.mProgress;
        this.mRelativeAngle = constraint.layout.circleAngle;
        for (String string2 : constraint.mCustomConstraints.keySet()) {
            ConstraintAttribute constraintAttribute = constraint.mCustomConstraints.get(string2);
            if (constraintAttribute == null || !constraintAttribute.isContinuous()) continue;
            this.attributes.put(string2, constraintAttribute);
        }
    }

    @Override
    public int compareTo(MotionPaths motionPaths) {
        return Float.compare(this.position, motionPaths.position);
    }

    public void configureRelativeTo(MotionController motionController) {
        motionController.getPos(this.mProgress);
    }

    void different(MotionPaths motionPaths, boolean[] blArray, String[] stringArray, boolean bl) {
        boolean bl2 = this.diff(this.x, motionPaths.x);
        boolean bl3 = this.diff(this.y, motionPaths.y);
        blArray[0] = blArray[0] | this.diff(this.position, motionPaths.position);
        boolean bl4 = blArray[1];
        boolean bl5 = bl2 | bl3 | bl;
        blArray[1] = bl4 | bl5;
        blArray[2] = bl5 | blArray[2];
        blArray[3] = blArray[3] | this.diff(this.width, motionPaths.width);
        bl = blArray[4];
        blArray[4] = this.diff(this.height, motionPaths.height) | bl;
    }

    void fillStandard(double[] dArray, int[] nArray) {
        float f = this.position;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.width;
        float f5 = this.height;
        float f6 = this.mPathRotate;
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n;
            if (nArray[i] < 6) {
                n2 = nArray[i];
                dArray[n] = (new float[]{f, f2, f3, f4, f5, f6})[n2];
                n2 = n + 1;
            }
            n = n2;
        }
    }

    void getBounds(int[] nArray, double[] dArray, float[] fArray, int n) {
        float f = this.width;
        float f2 = this.height;
        for (int i = 0; i < nArray.length; ++i) {
            float f3 = (float)dArray[i];
            int n2 = nArray[i];
            if (n2 != 3) {
                if (n2 != 4) continue;
                f2 = f3;
                continue;
            }
            f = f3;
        }
        fArray[n] = f;
        fArray[n + 1] = f2;
    }

    void getCenter(double d, int[] objectArray, double[] object, float[] fArray, int n) {
        float f;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.width;
        float f5 = this.height;
        for (int i = 0; i < objectArray.length; ++i) {
            f = (float)object[i];
            int n2 = objectArray[i];
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) continue;
                        f5 = f;
                        continue;
                    }
                    f4 = f;
                    continue;
                }
                f3 = f;
                continue;
            }
            f2 = f;
        }
        object = this.mRelativeToController;
        float f6 = f2;
        f = f3;
        if (object != null) {
            objectArray = new float[2];
            ((MotionController)object).getCenter(d, (float[])objectArray, new float[2]);
            f6 = objectArray[0];
            f = objectArray[1];
            double d2 = f6;
            double d3 = f2;
            d = f3;
            f6 = (float)(d2 + Math.sin(d) * d3 - (double)(f4 / 2.0f));
            f = (float)((double)f - d3 * Math.cos(d) - (double)(f5 / 2.0f));
        }
        fArray[n] = f6 + f4 / 2.0f + 0.0f;
        fArray[n + 1] = f + f5 / 2.0f + 0.0f;
    }

    void getCenter(double d, int[] objectArray, double[] object, float[] fArray, double[] objectArray2, float[] fArray2) {
        float f;
        float f2;
        float f3 = this.x;
        float f4 = this.y;
        float f5 = this.width;
        float f6 = this.height;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        for (int i = 0; i < objectArray.length; ++i) {
            f2 = (float)object[i];
            f = (float)objectArray2[i];
            int n = objectArray[i];
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) continue;
                        f6 = f2;
                        f10 = f;
                        continue;
                    }
                    f5 = f2;
                    f8 = f;
                    continue;
                }
                f4 = f2;
                f9 = f;
                continue;
            }
            f7 = f;
            f3 = f2;
        }
        f = f8 / 2.0f + f7;
        f2 = f10 / 2.0f + f9;
        object = this.mRelativeToController;
        if (object != null) {
            objectArray = new float[2];
            objectArray2 = new float[2];
            ((MotionController)object).getCenter(d, (float[])objectArray, (float[])objectArray2);
            f8 = objectArray[0];
            f10 = objectArray[1];
            f = (float)objectArray2[0];
            f2 = (float)objectArray2[1];
            double d2 = f8;
            double d3 = f3;
            d = f4;
            f3 = (float)(d2 + Math.sin(d) * d3 - (double)(f5 / 2.0f));
            f4 = (float)((double)f10 - d3 * Math.cos(d) - (double)(f6 / 2.0f));
            double d4 = f;
            d2 = f7;
            double d5 = Math.sin(d);
            double d6 = Math.cos(d);
            d3 = f9;
            f = (float)(d4 + d5 * d2 + d6 * d3);
            f2 = (float)((double)f2 - d2 * Math.cos(d) + Math.sin(d) * d3);
        }
        fArray[0] = f3 + f5 / 2.0f + 0.0f;
        fArray[1] = f4 + f6 / 2.0f + 0.0f;
        fArray2[0] = f;
        fArray2[1] = f2;
    }

    void getCenterVelocity(double d, int[] object, double[] objectArray, float[] fArray, int n) {
        float f;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.width;
        float f5 = this.height;
        for (int i = 0; i < ((int[])object).length; ++i) {
            f = (float)objectArray[i];
            int n2 = object[i];
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 3) {
                        if (n2 != 4) continue;
                        f5 = f;
                        continue;
                    }
                    f4 = f;
                    continue;
                }
                f3 = f;
                continue;
            }
            f2 = f;
        }
        object = this.mRelativeToController;
        float f6 = f2;
        f = f3;
        if (object != null) {
            objectArray = new float[2];
            ((MotionController)object).getCenter(d, (float[])objectArray, new float[2]);
            f6 = (float)objectArray[0];
            f = (float)objectArray[1];
            double d2 = f6;
            double d3 = f2;
            d = f3;
            f6 = (float)(d2 + Math.sin(d) * d3 - (double)(f4 / 2.0f));
            f = (float)((double)f - d3 * Math.cos(d) - (double)(f5 / 2.0f));
        }
        fArray[n] = f6 + f4 / 2.0f + 0.0f;
        fArray[n + 1] = f + f5 / 2.0f + 0.0f;
    }

    int getCustomData(String object, double[] dArray, int n) {
        ConstraintAttribute constraintAttribute = this.attributes.get(object);
        int n2 = 0;
        if (constraintAttribute == null) {
            return 0;
        }
        if (constraintAttribute.numberOfInterpolatedValues() == 1) {
            dArray[n] = constraintAttribute.getValueToInterpolate();
            return 1;
        }
        int n3 = constraintAttribute.numberOfInterpolatedValues();
        object = new float[n3];
        constraintAttribute.getValuesToInterpolate((float[])object);
        while (n2 < n3) {
            dArray[n] = (double)object[n2];
            ++n2;
            ++n;
        }
        return n3;
    }

    int getCustomDataCount(String object) {
        if ((object = this.attributes.get(object)) == null) {
            return 0;
        }
        return ((ConstraintAttribute)object).numberOfInterpolatedValues();
    }

    void getRect(int[] object, double[] dArray, float[] fArray, int n) {
        float f;
        int n2;
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.width;
        float f5 = this.height;
        for (n2 = 0; n2 < ((int[])object).length; ++n2) {
            f = (float)dArray[n2];
            int n3 = object[n2];
            if (n3 != 1) {
                if (n3 != 2) {
                    if (n3 != 3) {
                        if (n3 != 4) continue;
                        f5 = f;
                        continue;
                    }
                    f4 = f;
                    continue;
                }
                f3 = f;
                continue;
            }
            f2 = f;
        }
        object = this.mRelativeToController;
        float f6 = f2;
        f = f3;
        if (object != null) {
            f6 = ((MotionController)object).getCenterX();
            f = this.mRelativeToController.getCenterY();
            double d = f6;
            double d2 = f2;
            double d3 = f3;
            f6 = (float)(d + Math.sin(d3) * d2 - (double)(f4 / 2.0f));
            f = (float)((double)f - d2 * Math.cos(d3) - (double)(f5 / 2.0f));
        }
        f3 = f4 + f6;
        f2 = f5 + f;
        Float.isNaN(Float.NaN);
        Float.isNaN(Float.NaN);
        n2 = n + 1;
        fArray[n] = f6 + 0.0f;
        n = n2 + 1;
        fArray[n2] = f + 0.0f;
        n2 = n + 1;
        fArray[n] = f3 + 0.0f;
        n = n2 + 1;
        fArray[n2] = f + 0.0f;
        n2 = n + 1;
        fArray[n] = f3 + 0.0f;
        n = n2 + 1;
        fArray[n2] = f2 + 0.0f;
        fArray[n] = f6 + 0.0f;
        fArray[n + 1] = f2 + 0.0f;
    }

    boolean hasCustomData(String string2) {
        return this.attributes.containsKey(string2);
    }

    void initCartesian(KeyPosition keyPosition, MotionPaths motionPaths, MotionPaths motionPaths2) {
        float f;
        this.time = f = (float)keyPosition.mFramePosition / 100.0f;
        this.mDrawPath = keyPosition.mDrawPath;
        float f2 = Float.isNaN(keyPosition.mPercentWidth) ? f : keyPosition.mPercentWidth;
        float f3 = Float.isNaN(keyPosition.mPercentHeight) ? f : keyPosition.mPercentHeight;
        float f4 = motionPaths2.width;
        float f5 = motionPaths.width;
        float f6 = motionPaths2.height;
        float f7 = motionPaths.height;
        this.position = this.time;
        float f8 = motionPaths.x;
        float f9 = f5 / 2.0f;
        float f10 = motionPaths.y;
        float f11 = f7 / 2.0f;
        float f12 = motionPaths2.x;
        float f13 = f4 / 2.0f;
        float f14 = motionPaths2.y;
        float f15 = f6 / 2.0f;
        f13 = f12 + f13 - (f9 + f8);
        f11 = f14 + f15 - (f10 + f11);
        f2 = (f4 - f5) * f2;
        f4 = f2 / 2.0f;
        this.x = (int)(f8 + f13 * f - f4);
        f3 = (f6 - f7) * f3;
        f8 = f3 / 2.0f;
        this.y = (int)(f10 + f11 * f - f8);
        this.width = (int)(f5 + f2);
        this.height = (int)(f7 + f3);
        f3 = Float.isNaN(keyPosition.mPercentX) ? f : keyPosition.mPercentX;
        boolean bl = Float.isNaN(keyPosition.mAltPercentY);
        f10 = 0.0f;
        f2 = bl ? 0.0f : keyPosition.mAltPercentY;
        if (!Float.isNaN(keyPosition.mPercentY)) {
            f = keyPosition.mPercentY;
        }
        if (!Float.isNaN(keyPosition.mAltPercentX)) {
            f10 = keyPosition.mAltPercentX;
        }
        this.mMode = 0;
        this.x = (int)(motionPaths.x + f3 * f13 + f10 * f11 - f4);
        this.y = (int)(motionPaths.y + f13 * f2 + f11 * f - f8);
        this.mKeyFrameEasing = Easing.getInterpolator(keyPosition.mTransitionEasing);
        this.mPathMotionArc = keyPosition.mPathMotionArc;
    }

    void initPath(KeyPosition keyPosition, MotionPaths motionPaths, MotionPaths motionPaths2) {
        float f;
        this.time = f = (float)keyPosition.mFramePosition / 100.0f;
        this.mDrawPath = keyPosition.mDrawPath;
        float f2 = Float.isNaN(keyPosition.mPercentWidth) ? f : keyPosition.mPercentWidth;
        float f3 = Float.isNaN(keyPosition.mPercentHeight) ? f : keyPosition.mPercentHeight;
        float f4 = motionPaths2.width;
        float f5 = motionPaths.width;
        float f6 = motionPaths2.height;
        float f7 = motionPaths.height;
        this.position = this.time;
        if (!Float.isNaN(keyPosition.mPercentX)) {
            f = keyPosition.mPercentX;
        }
        float f8 = motionPaths.x;
        float f9 = motionPaths.width;
        float f10 = f9 / 2.0f;
        float f11 = motionPaths.y;
        float f12 = motionPaths.height;
        float f13 = f12 / 2.0f;
        float f14 = motionPaths2.x;
        float f15 = motionPaths2.width / 2.0f;
        float f16 = motionPaths2.y;
        float f17 = motionPaths2.height / 2.0f;
        f15 = f14 + f15 - (f10 + f8);
        f13 = f16 + f17 - (f13 + f11);
        f17 = f15 * f;
        f5 = (f4 - f5) * f2;
        f2 = f5 / 2.0f;
        this.x = (int)(f8 + f17 - f2);
        f4 = f * f13;
        f = (f6 - f7) * f3;
        f3 = f / 2.0f;
        this.y = (int)(f11 + f4 - f3);
        this.width = (int)(f9 + f5);
        this.height = (int)(f12 + f);
        f = Float.isNaN(keyPosition.mPercentY) ? 0.0f : keyPosition.mPercentY;
        f7 = -f13;
        this.mMode = 1;
        this.x = f2 = (float)((int)(motionPaths.x + f17 - f2));
        this.y = f3 = (float)((int)(motionPaths.y + f4 - f3));
        this.x = f2 + f7 * f;
        this.y = f3 + f15 * f;
        this.mAnimateRelativeTo = this.mAnimateRelativeTo;
        this.mKeyFrameEasing = Easing.getInterpolator(keyPosition.mTransitionEasing);
        this.mPathMotionArc = keyPosition.mPathMotionArc;
    }

    void initPolar(int n, int n2, KeyPosition keyPosition, MotionPaths motionPaths, MotionPaths motionPaths2) {
        float f;
        this.time = f = (float)keyPosition.mFramePosition / 100.0f;
        this.mDrawPath = keyPosition.mDrawPath;
        this.mMode = keyPosition.mPositionType;
        float f2 = Float.isNaN(keyPosition.mPercentWidth) ? f : keyPosition.mPercentWidth;
        float f3 = Float.isNaN(keyPosition.mPercentHeight) ? f : keyPosition.mPercentHeight;
        float f4 = motionPaths2.width;
        float f5 = motionPaths.width;
        float f6 = motionPaths2.height;
        float f7 = motionPaths.height;
        this.position = this.time;
        this.width = (int)(f5 + (f4 - f5) * f2);
        this.height = (int)(f7 + (f6 - f7) * f3);
        n = keyPosition.mPositionType;
        if (n != 1) {
            if (n != 2) {
                f2 = Float.isNaN(keyPosition.mPercentX) ? f : keyPosition.mPercentX;
                f3 = motionPaths2.x;
                f7 = motionPaths.x;
                this.x = f2 * (f3 - f7) + f7;
                if (!Float.isNaN(keyPosition.mPercentY)) {
                    f = keyPosition.mPercentY;
                }
                f3 = motionPaths2.y;
                f2 = motionPaths.y;
                this.y = f * (f3 - f2) + f2;
            } else {
                if (Float.isNaN(keyPosition.mPercentX)) {
                    f3 = motionPaths2.x;
                    f2 = motionPaths.x;
                    f2 = (f3 - f2) * f + f2;
                } else {
                    f7 = keyPosition.mPercentX;
                    f2 = Math.min(f3, f2) * f7;
                }
                this.x = f2;
                if (Float.isNaN(keyPosition.mPercentY)) {
                    f3 = motionPaths2.y;
                    f2 = motionPaths.y;
                    f = f * (f3 - f2) + f2;
                } else {
                    f = keyPosition.mPercentY;
                }
                this.y = f;
            }
        } else {
            f2 = Float.isNaN(keyPosition.mPercentX) ? f : keyPosition.mPercentX;
            f3 = motionPaths2.x;
            f7 = motionPaths.x;
            this.x = f2 * (f3 - f7) + f7;
            if (!Float.isNaN(keyPosition.mPercentY)) {
                f = keyPosition.mPercentY;
            }
            f3 = motionPaths2.y;
            f2 = motionPaths.y;
            this.y = f * (f3 - f2) + f2;
        }
        this.mAnimateRelativeTo = motionPaths.mAnimateRelativeTo;
        this.mKeyFrameEasing = Easing.getInterpolator(keyPosition.mTransitionEasing);
        this.mPathMotionArc = keyPosition.mPathMotionArc;
    }

    void initScreen(int n, int n2, KeyPosition keyPosition, MotionPaths motionPaths, MotionPaths motionPaths2) {
        float f;
        this.time = f = (float)keyPosition.mFramePosition / 100.0f;
        this.mDrawPath = keyPosition.mDrawPath;
        float f2 = Float.isNaN(keyPosition.mPercentWidth) ? f : keyPosition.mPercentWidth;
        float f3 = Float.isNaN(keyPosition.mPercentHeight) ? f : keyPosition.mPercentHeight;
        float f4 = motionPaths2.width;
        float f5 = motionPaths.width;
        float f6 = motionPaths2.height;
        float f7 = motionPaths.height;
        this.position = this.time;
        float f8 = motionPaths.x;
        float f9 = f5 / 2.0f;
        float f10 = motionPaths.y;
        float f11 = f7 / 2.0f;
        float f12 = motionPaths2.x;
        float f13 = f4 / 2.0f;
        float f14 = motionPaths2.y;
        float f15 = f6 / 2.0f;
        f2 = (f4 - f5) * f2;
        this.x = (int)(f8 + (f12 + f13 - (f9 + f8)) * f - f2 / 2.0f);
        f3 = (f6 - f7) * f3;
        this.y = (int)(f10 + (f14 + f15 - (f10 + f11)) * f - f3 / 2.0f);
        this.width = (int)(f5 + f2);
        this.height = (int)(f7 + f3);
        this.mMode = 2;
        if (!Float.isNaN(keyPosition.mPercentX)) {
            n = (int)((float)n - this.width);
            this.x = (int)(keyPosition.mPercentX * (float)n);
        }
        if (!Float.isNaN(keyPosition.mPercentY)) {
            n = (int)((float)n2 - this.height);
            this.y = (int)(keyPosition.mPercentY * (float)n);
        }
        this.mAnimateRelativeTo = this.mAnimateRelativeTo;
        this.mKeyFrameEasing = Easing.getInterpolator(keyPosition.mTransitionEasing);
        this.mPathMotionArc = keyPosition.mPathMotionArc;
    }

    void setBounds(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.width = f3;
        this.height = f4;
    }

    void setDpDt(float f, float f2, float[] fArray, int[] nArray, double[] dArray, double[] dArray2) {
        float f3;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int i = 0; i < nArray.length; ++i) {
            f3 = (float)dArray[i];
            double d = dArray2[i];
            int n = nArray[i];
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        if (n != 4) continue;
                        f7 = f3;
                        continue;
                    }
                    f5 = f3;
                    continue;
                }
                f6 = f3;
                continue;
            }
            f4 = f3;
        }
        f3 = f4 - 0.0f * f5 / 2.0f;
        fArray[0] = f3 * (1.0f - f) + (f5 * 1.0f + f3) * f + 0.0f;
        fArray[1] = (f6 -= 0.0f * f7 / 2.0f) * (1.0f - f2) + (f7 * 1.0f + f6) * f2 + 0.0f;
    }

    void setView(float f, View view, int[] objectArray, double[] object, double[] dArray, double[] objectArray2, boolean bl) {
        float f2;
        float f3;
        float f4;
        double d;
        int n;
        float f5 = this.x;
        float f6 = this.y;
        float f7 = this.width;
        float f8 = this.height;
        if (objectArray.length != 0 && this.mTempValue.length <= objectArray[objectArray.length - 1]) {
            n = objectArray[objectArray.length - 1] + 1;
            this.mTempValue = new double[n];
            this.mTempDelta = new double[n];
        }
        Arrays.fill(this.mTempValue, Double.NaN);
        for (n = 0; n < objectArray.length; ++n) {
            this.mTempValue[objectArray[n]] = object[n];
            this.mTempDelta[objectArray[n]] = dArray[n];
        }
        float f9 = Float.NaN;
        float f10 = 0.0f;
        float f11 = 0.0f;
        float f12 = 0.0f;
        float f13 = 0.0f;
        for (n = 0; n < (objectArray = (Object[])this.mTempValue).length; ++n) {
            block20: {
                block16: {
                    block17: {
                        block18: {
                            block19: {
                                block15: {
                                    boolean bl2 = Double.isNaN(objectArray[n]);
                                    d = 0.0;
                                    if (bl2 && (objectArray2 == null || objectArray2[n] == 0.0)) break block15;
                                    if (objectArray2 != null) {
                                        d = objectArray2[n];
                                    }
                                    if (!Double.isNaN(this.mTempValue[n])) {
                                        d = this.mTempValue[n] + d;
                                    }
                                    f4 = f9;
                                    f3 = (float)d;
                                    f2 = (float)this.mTempDelta[n];
                                    if (n == 1) break block16;
                                    if (n == 2) break block17;
                                    if (n == 3) break block18;
                                    if (n == 4) break block19;
                                    if (n == 5) break block20;
                                }
                                f3 = f9;
                                break block20;
                            }
                            f8 = f3;
                            f3 = f4;
                            f13 = f2;
                            break block20;
                        }
                        f7 = f3;
                        f3 = f4;
                        f12 = f2;
                        break block20;
                    }
                    f6 = f3;
                    f3 = f4;
                    f11 = f2;
                    break block20;
                }
                f5 = f3;
                f10 = f2;
                f3 = f4;
            }
            f9 = f3;
        }
        object = this.mRelativeToController;
        if (object != null) {
            objectArray2 = new float[2];
            objectArray = new float[2];
            ((MotionController)object).getCenter(f, (float[])objectArray2, (float[])objectArray);
            f = (float)objectArray2[0];
            f3 = (float)objectArray2[1];
            f2 = objectArray[0];
            f4 = objectArray[1];
            double d2 = f;
            double d3 = f5;
            d = f6;
            f = (float)(d2 + Math.sin(d) * d3 - (double)(f7 / 2.0f));
            f3 = (float)((double)f3 - Math.cos(d) * d3 - (double)(f8 / 2.0f));
            d2 = f2;
            double d4 = f10;
            double d5 = Math.sin(d);
            double d6 = Math.cos(d);
            double d7 = f11;
            f2 = (float)(d2 + d5 * d4 + d6 * d3 * d7);
            f4 = (float)((double)f4 - d4 * Math.cos(d) + d3 * Math.sin(d) * d7);
            if (dArray.length >= 2) {
                dArray[0] = f2;
                dArray[1] = f4;
            }
            if (!Float.isNaN(f9)) {
                view.setRotation((float)((double)f9 + Math.toDegrees(Math.atan2(f4, f2))));
            }
        } else {
            f = f5;
            f3 = f6;
            if (!Float.isNaN(f9)) {
                f = f12 / 2.0f;
                f3 = f13 / 2.0f;
                view.setRotation((float)((double)0.0f + ((double)f9 + Math.toDegrees(Math.atan2(f11 + f3, f10 + f)))));
                f3 = f6;
                f = f5;
            }
        }
        n = 0;
        if (view instanceof FloatLayout) {
            ((FloatLayout)view).layout(f, f3, f7 + f, f3 + f8);
            return;
        }
        int n2 = (int)(f += 0.5f);
        int n3 = (int)(f3 += 0.5f);
        int n4 = (int)(f + f7);
        int n5 = (int)(f3 + f8);
        int n6 = n4 - n2;
        int n7 = n5 - n3;
        if (n6 != view.getMeasuredWidth() || n7 != view.getMeasuredHeight()) {
            n = 1;
        }
        if (n != 0 || bl) {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n7, (int)0x40000000));
        }
        view.layout(n2, n3, n4, n5);
    }

    public void setupRelative(MotionController motionController, MotionPaths motionPaths) {
        double d = this.x + this.width / 2.0f - motionPaths.x - motionPaths.width / 2.0f;
        double d2 = this.y + this.height / 2.0f - motionPaths.y - motionPaths.height / 2.0f;
        this.mRelativeToController = motionController;
        this.x = (float)Math.hypot(d2, d);
        this.y = Float.isNaN(this.mRelativeAngle) ? (float)(Math.atan2(d2, d) + 1.5707963267948966) : (float)Math.toRadians(this.mRelativeAngle);
    }
}

