/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.motion.widget.OnSwipe;
import androidx.constraintlayout.widget.R;
import androidx.core.widget.NestedScrollView;
import org.xmlpull.v1.XmlPullParser;

class TouchResponse {
    public static final int COMPLETE_MODE_CONTINUOUS_VELOCITY = 0;
    public static final int COMPLETE_MODE_SPRING = 1;
    private static final boolean DEBUG = false;
    private static final float EPSILON = 1.0E-7f;
    static final int FLAG_DISABLE_POST_SCROLL = 1;
    static final int FLAG_DISABLE_SCROLL = 2;
    static final int FLAG_SUPPORT_SCROLL_UP = 4;
    private static final int SEC_TO_MILLISECONDS = 1000;
    private static final int SIDE_BOTTOM = 3;
    private static final int SIDE_END = 6;
    private static final int SIDE_LEFT = 1;
    private static final int SIDE_MIDDLE = 4;
    private static final int SIDE_RIGHT = 2;
    private static final int SIDE_START = 5;
    private static final int SIDE_TOP = 0;
    private static final String TAG = "TouchResponse";
    private static final float[][] TOUCH_DIRECTION;
    private static final int TOUCH_DOWN = 1;
    private static final int TOUCH_END = 5;
    private static final int TOUCH_LEFT = 2;
    private static final int TOUCH_RIGHT = 3;
    private static final float[][] TOUCH_SIDES;
    private static final int TOUCH_START = 4;
    private static final int TOUCH_UP = 0;
    private float[] mAnchorDpDt = new float[2];
    private int mAutoCompleteMode = 0;
    private float mDragScale = 1.0f;
    private boolean mDragStarted = false;
    private float mDragThreshold = 10.0f;
    private int mFlags = 0;
    boolean mIsRotateMode = false;
    private float mLastTouchX;
    private float mLastTouchY;
    private int mLimitBoundsTo = -1;
    private float mMaxAcceleration = 1.2f;
    private float mMaxVelocity = 4.0f;
    private final MotionLayout mMotionLayout;
    private boolean mMoveWhenScrollAtTop = true;
    private int mOnTouchUp = 0;
    float mRotateCenterX = 0.5f;
    float mRotateCenterY = 0.5f;
    private int mRotationCenterId = -1;
    private int mSpringBoundary = 0;
    private float mSpringDamping = 10.0f;
    private float mSpringMass = 1.0f;
    private float mSpringStiffness;
    private float mSpringStopThreshold;
    private int[] mTempLoc = new int[2];
    private int mTouchAnchorId = -1;
    private int mTouchAnchorSide = 0;
    private float mTouchAnchorX = 0.5f;
    private float mTouchAnchorY = 0.5f;
    private float mTouchDirectionX = 0.0f;
    private float mTouchDirectionY = 1.0f;
    private int mTouchRegionId = -1;
    private int mTouchSide = 0;

    static {
        float[] fArray = new float[]{1.0f, 0.5f};
        TOUCH_SIDES = new float[][]{{0.5f, 0.0f}, {0.0f, 0.5f}, {1.0f, 0.5f}, {0.5f, 1.0f}, {0.5f, 0.5f}, {0.0f, 0.5f}, fArray};
        fArray = new float[]{1.0f, 0.0f};
        TOUCH_DIRECTION = new float[][]{{0.0f, -1.0f}, {0.0f, 1.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}, {-1.0f, 0.0f}, fArray};
    }

    TouchResponse(Context context, MotionLayout motionLayout, XmlPullParser xmlPullParser) {
        this.mSpringStiffness = Float.NaN;
        this.mSpringStopThreshold = Float.NaN;
        this.mMotionLayout = motionLayout;
        this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)xmlPullParser));
    }

    public TouchResponse(MotionLayout object, OnSwipe onSwipe) {
        int n;
        this.mSpringStiffness = Float.NaN;
        this.mSpringStopThreshold = Float.NaN;
        this.mMotionLayout = object;
        this.mTouchAnchorId = onSwipe.getTouchAnchorId();
        this.mTouchAnchorSide = n = onSwipe.getTouchAnchorSide();
        if (n != -1) {
            object = TOUCH_SIDES;
            this.mTouchAnchorX = (float)object[n][0];
            this.mTouchAnchorY = (float)object[n][1];
        }
        this.mTouchSide = n = onSwipe.getDragDirection();
        object = TOUCH_DIRECTION;
        if (n < ((Object)object).length) {
            this.mTouchDirectionX = (float)object[n][0];
            this.mTouchDirectionY = (float)object[n][1];
        } else {
            this.mTouchDirectionY = Float.NaN;
            this.mTouchDirectionX = Float.NaN;
            this.mIsRotateMode = true;
        }
        this.mMaxVelocity = onSwipe.getMaxVelocity();
        this.mMaxAcceleration = onSwipe.getMaxAcceleration();
        this.mMoveWhenScrollAtTop = onSwipe.getMoveWhenScrollAtTop();
        this.mDragScale = onSwipe.getDragScale();
        this.mDragThreshold = onSwipe.getDragThreshold();
        this.mTouchRegionId = onSwipe.getTouchRegionId();
        this.mOnTouchUp = onSwipe.getOnTouchUp();
        this.mFlags = onSwipe.getNestedScrollFlags();
        this.mLimitBoundsTo = onSwipe.getLimitBoundsTo();
        this.mRotationCenterId = onSwipe.getRotationCenterId();
        this.mSpringBoundary = onSwipe.getSpringBoundary();
        this.mSpringDamping = onSwipe.getSpringDamping();
        this.mSpringMass = onSwipe.getSpringMass();
        this.mSpringStiffness = onSwipe.getSpringStiffness();
        this.mSpringStopThreshold = onSwipe.getSpringStopThreshold();
        this.mAutoCompleteMode = onSwipe.getAutoCompleteMode();
    }

    private void fill(TypedArray typedArray) {
        int n = typedArray.getIndexCount();
        for (int i = 0; i < n; ++i) {
            float[][] fArray;
            int n2 = typedArray.getIndex(i);
            if (n2 == R.styleable.OnSwipe_touchAnchorId) {
                this.mTouchAnchorId = typedArray.getResourceId(n2, this.mTouchAnchorId);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_touchAnchorSide) {
                this.mTouchAnchorSide = n2 = typedArray.getInt(n2, this.mTouchAnchorSide);
                fArray = TOUCH_SIDES;
                this.mTouchAnchorX = fArray[n2][0];
                this.mTouchAnchorY = fArray[n2][1];
                continue;
            }
            if (n2 == R.styleable.OnSwipe_dragDirection) {
                this.mTouchSide = n2 = typedArray.getInt(n2, this.mTouchSide);
                fArray = TOUCH_DIRECTION;
                if (n2 < fArray.length) {
                    this.mTouchDirectionX = fArray[n2][0];
                    this.mTouchDirectionY = fArray[n2][1];
                    continue;
                }
                this.mTouchDirectionY = Float.NaN;
                this.mTouchDirectionX = Float.NaN;
                this.mIsRotateMode = true;
                continue;
            }
            if (n2 == R.styleable.OnSwipe_maxVelocity) {
                this.mMaxVelocity = typedArray.getFloat(n2, this.mMaxVelocity);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_maxAcceleration) {
                this.mMaxAcceleration = typedArray.getFloat(n2, this.mMaxAcceleration);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_moveWhenScrollAtTop) {
                this.mMoveWhenScrollAtTop = typedArray.getBoolean(n2, this.mMoveWhenScrollAtTop);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_dragScale) {
                this.mDragScale = typedArray.getFloat(n2, this.mDragScale);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_dragThreshold) {
                this.mDragThreshold = typedArray.getFloat(n2, this.mDragThreshold);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_touchRegionId) {
                this.mTouchRegionId = typedArray.getResourceId(n2, this.mTouchRegionId);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_onTouchUp) {
                this.mOnTouchUp = typedArray.getInt(n2, this.mOnTouchUp);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_nestedScrollFlags) {
                this.mFlags = typedArray.getInteger(n2, 0);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_limitBoundsTo) {
                this.mLimitBoundsTo = typedArray.getResourceId(n2, 0);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_rotationCenterId) {
                this.mRotationCenterId = typedArray.getResourceId(n2, this.mRotationCenterId);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_springDamping) {
                this.mSpringDamping = typedArray.getFloat(n2, this.mSpringDamping);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_springMass) {
                this.mSpringMass = typedArray.getFloat(n2, this.mSpringMass);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_springStiffness) {
                this.mSpringStiffness = typedArray.getFloat(n2, this.mSpringStiffness);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_springStopThreshold) {
                this.mSpringStopThreshold = typedArray.getFloat(n2, this.mSpringStopThreshold);
                continue;
            }
            if (n2 == R.styleable.OnSwipe_springBoundary) {
                this.mSpringBoundary = typedArray.getInt(n2, this.mSpringBoundary);
                continue;
            }
            if (n2 != R.styleable.OnSwipe_autoCompleteMode) continue;
            this.mAutoCompleteMode = typedArray.getInt(n2, this.mAutoCompleteMode);
        }
    }

    private void fillFromAttributeList(Context context, AttributeSet attributeSet) {
        context = context.obtainStyledAttributes(attributeSet, R.styleable.OnSwipe);
        this.fill((TypedArray)context);
        context.recycle();
    }

    float dot(float f, float f2) {
        return f * this.mTouchDirectionX + f2 * this.mTouchDirectionY;
    }

    public int getAnchorId() {
        return this.mTouchAnchorId;
    }

    public int getAutoCompleteMode() {
        return this.mAutoCompleteMode;
    }

    public int getFlags() {
        return this.mFlags;
    }

    RectF getLimitBoundsTo(ViewGroup viewGroup, RectF rectF) {
        int n = this.mLimitBoundsTo;
        if (n == -1) {
            return null;
        }
        if ((viewGroup = viewGroup.findViewById(n)) == null) {
            return null;
        }
        rectF.set((float)viewGroup.getLeft(), (float)viewGroup.getTop(), (float)viewGroup.getRight(), (float)viewGroup.getBottom());
        return rectF;
    }

    int getLimitBoundsToId() {
        return this.mLimitBoundsTo;
    }

    float getMaxAcceleration() {
        return this.mMaxAcceleration;
    }

    public float getMaxVelocity() {
        return this.mMaxVelocity;
    }

    boolean getMoveWhenScrollAtTop() {
        return this.mMoveWhenScrollAtTop;
    }

    float getProgressDirection(float f, float f2) {
        float f3 = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, f3, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        f3 = this.mTouchDirectionX;
        if (f3 != 0.0f) {
            float[] fArray = this.mAnchorDpDt;
            if (fArray[0] == 0.0f) {
                fArray[0] = 1.0E-7f;
            }
            f = f * f3 / fArray[0];
        } else {
            float[] fArray = this.mAnchorDpDt;
            if (fArray[1] == 0.0f) {
                fArray[1] = 1.0E-7f;
            }
            f = f2 * this.mTouchDirectionY / fArray[1];
        }
        return f;
    }

    public int getSpringBoundary() {
        return this.mSpringBoundary;
    }

    public float getSpringDamping() {
        return this.mSpringDamping;
    }

    public float getSpringMass() {
        return this.mSpringMass;
    }

    public float getSpringStiffness() {
        return this.mSpringStiffness;
    }

    public float getSpringStopThreshold() {
        return this.mSpringStopThreshold;
    }

    RectF getTouchRegion(ViewGroup viewGroup, RectF rectF) {
        int n = this.mTouchRegionId;
        if (n == -1) {
            return null;
        }
        if ((viewGroup = viewGroup.findViewById(n)) == null) {
            return null;
        }
        rectF.set((float)viewGroup.getLeft(), (float)viewGroup.getTop(), (float)viewGroup.getRight(), (float)viewGroup.getBottom());
        return rectF;
    }

    int getTouchRegionId() {
        return this.mTouchRegionId;
    }

    boolean isDragStarted() {
        return this.mDragStarted;
    }

    void processTouchEvent(MotionEvent object, MotionLayout.MotionTracker motionTracker, int n, MotionScene object2) {
        if (this.mIsRotateMode) {
            this.processTouchRotateEvent((MotionEvent)object, motionTracker, n, (MotionScene)object2);
            return;
        }
        motionTracker.addMovement((MotionEvent)object);
        n = object.getAction();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    float f = object.getRawY() - this.mLastTouchY;
                    float f2 = object.getRawX() - this.mLastTouchX;
                    if (Math.abs(this.mTouchDirectionX * f2 + this.mTouchDirectionY * f) > this.mDragThreshold || this.mDragStarted) {
                        float f3;
                        float f4 = this.mMotionLayout.getProgress();
                        if (!this.mDragStarted) {
                            this.mDragStarted = true;
                            this.mMotionLayout.setProgress(f4);
                        }
                        if ((n = this.mTouchAnchorId) != -1) {
                            this.mMotionLayout.getAnchorDpDt(n, f4, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                        } else {
                            f3 = Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight());
                            object2 = this.mAnchorDpDt;
                            object2[1] = this.mTouchDirectionY * f3;
                            object2[0] = f3 * this.mTouchDirectionX;
                        }
                        f3 = this.mTouchDirectionX;
                        object2 = this.mAnchorDpDt;
                        if ((double)Math.abs((f3 * object2[0] + this.mTouchDirectionY * object2[1]) * this.mDragScale) < 0.01) {
                            object2 = this.mAnchorDpDt;
                            object2[0] = 0.01f;
                            object2[1] = 0.01f;
                        }
                        f2 = this.mTouchDirectionX != 0.0f ? (f2 /= this.mAnchorDpDt[0]) : f / this.mAnchorDpDt[1];
                        f2 = f4 = Math.max(Math.min(f4 + f2, 1.0f), 0.0f);
                        if (this.mOnTouchUp == 6) {
                            f2 = Math.max(f4, 0.01f);
                        }
                        f4 = f2;
                        if (this.mOnTouchUp == 7) {
                            f4 = Math.min(f2, 0.99f);
                        }
                        if (f4 != (f2 = this.mMotionLayout.getProgress())) {
                            float f5 = f2 - 0.0f;
                            n = f5 == 0.0f ? 0 : (f5 > 0.0f ? 1 : -1);
                            if (n == 0 || f2 == 1.0f) {
                                object2 = this.mMotionLayout;
                                boolean bl = n == 0;
                                ((MotionLayout)object2).endTrigger(bl);
                            }
                            this.mMotionLayout.setProgress(f4);
                            motionTracker.computeCurrentVelocity(1000);
                            f2 = motionTracker.getXVelocity();
                            f4 = motionTracker.getYVelocity();
                            f2 = this.mTouchDirectionX != 0.0f ? (f2 /= this.mAnchorDpDt[0]) : f4 / this.mAnchorDpDt[1];
                            this.mMotionLayout.mLastVelocity = f2;
                        } else {
                            this.mMotionLayout.mLastVelocity = 0.0f;
                        }
                        this.mLastTouchX = object.getRawX();
                        this.mLastTouchY = object.getRawY();
                    }
                }
            } else {
                float f;
                this.mDragStarted = false;
                motionTracker.computeCurrentVelocity(1000);
                float f6 = motionTracker.getXVelocity();
                float f7 = motionTracker.getYVelocity();
                float f8 = this.mMotionLayout.getProgress();
                n = this.mTouchAnchorId;
                if (n != -1) {
                    this.mMotionLayout.getAnchorDpDt(n, f8, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    f = Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight());
                    object = this.mAnchorDpDt;
                    object[1] = (MotionEvent)(this.mTouchDirectionY * f);
                    object[0] = (MotionEvent)(f * this.mTouchDirectionX);
                }
                f = this.mTouchDirectionX;
                object = this.mAnchorDpDt;
                MotionEvent motionEvent = object[0];
                motionEvent = object[1];
                f7 = f != 0.0f ? f6 / object[0] : (f7 /= object[1]);
                f6 = !Float.isNaN(f7) ? f7 / 3.0f + f8 : f8;
                if (f6 != 0.0f && f6 != 1.0f && (n = this.mOnTouchUp) != 3) {
                    f = (double)f6 < 0.5 ? 0.0f : 1.0f;
                    f6 = f7;
                    if (n == 6) {
                        f6 = f7;
                        if (f8 + f7 < 0.0f) {
                            f6 = Math.abs(f7);
                        }
                        f = 1.0f;
                    }
                    f7 = f6;
                    if (this.mOnTouchUp == 7) {
                        f7 = f6;
                        if (f8 + f6 > 1.0f) {
                            f7 = -Math.abs(f6);
                        }
                        f = 0.0f;
                    }
                    this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, f, f7);
                    if (0.0f >= f8 || 1.0f <= f8) {
                        this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
                    }
                } else if (0.0f >= f6 || 1.0f <= f6) {
                    this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
                }
            }
        } else {
            this.mLastTouchX = object.getRawX();
            this.mLastTouchY = object.getRawY();
            this.mDragStarted = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void processTouchRotateEvent(MotionEvent object, MotionLayout.MotionTracker object2, int n, MotionScene object3) {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        int n2;
        block33: {
            int n3;
            block32: {
                Object object4;
                block31: {
                    object4.addMovement((MotionEvent)object);
                    n2 = object.getAction();
                    boolean bl = false;
                    if (n2 == 0) {
                        this.mLastTouchX = object.getRawX();
                        this.mLastTouchY = object.getRawY();
                        this.mDragStarted = false;
                        return;
                    }
                    if (n2 != 1) {
                        float f6;
                        float f7;
                        Object object5;
                        if (n2 != 2) {
                            return;
                        }
                        object.getRawY();
                        object.getRawX();
                        float f8 = (float)this.mMotionLayout.getWidth() / 2.0f;
                        float f9 = (float)this.mMotionLayout.getHeight() / 2.0f;
                        n2 = this.mRotationCenterId;
                        if (n2 != -1) {
                            object5 = this.mMotionLayout.findViewById(n2);
                            this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                            f7 = this.mTempLoc[0];
                            f8 = (float)(object5.getLeft() + object5.getRight()) / 2.0f;
                            f6 = this.mTempLoc[1];
                            f6 = (float)(object5.getTop() + object5.getBottom()) / 2.0f + f6;
                            f7 += f8;
                        } else {
                            n2 = this.mTouchAnchorId;
                            f7 = f8;
                            f6 = f9;
                            if (n2 != -1) {
                                object5 = this.mMotionLayout.getMotionController(n2);
                                if ((object5 = this.mMotionLayout.findViewById(((MotionController)object5).getAnimateRelativeTo())) == null) {
                                    Log.e((String)TAG, (String)"could not find view to animate to");
                                    f7 = f8;
                                    f6 = f9;
                                } else {
                                    this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                                    f7 = (float)this.mTempLoc[0] + (float)(object5.getLeft() + object5.getRight()) / 2.0f;
                                    f6 = (float)this.mTempLoc[1] + (float)(object5.getTop() + object5.getBottom()) / 2.0f;
                                }
                            }
                        }
                        float f10 = object.getRawX();
                        float f11 = object.getRawY();
                        double d = Math.atan2(object.getRawY() - f6, object.getRawX() - f7);
                        f9 = (float)((d - Math.atan2(this.mLastTouchY - f6, this.mLastTouchX - f7)) * 180.0 / Math.PI);
                        if (f9 > 330.0f) {
                            f8 = f9 - 360.0f;
                        } else {
                            f8 = f9;
                            if (f9 < -330.0f) {
                                f8 = f9 + 360.0f;
                            }
                        }
                        if (!((double)Math.abs(f8) > 0.01)) {
                            if (!this.mDragStarted) return;
                        }
                        f9 = this.mMotionLayout.getProgress();
                        if (!this.mDragStarted) {
                            this.mDragStarted = true;
                            this.mMotionLayout.setProgress(f9);
                        }
                        if ((n2 = this.mTouchAnchorId) != -1) {
                            this.mMotionLayout.getAnchorDpDt(n2, f9, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                            object5 = this.mAnchorDpDt;
                            object5[1] = (View)((float)Math.toDegrees((double)object5[1]));
                        } else {
                            this.mAnchorDpDt[1] = 360.0f;
                        }
                        f8 = Math.max(Math.min(f9 + f8 * this.mDragScale / this.mAnchorDpDt[1], 1.0f), 0.0f);
                        f9 = this.mMotionLayout.getProgress();
                        if (f8 != f9) {
                            float f12 = f9 - 0.0f;
                            n2 = f12 == 0.0f ? 0 : (f12 > 0.0f ? 1 : -1);
                            if (n2 == 0 || f9 == 1.0f) {
                                object5 = this.mMotionLayout;
                                if (n2 == 0) {
                                    bl = true;
                                }
                                ((MotionLayout)object5).endTrigger(bl);
                            }
                            this.mMotionLayout.setProgress(f8);
                            object4.computeCurrentVelocity(1000);
                            f8 = object4.getXVelocity();
                            double d2 = object4.getYVelocity();
                            double d3 = f8;
                            f6 = (float)(Math.hypot(d2, d3) * Math.sin(Math.atan2(d2, d3) - d) / Math.hypot(f10 - f7, f11 - f6));
                            this.mMotionLayout.mLastVelocity = (float)Math.toDegrees(f6);
                        } else {
                            this.mMotionLayout.mLastVelocity = 0.0f;
                        }
                        this.mLastTouchX = object.getRawX();
                        this.mLastTouchY = object.getRawY();
                        return;
                    }
                    this.mDragStarted = false;
                    object4.computeCurrentVelocity(16);
                    f5 = object4.getXVelocity();
                    f4 = object4.getYVelocity();
                    f3 = this.mMotionLayout.getProgress();
                    f2 = (float)this.mMotionLayout.getWidth() / 2.0f;
                    f = (float)this.mMotionLayout.getHeight() / 2.0f;
                    n2 = this.mRotationCenterId;
                    if (n2 == -1) break block31;
                    object4 = this.mMotionLayout.findViewById(n2);
                    this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                    f2 = (float)this.mTempLoc[0] + (float)(object4.getLeft() + object4.getRight()) / 2.0f;
                    f = this.mTempLoc[1];
                    n2 = object4.getTop();
                    n3 = object4.getBottom();
                    break block32;
                }
                n2 = this.mTouchAnchorId;
                if (n2 == -1) break block33;
                object4 = this.mMotionLayout.getMotionController(n2);
                object4 = this.mMotionLayout.findViewById(((MotionController)object4).getAnimateRelativeTo());
                this.mMotionLayout.getLocationOnScreen(this.mTempLoc);
                f2 = (float)this.mTempLoc[0] + (float)(object4.getLeft() + object4.getRight()) / 2.0f;
                f = this.mTempLoc[1];
                n2 = object4.getTop();
                n3 = object4.getBottom();
            }
            f += (float)(n2 + n3) / 2.0f;
        }
        f2 = object.getRawX() - f2;
        f = object.getRawY() - f;
        double d = Math.toDegrees(Math.atan2(f, f2));
        n2 = this.mTouchAnchorId;
        if (n2 != -1) {
            this.mMotionLayout.getAnchorDpDt(n2, f3, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
            float[] fArray = this.mAnchorDpDt;
            fArray[1] = (float)Math.toDegrees(fArray[1]);
        } else {
            this.mAnchorDpDt[1] = 360.0f;
        }
        f = (float)(Math.toDegrees(Math.atan2(f4 + f, f5 + f2)) - d) * 62.5f;
        f2 = !Float.isNaN(f) ? f * 3.0f * this.mDragScale / this.mAnchorDpDt[1] + f3 : f3;
        if (f2 != 0.0f && f2 != 1.0f && (n2 = this.mOnTouchUp) != 3) {
            f5 = f * this.mDragScale / this.mAnchorDpDt[1];
            f = (double)f2 < 0.5 ? 0.0f : 1.0f;
            f2 = f5;
            if (n2 == 6) {
                f2 = f5;
                if (f3 + f5 < 0.0f) {
                    f2 = Math.abs(f5);
                }
                f = 1.0f;
            }
            f4 = f2;
            f5 = f;
            if (this.mOnTouchUp == 7) {
                f = f2;
                if (f3 + f2 > 1.0f) {
                    f = -Math.abs(f2);
                }
                f5 = 0.0f;
                f4 = f;
            }
            this.mMotionLayout.touchAnimateTo(this.mOnTouchUp, f5, f4 * 3.0f);
            if (!(0.0f >= f3)) {
                if (!(1.0f <= f3)) return;
            }
            this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
            return;
        }
        if (!(0.0f >= f2)) {
            if (!(1.0f <= f2)) return;
        }
        this.mMotionLayout.setState(MotionLayout.TransitionState.FINISHED);
    }

    void scrollMove(float f, float f2) {
        float f3 = this.mMotionLayout.getProgress();
        if (!this.mDragStarted) {
            this.mDragStarted = true;
            this.mMotionLayout.setProgress(f3);
        }
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, f3, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float f4 = this.mTouchDirectionX;
        float[] fArray = this.mAnchorDpDt;
        if ((double)Math.abs(f4 * fArray[0] + this.mTouchDirectionY * fArray[1]) < 0.01) {
            fArray = this.mAnchorDpDt;
            fArray[0] = 0.01f;
            fArray[1] = 0.01f;
        }
        f = (f4 = this.mTouchDirectionX) != 0.0f ? f * f4 / this.mAnchorDpDt[0] : f2 * this.mTouchDirectionY / this.mAnchorDpDt[1];
        if ((f = Math.max(Math.min(f3 + f, 1.0f), 0.0f)) != this.mMotionLayout.getProgress()) {
            this.mMotionLayout.setProgress(f);
        }
    }

    void scrollUp(float f, float f2) {
        boolean bl = false;
        this.mDragStarted = false;
        float f3 = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, f3, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float f4 = this.mTouchDirectionX;
        Object object = this.mAnchorDpDt;
        float f5 = object[0];
        float f6 = this.mTouchDirectionY;
        f5 = object[1];
        f5 = 0.0f;
        f = f4 != 0.0f ? f * f4 / object[0] : f2 * f6 / object[1];
        f2 = f3;
        if (!Float.isNaN(f)) {
            f2 = f3 + f / 3.0f;
        }
        if (f2 != 0.0f) {
            boolean bl2 = f2 != 1.0f;
            int n = this.mOnTouchUp;
            if (n != 3) {
                bl = true;
            }
            if (bl & bl2) {
                object = this.mMotionLayout;
                f2 = (double)f2 < 0.5 ? f5 : 1.0f;
                ((MotionLayout)object).touchAnimateTo(n, f2, f);
            }
        }
    }

    public void setAnchorId(int n) {
        this.mTouchAnchorId = n;
    }

    void setAutoCompleteMode(int n) {
        this.mAutoCompleteMode = n;
    }

    void setDown(float f, float f2) {
        this.mLastTouchX = f;
        this.mLastTouchY = f2;
    }

    public void setMaxAcceleration(float f) {
        this.mMaxAcceleration = f;
    }

    public void setMaxVelocity(float f) {
        this.mMaxVelocity = f;
    }

    public void setRTL(boolean bl) {
        float[][] fArray;
        if (bl) {
            fArray = TOUCH_DIRECTION;
            fArray[4] = fArray[3];
            fArray[5] = fArray[2];
            fArray = TOUCH_SIDES;
            fArray[5] = fArray[2];
            fArray[6] = fArray[1];
        } else {
            fArray = TOUCH_DIRECTION;
            fArray[4] = fArray[2];
            fArray[5] = fArray[3];
            fArray = TOUCH_SIDES;
            fArray[5] = fArray[1];
            fArray[6] = fArray[2];
        }
        fArray = TOUCH_SIDES;
        int n = this.mTouchAnchorSide;
        this.mTouchAnchorX = fArray[n][0];
        this.mTouchAnchorY = fArray[n][1];
        n = this.mTouchSide;
        fArray = TOUCH_DIRECTION;
        if (n >= fArray.length) {
            return;
        }
        this.mTouchDirectionX = fArray[n][0];
        this.mTouchDirectionY = fArray[n][1];
    }

    public void setTouchAnchorLocation(float f, float f2) {
        this.mTouchAnchorX = f;
        this.mTouchAnchorY = f2;
    }

    public void setTouchUpMode(int n) {
        this.mOnTouchUp = n;
    }

    void setUpTouchEvent(float f, float f2) {
        this.mLastTouchX = f;
        this.mLastTouchY = f2;
        this.mDragStarted = false;
    }

    void setupTouch() {
        Object object;
        int n = this.mTouchAnchorId;
        if (n != -1) {
            View view = this.mMotionLayout.findViewById(n);
            object = view;
            if (view == null) {
                object = new StringBuilder();
                ((StringBuilder)object).append("cannot find TouchAnchorId @id/");
                ((StringBuilder)object).append(Debug.getName(this.mMotionLayout.getContext(), this.mTouchAnchorId));
                Log.e((String)TAG, (String)((StringBuilder)object).toString());
                object = view;
            }
        } else {
            object = null;
        }
        if (object instanceof NestedScrollView) {
            object = (NestedScrollView)object;
            object.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return false;
                }
            });
            ((NestedScrollView)object).setOnScrollChangeListener(new NestedScrollView.OnScrollChangeListener(){

                @Override
                public void onScrollChange(NestedScrollView nestedScrollView, int n, int n2, int n3, int n4) {
                }
            });
        }
    }

    public String toString() {
        CharSequence charSequence;
        if (Float.isNaN(this.mTouchDirectionX)) {
            charSequence = "rotation";
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(this.mTouchDirectionX);
            ((StringBuilder)charSequence).append(" , ");
            ((StringBuilder)charSequence).append(this.mTouchDirectionY);
            charSequence = ((StringBuilder)charSequence).toString();
        }
        return charSequence;
    }
}

