/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.core.motion.utils.KeyCache;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyFrames;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.MotionScene;
import androidx.constraintlayout.motion.widget.ViewTransition$$ExternalSyntheticLambda0;
import androidx.constraintlayout.motion.widget.ViewTransitionController;
import androidx.constraintlayout.widget.ConstraintAttribute;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ViewTransition {
    static final int ANTICIPATE = 6;
    static final int BOUNCE = 4;
    public static final String CONSTRAINT_OVERRIDE = "ConstraintOverride";
    public static final String CUSTOM_ATTRIBUTE = "CustomAttribute";
    public static final String CUSTOM_METHOD = "CustomMethod";
    static final int EASE_IN = 1;
    static final int EASE_IN_OUT = 0;
    static final int EASE_OUT = 2;
    private static final int INTERPOLATOR_REFERENCE_ID = -2;
    public static final String KEY_FRAME_SET_TAG = "KeyFrameSet";
    static final int LINEAR = 3;
    public static final int ONSTATE_ACTION_DOWN = 1;
    public static final int ONSTATE_ACTION_DOWN_UP = 3;
    public static final int ONSTATE_ACTION_UP = 2;
    public static final int ONSTATE_SHARED_VALUE_SET = 4;
    public static final int ONSTATE_SHARED_VALUE_UNSET = 5;
    static final int OVERSHOOT = 5;
    private static final int SPLINE_STRING = -1;
    private static String TAG = "ViewTransition";
    private static final int UNSET = -1;
    static final int VIEWTRANSITIONMODE_ALLSTATES = 1;
    static final int VIEWTRANSITIONMODE_CURRENTSTATE = 0;
    static final int VIEWTRANSITIONMODE_NOSTATE = 2;
    public static final String VIEW_TRANSITION_TAG = "ViewTransition";
    private int mClearsTag = -1;
    ConstraintSet.Constraint mConstraintDelta;
    Context mContext;
    private int mDefaultInterpolator = 0;
    private int mDefaultInterpolatorID = -1;
    private String mDefaultInterpolatorString = null;
    private boolean mDisabled = false;
    private int mDuration = -1;
    private int mId;
    private int mIfTagNotSet = -1;
    private int mIfTagSet = -1;
    KeyFrames mKeyFrames;
    private int mOnStateTransition = -1;
    private int mPathMotionArc = 0;
    private int mSetsTag = -1;
    private int mSharedValueCurrent = -1;
    private int mSharedValueID = -1;
    private int mSharedValueTarget = -1;
    private int mTargetId;
    private String mTargetString;
    private int mUpDuration = -1;
    int mViewTransitionMode;
    ConstraintSet set;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ViewTransition(Context context, XmlPullParser xmlPullParser) {
        this.mContext = context;
        try {
            int n = xmlPullParser.getEventType();
            while (n != 1) {
                block16: {
                    block19: {
                        Object object;
                        block20: {
                            CharSequence charSequence;
                            block18: {
                                block17: {
                                    if (n == 2) break block17;
                                    if (n == 3 && VIEW_TRANSITION_TAG.equals(xmlPullParser.getName())) {
                                        return;
                                    }
                                    break block16;
                                }
                                charSequence = xmlPullParser.getName();
                                switch (((String)charSequence).hashCode()) {
                                    default: {
                                        break;
                                    }
                                    case 1791837707: {
                                        if (!((String)charSequence).equals(CUSTOM_ATTRIBUTE)) break;
                                        n = 3;
                                        break block18;
                                    }
                                    case 366511058: {
                                        if (!((String)charSequence).equals(CUSTOM_METHOD)) break;
                                        n = 4;
                                        break block18;
                                    }
                                    case 61998586: {
                                        if (!((String)charSequence).equals(VIEW_TRANSITION_TAG)) break;
                                        n = 0;
                                        break block18;
                                    }
                                    case -1239391468: {
                                        if (!((String)charSequence).equals(KEY_FRAME_SET_TAG)) break;
                                        n = 1;
                                        break block18;
                                    }
                                    case -1962203927: {
                                        if (!((String)charSequence).equals(CONSTRAINT_OVERRIDE)) break;
                                        n = 2;
                                        break block18;
                                    }
                                }
                                n = -1;
                            }
                            if (n == 0) break block19;
                            if (n == 1) break block20;
                            if (n != 2) {
                                if (n != 3 && n != 4) {
                                    object = TAG;
                                    StringBuilder stringBuilder = new StringBuilder();
                                    stringBuilder.append(Debug.getLoc());
                                    stringBuilder.append(" unknown tag ");
                                    stringBuilder.append((String)charSequence);
                                    Log.e((String)object, (String)stringBuilder.toString());
                                    object = TAG;
                                    ((StringBuilder)charSequence).append(".xml:");
                                    ((StringBuilder)charSequence).append(xmlPullParser.getLineNumber());
                                    Log.e((String)object, (String)((StringBuilder)charSequence).toString());
                                    break block16;
                                } else {
                                    ConstraintAttribute.parse(context, xmlPullParser, this.mConstraintDelta.mCustomConstraints);
                                }
                                break block16;
                            } else {
                                this.mConstraintDelta = ConstraintSet.buildDelta(context, xmlPullParser);
                            }
                            break block16;
                        }
                        object = new KeyFrames(context, xmlPullParser);
                        this.mKeyFrames = object;
                        break block16;
                    }
                    this.parseViewTransitionTags(context, xmlPullParser);
                }
                n = xmlPullParser.next();
            }
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    private void parseViewTransitionTags(Context context, XmlPullParser object) {
        context = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)object), R.styleable.ViewTransition);
        int n = context.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = context.getIndex(i);
            if (n3 == R.styleable.ViewTransition_android_id) {
                this.mId = context.getResourceId(n3, this.mId);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_motionTarget) {
                if (MotionLayout.IS_IN_EDIT_MODE) {
                    this.mTargetId = n2 = context.getResourceId(n3, this.mTargetId);
                    if (n2 != -1) continue;
                    this.mTargetString = context.getString(n3);
                    continue;
                }
                if (context.peekValue((int)n3).type == 3) {
                    this.mTargetString = context.getString(n3);
                    continue;
                }
                this.mTargetId = context.getResourceId(n3, this.mTargetId);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_onStateTransition) {
                this.mOnStateTransition = context.getInt(n3, this.mOnStateTransition);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_transitionDisable) {
                this.mDisabled = context.getBoolean(n3, this.mDisabled);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_pathMotionArc) {
                this.mPathMotionArc = context.getInt(n3, this.mPathMotionArc);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_duration) {
                this.mDuration = context.getInt(n3, this.mDuration);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_upDuration) {
                this.mUpDuration = context.getInt(n3, this.mUpDuration);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_viewTransitionMode) {
                this.mViewTransitionMode = context.getInt(n3, this.mViewTransitionMode);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_motionInterpolator) {
                object = context.peekValue(n3);
                if (((TypedValue)object).type == 1) {
                    this.mDefaultInterpolatorID = n2 = context.getResourceId(n3, -1);
                    if (n2 == -1) continue;
                    this.mDefaultInterpolator = -2;
                    continue;
                }
                if (((TypedValue)object).type == 3) {
                    object = context.getString(n3);
                    this.mDefaultInterpolatorString = object;
                    if (object != null && ((String)object).indexOf("/") > 0) {
                        this.mDefaultInterpolatorID = context.getResourceId(n3, -1);
                        this.mDefaultInterpolator = -2;
                        continue;
                    }
                    this.mDefaultInterpolator = -1;
                    continue;
                }
                this.mDefaultInterpolator = context.getInteger(n3, this.mDefaultInterpolator);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_setsTag) {
                this.mSetsTag = context.getResourceId(n3, this.mSetsTag);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_clearsTag) {
                this.mClearsTag = context.getResourceId(n3, this.mClearsTag);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_ifTagSet) {
                this.mIfTagSet = context.getResourceId(n3, this.mIfTagSet);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_ifTagNotSet) {
                this.mIfTagNotSet = context.getResourceId(n3, this.mIfTagNotSet);
                continue;
            }
            if (n3 == R.styleable.ViewTransition_SharedValueId) {
                this.mSharedValueID = context.getResourceId(n3, this.mSharedValueID);
                continue;
            }
            if (n3 != R.styleable.ViewTransition_SharedValue) continue;
            this.mSharedValueTarget = context.getInteger(n3, this.mSharedValueTarget);
        }
        context.recycle();
    }

    private void updateTransition(MotionScene.Transition transition, View object) {
        int n = this.mDuration;
        if (n != -1) {
            transition.setDuration(n);
        }
        transition.setPathMotionArc(this.mPathMotionArc);
        transition.setInterpolatorInfo(this.mDefaultInterpolator, this.mDefaultInterpolatorString, this.mDefaultInterpolatorID);
        n = object.getId();
        object = this.mKeyFrames;
        if (object != null) {
            Object object2 = ((KeyFrames)object).getKeyFramesForView(-1);
            object = new KeyFrames();
            object2 = ((ArrayList)object2).iterator();
            while (object2.hasNext()) {
                ((KeyFrames)object).addKey(((Key)object2.next()).clone().setViewId(n));
            }
            transition.addKeyFrame((KeyFrames)object);
        }
    }

    void applyIndependentTransition(ViewTransitionController viewTransitionController, MotionLayout motionLayout, View view) {
        MotionController motionController = new MotionController(view);
        motionController.setBothStates(view);
        this.mKeyFrames.addAllFrames(motionController);
        motionController.setup(motionLayout.getWidth(), motionLayout.getHeight(), this.mDuration, System.nanoTime());
        new Animate(viewTransitionController, motionController, this.mDuration, this.mUpDuration, this.mOnStateTransition, this.getInterpolator(motionLayout.getContext()), this.mSetsTag, this.mClearsTag);
    }

    void applyTransition(ViewTransitionController object, MotionLayout motionLayout, int n, ConstraintSet constraintSet, View ... viewArray) {
        ConstraintSet constraintSet2;
        int n2;
        Object object2;
        if (this.mDisabled) {
            return;
        }
        int n3 = this.mViewTransitionMode;
        int n4 = 0;
        if (n3 == 2) {
            this.applyIndependentTransition((ViewTransitionController)object, motionLayout, viewArray[0]);
            return;
        }
        if (n3 == 1) {
            object2 = motionLayout.getConstraintSetIds();
            for (n3 = 0; n3 < ((int[])object2).length; ++n3) {
                n2 = object2[n3];
                if (n2 == n) continue;
                constraintSet2 = motionLayout.getConstraintSet(n2);
                int n5 = viewArray.length;
                for (n2 = 0; n2 < n5; ++n2) {
                    object = constraintSet2.getConstraint(viewArray[n2].getId());
                    ConstraintSet.Constraint constraint = this.mConstraintDelta;
                    if (constraint == null) continue;
                    constraint.applyDelta((ConstraintSet.Constraint)object);
                    ((ConstraintSet.Constraint)object).mCustomConstraints.putAll(this.mConstraintDelta.mCustomConstraints);
                }
            }
        }
        constraintSet2 = new ConstraintSet();
        constraintSet2.clone(constraintSet);
        n2 = viewArray.length;
        for (n3 = 0; n3 < n2; ++n3) {
            object = constraintSet2.getConstraint(viewArray[n3].getId());
            object2 = this.mConstraintDelta;
            if (object2 == null) continue;
            ((ConstraintSet.Constraint)object2).applyDelta((ConstraintSet.Constraint)object);
            ((ConstraintSet.Constraint)object).mCustomConstraints.putAll(this.mConstraintDelta.mCustomConstraints);
        }
        motionLayout.updateState(n, constraintSet2);
        motionLayout.updateState(R.id.view_transition, constraintSet);
        motionLayout.setState(R.id.view_transition, -1, -1);
        object = new MotionScene.Transition(-1, motionLayout.mScene, R.id.view_transition, n);
        n3 = viewArray.length;
        for (n = n4; n < n3; ++n) {
            this.updateTransition((MotionScene.Transition)object, viewArray[n]);
        }
        motionLayout.setTransition((MotionScene.Transition)object);
        motionLayout.transitionToEnd(new ViewTransition$$ExternalSyntheticLambda0(this, viewArray));
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean checkTags(View view) {
        int n = this.mIfTagSet;
        boolean bl = false;
        n = n == -1 || view.getTag(n) != null ? 1 : 0;
        int n2 = this.mIfTagNotSet;
        n2 = n2 == -1 || view.getTag(n2) == null ? 1 : 0;
        boolean bl2 = bl;
        if (n == 0) return bl2;
        bl2 = bl;
        if (n2 == 0) return bl2;
        return true;
    }

    int getId() {
        return this.mId;
    }

    Interpolator getInterpolator(Context context) {
        int n = this.mDefaultInterpolator;
        if (n != -2) {
            if (n != -1) {
                if (n != 0) {
                    if (n != 1) {
                        if (n != 2) {
                            if (n != 4) {
                                if (n != 5) {
                                    if (n != 6) {
                                        return null;
                                    }
                                    return new AnticipateInterpolator();
                                }
                                return new OvershootInterpolator();
                            }
                            return new BounceInterpolator();
                        }
                        return new DecelerateInterpolator();
                    }
                    return new AccelerateInterpolator();
                }
                return new AccelerateDecelerateInterpolator();
            }
            return new Interpolator(Easing.getInterpolator(this.mDefaultInterpolatorString)){
                final /* synthetic */ Easing val$easing;
                {
                    this.val$easing = easing;
                }

                public float getInterpolation(float f) {
                    return (float)this.val$easing.get(f);
                }
            };
        }
        return AnimationUtils.loadInterpolator((Context)context, (int)this.mDefaultInterpolatorID);
    }

    public int getSharedValue() {
        return this.mSharedValueTarget;
    }

    public int getSharedValueCurrent() {
        return this.mSharedValueCurrent;
    }

    public int getSharedValueID() {
        return this.mSharedValueID;
    }

    public int getStateTransition() {
        return this.mOnStateTransition;
    }

    boolean isEnabled() {
        return this.mDisabled ^ true;
    }

    public /* synthetic */ void lambda$applyTransition$0$androidx-constraintlayout-motion-widget-ViewTransition(View[] viewArray) {
        int n;
        int n2 = this.mSetsTag;
        int n3 = 0;
        if (n2 != -1) {
            n = viewArray.length;
            for (n2 = 0; n2 < n; ++n2) {
                viewArray[n2].setTag(this.mSetsTag, (Object)System.nanoTime());
            }
        }
        if (this.mClearsTag != -1) {
            n = viewArray.length;
            for (n2 = n3; n2 < n; ++n2) {
                viewArray[n2].setTag(this.mClearsTag, null);
            }
        }
    }

    boolean matchesView(View object) {
        if (object == null) {
            return false;
        }
        if (this.mTargetId == -1 && this.mTargetString == null) {
            return false;
        }
        if (!this.checkTags((View)object)) {
            return false;
        }
        if (object.getId() == this.mTargetId) {
            return true;
        }
        if (this.mTargetString == null) {
            return false;
        }
        return object.getLayoutParams() instanceof ConstraintLayout.LayoutParams && (object = ((ConstraintLayout.LayoutParams)object.getLayoutParams()).constraintTag) != null && ((String)object).matches(this.mTargetString);
    }

    void setEnabled(boolean bl) {
        this.mDisabled = bl ^ true;
    }

    void setId(int n) {
        this.mId = n;
    }

    public void setSharedValue(int n) {
        this.mSharedValueTarget = n;
    }

    public void setSharedValueCurrent(int n) {
        this.mSharedValueCurrent = n;
    }

    public void setSharedValueID(int n) {
        this.mSharedValueID = n;
    }

    public void setStateTransition(int n) {
        this.mOnStateTransition = n;
    }

    boolean supports(int n) {
        int n2 = this.mOnStateTransition;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 == 1) {
            if (n == 0) {
                bl3 = true;
            }
            return bl3;
        }
        if (n2 == 2) {
            bl3 = bl;
            if (n == 1) {
                bl3 = true;
            }
            return bl3;
        }
        bl3 = bl2;
        if (n2 == 3) {
            bl3 = bl2;
            if (n == 0) {
                bl3 = true;
            }
        }
        return bl3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ViewTransition(");
        stringBuilder.append(Debug.getName(this.mContext, this.mId));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static class Animate {
        boolean hold_at_100 = false;
        KeyCache mCache = new KeyCache();
        private final int mClearsTag;
        float mDpositionDt;
        int mDuration;
        Interpolator mInterpolator;
        long mLastRender;
        MotionController mMC;
        float mPosition;
        private final int mSetsTag;
        long mStart;
        Rect mTempRec = new Rect();
        int mUpDuration;
        ViewTransitionController mVtController;
        boolean reverse = false;

        Animate(ViewTransitionController viewTransitionController, MotionController motionController, int n, int n2, int n3, Interpolator interpolator2, int n4, int n5) {
            long l;
            this.mVtController = viewTransitionController;
            this.mMC = motionController;
            this.mDuration = n;
            this.mUpDuration = n2;
            this.mStart = l = System.nanoTime();
            this.mLastRender = l;
            this.mVtController.addAnimation(this);
            this.mInterpolator = interpolator2;
            this.mSetsTag = n4;
            this.mClearsTag = n5;
            if (n3 == 3) {
                this.hold_at_100 = true;
            }
            float f = n == 0 ? Float.MAX_VALUE : 1.0f / (float)n;
            this.mDpositionDt = f;
            this.mutate();
        }

        void mutate() {
            if (this.reverse) {
                this.mutateReverse();
            } else {
                this.mutateForward();
            }
        }

        void mutateForward() {
            Object object;
            float f;
            long l = System.nanoTime();
            long l2 = this.mLastRender;
            this.mLastRender = l;
            this.mPosition = f = this.mPosition + (float)((double)(l - l2) * 1.0E-6) * this.mDpositionDt;
            if (f >= 1.0f) {
                this.mPosition = 1.0f;
            }
            f = (object = this.mInterpolator) == null ? this.mPosition : object.getInterpolation(this.mPosition);
            object = this.mMC;
            boolean bl = ((MotionController)object).interpolate(((MotionController)object).mView, f, l, this.mCache);
            if (this.mPosition >= 1.0f) {
                if (this.mSetsTag != -1) {
                    this.mMC.getView().setTag(this.mSetsTag, (Object)System.nanoTime());
                }
                if (this.mClearsTag != -1) {
                    this.mMC.getView().setTag(this.mClearsTag, null);
                }
                if (!this.hold_at_100) {
                    this.mVtController.removeAnimation(this);
                }
            }
            if (this.mPosition < 1.0f || bl) {
                this.mVtController.invalidate();
            }
        }

        void mutateReverse() {
            Object object;
            float f;
            long l = System.nanoTime();
            long l2 = this.mLastRender;
            this.mLastRender = l;
            this.mPosition = f = this.mPosition - (float)((double)(l - l2) * 1.0E-6) * this.mDpositionDt;
            if (f < 0.0f) {
                this.mPosition = 0.0f;
            }
            f = (object = this.mInterpolator) == null ? this.mPosition : object.getInterpolation(this.mPosition);
            object = this.mMC;
            boolean bl = ((MotionController)object).interpolate(((MotionController)object).mView, f, l, this.mCache);
            if (this.mPosition <= 0.0f) {
                if (this.mSetsTag != -1) {
                    this.mMC.getView().setTag(this.mSetsTag, (Object)System.nanoTime());
                }
                if (this.mClearsTag != -1) {
                    this.mMC.getView().setTag(this.mClearsTag, null);
                }
                this.mVtController.removeAnimation(this);
            }
            if (this.mPosition > 0.0f || bl) {
                this.mVtController.invalidate();
            }
        }

        public void reactTo(int n, float f, float f2) {
            if (n != 1) {
                if (n == 2) {
                    this.mMC.getView().getHitRect(this.mTempRec);
                    if (!this.mTempRec.contains((int)f, (int)f2) && !this.reverse) {
                        this.reverse(true);
                    }
                }
                return;
            }
            if (!this.reverse) {
                this.reverse(true);
            }
        }

        void reverse(boolean bl) {
            int n;
            this.reverse = bl;
            if (bl && (n = this.mUpDuration) != -1) {
                float f = n == 0 ? Float.MAX_VALUE : 1.0f / (float)n;
                this.mDpositionDt = f;
            }
            this.mVtController.invalidate();
            this.mLastRender = System.nanoTime();
        }
    }
}

