/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.graphics.Rect;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.motion.widget.ViewTransition;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.SharedValues;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class ViewTransitionController {
    private String TAG = "ViewTransitionController";
    ArrayList<ViewTransition.Animate> animations;
    private final MotionLayout mMotionLayout;
    private HashSet<View> mRelatedViews;
    ArrayList<ViewTransition.Animate> removeList;
    private ArrayList<ViewTransition> viewTransitions = new ArrayList();

    public ViewTransitionController(MotionLayout motionLayout) {
        this.removeList = new ArrayList();
        this.mMotionLayout = motionLayout;
    }

    private void listenForSharedVariable(final ViewTransition viewTransition, final boolean bl) {
        final int n = viewTransition.getSharedValueID();
        final int n2 = viewTransition.getSharedValue();
        ConstraintLayout.getSharedValues().addListener(viewTransition.getSharedValueID(), new SharedValues.SharedValuesListener(){

            @Override
            public void onNewValue(int n4, int n22, int n3) {
                block3: {
                    block4: {
                        n3 = viewTransition.getSharedValueCurrent();
                        viewTransition.setSharedValueCurrent(n22);
                        if (n != n4 || n3 == n22) break block3;
                        if (!bl) break block4;
                        if (n2 != n22) break block3;
                        n22 = ViewTransitionController.this.mMotionLayout.getChildCount();
                        for (n4 = 0; n4 < n22; ++n4) {
                            View view = ViewTransitionController.this.mMotionLayout.getChildAt(n4);
                            if (!viewTransition.matchesView(view)) continue;
                            n3 = ViewTransitionController.this.mMotionLayout.getCurrentState();
                            ConstraintSet constraintSet = ViewTransitionController.this.mMotionLayout.getConstraintSet(n3);
                            ViewTransition viewTransition2 = viewTransition;
                            ViewTransitionController viewTransitionController = ViewTransitionController.this;
                            viewTransition2.applyTransition(viewTransitionController, viewTransitionController.mMotionLayout, n3, constraintSet, view);
                        }
                        break block3;
                    }
                    if (n2 != n22) {
                        n22 = ViewTransitionController.this.mMotionLayout.getChildCount();
                        for (n4 = 0; n4 < n22; ++n4) {
                            View view = ViewTransitionController.this.mMotionLayout.getChildAt(n4);
                            if (!viewTransition.matchesView(view)) continue;
                            n3 = ViewTransitionController.this.mMotionLayout.getCurrentState();
                            ConstraintSet constraintSet = ViewTransitionController.this.mMotionLayout.getConstraintSet(n3);
                            ViewTransition viewTransition3 = viewTransition;
                            ViewTransitionController viewTransitionController = ViewTransitionController.this;
                            viewTransition3.applyTransition(viewTransitionController, viewTransitionController.mMotionLayout, n3, constraintSet, view);
                        }
                    }
                }
            }
        });
    }

    private void viewTransition(ViewTransition object, View ... object2) {
        int n = this.mMotionLayout.getCurrentState();
        if (((ViewTransition)object).mViewTransitionMode != 2) {
            if (n == -1) {
                object = this.TAG;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("No support for ViewTransition within transition yet. Currently: ");
                ((StringBuilder)object2).append(this.mMotionLayout.toString());
                Log.w((String)object, (String)((StringBuilder)object2).toString());
                return;
            }
            ConstraintSet constraintSet = this.mMotionLayout.getConstraintSet(n);
            if (constraintSet == null) {
                return;
            }
            ((ViewTransition)object).applyTransition(this, this.mMotionLayout, n, constraintSet, (View[])object2);
        } else {
            ((ViewTransition)object).applyTransition(this, this.mMotionLayout, n, null, (View[])object2);
        }
    }

    public void add(ViewTransition viewTransition) {
        this.viewTransitions.add(viewTransition);
        this.mRelatedViews = null;
        if (viewTransition.getStateTransition() == 4) {
            this.listenForSharedVariable(viewTransition, true);
        } else if (viewTransition.getStateTransition() == 5) {
            this.listenForSharedVariable(viewTransition, false);
        }
    }

    void addAnimation(ViewTransition.Animate animate) {
        if (this.animations == null) {
            this.animations = new ArrayList();
        }
        this.animations.add(animate);
    }

    void animate() {
        ArrayList<ViewTransition.Animate> arrayList = this.animations;
        if (arrayList == null) {
            return;
        }
        arrayList = arrayList.iterator();
        while (arrayList.hasNext()) {
            ((ViewTransition.Animate)arrayList.next()).mutate();
        }
        this.animations.removeAll(this.removeList);
        this.removeList.clear();
        if (this.animations.isEmpty()) {
            this.animations = null;
        }
    }

    boolean applyViewTransition(int n, MotionController motionController) {
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != n) continue;
            viewTransition.mKeyFrames.addAllFrames(motionController);
            return true;
        }
        return false;
    }

    void enableViewTransition(int n, boolean bl) {
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != n) continue;
            viewTransition.setEnabled(bl);
            break;
        }
    }

    void invalidate() {
        this.mMotionLayout.invalidate();
    }

    boolean isViewTransitionEnabled(int n) {
        for (ViewTransition viewTransition : this.viewTransitions) {
            if (viewTransition.getId() != n) continue;
            return viewTransition.isEnabled();
        }
        return false;
    }

    void remove(int n) {
        ViewTransition viewTransition2;
        block2: {
            for (ViewTransition viewTransition2 : this.viewTransitions) {
                if (viewTransition2.getId() != n) continue;
                break block2;
            }
            viewTransition2 = null;
        }
        if (viewTransition2 != null) {
            this.mRelatedViews = null;
            this.viewTransitions.remove(viewTransition2);
        }
    }

    void removeAnimation(ViewTransition.Animate animate) {
        this.removeList.add(animate);
    }

    void touchEvent(MotionEvent object3) {
        ConstraintSet constraintSet;
        int n;
        int n2 = this.mMotionLayout.getCurrentState();
        if (n2 == -1) {
            return;
        }
        if (this.mRelatedViews == null) {
            this.mRelatedViews = new HashSet();
            for (ViewTransition viewTransition : this.viewTransitions) {
                int n3 = this.mMotionLayout.getChildCount();
                for (n = 0; n < n3; ++n) {
                    constraintSet = this.mMotionLayout.getChildAt(n);
                    if (!viewTransition.matchesView((View)constraintSet)) continue;
                    constraintSet.getId();
                    this.mRelatedViews.add((View)constraintSet);
                }
            }
        }
        float f = object3.getX();
        float f2 = object3.getY();
        Rect rect = new Rect();
        n = object3.getAction();
        ArrayList<ViewTransition.Animate> arrayList = this.animations;
        if (arrayList != null && !arrayList.isEmpty()) {
            Iterator<ViewTransition.Animate> iterator = this.animations.iterator();
            while (iterator.hasNext()) {
                iterator.next().reactTo(n, f, f2);
            }
        }
        if (n == 0 || n == 1) {
            constraintSet = this.mMotionLayout.getConstraintSet(n2);
            for (ViewTransition viewTransition : this.viewTransitions) {
                if (!viewTransition.supports(n)) continue;
                for (View view : this.mRelatedViews) {
                    if (!viewTransition.matchesView(view)) continue;
                    view.getHitRect(rect);
                    if (!rect.contains((int)f, (int)f2)) continue;
                    viewTransition.applyTransition(this, this.mMotionLayout, n2, constraintSet, view);
                }
            }
        }
    }

    void viewTransition(int n, View ... viewArray) {
        ArrayList<View> arrayList = new ArrayList<View>();
        Iterator<ViewTransition> iterator = this.viewTransitions.iterator();
        Object object2 = null;
        while (iterator.hasNext()) {
            ViewTransition viewTransition = iterator.next();
            if (viewTransition.getId() != n) continue;
            for (Object object2 : viewArray) {
                if (!viewTransition.checkTags((View)object2)) continue;
                arrayList.add((View)object2);
            }
            if (!arrayList.isEmpty()) {
                this.viewTransition(viewTransition, arrayList.toArray(new View[0]));
                arrayList.clear();
            }
            object2 = viewTransition;
        }
        if (object2 == null) {
            Log.e((String)this.TAG, (String)" Could not find ViewTransition");
        }
    }
}

