/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.constraintlayout.utils.widget.ImageFilterView;
import androidx.constraintlayout.widget.R;

public class ImageFilterButton
extends AppCompatImageButton {
    private Drawable mAltDrawable = null;
    private float mCrossfade = 0.0f;
    private Drawable mDrawable = null;
    private ImageFilterView.ImageMatrix mImageMatrix = new ImageFilterView.ImageMatrix();
    LayerDrawable mLayer;
    Drawable[] mLayers;
    private boolean mOverlay = true;
    private float mPanX;
    private float mPanY;
    private Path mPath;
    RectF mRect;
    private float mRotate;
    private float mRound = Float.NaN;
    private float mRoundPercent = 0.0f;
    ViewOutlineProvider mViewOutlineProvider;
    private float mZoom;

    public ImageFilterButton(Context context) {
        super(context);
        this.mLayers = new Drawable[2];
        this.mPanX = Float.NaN;
        this.mPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, null);
    }

    public ImageFilterButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLayers = new Drawable[2];
        this.mPanX = Float.NaN;
        this.mPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, attributeSet);
    }

    public ImageFilterButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mLayers = new Drawable[2];
        this.mPanX = Float.NaN;
        this.mPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, attributeSet);
    }

    private void init(Context layerDrawable, AttributeSet drawable2) {
        this.setPadding(0, 0, 0, 0);
        if (drawable2 != null) {
            layerDrawable = this.getContext().obtainStyledAttributes((AttributeSet)drawable2, R.styleable.ImageFilterView);
            int n = layerDrawable.getIndexCount();
            this.mAltDrawable = layerDrawable.getDrawable(R.styleable.ImageFilterView_altSrc);
            for (int i = 0; i < n; ++i) {
                int n2 = layerDrawable.getIndex(i);
                if (n2 == R.styleable.ImageFilterView_crossfade) {
                    this.mCrossfade = layerDrawable.getFloat(n2, 0.0f);
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_warmth) {
                    this.setWarmth(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_saturation) {
                    this.setSaturation(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_contrast) {
                    this.setContrast(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_round) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(layerDrawable.getDimension(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_roundPercent) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRoundPercent(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_overlay) {
                    this.setOverlay(layerDrawable.getBoolean(n2, this.mOverlay));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_imagePanX) {
                    this.setImagePanX(layerDrawable.getFloat(n2, this.mPanX));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_imagePanY) {
                    this.setImagePanY(layerDrawable.getFloat(n2, this.mPanY));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_imageRotate) {
                    this.setImageRotate(layerDrawable.getFloat(n2, this.mRotate));
                    continue;
                }
                if (n2 != R.styleable.ImageFilterView_imageZoom) continue;
                this.setImageZoom(layerDrawable.getFloat(n2, this.mZoom));
            }
            layerDrawable.recycle();
            layerDrawable = this.getDrawable();
            this.mDrawable = layerDrawable;
            if (this.mAltDrawable != null && layerDrawable != null) {
                drawable2 = this.mLayers;
                this.mDrawable = layerDrawable = this.getDrawable().mutate();
                drawable2[0] = layerDrawable;
                this.mLayers[1] = this.mAltDrawable.mutate();
                this.mLayer = layerDrawable = new LayerDrawable(this.mLayers);
                layerDrawable.getDrawable(1).setAlpha((int)(this.mCrossfade * 255.0f));
                if (!this.mOverlay) {
                    this.mLayer.getDrawable(0).setAlpha((int)((1.0f - this.mCrossfade) * 255.0f));
                }
                super.setImageDrawable((Drawable)this.mLayer);
            } else {
                this.mDrawable = drawable2 = this.getDrawable();
                if (drawable2 != null) {
                    layerDrawable = this.mLayers;
                    this.mDrawable = drawable2 = drawable2.mutate();
                    layerDrawable[0] = drawable2;
                }
            }
        }
    }

    private void setMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            return;
        }
        boolean bl = Float.isNaN(this.mPanX);
        float f = 0.0f;
        float f2 = bl ? 0.0f : this.mPanX;
        float f3 = Float.isNaN(this.mPanY) ? 0.0f : this.mPanY;
        float f4 = Float.isNaN(this.mZoom) ? 1.0f : this.mZoom;
        if (!Float.isNaN(this.mRotate)) {
            f = this.mRotate;
        }
        Matrix matrix = new Matrix();
        matrix.reset();
        float f5 = this.getDrawable().getIntrinsicWidth();
        float f6 = this.getDrawable().getIntrinsicHeight();
        float f7 = this.getWidth();
        float f8 = this.getHeight();
        float f9 = f5 * f8 < f6 * f7 ? f7 / f5 : f8 / f6;
        matrix.postScale(f4 *= f9, f4);
        f9 = f5 * f4;
        matrix.postTranslate((f2 * (f7 - f9) + f7 - f9) * 0.5f, (f3 * (f8 - (f4 *= f6)) + f8 - f4) * 0.5f);
        matrix.postRotate(f, f7 / 2.0f, f8 / 2.0f);
        this.setImageMatrix(matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    private void setOverlay(boolean bl) {
        this.mOverlay = bl;
    }

    private void updateViewMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            return;
        }
        this.setMatrix();
    }

    public void draw(Canvas canvas) {
        boolean bl;
        if (Build.VERSION.SDK_INT < 21 && this.mRound != 0.0f && this.mPath != null) {
            bl = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        } else {
            bl = false;
        }
        super.draw(canvas);
        if (bl) {
            canvas.restore();
        }
    }

    public float getContrast() {
        return this.mImageMatrix.mContrast;
    }

    public float getCrossfade() {
        return this.mCrossfade;
    }

    public float getImagePanX() {
        return this.mPanX;
    }

    public float getImagePanY() {
        return this.mPanY;
    }

    public float getImageRotate() {
        return this.mRotate;
    }

    public float getImageZoom() {
        return this.mZoom;
    }

    public float getRound() {
        return this.mRound;
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getSaturation() {
        return this.mImageMatrix.mSaturation;
    }

    public float getWarmth() {
        return this.mImageMatrix.mWarmth;
    }

    public void layout(int n, int n2, int n3, int n4) {
        super.layout(n, n2, n3, n4);
        this.setMatrix();
    }

    public void setAltImageResource(int n) {
        Drawable drawable2;
        this.mAltDrawable = drawable2 = AppCompatResources.getDrawable(this.getContext(), n).mutate();
        LayerDrawable layerDrawable = this.mLayers;
        layerDrawable[0] = this.mDrawable;
        layerDrawable[1] = drawable2;
        this.mLayer = layerDrawable = new LayerDrawable(this.mLayers);
        super.setImageDrawable((Drawable)layerDrawable);
        this.setCrossfade(this.mCrossfade);
    }

    public void setBrightness(float f) {
        this.mImageMatrix.mBrightness = f;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public void setContrast(float f) {
        this.mImageMatrix.mContrast = f;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public void setCrossfade(float f) {
        this.mCrossfade = f;
        if (this.mLayers != null) {
            if (!this.mOverlay) {
                this.mLayer.getDrawable(0).setAlpha((int)((1.0f - this.mCrossfade) * 255.0f));
            }
            this.mLayer.getDrawable(1).setAlpha((int)(this.mCrossfade * 255.0f));
            super.setImageDrawable((Drawable)this.mLayer);
        }
    }

    @Override
    public void setImageDrawable(Drawable layerDrawable) {
        if (this.mAltDrawable != null && layerDrawable != null) {
            Drawable drawable2;
            this.mDrawable = drawable2 = layerDrawable.mutate();
            layerDrawable = this.mLayers;
            layerDrawable[0] = drawable2;
            layerDrawable[1] = this.mAltDrawable;
            this.mLayer = layerDrawable = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)layerDrawable);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageDrawable((Drawable)layerDrawable);
        }
    }

    public void setImagePanX(float f) {
        this.mPanX = f;
        this.updateViewMatrix();
    }

    public void setImagePanY(float f) {
        this.mPanY = f;
        this.updateViewMatrix();
    }

    @Override
    public void setImageResource(int n) {
        if (this.mAltDrawable != null) {
            Drawable drawable2;
            this.mDrawable = drawable2 = AppCompatResources.getDrawable(this.getContext(), n).mutate();
            LayerDrawable layerDrawable = this.mLayers;
            layerDrawable[0] = drawable2;
            layerDrawable[1] = this.mAltDrawable;
            this.mLayer = layerDrawable = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)layerDrawable);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageResource(n);
        }
    }

    public void setImageRotate(float f) {
        this.mRotate = f;
        this.updateViewMatrix();
    }

    public void setImageZoom(float f) {
        this.mZoom = f;
        this.updateViewMatrix();
    }

    public void setRound(float f) {
        if (Float.isNaN(f)) {
            this.mRound = f;
            f = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(f);
            return;
        }
        boolean bl = this.mRound != f;
        this.mRound = f;
        if (f != 0.0f) {
            ViewOutlineProvider viewOutlineProvider;
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, ImageFilterButton.this.getWidth(), ImageFilterButton.this.getHeight(), ImageFilterButton.this.mRound);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            viewOutlineProvider = this.mPath;
            RectF rectF = this.mRect;
            f = this.mRound;
            viewOutlineProvider.addRoundRect(rectF, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setRoundPercent(float f) {
        boolean bl = this.mRoundPercent != f;
        this.mRoundPercent = f;
        if (f != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    ViewOutlineProvider viewOutlineProvider;
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int n = ImageFilterButton.this.getWidth();
                            int n2 = ImageFilterButton.this.getHeight();
                            outline.setRoundRect(0, 0, n, n2, (float)Math.min(n, n2) * ImageFilterButton.this.mRoundPercent / 2.0f);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            f = (float)Math.min(n, n2) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setSaturation(float f) {
        this.mImageMatrix.mSaturation = f;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }

    public void setWarmth(float f) {
        this.mImageMatrix.mWarmth = f;
        this.mImageMatrix.updateMatrix((ImageView)this);
    }
}

