/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.ImageView;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.R;

public class ImageFilterView
extends AppCompatImageView {
    private Drawable mAltDrawable = null;
    private float mCrossfade = 0.0f;
    private Drawable mDrawable = null;
    private ImageMatrix mImageMatrix = new ImageMatrix();
    LayerDrawable mLayer;
    Drawable[] mLayers;
    private boolean mOverlay = true;
    float mPanX;
    float mPanY;
    private Path mPath;
    RectF mRect;
    float mRotate;
    private float mRound = Float.NaN;
    private float mRoundPercent = 0.0f;
    ViewOutlineProvider mViewOutlineProvider;
    float mZoom;

    public ImageFilterView(Context context) {
        super(context);
        this.mLayers = new Drawable[2];
        this.mPanX = Float.NaN;
        this.mPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, null);
    }

    public ImageFilterView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLayers = new Drawable[2];
        this.mPanX = Float.NaN;
        this.mPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, attributeSet);
    }

    public ImageFilterView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mLayers = new Drawable[2];
        this.mPanX = Float.NaN;
        this.mPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, attributeSet);
    }

    private void init(Context layerDrawable, AttributeSet attributeSet) {
        if (attributeSet != null) {
            layerDrawable = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ImageFilterView);
            int n = layerDrawable.getIndexCount();
            this.mAltDrawable = layerDrawable.getDrawable(R.styleable.ImageFilterView_altSrc);
            for (int i = 0; i < n; ++i) {
                int n2 = layerDrawable.getIndex(i);
                if (n2 == R.styleable.ImageFilterView_crossfade) {
                    this.mCrossfade = layerDrawable.getFloat(n2, 0.0f);
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_warmth) {
                    this.setWarmth(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_saturation) {
                    this.setSaturation(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_contrast) {
                    this.setContrast(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_brightness) {
                    this.setBrightness(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_round) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(layerDrawable.getDimension(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_roundPercent) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRoundPercent(layerDrawable.getFloat(n2, 0.0f));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_overlay) {
                    this.setOverlay(layerDrawable.getBoolean(n2, this.mOverlay));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_imagePanX) {
                    this.setImagePanX(layerDrawable.getFloat(n2, this.mPanX));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_imagePanY) {
                    this.setImagePanY(layerDrawable.getFloat(n2, this.mPanY));
                    continue;
                }
                if (n2 == R.styleable.ImageFilterView_imageRotate) {
                    this.setImageRotate(layerDrawable.getFloat(n2, this.mRotate));
                    continue;
                }
                if (n2 != R.styleable.ImageFilterView_imageZoom) continue;
                this.setImageZoom(layerDrawable.getFloat(n2, this.mZoom));
            }
            layerDrawable.recycle();
            layerDrawable = this.getDrawable();
            this.mDrawable = layerDrawable;
            if (this.mAltDrawable != null && layerDrawable != null) {
                layerDrawable = this.mLayers;
                attributeSet = this.getDrawable().mutate();
                this.mDrawable = attributeSet;
                layerDrawable[0] = attributeSet;
                this.mLayers[1] = this.mAltDrawable.mutate();
                this.mLayer = layerDrawable = new LayerDrawable(this.mLayers);
                layerDrawable.getDrawable(1).setAlpha((int)(this.mCrossfade * 255.0f));
                if (!this.mOverlay) {
                    this.mLayer.getDrawable(0).setAlpha((int)((1.0f - this.mCrossfade) * 255.0f));
                }
                super.setImageDrawable((Drawable)this.mLayer);
            } else {
                attributeSet = this.getDrawable();
                this.mDrawable = attributeSet;
                if (attributeSet != null) {
                    layerDrawable = this.mLayers;
                    attributeSet = attributeSet.mutate();
                    this.mDrawable = attributeSet;
                    layerDrawable[0] = attributeSet;
                }
            }
        }
    }

    private void setMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            return;
        }
        boolean bl = Float.isNaN(this.mPanX);
        float f = 0.0f;
        float f2 = bl ? 0.0f : this.mPanX;
        float f3 = Float.isNaN(this.mPanY) ? 0.0f : this.mPanY;
        float f4 = Float.isNaN(this.mZoom) ? 1.0f : this.mZoom;
        if (!Float.isNaN(this.mRotate)) {
            f = this.mRotate;
        }
        Matrix matrix = new Matrix();
        matrix.reset();
        float f5 = this.getDrawable().getIntrinsicWidth();
        float f6 = this.getDrawable().getIntrinsicHeight();
        float f7 = this.getWidth();
        float f8 = this.getHeight();
        float f9 = f5 * f8 < f6 * f7 ? f7 / f5 : f8 / f6;
        matrix.postScale(f4 *= f9, f4);
        f9 = f5 * f4;
        matrix.postTranslate((f2 * (f7 - f9) + f7 - f9) * 0.5f, (f3 * (f8 - (f4 *= f6)) + f8 - f4) * 0.5f);
        matrix.postRotate(f, f7 / 2.0f, f8 / 2.0f);
        this.setImageMatrix(matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    private void setOverlay(boolean bl) {
        this.mOverlay = bl;
    }

    private void updateViewMatrix() {
        if (Float.isNaN(this.mPanX) && Float.isNaN(this.mPanY) && Float.isNaN(this.mZoom) && Float.isNaN(this.mRotate)) {
            this.setScaleType(ImageView.ScaleType.FIT_CENTER);
            return;
        }
        this.setMatrix();
    }

    public void draw(Canvas canvas) {
        boolean bl;
        if (Build.VERSION.SDK_INT < 21 && this.mRoundPercent != 0.0f && this.mPath != null) {
            bl = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        } else {
            bl = false;
        }
        super.draw(canvas);
        if (bl) {
            canvas.restore();
        }
    }

    public float getBrightness() {
        return this.mImageMatrix.mBrightness;
    }

    public float getContrast() {
        return this.mImageMatrix.mContrast;
    }

    public float getCrossfade() {
        return this.mCrossfade;
    }

    public float getImagePanX() {
        return this.mPanX;
    }

    public float getImagePanY() {
        return this.mPanY;
    }

    public float getImageRotate() {
        return this.mRotate;
    }

    public float getImageZoom() {
        return this.mZoom;
    }

    public float getRound() {
        return this.mRound;
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getSaturation() {
        return this.mImageMatrix.mSaturation;
    }

    public float getWarmth() {
        return this.mImageMatrix.mWarmth;
    }

    public void layout(int n, int n2, int n3, int n4) {
        super.layout(n, n2, n3, n4);
        this.setMatrix();
    }

    public void setAltImageResource(int n) {
        Drawable drawable2;
        this.mAltDrawable = drawable2 = AppCompatResources.getDrawable(this.getContext(), n).mutate();
        Drawable[] drawableArray = this.mLayers;
        drawableArray[0] = this.mDrawable;
        drawableArray[1] = drawable2;
        drawable2 = new LayerDrawable(this.mLayers);
        this.mLayer = drawable2;
        super.setImageDrawable(drawable2);
        this.setCrossfade(this.mCrossfade);
    }

    public void setBrightness(float f) {
        this.mImageMatrix.mBrightness = f;
        this.mImageMatrix.updateMatrix(this);
    }

    public void setContrast(float f) {
        this.mImageMatrix.mContrast = f;
        this.mImageMatrix.updateMatrix(this);
    }

    public void setCrossfade(float f) {
        this.mCrossfade = f;
        if (this.mLayers != null) {
            if (!this.mOverlay) {
                this.mLayer.getDrawable(0).setAlpha((int)((1.0f - this.mCrossfade) * 255.0f));
            }
            this.mLayer.getDrawable(1).setAlpha((int)(this.mCrossfade * 255.0f));
            super.setImageDrawable((Drawable)this.mLayer);
        }
    }

    @Override
    public void setImageDrawable(Drawable drawable2) {
        if (this.mAltDrawable != null && drawable2 != null) {
            this.mDrawable = drawable2 = drawable2.mutate();
            Drawable[] drawableArray = this.mLayers;
            drawableArray[0] = drawable2;
            drawableArray[1] = this.mAltDrawable;
            drawable2 = new LayerDrawable(this.mLayers);
            this.mLayer = drawable2;
            super.setImageDrawable(drawable2);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageDrawable(drawable2);
        }
    }

    public void setImagePanX(float f) {
        this.mPanX = f;
        this.updateViewMatrix();
    }

    public void setImagePanY(float f) {
        this.mPanY = f;
        this.updateViewMatrix();
    }

    @Override
    public void setImageResource(int n) {
        if (this.mAltDrawable != null) {
            Drawable drawable2;
            this.mDrawable = drawable2 = AppCompatResources.getDrawable(this.getContext(), n).mutate();
            LayerDrawable layerDrawable = this.mLayers;
            layerDrawable[0] = drawable2;
            layerDrawable[1] = this.mAltDrawable;
            this.mLayer = layerDrawable = new LayerDrawable(this.mLayers);
            super.setImageDrawable((Drawable)layerDrawable);
            this.setCrossfade(this.mCrossfade);
        } else {
            super.setImageResource(n);
        }
    }

    public void setImageRotate(float f) {
        this.mRotate = f;
        this.updateViewMatrix();
    }

    public void setImageZoom(float f) {
        this.mZoom = f;
        this.updateViewMatrix();
    }

    public void setRound(float f) {
        if (Float.isNaN(f)) {
            this.mRound = f;
            f = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(f);
            return;
        }
        boolean bl = this.mRound != f;
        this.mRound = f;
        if (f != 0.0f) {
            ViewOutlineProvider viewOutlineProvider;
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, ImageFilterView.this.getWidth(), ImageFilterView.this.getHeight(), ImageFilterView.this.mRound);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            Path path = this.mPath;
            viewOutlineProvider = this.mRect;
            f = this.mRound;
            path.addRoundRect((RectF)viewOutlineProvider, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setRoundPercent(float f) {
        boolean bl = this.mRoundPercent != f;
        this.mRoundPercent = f;
        if (f != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    ViewOutlineProvider viewOutlineProvider;
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int n = ImageFilterView.this.getWidth();
                            int n2 = ImageFilterView.this.getHeight();
                            outline.setRoundRect(0, 0, n, n2, (float)Math.min(n, n2) * ImageFilterView.this.mRoundPercent / 2.0f);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            f = (float)Math.min(n, n2) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setSaturation(float f) {
        this.mImageMatrix.mSaturation = f;
        this.mImageMatrix.updateMatrix(this);
    }

    public void setWarmth(float f) {
        this.mImageMatrix.mWarmth = f;
        this.mImageMatrix.updateMatrix(this);
    }

    static class ImageMatrix {
        float[] m = new float[20];
        float mBrightness = 1.0f;
        ColorMatrix mColorMatrix = new ColorMatrix();
        float mContrast = 1.0f;
        float mSaturation = 1.0f;
        ColorMatrix mTmpColorMatrix = new ColorMatrix();
        float mWarmth = 1.0f;

        ImageMatrix() {
        }

        private void brightness(float f) {
            float[] fArray = this.m;
            fArray[0] = f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
            fArray[4] = 0.0f;
            fArray[5] = 0.0f;
            fArray[6] = f;
            fArray[7] = 0.0f;
            fArray[8] = 0.0f;
            fArray[9] = 0.0f;
            fArray[10] = 0.0f;
            fArray[11] = 0.0f;
            fArray[12] = f;
            fArray[13] = 0.0f;
            fArray[14] = 0.0f;
            fArray[15] = 0.0f;
            fArray[16] = 0.0f;
            fArray[17] = 0.0f;
            fArray[18] = 1.0f;
            fArray[19] = 0.0f;
        }

        private void saturation(float f) {
            float f2 = 1.0f - f;
            float f3 = 0.2999f * f2;
            float f4 = 0.587f * f2;
            float[] fArray = this.m;
            fArray[0] = f3 + f;
            fArray[1] = f4;
            fArray[2] = f2 *= 0.114f;
            fArray[3] = 0.0f;
            fArray[4] = 0.0f;
            fArray[5] = f3;
            fArray[6] = f4 + f;
            fArray[7] = f2;
            fArray[8] = 0.0f;
            fArray[9] = 0.0f;
            fArray[10] = f3;
            fArray[11] = f4;
            fArray[12] = f2 + f;
            fArray[13] = 0.0f;
            fArray[14] = 0.0f;
            fArray[15] = 0.0f;
            fArray[16] = 0.0f;
            fArray[17] = 0.0f;
            fArray[18] = 1.0f;
            fArray[19] = 0.0f;
        }

        private void warmth(float f) {
            float f2;
            float f3 = f;
            if (f <= 0.0f) {
                f3 = 0.01f;
            }
            if ((f = 5000.0f / f3 / 100.0f) > 66.0f) {
                double d = f - 60.0f;
                f2 = (float)Math.pow(d, -0.13320475816726685) * 329.69873f;
                f3 = (float)Math.pow(d, 0.07551484555006027) * 288.12216f;
            } else {
                f3 = (float)Math.log(f) * 99.4708f - 161.11957f;
                f2 = 255.0f;
            }
            f = f < 66.0f ? (f > 19.0f ? (float)Math.log(f - 10.0f) * 138.51773f - 305.0448f : 0.0f) : 255.0f;
            f2 = Math.min(255.0f, Math.max(f2, 0.0f));
            f3 = Math.min(255.0f, Math.max(f3, 0.0f));
            f = Math.min(255.0f, Math.max(f, 0.0f));
            float f4 = (float)Math.log(50.0f);
            float f5 = (float)Math.log(40.0f);
            float f6 = Math.min(255.0f, Math.max(255.0f, 0.0f));
            f4 = Math.min(255.0f, Math.max(f4 * 99.4708f - 161.11957f, 0.0f));
            f5 = Math.min(255.0f, Math.max(f5 * 138.51773f - 305.0448f, 0.0f));
            f3 /= f4;
            f /= f5;
            float[] fArray = this.m;
            fArray[0] = f2 /= f6;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
            fArray[4] = 0.0f;
            fArray[5] = 0.0f;
            fArray[6] = f3;
            fArray[7] = 0.0f;
            fArray[8] = 0.0f;
            fArray[9] = 0.0f;
            fArray[10] = 0.0f;
            fArray[11] = 0.0f;
            fArray[12] = f;
            fArray[13] = 0.0f;
            fArray[14] = 0.0f;
            fArray[15] = 0.0f;
            fArray[16] = 0.0f;
            fArray[17] = 0.0f;
            fArray[18] = 1.0f;
            fArray[19] = 0.0f;
        }

        void updateMatrix(ImageView imageView) {
            boolean bl;
            this.mColorMatrix.reset();
            float f = this.mSaturation;
            boolean bl2 = true;
            if (f != 1.0f) {
                this.saturation(f);
                this.mColorMatrix.set(this.m);
                bl = true;
            } else {
                bl = false;
            }
            f = this.mContrast;
            if (f != 1.0f) {
                this.mTmpColorMatrix.setScale(f, f, f, 1.0f);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                bl = true;
            }
            if ((f = this.mWarmth) != 1.0f) {
                this.warmth(f);
                this.mTmpColorMatrix.set(this.m);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                bl = true;
            }
            if ((f = this.mBrightness) != 1.0f) {
                this.brightness(f);
                this.mTmpColorMatrix.set(this.m);
                this.mColorMatrix.postConcat(this.mTmpColorMatrix);
                bl = bl2;
            }
            if (bl) {
                imageView.setColorFilter((ColorFilter)new ColorMatrixColorFilter(this.mColorMatrix));
            } else {
                imageView.clearColorFilter();
            }
        }
    }
}

