/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.appcompat.widget.AppCompatButton;
import androidx.constraintlayout.widget.R;

public class MotionButton
extends AppCompatButton {
    private Path mPath;
    RectF mRect;
    private float mRound = Float.NaN;
    private float mRoundPercent = 0.0f;
    ViewOutlineProvider mViewOutlineProvider;

    public MotionButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public MotionButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context, attributeSet);
    }

    public MotionButton(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context, attributeSet);
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.setPadding(0, 0, 0, 0);
        if (attributeSet != null) {
            context = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ImageFilterView);
            int n = context.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = context.getIndex(i);
                if (n2 == R.styleable.ImageFilterView_round) {
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(context.getDimension(n2, 0.0f));
                    continue;
                }
                if (n2 != R.styleable.ImageFilterView_roundPercent || Build.VERSION.SDK_INT < 21) continue;
                this.setRoundPercent(context.getFloat(n2, 0.0f));
            }
            context.recycle();
        }
    }

    public void draw(Canvas canvas) {
        boolean bl;
        if (Build.VERSION.SDK_INT < 21 && this.mRound != 0.0f && this.mPath != null) {
            bl = true;
            canvas.save();
            canvas.clipPath(this.mPath);
        } else {
            bl = false;
        }
        super.draw(canvas);
        if (bl) {
            canvas.restore();
        }
    }

    public float getRound() {
        return this.mRound;
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public void setRound(float f) {
        if (Float.isNaN(f)) {
            this.mRound = f;
            f = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(f);
            return;
        }
        boolean bl = this.mRound != f;
        this.mRound = f;
        if (f != 0.0f) {
            ViewOutlineProvider viewOutlineProvider;
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, MotionButton.this.getWidth(), MotionButton.this.getHeight(), MotionButton.this.mRound);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            viewOutlineProvider = this.mPath;
            RectF rectF = this.mRect;
            f = this.mRound;
            viewOutlineProvider.addRoundRect(rectF, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setRoundPercent(float f) {
        boolean bl = this.mRoundPercent != f;
        this.mRoundPercent = f;
        if (f != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    ViewOutlineProvider viewOutlineProvider;
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int n = MotionButton.this.getWidth();
                            int n2 = MotionButton.this.getHeight();
                            outline.setRoundRect(0, 0, n, n2, (float)Math.min(n, n2) * MotionButton.this.mRoundPercent / 2.0f);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            f = (float)Math.min(n, n2) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }
}

