/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.Layout;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.appcompat.R;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.FloatLayout;
import androidx.constraintlayout.widget.R;

public class MotionLabel
extends View
implements FloatLayout {
    private static final int MONOSPACE = 3;
    private static final int SANS = 1;
    private static final int SERIF = 2;
    static String TAG = "MotionLabel";
    private boolean mAutoSize = false;
    private int mAutoSizeTextType = 0;
    float mBackgroundPanX;
    float mBackgroundPanY;
    private float mBaseTextSize;
    private float mDeltaLeft;
    private float mFloatHeight;
    private float mFloatWidth;
    private String mFontFamily;
    private int mGravity = 0x800033;
    private Layout mLayout;
    boolean mNotBuilt = true;
    Matrix mOutlinePositionMatrix;
    private int mPaddingBottom = 1;
    private int mPaddingLeft = 1;
    private int mPaddingRight = 1;
    private int mPaddingTop = 1;
    TextPaint mPaint = new TextPaint();
    Path mPath = new Path();
    RectF mRect;
    float mRotate;
    private float mRound = Float.NaN;
    private float mRoundPercent = 0.0f;
    private int mStyleIndex;
    Paint mTempPaint;
    Rect mTempRect;
    private String mText = "Hello World";
    private Drawable mTextBackground;
    private Bitmap mTextBackgroundBitmap;
    private Rect mTextBounds;
    private int mTextFillColor = 65535;
    private int mTextOutlineColor = 65535;
    private float mTextOutlineThickness = 0.0f;
    private float mTextPanX = 0.0f;
    private float mTextPanY = 0.0f;
    private BitmapShader mTextShader;
    private Matrix mTextShaderMatrix;
    private float mTextSize = 48.0f;
    private int mTextureEffect = 0;
    private float mTextureHeight;
    private float mTextureWidth;
    private CharSequence mTransformed;
    private int mTypefaceIndex;
    private boolean mUseOutline = false;
    ViewOutlineProvider mViewOutlineProvider;
    float mZoom;
    Paint paintCache;
    float paintTextSize;

    public MotionLabel(Context context) {
        super(context);
        this.mBaseTextSize = Float.NaN;
        this.mTextBounds = new Rect();
        this.mTextureHeight = Float.NaN;
        this.mTextureWidth = Float.NaN;
        this.paintCache = new Paint();
        this.mBackgroundPanX = Float.NaN;
        this.mBackgroundPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, null);
    }

    public MotionLabel(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mBaseTextSize = Float.NaN;
        this.mTextBounds = new Rect();
        this.mTextureHeight = Float.NaN;
        this.mTextureWidth = Float.NaN;
        this.paintCache = new Paint();
        this.mBackgroundPanX = Float.NaN;
        this.mBackgroundPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, attributeSet);
    }

    public MotionLabel(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mBaseTextSize = Float.NaN;
        this.mTextBounds = new Rect();
        this.mTextureHeight = Float.NaN;
        this.mTextureWidth = Float.NaN;
        this.paintCache = new Paint();
        this.mBackgroundPanX = Float.NaN;
        this.mBackgroundPanY = Float.NaN;
        this.mZoom = Float.NaN;
        this.mRotate = Float.NaN;
        this.init(context, attributeSet);
    }

    private void adjustTexture(float f, float f2, float f3, float f4) {
        if (this.mTextShaderMatrix == null) {
            return;
        }
        this.mFloatWidth = f3 - f;
        this.mFloatHeight = f4 - f2;
        this.updateShaderMatrix();
    }

    private float getHorizontalOffset() {
        float f = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        TextPaint textPaint = this.mPaint;
        String string2 = this.mText;
        float f2 = textPaint.measureText(string2, 0, string2.length());
        float f3 = Float.isNaN(this.mFloatWidth) ? (float)this.getMeasuredWidth() : this.mFloatWidth;
        return (f3 - (float)this.getPaddingLeft() - (float)this.getPaddingRight() - f * f2) * (this.mTextPanX + 1.0f) / 2.0f;
    }

    private float getVerticalOffset() {
        float f = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        float f2 = Float.isNaN(this.mFloatHeight) ? (float)this.getMeasuredHeight() : this.mFloatHeight;
        return (f2 - (float)this.getPaddingTop() - (float)this.getPaddingBottom() - (fontMetrics.descent - fontMetrics.ascent) * f) * (1.0f - this.mTextPanY) / 2.0f - f * fontMetrics.ascent;
    }

    private void init(Context context, AttributeSet attributeSet) {
        this.setUpTheme(context, attributeSet);
        if (attributeSet != null) {
            context = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.MotionLabel);
            int n = context.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = context.getIndex(i);
                if (n2 == R.styleable.MotionLabel_android_text) {
                    this.setText(context.getText(n2));
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_fontFamily) {
                    this.mFontFamily = context.getString(n2);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_scaleFromTextSize) {
                    this.mBaseTextSize = context.getDimensionPixelSize(n2, (int)this.mBaseTextSize);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_textSize) {
                    this.mTextSize = context.getDimensionPixelSize(n2, (int)this.mTextSize);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_textStyle) {
                    this.mStyleIndex = context.getInt(n2, this.mStyleIndex);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_typeface) {
                    this.mTypefaceIndex = context.getInt(n2, this.mTypefaceIndex);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_textColor) {
                    this.mTextFillColor = context.getColor(n2, this.mTextFillColor);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_borderRound) {
                    this.mRound = context.getDimension(n2, this.mRound);
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRound(this.mRound);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_borderRoundPercent) {
                    this.mRoundPercent = context.getFloat(n2, this.mRoundPercent);
                    if (Build.VERSION.SDK_INT < 21) continue;
                    this.setRoundPercent(this.mRoundPercent);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_gravity) {
                    this.setGravity(context.getInt(n2, -1));
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_android_autoSizeTextType) {
                    this.mAutoSizeTextType = context.getInt(n2, 0);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textOutlineColor) {
                    this.mTextOutlineColor = context.getInt(n2, this.mTextOutlineColor);
                    this.mUseOutline = true;
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textOutlineThickness) {
                    this.mTextOutlineThickness = context.getDimension(n2, this.mTextOutlineThickness);
                    this.mUseOutline = true;
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textBackground) {
                    this.mTextBackground = context.getDrawable(n2);
                    this.mUseOutline = true;
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textBackgroundPanX) {
                    this.mBackgroundPanX = context.getFloat(n2, this.mBackgroundPanX);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textBackgroundPanY) {
                    this.mBackgroundPanY = context.getFloat(n2, this.mBackgroundPanY);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textPanX) {
                    this.mTextPanX = context.getFloat(n2, this.mTextPanX);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textPanY) {
                    this.mTextPanY = context.getFloat(n2, this.mTextPanY);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textBackgroundRotate) {
                    this.mRotate = context.getFloat(n2, this.mRotate);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textBackgroundZoom) {
                    this.mZoom = context.getFloat(n2, this.mZoom);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textureHeight) {
                    this.mTextureHeight = context.getDimension(n2, this.mTextureHeight);
                    continue;
                }
                if (n2 == R.styleable.MotionLabel_textureWidth) {
                    this.mTextureWidth = context.getDimension(n2, this.mTextureWidth);
                    continue;
                }
                if (n2 != R.styleable.MotionLabel_textureEffect) continue;
                this.mTextureEffect = context.getInt(n2, this.mTextureEffect);
            }
            context.recycle();
        }
        this.setupTexture();
        this.setupPath();
    }

    private void setTypefaceFromAttrs(String string2, int n, int n2) {
        if (string2 != null) {
            Typeface typeface = Typeface.create((String)string2, (int)n2);
            string2 = typeface;
            if (typeface != null) {
                this.setTypeface(typeface);
                return;
            }
        } else {
            string2 = null;
        }
        boolean bl = true;
        if (n != 1) {
            if (n != 2) {
                if (n == 3) {
                    string2 = Typeface.MONOSPACE;
                }
            } else {
                string2 = Typeface.SERIF;
            }
        } else {
            string2 = Typeface.SANS_SERIF;
        }
        float f = 0.0f;
        if (n2 > 0) {
            string2 = string2 == null ? Typeface.defaultFromStyle((int)n2) : Typeface.create((Typeface)string2, (int)n2);
            this.setTypeface((Typeface)string2);
            n = string2 != null ? string2.getStyle() : 0;
            string2 = this.mPaint;
            if (((n &= n2) & 1) == 0) {
                bl = false;
            }
            string2.setFakeBoldText(bl);
            string2 = this.mPaint;
            if ((n & 2) != 0) {
                f = -0.25f;
            }
            string2.setTextSkewX(f);
        } else {
            this.mPaint.setFakeBoldText(false);
            this.mPaint.setTextSkewX(0.0f);
            this.setTypeface((Typeface)string2);
        }
    }

    private void setUpTheme(Context context, AttributeSet attributeSet) {
        int n;
        attributeSet = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorPrimary, (TypedValue)attributeSet, true);
        context = this.mPaint;
        this.mTextFillColor = n = attributeSet.data;
        context.setColor(n);
    }

    private void setupTexture() {
        if (this.mTextBackground != null) {
            this.mTextShaderMatrix = new Matrix();
            int n = this.mTextBackground.getIntrinsicWidth();
            int n2 = this.mTextBackground.getIntrinsicHeight();
            int n3 = 128;
            int n4 = n;
            if (n <= 0) {
                n4 = n = this.getWidth();
                if (n == 0) {
                    n4 = Float.isNaN(this.mTextureWidth) ? 128 : (int)this.mTextureWidth;
                }
            }
            n = n2;
            if (n2 <= 0) {
                n = n2 = this.getHeight();
                if (n2 == 0) {
                    n = Float.isNaN(this.mTextureHeight) ? n3 : (int)this.mTextureHeight;
                }
            }
            n2 = n4;
            n3 = n;
            if (this.mTextureEffect != 0) {
                n2 = n4 / 2;
                n3 = n / 2;
            }
            this.mTextBackgroundBitmap = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(this.mTextBackgroundBitmap);
            this.mTextBackground.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            this.mTextBackground.setFilterBitmap(true);
            this.mTextBackground.draw(canvas);
            if (this.mTextureEffect != 0) {
                this.mTextBackgroundBitmap = this.blur(this.mTextBackgroundBitmap, 4);
            }
            this.mTextShader = new BitmapShader(this.mTextBackgroundBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        }
    }

    private void updateShaderMatrix() {
        boolean bl = Float.isNaN(this.mBackgroundPanX);
        float f = 0.0f;
        float f2 = bl ? 0.0f : this.mBackgroundPanX;
        float f3 = Float.isNaN(this.mBackgroundPanY) ? 0.0f : this.mBackgroundPanY;
        float f4 = Float.isNaN(this.mZoom) ? 1.0f : this.mZoom;
        if (!Float.isNaN(this.mRotate)) {
            f = this.mRotate;
        }
        this.mTextShaderMatrix.reset();
        float f5 = this.mTextBackgroundBitmap.getWidth();
        float f6 = this.mTextBackgroundBitmap.getHeight();
        float f7 = Float.isNaN(this.mTextureWidth) ? this.mFloatWidth : this.mTextureWidth;
        float f8 = Float.isNaN(this.mTextureHeight) ? this.mFloatHeight : this.mTextureHeight;
        float f9 = f5 * f8 < f6 * f7 ? f7 / f5 : f8 / f6;
        this.mTextShaderMatrix.postScale(f4 *= f9, f4);
        f9 = f7 - (f5 *= f4);
        f6 = f4 * f6;
        f4 = f8 - f6;
        if (!Float.isNaN(this.mTextureHeight)) {
            f4 = this.mTextureHeight / 2.0f;
        }
        if (!Float.isNaN(this.mTextureWidth)) {
            f9 = this.mTextureWidth / 2.0f;
        }
        this.mTextShaderMatrix.postTranslate((f2 * f9 + f7 - f5) * 0.5f, (f3 * f4 + f8 - f6) * 0.5f);
        this.mTextShaderMatrix.postRotate(f, f7 / 2.0f, f8 / 2.0f);
        this.mTextShader.setLocalMatrix(this.mTextShaderMatrix);
    }

    Bitmap blur(Bitmap bitmap, int n) {
        System.nanoTime();
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        int n4 = n2 / 2;
        n2 = n3 / 2;
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n4, (int)n2, (boolean)true);
        for (n3 = 0; n3 < n && n4 >= 32 && n2 >= 32; ++n3) {
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)(n4 /= 2), (int)(n2 /= 2), (boolean)true);
        }
        return bitmap;
    }

    void buildShape(float f) {
        if (!this.mUseOutline && f == 1.0f) {
            return;
        }
        this.mPath.reset();
        CharSequence charSequence = this.mText;
        int n = ((String)charSequence).length();
        this.mPaint.getTextBounds((String)charSequence, 0, n, this.mTextBounds);
        this.mPaint.getTextPath((String)charSequence, 0, n, 0.0f, 0.0f, this.mPath);
        if (f != 1.0f) {
            String string2 = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(Debug.getLoc());
            ((StringBuilder)charSequence).append(" scale ");
            ((StringBuilder)charSequence).append(f);
            Log.v((String)string2, (String)((StringBuilder)charSequence).toString());
            charSequence = new Matrix();
            charSequence.postScale(f, f);
            this.mPath.transform((Matrix)charSequence);
        }
        charSequence = this.mTextBounds;
        --((Rect)charSequence).right;
        charSequence = this.mTextBounds;
        ++((Rect)charSequence).left;
        charSequence = this.mTextBounds;
        ++((Rect)charSequence).bottom;
        charSequence = this.mTextBounds;
        --((Rect)charSequence).top;
        charSequence = new RectF();
        ((RectF)charSequence).bottom = this.getHeight();
        ((RectF)charSequence).right = this.getWidth();
        this.mNotBuilt = false;
    }

    public float getRound() {
        return this.mRound;
    }

    public float getRoundPercent() {
        return this.mRoundPercent;
    }

    public float getScaleFromTextSize() {
        return this.mBaseTextSize;
    }

    public float getTextBackgroundPanX() {
        return this.mBackgroundPanX;
    }

    public float getTextBackgroundPanY() {
        return this.mBackgroundPanY;
    }

    public float getTextBackgroundRotate() {
        return this.mRotate;
    }

    public float getTextBackgroundZoom() {
        return this.mZoom;
    }

    public int getTextOutlineColor() {
        return this.mTextOutlineColor;
    }

    public float getTextPanX() {
        return this.mTextPanX;
    }

    public float getTextPanY() {
        return this.mTextPanY;
    }

    public float getTextureHeight() {
        return this.mTextureHeight;
    }

    public float getTextureWidth() {
        return this.mTextureWidth;
    }

    public Typeface getTypeface() {
        return this.mPaint.getTypeface();
    }

    @Override
    public void layout(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        int n = (int)(f + 0.5f);
        this.mDeltaLeft = f - (float)n;
        int n2 = (int)(f3 + 0.5f);
        int n3 = n2 - n;
        int n4 = (int)(f4 + 0.5f);
        int n5 = (int)(0.5f + f2);
        int n6 = n4 - n5;
        this.mFloatWidth = f6 = f3 - f;
        this.mFloatHeight = f5 = f4 - f2;
        this.adjustTexture(f, f2, f3, f4);
        if (this.getMeasuredHeight() == n6 && this.getMeasuredWidth() == n3) {
            super.layout(n, n5, n2, n4);
        } else {
            this.measure(View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000));
            super.layout(n, n5, n2, n4);
        }
        if (this.mAutoSize) {
            if (this.mTempRect == null) {
                this.mTempPaint = new Paint();
                this.mTempRect = new Rect();
                this.mTempPaint.set((Paint)this.mPaint);
                this.paintTextSize = this.mTempPaint.getTextSize();
            }
            this.mFloatWidth = f6;
            this.mFloatHeight = f5;
            Paint paint = this.mTempPaint;
            String string2 = this.mText;
            paint.getTextBounds(string2, 0, string2.length(), this.mTempRect);
            n3 = this.mTempRect.width();
            f = (float)this.mTempRect.height() * 1.3f;
            f2 = f6 - (float)this.mPaddingRight - (float)this.mPaddingLeft;
            f4 = f5 - (float)this.mPaddingBottom - (float)this.mPaddingTop;
            f3 = n3;
            if (f3 * f4 > f * f2) {
                this.mPaint.setTextSize(this.paintTextSize * f2 / f3);
            } else {
                this.mPaint.setTextSize(this.paintTextSize * f4 / f);
            }
            if (this.mUseOutline || !Float.isNaN(this.mBaseTextSize)) {
                f = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
                this.buildShape(f);
            }
        }
    }

    public void layout(int n, int n2, int n3, int n4) {
        super.layout(n, n2, n3, n4);
        boolean bl = Float.isNaN(this.mBaseTextSize);
        float f = bl ? 1.0f : this.mTextSize / this.mBaseTextSize;
        this.mFloatWidth = n3 - n;
        this.mFloatHeight = n4 - n2;
        float f2 = f;
        if (this.mAutoSize) {
            if (this.mTempRect == null) {
                this.mTempPaint = new Paint();
                this.mTempRect = new Rect();
                this.mTempPaint.set((Paint)this.mPaint);
                this.paintTextSize = this.mTempPaint.getTextSize();
            }
            Paint paint = this.mTempPaint;
            String string2 = this.mText;
            paint.getTextBounds(string2, 0, string2.length(), this.mTempRect);
            int n5 = this.mTempRect.width();
            int n6 = (int)((float)this.mTempRect.height() * 1.3f);
            f2 = this.mFloatWidth - (float)this.mPaddingRight - (float)this.mPaddingLeft;
            float f3 = this.mFloatHeight - (float)this.mPaddingBottom - (float)this.mPaddingTop;
            if (bl) {
                float f4 = n5;
                float f5 = n6;
                if (f4 * f3 > f5 * f2) {
                    this.mPaint.setTextSize(this.paintTextSize * f2 / f4);
                    f2 = f;
                } else {
                    this.mPaint.setTextSize(this.paintTextSize * f3 / f5);
                    f2 = f;
                }
            } else {
                float f6 = n5;
                f = n6;
                f2 = f6 * f3 > f * f2 ? (f2 /= f6) : f3 / f;
            }
        }
        if (this.mUseOutline || !bl) {
            this.adjustTexture(n, n2, n3, n4);
            this.buildShape(f2);
        }
    }

    protected void onDraw(Canvas canvas) {
        float f = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        super.onDraw(canvas);
        if (!this.mUseOutline && f == 1.0f) {
            float f2 = this.mPaddingLeft;
            float f3 = this.getHorizontalOffset();
            float f4 = this.mPaddingTop;
            f = this.getVerticalOffset();
            canvas.drawText(this.mText, this.mDeltaLeft + (f2 + f3), f4 + f, (Paint)this.mPaint);
            return;
        }
        if (this.mNotBuilt) {
            this.buildShape(f);
        }
        if (this.mOutlinePositionMatrix == null) {
            this.mOutlinePositionMatrix = new Matrix();
        }
        if (this.mUseOutline) {
            this.paintCache.set((Paint)this.mPaint);
            this.mOutlinePositionMatrix.reset();
            float f5 = (float)this.mPaddingLeft + this.getHorizontalOffset();
            float f6 = (float)this.mPaddingTop + this.getVerticalOffset();
            this.mOutlinePositionMatrix.postTranslate(f5, f6);
            this.mOutlinePositionMatrix.preScale(f, f);
            this.mPath.transform(this.mOutlinePositionMatrix);
            if (this.mTextShader != null) {
                this.mPaint.setFilterBitmap(true);
                this.mPaint.setShader((Shader)this.mTextShader);
            } else {
                this.mPaint.setColor(this.mTextFillColor);
            }
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
            canvas.drawPath(this.mPath, (Paint)this.mPaint);
            if (this.mTextShader != null) {
                this.mPaint.setShader(null);
            }
            this.mPaint.setColor(this.mTextOutlineColor);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
            canvas.drawPath(this.mPath, (Paint)this.mPaint);
            this.mOutlinePositionMatrix.reset();
            this.mOutlinePositionMatrix.postTranslate(-f5, -f6);
            this.mPath.transform(this.mOutlinePositionMatrix);
            this.mPaint.set(this.paintCache);
        } else {
            float f7 = (float)this.mPaddingLeft + this.getHorizontalOffset();
            f = (float)this.mPaddingTop + this.getVerticalOffset();
            this.mOutlinePositionMatrix.reset();
            this.mOutlinePositionMatrix.preTranslate(f7, f);
            this.mPath.transform(this.mOutlinePositionMatrix);
            this.mPaint.setColor(this.mTextFillColor);
            this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
            this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
            canvas.drawPath(this.mPath, (Paint)this.mPaint);
            this.mOutlinePositionMatrix.reset();
            this.mOutlinePositionMatrix.preTranslate(-f7, -f);
            this.mPath.transform(this.mOutlinePositionMatrix);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = View.MeasureSpec.getMode((int)n2);
        n = View.MeasureSpec.getSize((int)n);
        int n5 = View.MeasureSpec.getSize((int)n2);
        this.mAutoSize = false;
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingBottom = this.getPaddingBottom();
        if (n3 == 0x40000000 && n4 == 0x40000000) {
            n2 = n;
            n3 = n5;
            if (this.mAutoSizeTextType != 0) {
                this.mAutoSize = true;
                n2 = n;
                n3 = n5;
            }
        } else {
            int n6;
            TextPaint textPaint = this.mPaint;
            String string2 = this.mText;
            textPaint.getTextBounds(string2, 0, string2.length(), this.mTextBounds);
            if (n3 != 0x40000000) {
                n = (int)((float)this.mTextBounds.width() + 0.99999f);
            }
            n2 = n6 = n + (this.mPaddingLeft + this.mPaddingRight);
            n3 = n5;
            if (n4 != 0x40000000) {
                n = n2 = (int)((float)this.mPaint.getFontMetricsInt(null) + 0.99999f);
                if (n4 == Integer.MIN_VALUE) {
                    n = Math.min(n5, n2);
                }
                n3 = this.mPaddingTop + this.mPaddingBottom + n;
                n2 = n6;
            }
        }
        this.setMeasuredDimension(n2, n3);
    }

    /*
     * Unable to fully structure code
     */
    public void setGravity(int var1_1) {
        block7: {
            block6: {
                var2_2 = var1_1;
                if ((var1_1 & 0x800007) == 0) {
                    var2_2 = var1_1 | 0x800003;
                }
                var1_1 = var2_2;
                if ((var2_2 & 112) == 0) {
                    var1_1 = var2_2 | 48;
                }
                if (var1_1 != this.mGravity) {
                    this.invalidate();
                }
                this.mGravity = var1_1;
                var2_2 = var1_1 & 112;
                this.mTextPanY = var2_2 != 48 ? (var2_2 != 80 ? 0.0f : 1.0f) : -1.0f;
                if ((var1_1 &= 0x800007) == 3) break block6;
                if (var1_1 == 5) ** GOTO lbl-1000
                if (var1_1 != 0x800003) {
                    ** if (var1_1 == 0x800005) goto lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        this.mTextPanX = 0.0f;
                        ** GOTO lbl23
                    }
                }
                break block6;
lbl-1000:
                // 2 sources

                {
                    this.mTextPanX = 1.0f;
                }
                break block7;
            }
            this.mTextPanX = -1.0f;
        }
    }

    public void setRound(float f) {
        if (Float.isNaN(f)) {
            this.mRound = f;
            f = this.mRoundPercent;
            this.mRoundPercent = -1.0f;
            this.setRoundPercent(f);
            return;
        }
        boolean bl = this.mRound != f;
        this.mRound = f;
        if (f != 0.0f) {
            ViewOutlineProvider viewOutlineProvider;
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            outline.setRoundRect(0, 0, MotionLabel.this.getWidth(), MotionLabel.this.getHeight(), MotionLabel.this.mRound);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            Path path = this.mPath;
            viewOutlineProvider = this.mRect;
            f = this.mRound;
            path.addRoundRect((RectF)viewOutlineProvider, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setRoundPercent(float f) {
        boolean bl = this.mRoundPercent != f;
        this.mRoundPercent = f;
        if (f != 0.0f) {
            if (this.mPath == null) {
                this.mPath = new Path();
            }
            if (this.mRect == null) {
                this.mRect = new RectF();
            }
            if (Build.VERSION.SDK_INT >= 21) {
                if (this.mViewOutlineProvider == null) {
                    ViewOutlineProvider viewOutlineProvider;
                    this.mViewOutlineProvider = viewOutlineProvider = new ViewOutlineProvider(){

                        public void getOutline(View view, Outline outline) {
                            int n = MotionLabel.this.getWidth();
                            int n2 = MotionLabel.this.getHeight();
                            outline.setRoundRect(0, 0, n, n2, (float)Math.min(n, n2) * MotionLabel.this.mRoundPercent / 2.0f);
                        }
                    };
                    this.setOutlineProvider(viewOutlineProvider);
                }
                this.setClipToOutline(true);
            }
            int n = this.getWidth();
            int n2 = this.getHeight();
            f = (float)Math.min(n, n2) * this.mRoundPercent / 2.0f;
            this.mRect.set(0.0f, 0.0f, (float)n, (float)n2);
            this.mPath.reset();
            this.mPath.addRoundRect(this.mRect, f, f, Path.Direction.CW);
        } else if (Build.VERSION.SDK_INT >= 21) {
            this.setClipToOutline(false);
        }
        if (bl && Build.VERSION.SDK_INT >= 21) {
            this.invalidateOutline();
        }
    }

    public void setScaleFromTextSize(float f) {
        this.mBaseTextSize = f;
    }

    public void setText(CharSequence charSequence) {
        this.mText = charSequence.toString();
        this.invalidate();
    }

    public void setTextBackgroundPanX(float f) {
        this.mBackgroundPanX = f;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextBackgroundPanY(float f) {
        this.mBackgroundPanY = f;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextBackgroundRotate(float f) {
        this.mRotate = f;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextBackgroundZoom(float f) {
        this.mZoom = f;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextFillColor(int n) {
        this.mTextFillColor = n;
        this.invalidate();
    }

    public void setTextOutlineColor(int n) {
        this.mTextOutlineColor = n;
        this.mUseOutline = true;
        this.invalidate();
    }

    public void setTextOutlineThickness(float f) {
        this.mTextOutlineThickness = f;
        this.mUseOutline = true;
        if (Float.isNaN(f)) {
            this.mTextOutlineThickness = 1.0f;
            this.mUseOutline = false;
        }
        this.invalidate();
    }

    public void setTextPanX(float f) {
        this.mTextPanX = f;
        this.invalidate();
    }

    public void setTextPanY(float f) {
        this.mTextPanY = f;
        this.invalidate();
    }

    public void setTextSize(float f) {
        this.mTextSize = f;
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Debug.getLoc());
        stringBuilder.append("  ");
        stringBuilder.append(f);
        stringBuilder.append(" / ");
        stringBuilder.append(this.mBaseTextSize);
        Log.v((String)string2, (String)stringBuilder.toString());
        string2 = this.mPaint;
        if (!Float.isNaN(this.mBaseTextSize)) {
            f = this.mBaseTextSize;
        }
        string2.setTextSize(f);
        f = Float.isNaN(this.mBaseTextSize) ? 1.0f : this.mTextSize / this.mBaseTextSize;
        this.buildShape(f);
        this.requestLayout();
        this.invalidate();
    }

    public void setTextureHeight(float f) {
        this.mTextureHeight = f;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTextureWidth(float f) {
        this.mTextureWidth = f;
        this.updateShaderMatrix();
        this.invalidate();
    }

    public void setTypeface(Typeface typeface) {
        if (this.mPaint.getTypeface() != typeface) {
            this.mPaint.setTypeface(typeface);
            if (this.mLayout != null) {
                this.mLayout = null;
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    void setupPath() {
        this.mPaddingLeft = this.getPaddingLeft();
        this.mPaddingRight = this.getPaddingRight();
        this.mPaddingTop = this.getPaddingTop();
        this.mPaddingBottom = this.getPaddingBottom();
        this.setTypefaceFromAttrs(this.mFontFamily, this.mTypefaceIndex, this.mStyleIndex);
        this.mPaint.setColor(this.mTextFillColor);
        this.mPaint.setStrokeWidth(this.mTextOutlineThickness);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.mPaint.setFlags(128);
        this.setTextSize(this.mTextSize);
        this.mPaint.setAntiAlias(true);
    }
}

