/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import androidx.constraintlayout.widget.R;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class ConstraintAttribute {
    private static final String TAG = "TransitionLayout";
    boolean mBooleanValue;
    private int mColorValue;
    private float mFloatValue;
    private int mIntegerValue;
    private boolean mMethod = false;
    String mName;
    private String mStringValue;
    private AttributeType mType;

    public ConstraintAttribute(ConstraintAttribute constraintAttribute, Object object) {
        this.mName = constraintAttribute.mName;
        this.mType = constraintAttribute.mType;
        this.setValue(object);
    }

    public ConstraintAttribute(String string2, AttributeType attributeType) {
        this.mName = string2;
        this.mType = attributeType;
    }

    public ConstraintAttribute(String string2, AttributeType attributeType, Object object, boolean bl) {
        this.mName = string2;
        this.mType = attributeType;
        this.mMethod = bl;
        this.setValue(object);
    }

    private static int clamp(int n) {
        n = (n & n >> 31) - 255;
        return (n & n >> 31) + 255;
    }

    public static HashMap<String, ConstraintAttribute> extractAttributes(HashMap<String, ConstraintAttribute> hashMap, View view) {
        HashMap<String, ConstraintAttribute> hashMap2 = new HashMap<String, ConstraintAttribute>();
        Class<?> clazz = view.getClass();
        for (String string2 : hashMap.keySet()) {
            ConstraintAttribute constraintAttribute = hashMap.get(string2);
            try {
                Object object;
                if (string2.equals("BackgroundColor")) {
                    int n = ((ColorDrawable)view.getBackground()).getColor();
                    object = new ConstraintAttribute(constraintAttribute, n);
                    hashMap2.put(string2, (ConstraintAttribute)object);
                    continue;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("getMap");
                ((StringBuilder)object).append(string2);
                Object object2 = clazz.getMethod(((StringBuilder)object).toString(), new Class[0]).invoke((Object)view, new Object[0]);
                object = new ConstraintAttribute(constraintAttribute, object2);
                hashMap2.put(string2, (ConstraintAttribute)object);
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void parse(Context context, XmlPullParser object, HashMap<String, ConstraintAttribute> hashMap) {
        Boolean bl;
        TypedArray typedArray = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)object), R.styleable.CustomAttribute);
        int n = typedArray.getIndexCount();
        String string2 = null;
        Boolean bl2 = bl = null;
        boolean bl3 = false;
        for (int i = 0; i < n; ++i) {
            void var12_12;
            boolean bl4;
            Object object2;
            block12: {
                block16: {
                    int n2;
                    int n3;
                    block22: {
                        block21: {
                            block20: {
                                block19: {
                                    block18: {
                                        block17: {
                                            block15: {
                                                block14: {
                                                    block13: {
                                                        block11: {
                                                            n3 = typedArray.getIndex(i);
                                                            if (n3 != R.styleable.CustomAttribute_attributeName) break block11;
                                                            string2 = typedArray.getString(n3);
                                                            object = string2;
                                                            object2 = bl;
                                                            Boolean bl5 = bl2;
                                                            bl4 = bl3;
                                                            if (string2 != null) {
                                                                object = string2;
                                                                object2 = bl;
                                                                Boolean bl6 = bl2;
                                                                bl4 = bl3;
                                                                if (string2.length() > 0) {
                                                                    object = new StringBuilder();
                                                                    ((StringBuilder)object).append(Character.toUpperCase(string2.charAt(0)));
                                                                    ((StringBuilder)object).append(string2.substring(1));
                                                                    object = ((StringBuilder)object).toString();
                                                                    object2 = bl;
                                                                    Boolean bl7 = bl2;
                                                                    bl4 = bl3;
                                                                }
                                                            }
                                                            break block12;
                                                        }
                                                        if (n3 != R.styleable.CustomAttribute_methodName) break block13;
                                                        object = typedArray.getString(n3);
                                                        bl4 = true;
                                                        object2 = bl;
                                                        Boolean bl8 = bl2;
                                                        break block12;
                                                    }
                                                    if (n3 != R.styleable.CustomAttribute_customBoolean) break block14;
                                                    object2 = typedArray.getBoolean(n3, false);
                                                    AttributeType attributeType = AttributeType.BOOLEAN_TYPE;
                                                    object = string2;
                                                    bl4 = bl3;
                                                    break block12;
                                                }
                                                if (n3 != R.styleable.CustomAttribute_customColorValue) break block15;
                                                object = AttributeType.COLOR_TYPE;
                                                object2 = typedArray.getColor(n3, 0);
                                                break block16;
                                            }
                                            if (n3 != R.styleable.CustomAttribute_customColorDrawableValue) break block17;
                                            object = AttributeType.COLOR_DRAWABLE_TYPE;
                                            object2 = typedArray.getColor(n3, 0);
                                            break block16;
                                        }
                                        if (n3 != R.styleable.CustomAttribute_customPixelDimension) break block18;
                                        object = AttributeType.DIMENSION_TYPE;
                                        object2 = Float.valueOf(TypedValue.applyDimension((int)1, (float)typedArray.getDimension(n3, 0.0f), (DisplayMetrics)context.getResources().getDisplayMetrics()));
                                        break block16;
                                    }
                                    if (n3 != R.styleable.CustomAttribute_customDimension) break block19;
                                    object = AttributeType.DIMENSION_TYPE;
                                    object2 = Float.valueOf(typedArray.getDimension(n3, 0.0f));
                                    break block16;
                                }
                                if (n3 != R.styleable.CustomAttribute_customFloatValue) break block20;
                                object = AttributeType.FLOAT_TYPE;
                                object2 = Float.valueOf(typedArray.getFloat(n3, Float.NaN));
                                break block16;
                            }
                            if (n3 != R.styleable.CustomAttribute_customIntegerValue) break block21;
                            object = AttributeType.INT_TYPE;
                            object2 = typedArray.getInteger(n3, -1);
                            break block16;
                        }
                        if (n3 != R.styleable.CustomAttribute_customStringValue) break block22;
                        object = AttributeType.STRING_TYPE;
                        object2 = typedArray.getString(n3);
                        break block16;
                    }
                    object = string2;
                    object2 = bl;
                    Boolean bl9 = bl2;
                    bl4 = bl3;
                    if (n3 != R.styleable.CustomAttribute_customReference) break block12;
                    object = AttributeType.REFERENCE_TYPE;
                    int n4 = n2 = typedArray.getResourceId(n3, -1);
                    if (n2 == -1) {
                        n4 = typedArray.getInt(n3, -1);
                    }
                    object2 = n4;
                }
                Object object3 = object;
                object = string2;
                bl4 = bl3;
            }
            string2 = object;
            bl = object2;
            bl2 = var12_12;
            bl3 = bl4;
        }
        if (string2 != null && bl != null) {
            hashMap.put(string2, new ConstraintAttribute(string2, (AttributeType)((Object)bl2), bl, bl3));
        }
        typedArray.recycle();
    }

    public static void setAttributes(View view, HashMap<String, ConstraintAttribute> hashMap) {
        Class<?> clazz = view.getClass();
        block14: for (String string2 : hashMap.keySet()) {
            CharSequence illegalAccessException;
            Object object = hashMap.get(string2);
            if (!((ConstraintAttribute)object).mMethod) {
                illegalAccessException = new StringBuilder();
                ((StringBuilder)illegalAccessException).append("set");
                ((StringBuilder)illegalAccessException).append(string2);
                illegalAccessException = ((StringBuilder)illegalAccessException).toString();
            } else {
                illegalAccessException = string2;
            }
            try {
                switch (1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[((ConstraintAttribute)object).mType.ordinal()]) {
                    default: {
                        continue block14;
                    }
                    case 8: {
                        clazz.getMethod((String)illegalAccessException, Float.TYPE).invoke((Object)view, Float.valueOf(((ConstraintAttribute)object).mFloatValue));
                        continue block14;
                    }
                    case 7: {
                        clazz.getMethod((String)illegalAccessException, Float.TYPE).invoke((Object)view, Float.valueOf(((ConstraintAttribute)object).mFloatValue));
                        continue block14;
                    }
                    case 6: {
                        clazz.getMethod((String)illegalAccessException, Integer.TYPE).invoke((Object)view, ((ConstraintAttribute)object).mIntegerValue);
                        continue block14;
                    }
                    case 5: {
                        Method method = clazz.getMethod((String)illegalAccessException, Drawable.class);
                        ColorDrawable colorDrawable = new ColorDrawable();
                        colorDrawable.setColor(((ConstraintAttribute)object).mColorValue);
                        method.invoke((Object)view, colorDrawable);
                        continue block14;
                    }
                    case 4: {
                        clazz.getMethod((String)illegalAccessException, Integer.TYPE).invoke((Object)view, ((ConstraintAttribute)object).mColorValue);
                        continue block14;
                    }
                    case 3: {
                        clazz.getMethod((String)illegalAccessException, CharSequence.class).invoke((Object)view, ((ConstraintAttribute)object).mStringValue);
                        continue block14;
                    }
                    case 2: {
                        clazz.getMethod((String)illegalAccessException, Boolean.TYPE).invoke((Object)view, ((ConstraintAttribute)object).mBooleanValue);
                        continue block14;
                    }
                    case 1: 
                }
                clazz.getMethod((String)illegalAccessException, Integer.TYPE).invoke((Object)view, ((ConstraintAttribute)object).mIntegerValue);
            }
            catch (InvocationTargetException invocationTargetException) {
                object = new StringBuilder();
                ((StringBuilder)object).append(" Custom Attribute \"");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("\" not found on ");
                ((StringBuilder)object).append(clazz.getName());
                Log.e((String)TAG, (String)((StringBuilder)object).toString());
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException2) {
                object = new StringBuilder();
                ((StringBuilder)object).append(" Custom Attribute \"");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("\" not found on ");
                ((StringBuilder)object).append(clazz.getName());
                Log.e((String)TAG, (String)((StringBuilder)object).toString());
                illegalAccessException2.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Log.e((String)TAG, (String)noSuchMethodException.getMessage());
                object = new StringBuilder();
                ((StringBuilder)object).append(" Custom Attribute \"");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append("\" not found on ");
                ((StringBuilder)object).append(clazz.getName());
                Log.e((String)TAG, (String)((StringBuilder)object).toString());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(clazz.getName());
                stringBuilder.append(" must have a method ");
                stringBuilder.append((String)illegalAccessException);
                Log.e((String)TAG, (String)stringBuilder.toString());
            }
        }
    }

    public void applyCustom(View view) {
        CharSequence charSequence;
        Class<?> clazz = view.getClass();
        String string2 = this.mName;
        if (!this.mMethod) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("set");
            ((StringBuilder)charSequence).append(string2);
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            charSequence = string2;
        }
        try {
            switch (1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()]) {
                default: {
                    break;
                }
                case 8: {
                    clazz.getMethod((String)charSequence, Float.TYPE).invoke((Object)view, Float.valueOf(this.mFloatValue));
                    break;
                }
                case 7: {
                    clazz.getMethod((String)charSequence, Float.TYPE).invoke((Object)view, Float.valueOf(this.mFloatValue));
                    break;
                }
                case 5: {
                    Method method = clazz.getMethod((String)charSequence, Drawable.class);
                    ColorDrawable colorDrawable = new ColorDrawable();
                    colorDrawable.setColor(this.mColorValue);
                    method.invoke((Object)view, colorDrawable);
                    break;
                }
                case 4: {
                    clazz.getMethod((String)charSequence, Integer.TYPE).invoke((Object)view, this.mColorValue);
                    break;
                }
                case 3: {
                    clazz.getMethod((String)charSequence, CharSequence.class).invoke((Object)view, this.mStringValue);
                    break;
                }
                case 2: {
                    clazz.getMethod((String)charSequence, Boolean.TYPE).invoke((Object)view, this.mBooleanValue);
                    break;
                }
                case 1: 
                case 6: {
                    clazz.getMethod((String)charSequence, Integer.TYPE).invoke((Object)view, this.mIntegerValue);
                    break;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(" Custom Attribute \"");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append("\" not found on ");
            ((StringBuilder)charSequence).append(clazz.getName());
            Log.e((String)TAG, (String)((StringBuilder)charSequence).toString());
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(" Custom Attribute \"");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append("\" not found on ");
            ((StringBuilder)charSequence).append(clazz.getName());
            Log.e((String)TAG, (String)((StringBuilder)charSequence).toString());
            illegalAccessException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Log.e((String)TAG, (String)noSuchMethodException.getMessage());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(" Custom Attribute \"");
            stringBuilder.append(string2);
            stringBuilder.append("\" not found on ");
            stringBuilder.append(clazz.getName());
            Log.e((String)TAG, (String)stringBuilder.toString());
            stringBuilder = new StringBuilder();
            stringBuilder.append(clazz.getName());
            stringBuilder.append(" must have a method ");
            stringBuilder.append((String)charSequence);
            Log.e((String)TAG, (String)stringBuilder.toString());
        }
    }

    public boolean diff(ConstraintAttribute constraintAttribute) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = bl5;
        if (constraintAttribute != null) {
            if (this.mType != constraintAttribute.mType) {
                bl7 = bl5;
            } else {
                switch (1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()]) {
                    default: {
                        return false;
                    }
                    case 8: {
                        bl7 = bl6;
                        if (this.mFloatValue == constraintAttribute.mFloatValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 7: {
                        bl7 = bl;
                        if (this.mFloatValue == constraintAttribute.mFloatValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 4: 
                    case 5: {
                        bl7 = bl2;
                        if (this.mColorValue == constraintAttribute.mColorValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 3: {
                        bl7 = bl3;
                        if (this.mIntegerValue == constraintAttribute.mIntegerValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 2: {
                        bl7 = bl4;
                        if (this.mBooleanValue == constraintAttribute.mBooleanValue) {
                            bl7 = true;
                        }
                        return bl7;
                    }
                    case 1: 
                    case 6: 
                }
                bl7 = bl5;
                if (this.mIntegerValue == constraintAttribute.mIntegerValue) {
                    bl7 = true;
                }
            }
        }
        return bl7;
    }

    public int getColorValue() {
        return this.mColorValue;
    }

    public float getFloatValue() {
        return this.mFloatValue;
    }

    public int getIntegerValue() {
        return this.mIntegerValue;
    }

    public String getName() {
        return this.mName;
    }

    public String getStringValue() {
        return this.mStringValue;
    }

    public AttributeType getType() {
        return this.mType;
    }

    public float getValueToInterpolate() {
        switch (1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()]) {
            default: {
                return Float.NaN;
            }
            case 8: {
                return this.mFloatValue;
            }
            case 7: {
                return this.mFloatValue;
            }
            case 6: {
                return this.mIntegerValue;
            }
            case 4: 
            case 5: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 3: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case 2: 
        }
        float f = this.mBooleanValue ? 1.0f : 0.0f;
        return f;
    }

    public void getValuesToInterpolate(float[] fArray) {
        switch (1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()]) {
            default: {
                break;
            }
            case 8: {
                fArray[0] = this.mFloatValue;
                break;
            }
            case 7: {
                fArray[0] = this.mFloatValue;
                break;
            }
            case 6: {
                fArray[0] = this.mIntegerValue;
                break;
            }
            case 4: 
            case 5: {
                int n = this.mColorValue;
                float f = (float)Math.pow((float)(n >> 16 & 0xFF) / 255.0f, 2.2);
                float f2 = (float)Math.pow((float)(n >> 8 & 0xFF) / 255.0f, 2.2);
                float f3 = (float)Math.pow((float)(n & 0xFF) / 255.0f, 2.2);
                fArray[0] = f;
                fArray[1] = f2;
                fArray[2] = f3;
                fArray[3] = (float)(n >> 24 & 0xFF) / 255.0f;
                break;
            }
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 2: {
                float f = this.mBooleanValue ? 1.0f : 0.0f;
                fArray[0] = f;
            }
        }
    }

    public boolean isBooleanValue() {
        return this.mBooleanValue;
    }

    public boolean isContinuous() {
        int n = 1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()];
        return n != 1 && n != 2 && n != 3;
    }

    public boolean isMethod() {
        return this.mMethod;
    }

    public int numberOfInterpolatedValues() {
        int n = 1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()];
        if (n != 4 && n != 5) {
            return 1;
        }
        return 4;
    }

    public void setColorValue(int n) {
        this.mColorValue = n;
    }

    public void setFloatValue(float f) {
        this.mFloatValue = f;
    }

    public void setIntValue(int n) {
        this.mIntegerValue = n;
    }

    public void setStringValue(String string2) {
        this.mStringValue = string2;
    }

    public void setValue(Object object) {
        switch (1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()]) {
            default: {
                break;
            }
            case 8: {
                this.mFloatValue = ((Float)object).floatValue();
                break;
            }
            case 7: {
                this.mFloatValue = ((Float)object).floatValue();
                break;
            }
            case 4: 
            case 5: {
                this.mColorValue = (Integer)object;
                break;
            }
            case 3: {
                this.mStringValue = (String)object;
                break;
            }
            case 2: {
                this.mBooleanValue = (Boolean)object;
                break;
            }
            case 1: 
            case 6: {
                this.mIntegerValue = (Integer)object;
            }
        }
    }

    public void setValue(float[] fArray) {
        int n = 1.$SwitchMap$androidx$constraintlayout$widget$ConstraintAttribute$AttributeType[this.mType.ordinal()];
        boolean bl = false;
        switch (n) {
            default: {
                break;
            }
            case 8: {
                this.mFloatValue = fArray[0];
                break;
            }
            case 7: {
                this.mFloatValue = fArray[0];
                break;
            }
            case 4: 
            case 5: {
                this.mColorValue = n = Color.HSVToColor((float[])fArray);
                this.mColorValue = ConstraintAttribute.clamp((int)(fArray[3] * 255.0f)) << 24 | n & 0xFFFFFF;
                break;
            }
            case 3: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case 2: {
                if ((double)fArray[0] > 0.5) {
                    bl = true;
                }
                this.mBooleanValue = bl;
                break;
            }
            case 1: 
            case 6: {
                this.mIntegerValue = (int)fArray[0];
            }
        }
    }

    public static final class AttributeType
    extends Enum<AttributeType> {
        private static final /* synthetic */ AttributeType[] $VALUES;
        public static final /* enum */ AttributeType BOOLEAN_TYPE;
        public static final /* enum */ AttributeType COLOR_DRAWABLE_TYPE;
        public static final /* enum */ AttributeType COLOR_TYPE;
        public static final /* enum */ AttributeType DIMENSION_TYPE;
        public static final /* enum */ AttributeType FLOAT_TYPE;
        public static final /* enum */ AttributeType INT_TYPE;
        public static final /* enum */ AttributeType REFERENCE_TYPE;
        public static final /* enum */ AttributeType STRING_TYPE;

        static {
            AttributeType attributeType;
            AttributeType attributeType2;
            AttributeType attributeType3;
            AttributeType attributeType4;
            AttributeType attributeType5;
            AttributeType attributeType6;
            AttributeType attributeType7;
            AttributeType attributeType8;
            INT_TYPE = attributeType8 = new AttributeType();
            FLOAT_TYPE = attributeType7 = new AttributeType();
            COLOR_TYPE = attributeType6 = new AttributeType();
            COLOR_DRAWABLE_TYPE = attributeType5 = new AttributeType();
            STRING_TYPE = attributeType4 = new AttributeType();
            BOOLEAN_TYPE = attributeType3 = new AttributeType();
            DIMENSION_TYPE = attributeType2 = new AttributeType();
            REFERENCE_TYPE = attributeType = new AttributeType();
            $VALUES = new AttributeType[]{attributeType8, attributeType7, attributeType6, attributeType5, attributeType4, attributeType3, attributeType2, attributeType};
        }

        public static AttributeType valueOf(String string2) {
            return Enum.valueOf(AttributeType.class, string2);
        }

        public static AttributeType[] values() {
            return (AttributeType[])$VALUES.clone();
        }
    }
}

