/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.core.Metrics;
import androidx.constraintlayout.core.widgets.ConstraintAnchor;
import androidx.constraintlayout.core.widgets.ConstraintWidget;
import androidx.constraintlayout.core.widgets.ConstraintWidgetContainer;
import androidx.constraintlayout.core.widgets.Optimizer;
import androidx.constraintlayout.core.widgets.analyzer.BasicMeasure;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayoutStates;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.Constraints;
import androidx.constraintlayout.widget.ConstraintsChangedListener;
import androidx.constraintlayout.widget.Guideline;
import androidx.constraintlayout.widget.Placeholder;
import androidx.constraintlayout.widget.R;
import androidx.constraintlayout.widget.SharedValues;
import androidx.constraintlayout.widget.VirtualLayout;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstraintLayout
extends ViewGroup {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_DRAW_CONSTRAINTS = false;
    public static final int DESIGN_INFO_ID = 0;
    private static final boolean MEASURE = false;
    private static final boolean OPTIMIZE_HEIGHT_CHANGE = false;
    private static final String TAG = "ConstraintLayout";
    private static final boolean USE_CONSTRAINTS_HELPER = true;
    public static final String VERSION = "ConstraintLayout-2.1.3";
    private static SharedValues sSharedValues;
    SparseArray<View> mChildrenByIds = new SparseArray();
    private ArrayList<ConstraintHelper> mConstraintHelpers = new ArrayList(4);
    protected ConstraintLayoutStates mConstraintLayoutSpec = null;
    private ConstraintSet mConstraintSet = null;
    private int mConstraintSetId = -1;
    private ConstraintsChangedListener mConstraintsChangedListener;
    private HashMap<String, Integer> mDesignIds;
    protected boolean mDirtyHierarchy = true;
    private int mLastMeasureHeight = -1;
    int mLastMeasureHeightMode = 0;
    int mLastMeasureHeightSize = -1;
    private int mLastMeasureWidth = -1;
    int mLastMeasureWidthMode = 0;
    int mLastMeasureWidthSize = -1;
    protected ConstraintWidgetContainer mLayoutWidget = new ConstraintWidgetContainer();
    private int mMaxHeight;
    private int mMaxWidth = Integer.MAX_VALUE;
    Measurer mMeasurer;
    private Metrics mMetrics;
    private int mMinHeight = 0;
    private int mMinWidth = 0;
    private int mOnMeasureHeightMeasureSpec = 0;
    private int mOnMeasureWidthMeasureSpec = 0;
    private int mOptimizationLevel = 257;
    private SparseArray<ConstraintWidget> mTempMapIdToWidget;

    public ConstraintLayout(Context context) {
        super(context);
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mDesignIds = new HashMap();
        this.mTempMapIdToWidget = new SparseArray();
        this.mMeasurer = new Measurer(this);
        this.init(null, 0, 0);
    }

    public ConstraintLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mDesignIds = new HashMap();
        this.mTempMapIdToWidget = new SparseArray();
        this.mMeasurer = new Measurer(this);
        this.init(attributeSet, 0, 0);
    }

    public ConstraintLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mDesignIds = new HashMap();
        this.mTempMapIdToWidget = new SparseArray();
        this.mMeasurer = new Measurer(this);
        this.init(attributeSet, n, 0);
    }

    public ConstraintLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mMaxHeight = Integer.MAX_VALUE;
        this.mDesignIds = new HashMap();
        this.mTempMapIdToWidget = new SparseArray();
        this.mMeasurer = new Measurer(this);
        this.init(attributeSet, n, n2);
    }

    private int getPaddingWidth() {
        int n = this.getPaddingLeft();
        int n2 = 0;
        n = Math.max(0, n) + Math.max(0, this.getPaddingRight());
        if (Build.VERSION.SDK_INT >= 17) {
            n2 = Math.max(0, this.getPaddingStart());
            n2 = Math.max(0, this.getPaddingEnd()) + n2;
        }
        if (n2 > 0) {
            n = n2;
        }
        return n;
    }

    public static SharedValues getSharedValues() {
        if (sSharedValues == null) {
            sSharedValues = new SharedValues();
        }
        return sSharedValues;
    }

    private final ConstraintWidget getTargetWidget(int n) {
        View view;
        if (n == 0) {
            return this.mLayoutWidget;
        }
        Object object = view = (View)this.mChildrenByIds.get(n);
        if (view == null) {
            object = view = this.findViewById(n);
            if (view != null) {
                object = view;
                if (view != this) {
                    object = view;
                    if (view.getParent() == this) {
                        this.onViewAdded(view);
                        object = view;
                    }
                }
            }
        }
        if (object == this) {
            return this.mLayoutWidget;
        }
        object = object == null ? null : ((LayoutParams)object.getLayoutParams()).widget;
        return object;
    }

    private void init(AttributeSet attributeSet, int n, int n2) {
        this.mLayoutWidget.setCompanionWidget((Object)this);
        this.mLayoutWidget.setMeasurer(this.mMeasurer);
        this.mChildrenByIds.put(this.getId(), (Object)this);
        this.mConstraintSet = null;
        if (attributeSet != null) {
            attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ConstraintLayout_Layout, n, n2);
            n2 = attributeSet.getIndexCount();
            for (n = 0; n < n2; ++n) {
                int n3 = attributeSet.getIndex(n);
                if (n3 == R.styleable.ConstraintLayout_Layout_android_minWidth) {
                    this.mMinWidth = attributeSet.getDimensionPixelOffset(n3, this.mMinWidth);
                    continue;
                }
                if (n3 == R.styleable.ConstraintLayout_Layout_android_minHeight) {
                    this.mMinHeight = attributeSet.getDimensionPixelOffset(n3, this.mMinHeight);
                    continue;
                }
                if (n3 == R.styleable.ConstraintLayout_Layout_android_maxWidth) {
                    this.mMaxWidth = attributeSet.getDimensionPixelOffset(n3, this.mMaxWidth);
                    continue;
                }
                if (n3 == R.styleable.ConstraintLayout_Layout_android_maxHeight) {
                    this.mMaxHeight = attributeSet.getDimensionPixelOffset(n3, this.mMaxHeight);
                    continue;
                }
                if (n3 == R.styleable.ConstraintLayout_Layout_layout_optimizationLevel) {
                    this.mOptimizationLevel = attributeSet.getInt(n3, this.mOptimizationLevel);
                    continue;
                }
                if (n3 == R.styleable.ConstraintLayout_Layout_layoutDescription) {
                    if ((n3 = attributeSet.getResourceId(n3, 0)) == 0) continue;
                    try {
                        this.parseLayoutDescription(n3);
                    }
                    catch (Resources.NotFoundException notFoundException) {
                        this.mConstraintLayoutSpec = null;
                    }
                    continue;
                }
                if (n3 != R.styleable.ConstraintLayout_Layout_constraintSet) continue;
                n3 = attributeSet.getResourceId(n3, 0);
                try {
                    ConstraintSet constraintSet;
                    this.mConstraintSet = constraintSet = new ConstraintSet();
                    constraintSet.load(this.getContext(), n3);
                }
                catch (Resources.NotFoundException notFoundException) {
                    this.mConstraintSet = null;
                }
                this.mConstraintSetId = n3;
            }
            attributeSet.recycle();
        }
        this.mLayoutWidget.setOptimizationLevel(this.mOptimizationLevel);
    }

    private void markHierarchyDirty() {
        this.mDirtyHierarchy = true;
        this.mLastMeasureWidth = -1;
        this.mLastMeasureHeight = -1;
        this.mLastMeasureWidthSize = -1;
        this.mLastMeasureHeightSize = -1;
        this.mLastMeasureWidthMode = 0;
        this.mLastMeasureHeightMode = 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setChildrenConstraints() {
        ConstraintSet constraintSet;
        int n;
        Object object;
        int n2;
        boolean bl = this.isInEditMode();
        int n3 = this.getChildCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ConstraintWidget constraintWidget = this.getViewWidget(this.getChildAt(n2));
            if (constraintWidget == null) continue;
            constraintWidget.reset();
        }
        if (bl) {
            for (n2 = 0; n2 < n3; ++n2) {
                View view = this.getChildAt(n2);
                try {
                    void var4_8;
                    object = this.getResources().getResourceName(view.getId());
                    this.setDesignInformation(0, object, view.getId());
                    n = ((String)object).indexOf(47);
                    String string2 = object;
                    if (n != -1) {
                        String string3 = ((String)object).substring(n + 1);
                    }
                    this.getTargetWidget(view.getId()).setDebugName((String)var4_8);
                    continue;
                }
                catch (Resources.NotFoundException notFoundException) {}
            }
        }
        if (this.mConstraintSetId != -1) {
            for (n2 = 0; n2 < n3; ++n2) {
                View view = this.getChildAt(n2);
                if (view.getId() != this.mConstraintSetId || !(view instanceof Constraints)) continue;
                this.mConstraintSet = ((Constraints)view).getConstraintSet();
            }
        }
        if ((constraintSet = this.mConstraintSet) != null) {
            constraintSet.applyToInternal(this, true);
        }
        this.mLayoutWidget.removeAllChildren();
        n = this.mConstraintHelpers.size();
        if (n > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                this.mConstraintHelpers.get(n2).updatePreLayout(this);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            View view = this.getChildAt(n2);
            if (!(view instanceof Placeholder)) continue;
            ((Placeholder)view).updatePreLayout(this);
        }
        this.mTempMapIdToWidget.clear();
        this.mTempMapIdToWidget.put(0, (Object)this.mLayoutWidget);
        this.mTempMapIdToWidget.put(this.getId(), (Object)this.mLayoutWidget);
        for (n2 = 0; n2 < n3; ++n2) {
            View view = this.getChildAt(n2);
            object = this.getViewWidget(view);
            this.mTempMapIdToWidget.put(view.getId(), object);
        }
        n2 = 0;
        while (n2 < n3) {
            object = this.getChildAt(n2);
            ConstraintWidget constraintWidget = this.getViewWidget((View)object);
            if (constraintWidget != null) {
                LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
                this.mLayoutWidget.add(constraintWidget);
                this.applyConstraintsFromLayoutParams(bl, (View)object, constraintWidget, layoutParams, this.mTempMapIdToWidget);
            }
            ++n2;
        }
        return;
    }

    private void setWidgetBaseline(ConstraintWidget constraintWidget, LayoutParams layoutParams, SparseArray<ConstraintWidget> object, int n, ConstraintAnchor.Type type) {
        Object object2 = (View)this.mChildrenByIds.get(n);
        if ((object = (ConstraintWidget)object.get(n)) != null && object2 != null && object2.getLayoutParams() instanceof LayoutParams) {
            layoutParams.needsBaseline = true;
            if (type == ConstraintAnchor.Type.BASELINE) {
                object2 = (LayoutParams)object2.getLayoutParams();
                object2.needsBaseline = true;
                object2.widget.setHasBaseline(true);
            }
            constraintWidget.getAnchor(ConstraintAnchor.Type.BASELINE).connect(((ConstraintWidget)object).getAnchor(type), layoutParams.baselineMargin, layoutParams.goneBaselineMargin, true);
            constraintWidget.setHasBaseline(true);
            constraintWidget.getAnchor(ConstraintAnchor.Type.TOP).reset();
            constraintWidget.getAnchor(ConstraintAnchor.Type.BOTTOM).reset();
        }
    }

    private boolean updateHierarchy() {
        boolean bl;
        int n = this.getChildCount();
        boolean bl2 = false;
        int n2 = 0;
        while (true) {
            bl = bl2;
            if (n2 >= n) break;
            if (this.getChildAt(n2).isLayoutRequested()) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl) {
            this.setChildrenConstraints();
        }
        return bl;
    }

    protected void applyConstraintsFromLayoutParams(boolean bl, View object, ConstraintWidget constraintWidget, LayoutParams layoutParams, SparseArray<ConstraintWidget> sparseArray) {
        layoutParams.validate();
        layoutParams.helped = false;
        constraintWidget.setVisibility(object.getVisibility());
        if (layoutParams.isInPlaceholder) {
            constraintWidget.setInPlaceholder(true);
            constraintWidget.setVisibility(8);
        }
        constraintWidget.setCompanionWidget(object);
        if (object instanceof ConstraintHelper) {
            ((ConstraintHelper)((Object)object)).resolveRtl(constraintWidget, this.mLayoutWidget.isRtl());
        }
        if (layoutParams.isGuideline) {
            object = (androidx.constraintlayout.core.widgets.Guideline)constraintWidget;
            int n = layoutParams.resolvedGuideBegin;
            int n2 = layoutParams.resolvedGuideEnd;
            float f = layoutParams.resolvedGuidePercent;
            if (Build.VERSION.SDK_INT < 17) {
                n = layoutParams.guideBegin;
                n2 = layoutParams.guideEnd;
                f = layoutParams.guidePercent;
            }
            if (f != -1.0f) {
                ((androidx.constraintlayout.core.widgets.Guideline)object).setGuidePercent(f);
            } else if (n != -1) {
                ((androidx.constraintlayout.core.widgets.Guideline)object).setGuideBegin(n);
            } else if (n2 != -1) {
                ((androidx.constraintlayout.core.widgets.Guideline)object).setGuideEnd(n2);
            }
        } else {
            int n = layoutParams.resolvedLeftToLeft;
            int n3 = layoutParams.resolvedLeftToRight;
            int n4 = layoutParams.resolvedRightToLeft;
            int n5 = layoutParams.resolvedRightToRight;
            int n6 = layoutParams.resolveGoneLeftMargin;
            int n7 = layoutParams.resolveGoneRightMargin;
            float f = layoutParams.resolvedHorizontalBias;
            if (Build.VERSION.SDK_INT < 17) {
                n = layoutParams.leftToLeft;
                n7 = layoutParams.leftToRight;
                n4 = layoutParams.rightToLeft;
                int n8 = layoutParams.rightToRight;
                int n9 = layoutParams.goneLeftMargin;
                n3 = layoutParams.goneRightMargin;
                f = layoutParams.horizontalBias;
                n6 = n;
                n5 = n7;
                if (n == -1) {
                    n6 = n;
                    n5 = n7;
                    if (n7 == -1) {
                        if (layoutParams.startToStart != -1) {
                            n6 = layoutParams.startToStart;
                            n5 = n7;
                        } else {
                            n6 = n;
                            n5 = n7;
                            if (layoutParams.startToEnd != -1) {
                                n5 = layoutParams.startToEnd;
                                n6 = n;
                            }
                        }
                    }
                }
                n7 = n4;
                n = n8;
                if (n4 == -1) {
                    n7 = n4;
                    n = n8;
                    if (n8 == -1) {
                        if (layoutParams.endToStart != -1) {
                            n7 = layoutParams.endToStart;
                            n = n8;
                        } else {
                            n7 = n4;
                            n = n8;
                            if (layoutParams.endToEnd != -1) {
                                n = layoutParams.endToEnd;
                                n7 = n4;
                            }
                        }
                    }
                }
                n4 = n7;
                n7 = n3;
                n8 = n;
                n = n6;
                n3 = n5;
                n6 = n9;
                n5 = n8;
            }
            if (layoutParams.circleConstraint != -1) {
                object = (ConstraintWidget)sparseArray.get(layoutParams.circleConstraint);
                if (object != null) {
                    constraintWidget.connectCircularConstraint((ConstraintWidget)object, layoutParams.circleAngle, layoutParams.circleRadius);
                }
            } else {
                if (n != -1) {
                    object = (ConstraintWidget)sparseArray.get(n);
                    if (object != null) {
                        constraintWidget.immediateConnect(ConstraintAnchor.Type.LEFT, (ConstraintWidget)object, ConstraintAnchor.Type.LEFT, layoutParams.leftMargin, n6);
                    }
                } else if (n3 != -1 && (object = (ConstraintWidget)sparseArray.get(n3)) != null) {
                    constraintWidget.immediateConnect(ConstraintAnchor.Type.LEFT, (ConstraintWidget)object, ConstraintAnchor.Type.RIGHT, layoutParams.leftMargin, n6);
                }
                if (n4 != -1) {
                    object = (ConstraintWidget)sparseArray.get(n4);
                    if (object != null) {
                        constraintWidget.immediateConnect(ConstraintAnchor.Type.RIGHT, (ConstraintWidget)object, ConstraintAnchor.Type.LEFT, layoutParams.rightMargin, n7);
                    }
                } else if (n5 != -1 && (object = (ConstraintWidget)sparseArray.get(n5)) != null) {
                    constraintWidget.immediateConnect(ConstraintAnchor.Type.RIGHT, (ConstraintWidget)object, ConstraintAnchor.Type.RIGHT, layoutParams.rightMargin, n7);
                }
                if (layoutParams.topToTop != -1) {
                    object = (ConstraintWidget)sparseArray.get(layoutParams.topToTop);
                    if (object != null) {
                        constraintWidget.immediateConnect(ConstraintAnchor.Type.TOP, (ConstraintWidget)object, ConstraintAnchor.Type.TOP, layoutParams.topMargin, layoutParams.goneTopMargin);
                    }
                } else if (layoutParams.topToBottom != -1 && (object = (ConstraintWidget)sparseArray.get(layoutParams.topToBottom)) != null) {
                    constraintWidget.immediateConnect(ConstraintAnchor.Type.TOP, (ConstraintWidget)object, ConstraintAnchor.Type.BOTTOM, layoutParams.topMargin, layoutParams.goneTopMargin);
                }
                if (layoutParams.bottomToTop != -1) {
                    object = (ConstraintWidget)sparseArray.get(layoutParams.bottomToTop);
                    if (object != null) {
                        constraintWidget.immediateConnect(ConstraintAnchor.Type.BOTTOM, (ConstraintWidget)object, ConstraintAnchor.Type.TOP, layoutParams.bottomMargin, layoutParams.goneBottomMargin);
                    }
                } else if (layoutParams.bottomToBottom != -1 && (object = (ConstraintWidget)sparseArray.get(layoutParams.bottomToBottom)) != null) {
                    constraintWidget.immediateConnect(ConstraintAnchor.Type.BOTTOM, (ConstraintWidget)object, ConstraintAnchor.Type.BOTTOM, layoutParams.bottomMargin, layoutParams.goneBottomMargin);
                }
                if (layoutParams.baselineToBaseline != -1) {
                    this.setWidgetBaseline(constraintWidget, layoutParams, sparseArray, layoutParams.baselineToBaseline, ConstraintAnchor.Type.BASELINE);
                } else if (layoutParams.baselineToTop != -1) {
                    this.setWidgetBaseline(constraintWidget, layoutParams, sparseArray, layoutParams.baselineToTop, ConstraintAnchor.Type.TOP);
                } else if (layoutParams.baselineToBottom != -1) {
                    this.setWidgetBaseline(constraintWidget, layoutParams, sparseArray, layoutParams.baselineToBottom, ConstraintAnchor.Type.BOTTOM);
                }
                if (f >= 0.0f) {
                    constraintWidget.setHorizontalBiasPercent(f);
                }
                if (layoutParams.verticalBias >= 0.0f) {
                    constraintWidget.setVerticalBiasPercent(layoutParams.verticalBias);
                }
            }
            if (bl && (layoutParams.editorAbsoluteX != -1 || layoutParams.editorAbsoluteY != -1)) {
                constraintWidget.setOrigin(layoutParams.editorAbsoluteX, layoutParams.editorAbsoluteY);
            }
            if (!layoutParams.horizontalDimensionFixed) {
                if (layoutParams.width == -1) {
                    if (layoutParams.constrainedWidth) {
                        constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    } else {
                        constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                    }
                    constraintWidget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.LEFT).mMargin = layoutParams.leftMargin;
                    constraintWidget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.RIGHT).mMargin = layoutParams.rightMargin;
                } else {
                    constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    constraintWidget.setWidth(0);
                }
            } else {
                constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setWidth(layoutParams.width);
                if (layoutParams.width == -2) {
                    constraintWidget.setHorizontalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
            if (!layoutParams.verticalDimensionFixed) {
                if (layoutParams.height == -1) {
                    if (layoutParams.constrainedHeight) {
                        constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    } else {
                        constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                    }
                    constraintWidget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.TOP).mMargin = layoutParams.topMargin;
                    constraintWidget.getAnchor((ConstraintAnchor.Type)ConstraintAnchor.Type.BOTTOM).mMargin = layoutParams.bottomMargin;
                } else {
                    constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                    constraintWidget.setHeight(0);
                }
            } else {
                constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.setHeight(layoutParams.height);
                if (layoutParams.height == -2) {
                    constraintWidget.setVerticalDimensionBehaviour(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            }
            constraintWidget.setDimensionRatio(layoutParams.dimensionRatio);
            constraintWidget.setHorizontalWeight(layoutParams.horizontalWeight);
            constraintWidget.setVerticalWeight(layoutParams.verticalWeight);
            constraintWidget.setHorizontalChainStyle(layoutParams.horizontalChainStyle);
            constraintWidget.setVerticalChainStyle(layoutParams.verticalChainStyle);
            constraintWidget.setWrapBehaviorInParent(layoutParams.wrapBehaviorInParent);
            constraintWidget.setHorizontalMatchStyle(layoutParams.matchConstraintDefaultWidth, layoutParams.matchConstraintMinWidth, layoutParams.matchConstraintMaxWidth, layoutParams.matchConstraintPercentWidth);
            constraintWidget.setVerticalMatchStyle(layoutParams.matchConstraintDefaultHeight, layoutParams.matchConstraintMinHeight, layoutParams.matchConstraintMaxHeight, layoutParams.matchConstraintPercentHeight);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    protected void dispatchDraw(Canvas canvas) {
        int n;
        int n2;
        Paint paint = this.mConstraintHelpers;
        if (paint != null && (n2 = paint.size()) > 0) {
            for (n = 0; n < n2; ++n) {
                this.mConstraintHelpers.get(n).updatePreDraw(this);
            }
        }
        super.dispatchDraw(canvas);
        if (this.isInEditMode()) {
            float f = this.getWidth();
            float f2 = this.getHeight();
            n2 = this.getChildCount();
            for (n = 0; n < n2; ++n) {
                paint = this.getChildAt(n);
                if (paint.getVisibility() == 8 || (paint = paint.getTag()) == null || !(paint instanceof String) || ((String[])(paint = ((String)paint).split(","))).length != 4) continue;
                int n3 = Integer.parseInt(paint[0]);
                int n4 = Integer.parseInt(paint[1]);
                int n5 = Integer.parseInt(paint[2]);
                int n6 = Integer.parseInt(paint[3]);
                n3 = (int)((float)n3 / 1080.0f * f);
                n4 = (int)((float)n4 / 1920.0f * f2);
                n5 = (int)((float)n5 / 1080.0f * f);
                n6 = (int)((float)n6 / 1920.0f * f2);
                paint = new Paint();
                paint.setColor(-65536);
                float f3 = n3;
                float f4 = n4;
                float f5 = n3 + n5;
                canvas.drawLine(f3, f4, f5, f4, paint);
                float f6 = n4 + n6;
                canvas.drawLine(f5, f4, f5, f6, paint);
                canvas.drawLine(f5, f6, f3, f6, paint);
                canvas.drawLine(f3, f6, f3, f4, paint);
                paint.setColor(-16711936);
                canvas.drawLine(f3, f4, f5, f6, paint);
                canvas.drawLine(f3, f6, f5, f4, paint);
            }
        }
    }

    public void fillMetrics(Metrics metrics) {
        this.mMetrics = metrics;
        this.mLayoutWidget.fillMetrics(metrics);
    }

    public void forceLayout() {
        this.markHierarchyDirty();
        super.forceLayout();
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    public Object getDesignInformation(int n, Object hashMap) {
        if (n == 0 && hashMap instanceof String) {
            String string2 = (String)((Object)hashMap);
            hashMap = this.mDesignIds;
            if (hashMap != null && hashMap.containsKey(string2)) {
                return this.mDesignIds.get(string2);
            }
        }
        return null;
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getOptimizationLevel() {
        return this.mLayoutWidget.getOptimizationLevel();
    }

    public String getSceneString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mLayoutWidget.stringId == null) {
            String object2;
            n = this.getId();
            this.mLayoutWidget.stringId = n != -1 ? (object2 = this.getContext().getResources().getResourceEntryName(n)) : "parent";
        }
        if (this.mLayoutWidget.getDebugName() == null) {
            ConstraintWidgetContainer constraintWidgetContainer = this.mLayoutWidget;
            constraintWidgetContainer.setDebugName(constraintWidgetContainer.stringId);
            StringBuilder stringBuilder2 = new StringBuilder();
            stringBuilder2.append(" setDebugName ");
            stringBuilder2.append(this.mLayoutWidget.getDebugName());
            Log.v((String)TAG, (String)stringBuilder2.toString());
        }
        for (ConstraintWidget constraintWidget : this.mLayoutWidget.getChildren()) {
            Object object = (View)constraintWidget.getCompanionWidget();
            if (object == null) continue;
            if (constraintWidget.stringId == null && (n = object.getId()) != -1) {
                constraintWidget.stringId = this.getContext().getResources().getResourceEntryName(n);
            }
            if (constraintWidget.getDebugName() != null) continue;
            constraintWidget.setDebugName(constraintWidget.stringId);
            object = new StringBuilder();
            ((StringBuilder)object).append(" setDebugName ");
            ((StringBuilder)object).append(constraintWidget.getDebugName());
            Log.v((String)TAG, (String)((StringBuilder)object).toString());
        }
        this.mLayoutWidget.getSceneString(stringBuilder);
        return stringBuilder.toString();
    }

    public View getViewById(int n) {
        return (View)this.mChildrenByIds.get(n);
    }

    public final ConstraintWidget getViewWidget(View view) {
        if (view == this) {
            return this.mLayoutWidget;
        }
        if (view != null) {
            if (view.getLayoutParams() instanceof LayoutParams) {
                return ((LayoutParams)view.getLayoutParams()).widget;
            }
            view.setLayoutParams(this.generateLayoutParams(view.getLayoutParams()));
            if (view.getLayoutParams() instanceof LayoutParams) {
                return ((LayoutParams)view.getLayoutParams()).widget;
            }
        }
        return null;
    }

    protected boolean isRtl() {
        boolean bl;
        int n = Build.VERSION.SDK_INT;
        boolean bl2 = bl = false;
        if (n >= 17) {
            n = (this.getContext().getApplicationInfo().flags & 0x400000) != 0 ? 1 : 0;
            bl2 = bl;
            if (n != 0) {
                bl2 = bl;
                if (1 == this.getLayoutDirection()) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    public void loadLayoutDescription(int n) {
        if (n != 0) {
            try {
                ConstraintLayoutStates constraintLayoutStates;
                this.mConstraintLayoutSpec = constraintLayoutStates = new ConstraintLayoutStates(this.getContext(), this, n);
            }
            catch (Resources.NotFoundException notFoundException) {
                this.mConstraintLayoutSpec = null;
            }
        } else {
            this.mConstraintLayoutSpec = null;
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        n3 = this.getChildCount();
        bl = this.isInEditMode();
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            View view = this.getChildAt(n);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            ConstraintWidget constraintWidget = layoutParams.widget;
            if (view.getVisibility() == 8 && !layoutParams.isGuideline && !layoutParams.isHelper && !layoutParams.isVirtualGroup && !bl || layoutParams.isInPlaceholder) continue;
            int n5 = constraintWidget.getX();
            int n6 = constraintWidget.getY();
            n4 = constraintWidget.getWidth() + n5;
            int n7 = constraintWidget.getHeight() + n6;
            view.layout(n5, n6, n4, n7);
            if (!(view instanceof Placeholder) || (layoutParams = ((Placeholder)view).getContent()) == null) continue;
            layoutParams.setVisibility(0);
            layoutParams.layout(n5, n6, n4, n7);
        }
        n3 = this.mConstraintHelpers.size();
        if (n3 > 0) {
            for (n = n2; n < n3; ++n) {
                this.mConstraintHelpers.get(n).updatePostLayout(this);
            }
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        if (this.mOnMeasureWidthMeasureSpec == n) {
            n3 = this.mOnMeasureHeightMeasureSpec;
        }
        if (!this.mDirtyHierarchy) {
            int n4 = this.getChildCount();
            for (n3 = 0; n3 < n4; ++n3) {
                if (!this.getChildAt(n3).isLayoutRequested()) continue;
                this.mDirtyHierarchy = true;
                break;
            }
        }
        boolean bl = this.mDirtyHierarchy;
        this.mOnMeasureWidthMeasureSpec = n;
        this.mOnMeasureHeightMeasureSpec = n2;
        this.mLayoutWidget.setRtl(this.isRtl());
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            if (this.updateHierarchy()) {
                this.mLayoutWidget.updateHierarchy();
            }
        }
        this.resolveSystem(this.mLayoutWidget, this.mOptimizationLevel, n, n2);
        this.resolveMeasuredDimension(n, n2, this.mLayoutWidget.getWidth(), this.mLayoutWidget.getHeight(), this.mLayoutWidget.isWidthMeasuredTooSmall(), this.mLayoutWidget.isHeightMeasuredTooSmall());
    }

    public void onViewAdded(View view) {
        super.onViewAdded(view);
        Object object = this.getViewWidget(view);
        if (view instanceof Guideline && !(object instanceof androidx.constraintlayout.core.widgets.Guideline)) {
            object = (LayoutParams)view.getLayoutParams();
            ((LayoutParams)((Object)object)).widget = new androidx.constraintlayout.core.widgets.Guideline();
            ((LayoutParams)((Object)object)).isGuideline = true;
            ((androidx.constraintlayout.core.widgets.Guideline)((LayoutParams)((Object)object)).widget).setOrientation(((LayoutParams)((Object)object)).orientation);
        }
        if (view instanceof ConstraintHelper) {
            object = (ConstraintHelper)view;
            ((ConstraintHelper)((Object)object)).validateParams();
            ((LayoutParams)view.getLayoutParams()).isHelper = true;
            if (!this.mConstraintHelpers.contains(object)) {
                this.mConstraintHelpers.add((ConstraintHelper)((Object)object));
            }
        }
        this.mChildrenByIds.put(view.getId(), (Object)view);
        this.mDirtyHierarchy = true;
    }

    public void onViewRemoved(View view) {
        super.onViewRemoved(view);
        this.mChildrenByIds.remove(view.getId());
        ConstraintWidget constraintWidget = this.getViewWidget(view);
        this.mLayoutWidget.remove(constraintWidget);
        this.mConstraintHelpers.remove(view);
        this.mDirtyHierarchy = true;
    }

    protected void parseLayoutDescription(int n) {
        this.mConstraintLayoutSpec = new ConstraintLayoutStates(this.getContext(), this, n);
    }

    public void requestLayout() {
        this.markHierarchyDirty();
        super.requestLayout();
    }

    protected void resolveMeasuredDimension(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = this.mMeasurer.paddingHeight;
        n = ConstraintLayout.resolveSizeAndState((int)(n3 + this.mMeasurer.paddingWidth), (int)n, (int)0);
        n3 = ConstraintLayout.resolveSizeAndState((int)(n4 + n5), (int)n2, (int)0);
        n2 = Math.min(this.mMaxWidth, n & 0xFFFFFF);
        n3 = Math.min(this.mMaxHeight, n3 & 0xFFFFFF);
        n = n2;
        if (bl) {
            n = n2 | 0x1000000;
        }
        n2 = n3;
        if (bl2) {
            n2 = n3 | 0x1000000;
        }
        this.setMeasuredDimension(n, n2);
        this.mLastMeasureWidth = n;
        this.mLastMeasureHeight = n2;
    }

    protected void resolveSystem(ConstraintWidgetContainer constraintWidgetContainer, int n, int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getSize((int)n2);
        int n6 = View.MeasureSpec.getMode((int)n3);
        int n7 = View.MeasureSpec.getSize((int)n3);
        int n8 = Math.max(0, this.getPaddingTop());
        int n9 = Math.max(0, this.getPaddingBottom());
        int n10 = n8 + n9;
        int n11 = this.getPaddingWidth();
        this.mMeasurer.captureLayoutInfo(n2, n3, n8, n9, n11, n10);
        if (Build.VERSION.SDK_INT >= 17) {
            n2 = Math.max(0, this.getPaddingStart());
            n3 = Math.max(0, this.getPaddingEnd());
            if (n2 <= 0 && n3 <= 0) {
                n2 = Math.max(0, this.getPaddingLeft());
            } else if (this.isRtl()) {
                n2 = n3;
            }
        } else {
            n2 = Math.max(0, this.getPaddingLeft());
        }
        n3 = n5 - n11;
        n10 = n7 - n10;
        this.setSelfDimensionBehaviour(constraintWidgetContainer, n4, n3, n6, n10);
        constraintWidgetContainer.measure(n, n4, n3, n6, n10, this.mLastMeasureWidth, this.mLastMeasureHeight, n2, n8);
    }

    public void setConstraintSet(ConstraintSet constraintSet) {
        this.mConstraintSet = constraintSet;
    }

    public void setDesignInformation(int n, Object object, Object object2) {
        if (n == 0 && object instanceof String && object2 instanceof Integer) {
            if (this.mDesignIds == null) {
                this.mDesignIds = new HashMap();
            }
            String string2 = (String)object;
            n = string2.indexOf("/");
            object = string2;
            if (n != -1) {
                object = string2.substring(n + 1);
            }
            n = (Integer)object2;
            this.mDesignIds.put((String)object, n);
        }
    }

    public void setId(int n) {
        this.mChildrenByIds.remove(this.getId());
        super.setId(n);
        this.mChildrenByIds.put(this.getId(), (Object)this);
    }

    public void setMaxHeight(int n) {
        if (n == this.mMaxHeight) {
            return;
        }
        this.mMaxHeight = n;
        this.requestLayout();
    }

    public void setMaxWidth(int n) {
        if (n == this.mMaxWidth) {
            return;
        }
        this.mMaxWidth = n;
        this.requestLayout();
    }

    public void setMinHeight(int n) {
        if (n == this.mMinHeight) {
            return;
        }
        this.mMinHeight = n;
        this.requestLayout();
    }

    public void setMinWidth(int n) {
        if (n == this.mMinWidth) {
            return;
        }
        this.mMinWidth = n;
        this.requestLayout();
    }

    public void setOnConstraintsChanged(ConstraintsChangedListener constraintsChangedListener) {
        this.mConstraintsChangedListener = constraintsChangedListener;
        ConstraintLayoutStates constraintLayoutStates = this.mConstraintLayoutSpec;
        if (constraintLayoutStates != null) {
            constraintLayoutStates.setOnConstraintsChanged(constraintsChangedListener);
        }
    }

    public void setOptimizationLevel(int n) {
        this.mOptimizationLevel = n;
        this.mLayoutWidget.setOptimizationLevel(n);
    }

    /*
     * Unable to fully structure code
     */
    protected void setSelfDimensionBehaviour(ConstraintWidgetContainer var1_1, int var2_2, int var3_3, int var4_4, int var5_5) {
        var6_6 = this.mMeasurer.paddingHeight;
        var7_7 = this.mMeasurer.paddingWidth;
        var8_8 = ConstraintWidget.DimensionBehaviour.FIXED;
        var9_9 = ConstraintWidget.DimensionBehaviour.FIXED;
        var10_10 = this.getChildCount();
        if (var2_2 != -2147483648) {
            if (var2_2 != 0) {
                if (var2_2 != 0x40000000) {
                    while (true) {
                        var3_3 = 0;
                        break;
                    }
                } else {
                    var3_3 = Math.min(this.mMaxWidth - var7_7, var3_3);
                }
            } else {
                var8_8 = var11_11 = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (var10_10 != 0) ** continue;
                var3_3 = Math.max(0, this.mMinWidth);
                var8_8 = var11_11;
            }
        } else {
            var8_8 = var11_11 = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (var10_10 == 0) {
                var3_3 = Math.max(0, this.mMinWidth);
                var8_8 = var11_11;
            }
        }
        if (var4_4 != -2147483648) {
            if (var4_4 != 0) {
                if (var4_4 != 0x40000000) {
                    while (true) {
                        var5_5 = 0;
                        break;
                    }
                } else {
                    var5_5 = Math.min(this.mMaxHeight - var6_6, var5_5);
                }
            } else {
                var9_9 = var11_11 = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (var10_10 != 0) ** continue;
                var5_5 = Math.max(0, this.mMinHeight);
                var9_9 = var11_11;
            }
        } else {
            var9_9 = var11_11 = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (var10_10 == 0) {
                var5_5 = Math.max(0, this.mMinHeight);
                var9_9 = var11_11;
            }
        }
        if (var3_3 != var1_1.getWidth() || var5_5 != var1_1.getHeight()) {
            var1_1.invalidateMeasures();
        }
        var1_1.setX(0);
        var1_1.setY(0);
        var1_1.setMaxWidth(this.mMaxWidth - var7_7);
        var1_1.setMaxHeight(this.mMaxHeight - var6_6);
        var1_1.setMinWidth(0);
        var1_1.setMinHeight(0);
        var1_1.setHorizontalDimensionBehaviour(var8_8);
        var1_1.setWidth(var3_3);
        var1_1.setVerticalDimensionBehaviour(var9_9);
        var1_1.setHeight(var5_5);
        var1_1.setMinWidth(this.mMinWidth - var7_7);
        var1_1.setMinHeight(this.mMinHeight - var6_6);
    }

    public void setState(int n, int n2, int n3) {
        ConstraintLayoutStates constraintLayoutStates = this.mConstraintLayoutSpec;
        if (constraintLayoutStates != null) {
            constraintLayoutStates.updateConstraints(n, n2, n3);
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public static final int BASELINE = 5;
        public static final int BOTTOM = 4;
        public static final int CHAIN_PACKED = 2;
        public static final int CHAIN_SPREAD = 0;
        public static final int CHAIN_SPREAD_INSIDE = 1;
        public static final int CIRCLE = 8;
        public static final int END = 7;
        public static final int GONE_UNSET = Integer.MIN_VALUE;
        public static final int HORIZONTAL = 0;
        public static final int LEFT = 1;
        public static final int MATCH_CONSTRAINT = 0;
        public static final int MATCH_CONSTRAINT_PERCENT = 2;
        public static final int MATCH_CONSTRAINT_SPREAD = 0;
        public static final int MATCH_CONSTRAINT_WRAP = 1;
        public static final int PARENT_ID = 0;
        public static final int RIGHT = 2;
        public static final int START = 6;
        public static final int TOP = 3;
        public static final int UNSET = -1;
        public static final int VERTICAL = 1;
        public static final int WRAP_BEHAVIOR_HORIZONTAL_ONLY = 1;
        public static final int WRAP_BEHAVIOR_INCLUDED = 0;
        public static final int WRAP_BEHAVIOR_SKIPPED = 3;
        public static final int WRAP_BEHAVIOR_VERTICAL_ONLY = 2;
        public int baselineMargin = 0;
        public int baselineToBaseline = -1;
        public int baselineToBottom = -1;
        public int baselineToTop = -1;
        public int bottomToBottom = -1;
        public int bottomToTop = -1;
        public float circleAngle = 0.0f;
        public int circleConstraint = -1;
        public int circleRadius = 0;
        public boolean constrainedHeight = false;
        public boolean constrainedWidth = false;
        public String constraintTag = null;
        public String dimensionRatio = null;
        int dimensionRatioSide = 1;
        float dimensionRatioValue = 0.0f;
        public int editorAbsoluteX = -1;
        public int editorAbsoluteY = -1;
        public int endToEnd = -1;
        public int endToStart = -1;
        public int goneBaselineMargin;
        public int goneBottomMargin;
        public int goneEndMargin;
        public int goneLeftMargin = Integer.MIN_VALUE;
        public int goneRightMargin;
        public int goneStartMargin;
        public int goneTopMargin = Integer.MIN_VALUE;
        public int guideBegin = -1;
        public int guideEnd = -1;
        public float guidePercent = -1.0f;
        public boolean guidelineUseRtl = true;
        boolean heightSet = true;
        public boolean helped = false;
        public float horizontalBias = 0.5f;
        public int horizontalChainStyle = 0;
        boolean horizontalDimensionFixed = true;
        public float horizontalWeight = -1.0f;
        boolean isGuideline = false;
        boolean isHelper = false;
        boolean isInPlaceholder = false;
        boolean isVirtualGroup = false;
        public int leftToLeft = -1;
        public int leftToRight = -1;
        public int matchConstraintDefaultHeight = 0;
        public int matchConstraintDefaultWidth = 0;
        public int matchConstraintMaxHeight = 0;
        public int matchConstraintMaxWidth = 0;
        public int matchConstraintMinHeight = 0;
        public int matchConstraintMinWidth = 0;
        public float matchConstraintPercentHeight = 1.0f;
        public float matchConstraintPercentWidth = 1.0f;
        boolean needsBaseline = false;
        public int orientation = -1;
        int resolveGoneLeftMargin;
        int resolveGoneRightMargin;
        int resolvedGuideBegin;
        int resolvedGuideEnd;
        float resolvedGuidePercent;
        float resolvedHorizontalBias = 0.5f;
        int resolvedLeftToLeft = -1;
        int resolvedLeftToRight = -1;
        int resolvedRightToLeft = -1;
        int resolvedRightToRight = -1;
        public int rightToLeft = -1;
        public int rightToRight = -1;
        public int startToEnd = -1;
        public int startToStart = -1;
        public int topToBottom = -1;
        public int topToTop = -1;
        public float verticalBias = 0.5f;
        public int verticalChainStyle = 0;
        boolean verticalDimensionFixed = true;
        public float verticalWeight = -1.0f;
        ConstraintWidget widget;
        boolean widthSet = true;
        public int wrapBehaviorInParent = 0;

        public LayoutParams(int n, int n2) {
            super(n, n2);
            this.goneRightMargin = Integer.MIN_VALUE;
            this.goneBottomMargin = Integer.MIN_VALUE;
            this.goneStartMargin = Integer.MIN_VALUE;
            this.goneEndMargin = Integer.MIN_VALUE;
            this.goneBaselineMargin = Integer.MIN_VALUE;
            this.resolveGoneLeftMargin = Integer.MIN_VALUE;
            this.resolveGoneRightMargin = Integer.MIN_VALUE;
            this.widget = new ConstraintWidget();
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.goneRightMargin = Integer.MIN_VALUE;
            this.goneBottomMargin = Integer.MIN_VALUE;
            this.goneStartMargin = Integer.MIN_VALUE;
            this.goneEndMargin = Integer.MIN_VALUE;
            this.goneBaselineMargin = Integer.MIN_VALUE;
            this.resolveGoneLeftMargin = Integer.MIN_VALUE;
            this.resolveGoneRightMargin = Integer.MIN_VALUE;
            this.widget = new ConstraintWidget();
            context = context.obtainStyledAttributes(attributeSet, R.styleable.ConstraintLayout_Layout);
            int n = context.getIndexCount();
            block68: for (int i = 0; i < n; ++i) {
                int n2 = context.getIndex(i);
                int n3 = Table.map.get(n2);
                switch (n3) {
                    default: {
                        block44 : switch (n3) {
                            default: {
                                switch (n3) {
                                    default: {
                                        break block44;
                                    }
                                    case 67: {
                                        this.guidelineUseRtl = context.getBoolean(n2, this.guidelineUseRtl);
                                        break block44;
                                    }
                                    case 66: {
                                        this.wrapBehaviorInParent = context.getInt(n2, this.wrapBehaviorInParent);
                                        break block44;
                                    }
                                    case 65: {
                                        ConstraintSet.parseDimensionConstraints((Object)this, (TypedArray)context, n2, 1);
                                        this.heightSet = true;
                                        break block44;
                                    }
                                    case 64: 
                                }
                                ConstraintSet.parseDimensionConstraints((Object)this, (TypedArray)context, n2, 0);
                                this.widthSet = true;
                                break;
                            }
                            case 55: {
                                this.goneBaselineMargin = context.getDimensionPixelSize(n2, this.goneBaselineMargin);
                                break;
                            }
                            case 54: {
                                this.baselineMargin = context.getDimensionPixelSize(n2, this.baselineMargin);
                                break;
                            }
                            case 53: {
                                this.baselineToBottom = n3 = context.getResourceId(n2, this.baselineToBottom);
                                if (n3 != -1) continue block68;
                                this.baselineToBottom = context.getInt(n2, -1);
                                break;
                            }
                            case 52: {
                                this.baselineToTop = n3 = context.getResourceId(n2, this.baselineToTop);
                                if (n3 != -1) continue block68;
                                this.baselineToTop = context.getInt(n2, -1);
                                break;
                            }
                            case 51: {
                                this.constraintTag = context.getString(n2);
                                break;
                            }
                            case 50: {
                                this.editorAbsoluteY = context.getDimensionPixelOffset(n2, this.editorAbsoluteY);
                                break;
                            }
                            case 49: {
                                this.editorAbsoluteX = context.getDimensionPixelOffset(n2, this.editorAbsoluteX);
                                break;
                            }
                            case 48: {
                                this.verticalChainStyle = context.getInt(n2, 0);
                                break;
                            }
                            case 47: {
                                this.horizontalChainStyle = context.getInt(n2, 0);
                                break;
                            }
                            case 46: {
                                this.verticalWeight = context.getFloat(n2, this.verticalWeight);
                                break;
                            }
                            case 45: {
                                this.horizontalWeight = context.getFloat(n2, this.horizontalWeight);
                                break;
                            }
                            case 44: {
                                ConstraintSet.parseDimensionRatioString(this, context.getString(n2));
                                break;
                            }
                        }
                        continue block68;
                    }
                    case 38: {
                        this.matchConstraintPercentHeight = Math.max(0.0f, context.getFloat(n2, this.matchConstraintPercentHeight));
                        this.matchConstraintDefaultHeight = 2;
                        continue block68;
                    }
                    case 37: {
                        try {
                            this.matchConstraintMaxHeight = context.getDimensionPixelSize(n2, this.matchConstraintMaxHeight);
                        }
                        catch (Exception exception) {
                            if (context.getInt(n2, this.matchConstraintMaxHeight) != -2) continue block68;
                            this.matchConstraintMaxHeight = -2;
                        }
                        continue block68;
                    }
                    case 36: {
                        try {
                            this.matchConstraintMinHeight = context.getDimensionPixelSize(n2, this.matchConstraintMinHeight);
                        }
                        catch (Exception exception) {
                            if (context.getInt(n2, this.matchConstraintMinHeight) != -2) continue block68;
                            this.matchConstraintMinHeight = -2;
                        }
                        continue block68;
                    }
                    case 35: {
                        this.matchConstraintPercentWidth = Math.max(0.0f, context.getFloat(n2, this.matchConstraintPercentWidth));
                        this.matchConstraintDefaultWidth = 2;
                        continue block68;
                    }
                    case 34: {
                        try {
                            this.matchConstraintMaxWidth = context.getDimensionPixelSize(n2, this.matchConstraintMaxWidth);
                        }
                        catch (Exception exception) {
                            if (context.getInt(n2, this.matchConstraintMaxWidth) != -2) continue block68;
                            this.matchConstraintMaxWidth = -2;
                        }
                        continue block68;
                    }
                    case 33: {
                        try {
                            this.matchConstraintMinWidth = context.getDimensionPixelSize(n2, this.matchConstraintMinWidth);
                        }
                        catch (Exception exception) {
                            if (context.getInt(n2, this.matchConstraintMinWidth) != -2) continue block68;
                            this.matchConstraintMinWidth = -2;
                        }
                        continue block68;
                    }
                    case 32: {
                        this.matchConstraintDefaultHeight = n2 = context.getInt(n2, 0);
                        if (n2 != 1) continue block68;
                        Log.e((String)ConstraintLayout.TAG, (String)"layout_constraintHeight_default=\"wrap\" is deprecated.\nUse layout_height=\"WRAP_CONTENT\" and layout_constrainedHeight=\"true\" instead.");
                        continue block68;
                    }
                    case 31: {
                        this.matchConstraintDefaultWidth = n2 = context.getInt(n2, 0);
                        if (n2 != 1) continue block68;
                        Log.e((String)ConstraintLayout.TAG, (String)"layout_constraintWidth_default=\"wrap\" is deprecated.\nUse layout_width=\"WRAP_CONTENT\" and layout_constrainedWidth=\"true\" instead.");
                        continue block68;
                    }
                    case 30: {
                        this.verticalBias = context.getFloat(n2, this.verticalBias);
                        continue block68;
                    }
                    case 29: {
                        this.horizontalBias = context.getFloat(n2, this.horizontalBias);
                        continue block68;
                    }
                    case 28: {
                        this.constrainedHeight = context.getBoolean(n2, this.constrainedHeight);
                        continue block68;
                    }
                    case 27: {
                        this.constrainedWidth = context.getBoolean(n2, this.constrainedWidth);
                        continue block68;
                    }
                    case 26: {
                        this.goneEndMargin = context.getDimensionPixelSize(n2, this.goneEndMargin);
                        continue block68;
                    }
                    case 25: {
                        this.goneStartMargin = context.getDimensionPixelSize(n2, this.goneStartMargin);
                        continue block68;
                    }
                    case 24: {
                        this.goneBottomMargin = context.getDimensionPixelSize(n2, this.goneBottomMargin);
                        continue block68;
                    }
                    case 23: {
                        this.goneRightMargin = context.getDimensionPixelSize(n2, this.goneRightMargin);
                        continue block68;
                    }
                    case 22: {
                        this.goneTopMargin = context.getDimensionPixelSize(n2, this.goneTopMargin);
                        continue block68;
                    }
                    case 21: {
                        this.goneLeftMargin = context.getDimensionPixelSize(n2, this.goneLeftMargin);
                        continue block68;
                    }
                    case 20: {
                        this.endToEnd = n3 = context.getResourceId(n2, this.endToEnd);
                        if (n3 != -1) continue block68;
                        this.endToEnd = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 19: {
                        this.endToStart = n3 = context.getResourceId(n2, this.endToStart);
                        if (n3 != -1) continue block68;
                        this.endToStart = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 18: {
                        this.startToStart = n3 = context.getResourceId(n2, this.startToStart);
                        if (n3 != -1) continue block68;
                        this.startToStart = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 17: {
                        this.startToEnd = n3 = context.getResourceId(n2, this.startToEnd);
                        if (n3 != -1) continue block68;
                        this.startToEnd = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 16: {
                        this.baselineToBaseline = n3 = context.getResourceId(n2, this.baselineToBaseline);
                        if (n3 != -1) continue block68;
                        this.baselineToBaseline = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 15: {
                        this.bottomToBottom = n3 = context.getResourceId(n2, this.bottomToBottom);
                        if (n3 != -1) continue block68;
                        this.bottomToBottom = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 14: {
                        this.bottomToTop = n3 = context.getResourceId(n2, this.bottomToTop);
                        if (n3 != -1) continue block68;
                        this.bottomToTop = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 13: {
                        this.topToBottom = n3 = context.getResourceId(n2, this.topToBottom);
                        if (n3 != -1) continue block68;
                        this.topToBottom = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 12: {
                        this.topToTop = n3 = context.getResourceId(n2, this.topToTop);
                        if (n3 != -1) continue block68;
                        this.topToTop = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 11: {
                        this.rightToRight = n3 = context.getResourceId(n2, this.rightToRight);
                        if (n3 != -1) continue block68;
                        this.rightToRight = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 10: {
                        this.rightToLeft = n3 = context.getResourceId(n2, this.rightToLeft);
                        if (n3 != -1) continue block68;
                        this.rightToLeft = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 9: {
                        this.leftToRight = n3 = context.getResourceId(n2, this.leftToRight);
                        if (n3 != -1) continue block68;
                        this.leftToRight = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 8: {
                        this.leftToLeft = n3 = context.getResourceId(n2, this.leftToLeft);
                        if (n3 != -1) continue block68;
                        this.leftToLeft = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 7: {
                        this.guidePercent = context.getFloat(n2, this.guidePercent);
                        continue block68;
                    }
                    case 6: {
                        this.guideEnd = context.getDimensionPixelOffset(n2, this.guideEnd);
                        continue block68;
                    }
                    case 5: {
                        this.guideBegin = context.getDimensionPixelOffset(n2, this.guideBegin);
                        continue block68;
                    }
                    case 4: {
                        float f;
                        this.circleAngle = f = context.getFloat(n2, this.circleAngle) % 360.0f;
                        if (!(f < 0.0f)) continue block68;
                        this.circleAngle = (360.0f - f) % 360.0f;
                        continue block68;
                    }
                    case 3: {
                        this.circleRadius = context.getDimensionPixelSize(n2, this.circleRadius);
                        continue block68;
                    }
                    case 2: {
                        this.circleConstraint = n3 = context.getResourceId(n2, this.circleConstraint);
                        if (n3 != -1) continue block68;
                        this.circleConstraint = context.getInt(n2, -1);
                        continue block68;
                    }
                    case 1: {
                        this.orientation = context.getInt(n2, this.orientation);
                    }
                }
            }
            context.recycle();
            this.validate();
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
            this.goneRightMargin = Integer.MIN_VALUE;
            this.goneBottomMargin = Integer.MIN_VALUE;
            this.goneStartMargin = Integer.MIN_VALUE;
            this.goneEndMargin = Integer.MIN_VALUE;
            this.goneBaselineMargin = Integer.MIN_VALUE;
            this.resolveGoneLeftMargin = Integer.MIN_VALUE;
            this.resolveGoneRightMargin = Integer.MIN_VALUE;
            this.widget = new ConstraintWidget();
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
            this.goneRightMargin = Integer.MIN_VALUE;
            this.goneBottomMargin = Integer.MIN_VALUE;
            this.goneStartMargin = Integer.MIN_VALUE;
            this.goneEndMargin = Integer.MIN_VALUE;
            this.goneBaselineMargin = Integer.MIN_VALUE;
            this.resolveGoneLeftMargin = Integer.MIN_VALUE;
            this.resolveGoneRightMargin = Integer.MIN_VALUE;
            this.widget = new ConstraintWidget();
            this.guideBegin = layoutParams.guideBegin;
            this.guideEnd = layoutParams.guideEnd;
            this.guidePercent = layoutParams.guidePercent;
            this.guidelineUseRtl = layoutParams.guidelineUseRtl;
            this.leftToLeft = layoutParams.leftToLeft;
            this.leftToRight = layoutParams.leftToRight;
            this.rightToLeft = layoutParams.rightToLeft;
            this.rightToRight = layoutParams.rightToRight;
            this.topToTop = layoutParams.topToTop;
            this.topToBottom = layoutParams.topToBottom;
            this.bottomToTop = layoutParams.bottomToTop;
            this.bottomToBottom = layoutParams.bottomToBottom;
            this.baselineToBaseline = layoutParams.baselineToBaseline;
            this.baselineToTop = layoutParams.baselineToTop;
            this.baselineToBottom = layoutParams.baselineToBottom;
            this.circleConstraint = layoutParams.circleConstraint;
            this.circleRadius = layoutParams.circleRadius;
            this.circleAngle = layoutParams.circleAngle;
            this.startToEnd = layoutParams.startToEnd;
            this.startToStart = layoutParams.startToStart;
            this.endToStart = layoutParams.endToStart;
            this.endToEnd = layoutParams.endToEnd;
            this.goneLeftMargin = layoutParams.goneLeftMargin;
            this.goneTopMargin = layoutParams.goneTopMargin;
            this.goneRightMargin = layoutParams.goneRightMargin;
            this.goneBottomMargin = layoutParams.goneBottomMargin;
            this.goneStartMargin = layoutParams.goneStartMargin;
            this.goneEndMargin = layoutParams.goneEndMargin;
            this.goneBaselineMargin = layoutParams.goneBaselineMargin;
            this.baselineMargin = layoutParams.baselineMargin;
            this.horizontalBias = layoutParams.horizontalBias;
            this.verticalBias = layoutParams.verticalBias;
            this.dimensionRatio = layoutParams.dimensionRatio;
            this.dimensionRatioValue = layoutParams.dimensionRatioValue;
            this.dimensionRatioSide = layoutParams.dimensionRatioSide;
            this.horizontalWeight = layoutParams.horizontalWeight;
            this.verticalWeight = layoutParams.verticalWeight;
            this.horizontalChainStyle = layoutParams.horizontalChainStyle;
            this.verticalChainStyle = layoutParams.verticalChainStyle;
            this.constrainedWidth = layoutParams.constrainedWidth;
            this.constrainedHeight = layoutParams.constrainedHeight;
            this.matchConstraintDefaultWidth = layoutParams.matchConstraintDefaultWidth;
            this.matchConstraintDefaultHeight = layoutParams.matchConstraintDefaultHeight;
            this.matchConstraintMinWidth = layoutParams.matchConstraintMinWidth;
            this.matchConstraintMaxWidth = layoutParams.matchConstraintMaxWidth;
            this.matchConstraintMinHeight = layoutParams.matchConstraintMinHeight;
            this.matchConstraintMaxHeight = layoutParams.matchConstraintMaxHeight;
            this.matchConstraintPercentWidth = layoutParams.matchConstraintPercentWidth;
            this.matchConstraintPercentHeight = layoutParams.matchConstraintPercentHeight;
            this.editorAbsoluteX = layoutParams.editorAbsoluteX;
            this.editorAbsoluteY = layoutParams.editorAbsoluteY;
            this.orientation = layoutParams.orientation;
            this.horizontalDimensionFixed = layoutParams.horizontalDimensionFixed;
            this.verticalDimensionFixed = layoutParams.verticalDimensionFixed;
            this.needsBaseline = layoutParams.needsBaseline;
            this.isGuideline = layoutParams.isGuideline;
            this.resolvedLeftToLeft = layoutParams.resolvedLeftToLeft;
            this.resolvedLeftToRight = layoutParams.resolvedLeftToRight;
            this.resolvedRightToLeft = layoutParams.resolvedRightToLeft;
            this.resolvedRightToRight = layoutParams.resolvedRightToRight;
            this.resolveGoneLeftMargin = layoutParams.resolveGoneLeftMargin;
            this.resolveGoneRightMargin = layoutParams.resolveGoneRightMargin;
            this.resolvedHorizontalBias = layoutParams.resolvedHorizontalBias;
            this.constraintTag = layoutParams.constraintTag;
            this.wrapBehaviorInParent = layoutParams.wrapBehaviorInParent;
            this.widget = layoutParams.widget;
            this.widthSet = layoutParams.widthSet;
            this.heightSet = layoutParams.heightSet;
        }

        public String getConstraintTag() {
            return this.constraintTag;
        }

        public ConstraintWidget getConstraintWidget() {
            return this.widget;
        }

        public void reset() {
            ConstraintWidget constraintWidget = this.widget;
            if (constraintWidget != null) {
                constraintWidget.reset();
            }
        }

        /*
         * Unable to fully structure code
         */
        public void resolveLayoutDirection(int var1_1) {
            var2_2 = this.leftMargin;
            var3_3 = this.rightMargin;
            var4_4 = Build.VERSION.SDK_INT;
            var5_5 = 0;
            if (var4_4 < 17) ** GOTO lbl-1000
            super.resolveLayoutDirection(var1_1);
            if (1 == this.getLayoutDirection()) {
                var1_1 = 1;
            } else lbl-1000:
            // 2 sources

            {
                var1_1 = 0;
            }
            this.resolvedRightToLeft = -1;
            this.resolvedRightToRight = -1;
            this.resolvedLeftToLeft = -1;
            this.resolvedLeftToRight = -1;
            this.resolveGoneLeftMargin = -1;
            this.resolveGoneRightMargin = -1;
            this.resolveGoneLeftMargin = this.goneLeftMargin;
            this.resolveGoneRightMargin = this.goneRightMargin;
            this.resolvedHorizontalBias = var6_6 = this.horizontalBias;
            this.resolvedGuideBegin = var7_7 = this.guideBegin;
            this.resolvedGuideEnd = var4_4 = this.guideEnd;
            this.resolvedGuidePercent = var8_8 = this.guidePercent;
            if (var1_1 != 0) {
                var1_1 = this.startToEnd;
                if (var1_1 != -1) {
                    this.resolvedRightToLeft = var1_1;
lbl27:
                    // 2 sources

                    while (true) {
                        var1_1 = 1;
                        break;
                    }
                } else {
                    var9_9 = this.startToStart;
                    var1_1 = var5_5;
                    if (var9_9 != -1) {
                        this.resolvedRightToRight = var9_9;
                        ** continue;
                    }
                }
                var5_5 = this.endToStart;
                if (var5_5 != -1) {
                    this.resolvedLeftToRight = var5_5;
                    var1_1 = 1;
                }
                if ((var5_5 = this.endToEnd) != -1) {
                    this.resolvedLeftToLeft = var5_5;
                    var1_1 = 1;
                }
                if ((var5_5 = this.goneStartMargin) != -2147483648) {
                    this.resolveGoneRightMargin = var5_5;
                }
                if ((var5_5 = this.goneEndMargin) != -2147483648) {
                    this.resolveGoneLeftMargin = var5_5;
                }
                if (var1_1 != 0) {
                    this.resolvedHorizontalBias = 1.0f - var6_6;
                }
                if (this.isGuideline && this.orientation == 1 && this.guidelineUseRtl) {
                    if (var8_8 != -1.0f) {
                        this.resolvedGuidePercent = 1.0f - var8_8;
                        this.resolvedGuideBegin = -1;
                        this.resolvedGuideEnd = -1;
                    } else if (var7_7 != -1) {
                        this.resolvedGuideEnd = var7_7;
                        this.resolvedGuideBegin = -1;
                        this.resolvedGuidePercent = -1.0f;
                    } else if (var4_4 != -1) {
                        this.resolvedGuideBegin = var4_4;
                        this.resolvedGuideEnd = -1;
                        this.resolvedGuidePercent = -1.0f;
                    }
                }
            } else {
                var1_1 = this.startToEnd;
                if (var1_1 != -1) {
                    this.resolvedLeftToRight = var1_1;
                }
                if ((var1_1 = this.startToStart) != -1) {
                    this.resolvedLeftToLeft = var1_1;
                }
                if ((var1_1 = this.endToStart) != -1) {
                    this.resolvedRightToLeft = var1_1;
                }
                if ((var1_1 = this.endToEnd) != -1) {
                    this.resolvedRightToRight = var1_1;
                }
                if ((var1_1 = this.goneStartMargin) != -2147483648) {
                    this.resolveGoneLeftMargin = var1_1;
                }
                if ((var1_1 = this.goneEndMargin) != -2147483648) {
                    this.resolveGoneRightMargin = var1_1;
                }
            }
            if (this.endToStart == -1 && this.endToEnd == -1 && this.startToStart == -1 && this.startToEnd == -1) {
                var1_1 = this.rightToLeft;
                if (var1_1 != -1) {
                    this.resolvedRightToLeft = var1_1;
                    if (this.rightMargin <= 0 && var3_3 > 0) {
                        this.rightMargin = var3_3;
                    }
                } else {
                    var1_1 = this.rightToRight;
                    if (var1_1 != -1) {
                        this.resolvedRightToRight = var1_1;
                        if (this.rightMargin <= 0 && var3_3 > 0) {
                            this.rightMargin = var3_3;
                        }
                    }
                }
                if ((var1_1 = this.leftToLeft) != -1) {
                    this.resolvedLeftToLeft = var1_1;
                    if (this.leftMargin <= 0 && var2_2 > 0) {
                        this.leftMargin = var2_2;
                    }
                } else {
                    var1_1 = this.leftToRight;
                    if (var1_1 != -1) {
                        this.resolvedLeftToRight = var1_1;
                        if (this.leftMargin <= 0 && var2_2 > 0) {
                            this.leftMargin = var2_2;
                        }
                    }
                }
            }
        }

        public void setWidgetDebugName(String string2) {
            this.widget.setDebugName(string2);
        }

        public void validate() {
            this.isGuideline = false;
            this.horizontalDimensionFixed = true;
            this.verticalDimensionFixed = true;
            if (this.width == -2 && this.constrainedWidth) {
                this.horizontalDimensionFixed = false;
                if (this.matchConstraintDefaultWidth == 0) {
                    this.matchConstraintDefaultWidth = 1;
                }
            }
            if (this.height == -2 && this.constrainedHeight) {
                this.verticalDimensionFixed = false;
                if (this.matchConstraintDefaultHeight == 0) {
                    this.matchConstraintDefaultHeight = 1;
                }
            }
            if (this.width == 0 || this.width == -1) {
                this.horizontalDimensionFixed = false;
                if (this.width == 0 && this.matchConstraintDefaultWidth == 1) {
                    this.width = -2;
                    this.constrainedWidth = true;
                }
            }
            if (this.height == 0 || this.height == -1) {
                this.verticalDimensionFixed = false;
                if (this.height == 0 && this.matchConstraintDefaultHeight == 1) {
                    this.height = -2;
                    this.constrainedHeight = true;
                }
            }
            if (this.guidePercent != -1.0f || this.guideBegin != -1 || this.guideEnd != -1) {
                this.isGuideline = true;
                this.horizontalDimensionFixed = true;
                this.verticalDimensionFixed = true;
                if (!(this.widget instanceof androidx.constraintlayout.core.widgets.Guideline)) {
                    this.widget = new androidx.constraintlayout.core.widgets.Guideline();
                }
                ((androidx.constraintlayout.core.widgets.Guideline)this.widget).setOrientation(this.orientation);
            }
        }

        private static class Table {
            public static final int ANDROID_ORIENTATION = 1;
            public static final int GUIDELINE_USE_RTL = 67;
            public static final int LAYOUT_CONSTRAINED_HEIGHT = 28;
            public static final int LAYOUT_CONSTRAINED_WIDTH = 27;
            public static final int LAYOUT_CONSTRAINT_BASELINE_CREATOR = 43;
            public static final int LAYOUT_CONSTRAINT_BASELINE_TO_BASELINE_OF = 16;
            public static final int LAYOUT_CONSTRAINT_BASELINE_TO_BOTTOM_OF = 53;
            public static final int LAYOUT_CONSTRAINT_BASELINE_TO_TOP_OF = 52;
            public static final int LAYOUT_CONSTRAINT_BOTTOM_CREATOR = 42;
            public static final int LAYOUT_CONSTRAINT_BOTTOM_TO_BOTTOM_OF = 15;
            public static final int LAYOUT_CONSTRAINT_BOTTOM_TO_TOP_OF = 14;
            public static final int LAYOUT_CONSTRAINT_CIRCLE = 2;
            public static final int LAYOUT_CONSTRAINT_CIRCLE_ANGLE = 4;
            public static final int LAYOUT_CONSTRAINT_CIRCLE_RADIUS = 3;
            public static final int LAYOUT_CONSTRAINT_DIMENSION_RATIO = 44;
            public static final int LAYOUT_CONSTRAINT_END_TO_END_OF = 20;
            public static final int LAYOUT_CONSTRAINT_END_TO_START_OF = 19;
            public static final int LAYOUT_CONSTRAINT_GUIDE_BEGIN = 5;
            public static final int LAYOUT_CONSTRAINT_GUIDE_END = 6;
            public static final int LAYOUT_CONSTRAINT_GUIDE_PERCENT = 7;
            public static final int LAYOUT_CONSTRAINT_HEIGHT = 65;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_DEFAULT = 32;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_MAX = 37;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_MIN = 36;
            public static final int LAYOUT_CONSTRAINT_HEIGHT_PERCENT = 38;
            public static final int LAYOUT_CONSTRAINT_HORIZONTAL_BIAS = 29;
            public static final int LAYOUT_CONSTRAINT_HORIZONTAL_CHAINSTYLE = 47;
            public static final int LAYOUT_CONSTRAINT_HORIZONTAL_WEIGHT = 45;
            public static final int LAYOUT_CONSTRAINT_LEFT_CREATOR = 39;
            public static final int LAYOUT_CONSTRAINT_LEFT_TO_LEFT_OF = 8;
            public static final int LAYOUT_CONSTRAINT_LEFT_TO_RIGHT_OF = 9;
            public static final int LAYOUT_CONSTRAINT_RIGHT_CREATOR = 41;
            public static final int LAYOUT_CONSTRAINT_RIGHT_TO_LEFT_OF = 10;
            public static final int LAYOUT_CONSTRAINT_RIGHT_TO_RIGHT_OF = 11;
            public static final int LAYOUT_CONSTRAINT_START_TO_END_OF = 17;
            public static final int LAYOUT_CONSTRAINT_START_TO_START_OF = 18;
            public static final int LAYOUT_CONSTRAINT_TAG = 51;
            public static final int LAYOUT_CONSTRAINT_TOP_CREATOR = 40;
            public static final int LAYOUT_CONSTRAINT_TOP_TO_BOTTOM_OF = 13;
            public static final int LAYOUT_CONSTRAINT_TOP_TO_TOP_OF = 12;
            public static final int LAYOUT_CONSTRAINT_VERTICAL_BIAS = 30;
            public static final int LAYOUT_CONSTRAINT_VERTICAL_CHAINSTYLE = 48;
            public static final int LAYOUT_CONSTRAINT_VERTICAL_WEIGHT = 46;
            public static final int LAYOUT_CONSTRAINT_WIDTH = 64;
            public static final int LAYOUT_CONSTRAINT_WIDTH_DEFAULT = 31;
            public static final int LAYOUT_CONSTRAINT_WIDTH_MAX = 34;
            public static final int LAYOUT_CONSTRAINT_WIDTH_MIN = 33;
            public static final int LAYOUT_CONSTRAINT_WIDTH_PERCENT = 35;
            public static final int LAYOUT_EDITOR_ABSOLUTEX = 49;
            public static final int LAYOUT_EDITOR_ABSOLUTEY = 50;
            public static final int LAYOUT_GONE_MARGIN_BASELINE = 55;
            public static final int LAYOUT_GONE_MARGIN_BOTTOM = 24;
            public static final int LAYOUT_GONE_MARGIN_END = 26;
            public static final int LAYOUT_GONE_MARGIN_LEFT = 21;
            public static final int LAYOUT_GONE_MARGIN_RIGHT = 23;
            public static final int LAYOUT_GONE_MARGIN_START = 25;
            public static final int LAYOUT_GONE_MARGIN_TOP = 22;
            public static final int LAYOUT_MARGIN_BASELINE = 54;
            public static final int LAYOUT_WRAP_BEHAVIOR_IN_PARENT = 66;
            public static final int UNUSED = 0;
            public static final SparseIntArray map;

            static {
                SparseIntArray sparseIntArray;
                map = sparseIntArray = new SparseIntArray();
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth, 64);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight, 65);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintLeft_toLeftOf, 8);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintLeft_toRightOf, 9);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintRight_toLeftOf, 10);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintRight_toRightOf, 11);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintTop_toTopOf, 12);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintTop_toBottomOf, 13);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBottom_toTopOf, 14);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBottom_toBottomOf, 15);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_toBaselineOf, 16);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_toTopOf, 52);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_toBottomOf, 53);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintCircle, 2);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintCircleRadius, 3);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintCircleAngle, 4);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_editor_absoluteX, 49);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_editor_absoluteY, 50);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintGuide_begin, 5);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintGuide_end, 6);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintGuide_percent, 7);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_guidelineUseRtl, 67);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_android_orientation, 1);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintStart_toEndOf, 17);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintStart_toStartOf, 18);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintEnd_toStartOf, 19);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintEnd_toEndOf, 20);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginLeft, 21);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginTop, 22);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginRight, 23);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginBottom, 24);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginStart, 25);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginEnd, 26);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_goneMarginBaseline, 55);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_marginBaseline, 54);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_bias, 29);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintVertical_bias, 30);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintDimensionRatio, 44);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_weight, 45);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintVertical_weight, 46);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHorizontal_chainStyle, 47);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintVertical_chainStyle, 48);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constrainedWidth, 27);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constrainedHeight, 28);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_default, 31);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_default, 32);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_min, 33);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_max, 34);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintWidth_percent, 35);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_min, 36);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_max, 37);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintHeight_percent, 38);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintLeft_creator, 39);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintTop_creator, 40);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintRight_creator, 41);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBottom_creator, 42);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintBaseline_creator, 43);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_constraintTag, 51);
                sparseIntArray.append(R.styleable.ConstraintLayout_Layout_layout_wrapBehaviorInParent, 66);
            }

            private Table() {
            }
        }
    }

    class Measurer
    implements BasicMeasure.Measurer {
        ConstraintLayout layout;
        int layoutHeightSpec;
        int layoutWidthSpec;
        int paddingBottom;
        int paddingHeight;
        int paddingTop;
        int paddingWidth;

        public Measurer(ConstraintLayout constraintLayout2) {
            this.layout = constraintLayout2;
        }

        private boolean isSimilarSpec(int n, int n2, int n3) {
            if (n == n2) {
                return true;
            }
            int n4 = View.MeasureSpec.getMode((int)n);
            View.MeasureSpec.getSize((int)n);
            n = View.MeasureSpec.getMode((int)n2);
            n2 = View.MeasureSpec.getSize((int)n2);
            return n == 0x40000000 && (n4 == Integer.MIN_VALUE || n4 == 0) && n3 == n2;
        }

        public void captureLayoutInfo(int n, int n2, int n3, int n4, int n5, int n6) {
            this.paddingTop = n3;
            this.paddingBottom = n4;
            this.paddingWidth = n5;
            this.paddingHeight = n6;
            this.layoutWidthSpec = n;
            this.layoutHeightSpec = n2;
        }

        @Override
        public final void didMeasures() {
            int n;
            int n2 = this.layout.getChildCount();
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                View view = this.layout.getChildAt(n);
                if (!(view instanceof Placeholder)) continue;
                ((Placeholder)view).updatePostMeasure(this.layout);
            }
            n2 = this.layout.mConstraintHelpers.size();
            if (n2 > 0) {
                for (n = n3; n < n2; ++n) {
                    ((ConstraintHelper)((Object)this.layout.mConstraintHelpers.get(n))).updatePostMeasure(this.layout);
                }
            }
        }

        @Override
        public final void measure(ConstraintWidget constraintWidget, BasicMeasure.Measure measure) {
            int n;
            int n2;
            int n3;
            Object object;
            block42: {
                int n4;
                int n5;
                int n6;
                View view;
                int n7;
                int n8;
                int n9;
                block43: {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    Object object2;
                    block41: {
                        block39: {
                            block35: {
                                block36: {
                                    block37: {
                                        block40: {
                                            block38: {
                                                block33: {
                                                    block29: {
                                                        block30: {
                                                            block31: {
                                                                block34: {
                                                                    block32: {
                                                                        if (constraintWidget == null) {
                                                                            return;
                                                                        }
                                                                        if (constraintWidget.getVisibility() == 8 && !constraintWidget.isInPlaceholder()) {
                                                                            measure.measuredWidth = 0;
                                                                            measure.measuredHeight = 0;
                                                                            measure.measuredBaseline = 0;
                                                                            return;
                                                                        }
                                                                        if (constraintWidget.getParent() == null) {
                                                                            return;
                                                                        }
                                                                        object = measure.horizontalBehavior;
                                                                        object2 = measure.verticalBehavior;
                                                                        n3 = measure.horizontalDimension;
                                                                        n9 = measure.verticalDimension;
                                                                        n8 = this.paddingTop + this.paddingBottom;
                                                                        n7 = this.paddingWidth;
                                                                        view = (View)constraintWidget.getCompanionWidget();
                                                                        n6 = 1.$SwitchMap$androidx$constraintlayout$core$widgets$ConstraintWidget$DimensionBehaviour[object.ordinal()];
                                                                        if (n6 == 1) break block29;
                                                                        if (n6 == 2) break block30;
                                                                        if (n6 == 3) break block31;
                                                                        if (n6 == 4) break block32;
                                                                        n7 = 0;
                                                                        break block33;
                                                                    }
                                                                    n3 = ViewGroup.getChildMeasureSpec((int)this.layoutWidthSpec, (int)n7, (int)-2);
                                                                    n6 = constraintWidget.mMatchConstraintDefaultWidth == 1 ? 1 : 0;
                                                                    if (measure.measureStrategy == BasicMeasure.Measure.TRY_GIVEN_DIMENSIONS) break block34;
                                                                    n7 = n3;
                                                                    if (measure.measureStrategy != BasicMeasure.Measure.USE_GIVEN_DIMENSIONS) break block33;
                                                                }
                                                                n7 = view.getMeasuredHeight() == constraintWidget.getHeight() ? 1 : 0;
                                                                n6 = !(measure.measureStrategy == BasicMeasure.Measure.USE_GIVEN_DIMENSIONS || n6 == 0 || n6 != 0 && n7 != 0 || view instanceof Placeholder || constraintWidget.isResolvedHorizontally()) ? 0 : 1;
                                                                n7 = n3;
                                                                if (n6 != 0) {
                                                                    n7 = View.MeasureSpec.makeMeasureSpec((int)constraintWidget.getWidth(), (int)0x40000000);
                                                                }
                                                                break block33;
                                                            }
                                                            n7 = ViewGroup.getChildMeasureSpec((int)this.layoutWidthSpec, (int)(n7 + constraintWidget.getHorizontalMargin()), (int)-1);
                                                            break block33;
                                                        }
                                                        n7 = ViewGroup.getChildMeasureSpec((int)this.layoutWidthSpec, (int)n7, (int)-2);
                                                        break block33;
                                                    }
                                                    n7 = View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000);
                                                }
                                                n6 = 1.$SwitchMap$androidx$constraintlayout$core$widgets$ConstraintWidget$DimensionBehaviour[object2.ordinal()];
                                                if (n6 == 1) break block35;
                                                if (n6 == 2) break block36;
                                                if (n6 == 3) break block37;
                                                if (n6 == 4) break block38;
                                                n6 = 0;
                                                break block39;
                                            }
                                            n9 = ViewGroup.getChildMeasureSpec((int)this.layoutHeightSpec, (int)n8, (int)-2);
                                            n3 = constraintWidget.mMatchConstraintDefaultHeight == 1 ? 1 : 0;
                                            if (measure.measureStrategy == BasicMeasure.Measure.TRY_GIVEN_DIMENSIONS) break block40;
                                            n6 = n9;
                                            if (measure.measureStrategy != BasicMeasure.Measure.USE_GIVEN_DIMENSIONS) break block39;
                                        }
                                        n6 = view.getMeasuredWidth() == constraintWidget.getWidth() ? 1 : 0;
                                        n3 = !(measure.measureStrategy == BasicMeasure.Measure.USE_GIVEN_DIMENSIONS || n3 == 0 || n3 != 0 && n6 != 0 || view instanceof Placeholder || constraintWidget.isResolvedVertically()) ? 0 : 1;
                                        n6 = n9;
                                        if (n3 != 0) {
                                            n6 = View.MeasureSpec.makeMeasureSpec((int)constraintWidget.getHeight(), (int)0x40000000);
                                        }
                                        break block39;
                                    }
                                    n6 = ViewGroup.getChildMeasureSpec((int)this.layoutHeightSpec, (int)(n8 + constraintWidget.getVerticalMargin()), (int)-1);
                                    break block39;
                                }
                                n6 = ViewGroup.getChildMeasureSpec((int)this.layoutHeightSpec, (int)n8, (int)-2);
                                break block39;
                            }
                            n6 = View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000);
                        }
                        ConstraintWidgetContainer constraintWidgetContainer = (ConstraintWidgetContainer)constraintWidget.getParent();
                        if (constraintWidgetContainer != null && Optimizer.enabled(ConstraintLayout.this.mOptimizationLevel, 256) && view.getMeasuredWidth() == constraintWidget.getWidth() && view.getMeasuredWidth() < constraintWidgetContainer.getWidth() && view.getMeasuredHeight() == constraintWidget.getHeight() && view.getMeasuredHeight() < constraintWidgetContainer.getHeight() && view.getBaseline() == constraintWidget.getBaselineDistance() && !constraintWidget.isMeasureRequested() && (n3 = this.isSimilarSpec(constraintWidget.getLastHorizontalMeasureSpec(), n7, constraintWidget.getWidth()) && this.isSimilarSpec(constraintWidget.getLastVerticalMeasureSpec(), n6, constraintWidget.getHeight()) ? 1 : 0) != 0) {
                            measure.measuredWidth = constraintWidget.getWidth();
                            measure.measuredHeight = constraintWidget.getHeight();
                            measure.measuredBaseline = constraintWidget.getBaselineDistance();
                            return;
                        }
                        n3 = object == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
                        n9 = object2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT ? 1 : 0;
                        n2 = object2 != ConstraintWidget.DimensionBehaviour.MATCH_PARENT && object2 != ConstraintWidget.DimensionBehaviour.FIXED ? 0 : 1;
                        bl3 = object == ConstraintWidget.DimensionBehaviour.MATCH_PARENT || object == ConstraintWidget.DimensionBehaviour.FIXED;
                        bl2 = n3 != 0 && constraintWidget.mDimensionRatio > 0.0f;
                        bl = n9 != 0 && constraintWidget.mDimensionRatio > 0.0f;
                        if (view == null) {
                            return;
                        }
                        object = (LayoutParams)view.getLayoutParams();
                        if (measure.measureStrategy == BasicMeasure.Measure.TRY_GIVEN_DIMENSIONS || measure.measureStrategy == BasicMeasure.Measure.USE_GIVEN_DIMENSIONS || n3 == 0 || constraintWidget.mMatchConstraintDefaultWidth != 0 || n9 == 0 || constraintWidget.mMatchConstraintDefaultHeight != 0) break block41;
                        n = 0;
                        n3 = 0;
                        n2 = 0;
                        break block42;
                    }
                    if (view instanceof VirtualLayout && constraintWidget instanceof androidx.constraintlayout.core.widgets.VirtualLayout) {
                        object2 = (androidx.constraintlayout.core.widgets.VirtualLayout)constraintWidget;
                        ((VirtualLayout)view).onMeasure((androidx.constraintlayout.core.widgets.VirtualLayout)object2, n7, n6);
                    } else {
                        view.measure(n7, n6);
                    }
                    constraintWidget.setLastMeasureSpec(n7, n6);
                    n5 = view.getMeasuredWidth();
                    n4 = view.getMeasuredHeight();
                    int n10 = view.getBaseline();
                    n9 = constraintWidget.mMatchConstraintMinWidth > 0 ? Math.max(constraintWidget.mMatchConstraintMinWidth, n5) : n5;
                    n3 = n9;
                    if (constraintWidget.mMatchConstraintMaxWidth > 0) {
                        n3 = Math.min(constraintWidget.mMatchConstraintMaxWidth, n9);
                    }
                    n9 = constraintWidget.mMatchConstraintMinHeight > 0 ? Math.max(constraintWidget.mMatchConstraintMinHeight, n4) : n4;
                    n = n9;
                    if (constraintWidget.mMatchConstraintMaxHeight > 0) {
                        n = Math.min(constraintWidget.mMatchConstraintMaxHeight, n9);
                    }
                    n8 = n3;
                    n9 = n;
                    if (!Optimizer.enabled(ConstraintLayout.this.mOptimizationLevel, 1)) {
                        if (bl2 && n2 != 0) {
                            float f = constraintWidget.mDimensionRatio;
                            n8 = (int)((float)n * f + 0.5f);
                            n9 = n;
                        } else {
                            n8 = n3;
                            n9 = n;
                            if (bl) {
                                n8 = n3;
                                n9 = n;
                                if (bl3) {
                                    float f = constraintWidget.mDimensionRatio;
                                    n9 = (int)((float)n3 / f + 0.5f);
                                    n8 = n3;
                                }
                            }
                        }
                    }
                    if (n5 != n8) break block43;
                    n = n10;
                    n3 = n8;
                    n2 = n9;
                    if (n4 == n9) break block42;
                }
                if (n5 != n8) {
                    n7 = View.MeasureSpec.makeMeasureSpec((int)n8, (int)0x40000000);
                }
                if (n4 != n9) {
                    n6 = View.MeasureSpec.makeMeasureSpec((int)n9, (int)0x40000000);
                }
                view.measure(n7, n6);
                constraintWidget.setLastMeasureSpec(n7, n6);
                n3 = view.getMeasuredWidth();
                n2 = view.getMeasuredHeight();
                n = view.getBaseline();
            }
            boolean bl = n != -1;
            boolean bl4 = n3 != measure.horizontalDimension || n2 != measure.verticalDimension;
            measure.measuredNeedsSolverPass = bl4;
            if (((LayoutParams)((Object)object)).needsBaseline) {
                bl = true;
            }
            if (bl && n != -1 && constraintWidget.getBaselineDistance() != n) {
                measure.measuredNeedsSolverPass = true;
            }
            measure.measuredWidth = n3;
            measure.measuredHeight = n2;
            measure.measuredHasBaseline = bl;
            measure.measuredBaseline = n;
        }
    }
}

