/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.ConstraintsChangedListener;
import androidx.constraintlayout.widget.R;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConstraintLayoutStates {
    private static final boolean DEBUG = false;
    public static final String TAG = "ConstraintLayoutStates";
    private final ConstraintLayout mConstraintLayout;
    private SparseArray<ConstraintSet> mConstraintSetMap;
    private ConstraintsChangedListener mConstraintsChangedListener = null;
    int mCurrentConstraintNumber = -1;
    int mCurrentStateId = -1;
    ConstraintSet mDefaultConstraintSet;
    private SparseArray<State> mStateList = new SparseArray();

    ConstraintLayoutStates(Context context, ConstraintLayout constraintLayout, int n) {
        this.mConstraintSetMap = new SparseArray();
        this.mConstraintLayout = constraintLayout;
        this.load(context, n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load(Context context, int n) {
        XmlResourceParser xmlResourceParser = context.getResources().getXml(n);
        String string2 = null;
        try {
            n = xmlResourceParser.getEventType();
            while (true) {
                Object object;
                block16: {
                    block17: {
                        block20: {
                            block19: {
                                int n2;
                                block18: {
                                    n2 = 1;
                                    if (n == 1) return;
                                    if (n == 0) break block17;
                                    if (n == 2) break block18;
                                    object = string2;
                                    break block16;
                                }
                                object = xmlResourceParser.getName();
                                switch (((String)object).hashCode()) {
                                    default: {
                                        break;
                                    }
                                    case 1901439077: {
                                        if (!((String)object).equals("Variant")) break;
                                        n = 3;
                                        break block19;
                                    }
                                    case 1657696882: {
                                        if (!((String)object).equals("layoutDescription")) break;
                                        n = 0;
                                        break block19;
                                    }
                                    case 1382829617: {
                                        if (!((String)object).equals("StateSet")) break;
                                        n = n2;
                                        break block19;
                                    }
                                    case 80204913: {
                                        if (!((String)object).equals("State")) break;
                                        n = 2;
                                        break block19;
                                    }
                                    case -1349929691: {
                                        if (!((String)object).equals("ConstraintSet")) break;
                                        n = 4;
                                        break block19;
                                    }
                                }
                                n = -1;
                            }
                            if (n == 2) break block20;
                            if (n != 3) {
                                if (n != 4) {
                                    object = string2;
                                    break block16;
                                } else {
                                    this.parseConstraintSet(context, (XmlPullParser)xmlResourceParser);
                                    object = string2;
                                }
                                break block16;
                            } else {
                                Variant variant = new Variant(context, (XmlPullParser)xmlResourceParser);
                                object = string2;
                                if (string2 != null) {
                                    ((State)((Object)string2)).add(variant);
                                    object = string2;
                                }
                            }
                            break block16;
                        }
                        object = new State(context, (XmlPullParser)xmlResourceParser);
                        this.mStateList.put(((State)object).mId, object);
                        break block16;
                    }
                    xmlResourceParser.getName();
                    object = string2;
                }
                n = xmlResourceParser.next();
                string2 = object;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    private void parseConstraintSet(Context context, XmlPullParser xmlPullParser) {
        ConstraintSet constraintSet = new ConstraintSet();
        int n = xmlPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            String string2 = xmlPullParser.getAttributeName(i);
            String string3 = xmlPullParser.getAttributeValue(i);
            if (string2 == null || string3 == null || !"id".equals(string2)) continue;
            if (string3.contains("/")) {
                string2 = string3.substring(string3.indexOf(47) + 1);
                i = context.getResources().getIdentifier(string2, "id", context.getPackageName());
            } else {
                i = -1;
            }
            n = i;
            if (i == -1) {
                if (string3.length() > 1) {
                    n = Integer.parseInt(string3.substring(1));
                } else {
                    Log.e((String)TAG, (String)"error in parsing id");
                    n = i;
                }
            }
            constraintSet.load(context, xmlPullParser);
            this.mConstraintSetMap.put(n, (Object)constraintSet);
            break;
        }
    }

    public boolean needsToChange(int n, float f, float f2) {
        int n2 = this.mCurrentStateId;
        if (n2 != n) {
            return true;
        }
        Object object = n == -1 ? this.mStateList.valueAt(0) : this.mStateList.get(n2);
        object = (State)object;
        if (this.mCurrentConstraintNumber != -1 && ((State)object).mVariants.get(this.mCurrentConstraintNumber).match(f, f2)) {
            return false;
        }
        return this.mCurrentConstraintNumber != ((State)object).findMatch(f, f2);
    }

    public void setOnConstraintsChanged(ConstraintsChangedListener constraintsChangedListener) {
        this.mConstraintsChangedListener = constraintsChangedListener;
    }

    public void updateConstraints(int n, float f, float f2) {
        int n2 = this.mCurrentStateId;
        if (n2 == n) {
            Object object = n == -1 ? (State)this.mStateList.valueAt(0) : (State)this.mStateList.get(n2);
            if (this.mCurrentConstraintNumber != -1 && ((State)object).mVariants.get(this.mCurrentConstraintNumber).match(f, f2)) {
                return;
            }
            n2 = ((State)object).findMatch(f, f2);
            if (this.mCurrentConstraintNumber == n2) {
                return;
            }
            ConstraintSet constraintSet = n2 == -1 ? this.mDefaultConstraintSet : ((State)object).mVariants.get((int)n2).mConstraintSet;
            n = n2 == -1 ? ((State)object).mConstraintID : ((State)object).mVariants.get((int)n2).mConstraintID;
            if (constraintSet == null) {
                return;
            }
            this.mCurrentConstraintNumber = n2;
            object = this.mConstraintsChangedListener;
            if (object != null) {
                ((ConstraintsChangedListener)object).preLayoutChange(-1, n);
            }
            constraintSet.applyTo(this.mConstraintLayout);
            object = this.mConstraintsChangedListener;
            if (object != null) {
                ((ConstraintsChangedListener)object).postLayoutChange(-1, n);
            }
        } else {
            this.mCurrentStateId = n;
            Object object = (State)this.mStateList.get(n);
            int n3 = ((State)object).findMatch(f, f2);
            Object object2 = n3 == -1 ? ((State)object).mConstraintSet : ((State)object).mVariants.get((int)n3).mConstraintSet;
            n2 = n3 == -1 ? ((State)object).mConstraintID : ((State)object).mVariants.get((int)n3).mConstraintID;
            if (object2 == null) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("NO Constraint set found ! id=");
                ((StringBuilder)object2).append(n);
                ((StringBuilder)object2).append(", dim =");
                ((StringBuilder)object2).append(f);
                ((StringBuilder)object2).append(", ");
                ((StringBuilder)object2).append(f2);
                Log.v((String)TAG, (String)((StringBuilder)object2).toString());
                return;
            }
            this.mCurrentConstraintNumber = n3;
            object = this.mConstraintsChangedListener;
            if (object != null) {
                ((ConstraintsChangedListener)object).preLayoutChange(n, n2);
            }
            ((ConstraintSet)object2).applyTo(this.mConstraintLayout);
            object2 = this.mConstraintsChangedListener;
            if (object2 != null) {
                ((ConstraintsChangedListener)object2).postLayoutChange(n, n2);
            }
        }
    }

    static class State {
        int mConstraintID = -1;
        ConstraintSet mConstraintSet;
        int mId;
        ArrayList<Variant> mVariants = new ArrayList();

        public State(Context context, XmlPullParser xmlPullParser) {
            xmlPullParser = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)xmlPullParser), R.styleable.State);
            int n = xmlPullParser.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = xmlPullParser.getIndex(i);
                if (n2 == R.styleable.State_android_id) {
                    this.mId = xmlPullParser.getResourceId(n2, this.mId);
                    continue;
                }
                if (n2 != R.styleable.State_constraints) continue;
                this.mConstraintID = xmlPullParser.getResourceId(n2, this.mConstraintID);
                Object object = context.getResources().getResourceTypeName(this.mConstraintID);
                context.getResources().getResourceName(this.mConstraintID);
                if (!"layout".equals(object)) continue;
                this.mConstraintSet = object = new ConstraintSet();
                ((ConstraintSet)object).clone(context, this.mConstraintID);
            }
            xmlPullParser.recycle();
        }

        void add(Variant variant) {
            this.mVariants.add(variant);
        }

        public int findMatch(float f, float f2) {
            for (int i = 0; i < this.mVariants.size(); ++i) {
                if (!this.mVariants.get(i).match(f, f2)) continue;
                return i;
            }
            return -1;
        }
    }

    static class Variant {
        int mConstraintID = -1;
        ConstraintSet mConstraintSet;
        int mId;
        float mMaxHeight;
        float mMaxWidth;
        float mMinHeight;
        float mMinWidth = Float.NaN;

        public Variant(Context context, XmlPullParser xmlPullParser) {
            this.mMinHeight = Float.NaN;
            this.mMaxWidth = Float.NaN;
            this.mMaxHeight = Float.NaN;
            xmlPullParser = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)xmlPullParser), R.styleable.Variant);
            int n = xmlPullParser.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = xmlPullParser.getIndex(i);
                if (n2 == R.styleable.Variant_constraints) {
                    this.mConstraintID = xmlPullParser.getResourceId(n2, this.mConstraintID);
                    Object object = context.getResources().getResourceTypeName(this.mConstraintID);
                    context.getResources().getResourceName(this.mConstraintID);
                    if (!"layout".equals(object)) continue;
                    this.mConstraintSet = object = new ConstraintSet();
                    ((ConstraintSet)object).clone(context, this.mConstraintID);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_heightLessThan) {
                    this.mMaxHeight = xmlPullParser.getDimension(n2, this.mMaxHeight);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_heightMoreThan) {
                    this.mMinHeight = xmlPullParser.getDimension(n2, this.mMinHeight);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_widthLessThan) {
                    this.mMaxWidth = xmlPullParser.getDimension(n2, this.mMaxWidth);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_widthMoreThan) {
                    this.mMinWidth = xmlPullParser.getDimension(n2, this.mMinWidth);
                    continue;
                }
                Log.v((String)ConstraintLayoutStates.TAG, (String)"Unknown tag");
            }
            xmlPullParser.recycle();
        }

        boolean match(float f, float f2) {
            if (!Float.isNaN(this.mMinWidth) && f < this.mMinWidth) {
                return false;
            }
            if (!Float.isNaN(this.mMinHeight) && f2 < this.mMinHeight) {
                return false;
            }
            if (!Float.isNaN(this.mMaxWidth) && f > this.mMaxWidth) {
                return false;
            }
            return Float.isNaN(this.mMaxHeight) || !(f2 > this.mMaxHeight);
        }
    }
}

