/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import androidx.constraintlayout.widget.SharedValues;

public class ReactiveGuide
extends View
implements SharedValues.SharedValuesListener {
    private boolean mAnimateChange = false;
    private boolean mApplyToAllConstraintSets = true;
    private int mApplyToConstraintSetId = 0;
    private int mAttributeId = -1;

    public ReactiveGuide(Context context) {
        super(context);
        super.setVisibility(8);
        this.init(null);
    }

    public ReactiveGuide(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        super.setVisibility(8);
        this.init(attributeSet);
    }

    public ReactiveGuide(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        super.setVisibility(8);
        this.init(attributeSet);
    }

    public ReactiveGuide(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n);
        super.setVisibility(8);
        this.init(attributeSet);
    }

    private void changeValue(int n, int n2, MotionLayout motionLayout, int n3) {
        ConstraintSet constraintSet = motionLayout.getConstraintSet(n3);
        constraintSet.setGuidelineEnd(n2, n);
        motionLayout.updateState(n3, constraintSet);
    }

    private void init(AttributeSet attributeSet) {
        if (attributeSet != null) {
            attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ConstraintLayout_ReactiveGuide);
            int n = attributeSet.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = attributeSet.getIndex(i);
                if (n2 == R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_valueId) {
                    this.mAttributeId = attributeSet.getResourceId(n2, this.mAttributeId);
                    continue;
                }
                if (n2 == R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_animateChange) {
                    this.mAnimateChange = attributeSet.getBoolean(n2, this.mAnimateChange);
                    continue;
                }
                if (n2 == R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_applyToConstraintSet) {
                    this.mApplyToConstraintSetId = attributeSet.getResourceId(n2, this.mApplyToConstraintSetId);
                    continue;
                }
                if (n2 != R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_applyToAllConstraintSets) continue;
                this.mApplyToAllConstraintSets = attributeSet.getBoolean(n2, this.mApplyToAllConstraintSets);
            }
            attributeSet.recycle();
        }
        if (this.mAttributeId != -1) {
            ConstraintLayout.getSharedValues().addListener(this.mAttributeId, this);
        }
    }

    public void draw(Canvas canvas) {
    }

    public int getApplyToConstraintSetId() {
        return this.mApplyToConstraintSetId;
    }

    public int getAttributeId() {
        return this.mAttributeId;
    }

    public boolean isAnimatingChange() {
        return this.mAnimateChange;
    }

    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(0, 0);
    }

    @Override
    public void onNewValue(int n, int n2, int n3) {
        this.setGuidelineBegin(n2);
        int n4 = this.getId();
        if (n4 <= 0) {
            return;
        }
        if (this.getParent() instanceof MotionLayout) {
            MotionLayout motionLayout = (MotionLayout)this.getParent();
            n = motionLayout.getCurrentState();
            n3 = this.mApplyToConstraintSetId;
            if (n3 != 0) {
                n = n3;
            }
            boolean bl = this.mAnimateChange;
            Object object = 0;
            if (bl) {
                Object object2;
                if (this.mApplyToAllConstraintSets) {
                    object2 = motionLayout.getConstraintSetIds();
                    for (n3 = 0; n3 < ((int[])object2).length; ++n3) {
                        object = object2[n3];
                        if (object == n) continue;
                        this.changeValue(n2, n4, motionLayout, (int)object);
                    }
                }
                object2 = motionLayout.cloneConstraintSet(n);
                ((ConstraintSet)object2).setGuidelineEnd(n4, n2);
                motionLayout.updateStateAnimate(n, (ConstraintSet)object2, 1000);
            } else if (this.mApplyToAllConstraintSets) {
                int[] nArray = motionLayout.getConstraintSetIds();
                for (n = object; n < nArray.length; ++n) {
                    this.changeValue(n2, n4, motionLayout, nArray[n]);
                }
            } else {
                this.changeValue(n2, n4, motionLayout, n);
            }
        }
    }

    public void setAnimateChange(boolean bl) {
        this.mAnimateChange = bl;
    }

    public void setApplyToConstraintSetId(int n) {
        this.mApplyToConstraintSetId = n;
    }

    public void setAttributeId(int n) {
        SharedValues sharedValues = ConstraintLayout.getSharedValues();
        int n2 = this.mAttributeId;
        if (n2 != -1) {
            sharedValues.removeListener(n2, this);
        }
        this.mAttributeId = n;
        if (n != -1) {
            sharedValues.addListener(n, this);
        }
    }

    public void setGuidelineBegin(int n) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        layoutParams.guideBegin = n;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setGuidelineEnd(int n) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        layoutParams.guideEnd = n;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setGuidelinePercent(float f) {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        layoutParams.guidePercent = f;
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setVisibility(int n) {
    }
}

