/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.util.SparseIntArray;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SharedValues {
    public static final int UNSET = -1;
    private SparseIntArray mValues = new SparseIntArray();
    private HashMap<Integer, HashSet<WeakReference<SharedValuesListener>>> mValuesListeners = new HashMap();

    public void addListener(int n, SharedValuesListener sharedValuesListener) {
        HashSet<WeakReference<SharedValuesListener>> hashSet;
        HashSet<WeakReference<SharedValuesListener>> hashSet2 = hashSet = this.mValuesListeners.get(n);
        if (hashSet == null) {
            hashSet2 = new HashSet();
            this.mValuesListeners.put(n, hashSet2);
        }
        hashSet2.add(new WeakReference<SharedValuesListener>(sharedValuesListener));
    }

    public void clearListeners() {
        this.mValuesListeners.clear();
    }

    public void fireNewValue(int n, int n2) {
        int n3 = this.mValues.get(n, -1);
        if (n3 == n2) {
            return;
        }
        this.mValues.put(n, n2);
        HashSet<WeakReference<SharedValuesListener>> hashSet = this.mValuesListeners.get(n);
        if (hashSet == null) {
            return;
        }
        Object object = hashSet.iterator();
        boolean bl = false;
        while (object.hasNext()) {
            SharedValuesListener sharedValuesListener = (SharedValuesListener)object.next().get();
            if (sharedValuesListener != null) {
                sharedValuesListener.onNewValue(n, n2, n3);
                continue;
            }
            bl = true;
        }
        if (bl) {
            object = new ArrayList();
            for (WeakReference weakReference : hashSet) {
                if ((SharedValuesListener)weakReference.get() != null) continue;
                object.add(weakReference);
            }
            hashSet.removeAll((Collection<?>)object);
        }
    }

    public int getValue(int n) {
        return this.mValues.get(n, -1);
    }

    public void removeListener(int n, SharedValuesListener sharedValuesListener) {
        HashSet<WeakReference<SharedValuesListener>> hashSet = this.mValuesListeners.get(n);
        if (hashSet == null) {
            return;
        }
        ArrayList<WeakReference<SharedValuesListener>> arrayList = new ArrayList<WeakReference<SharedValuesListener>>();
        for (WeakReference<SharedValuesListener> weakReference : hashSet) {
            SharedValuesListener sharedValuesListener2 = (SharedValuesListener)weakReference.get();
            if (sharedValuesListener2 != null && sharedValuesListener2 != sharedValuesListener) continue;
            arrayList.add(weakReference);
        }
        hashSet.removeAll(arrayList);
    }

    public void removeListener(SharedValuesListener sharedValuesListener) {
        Iterator<Integer> iterator = this.mValuesListeners.keySet().iterator();
        while (iterator.hasNext()) {
            this.removeListener(iterator.next(), sharedValuesListener);
        }
    }

    public static interface SharedValuesListener {
        public void onNewValue(int var1, int var2, int var3);
    }
}

