/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.ConstraintsChangedListener;
import androidx.constraintlayout.widget.R;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateSet {
    private static final boolean DEBUG = false;
    public static final String TAG = "ConstraintLayoutStates";
    private SparseArray<ConstraintSet> mConstraintSetMap;
    private ConstraintsChangedListener mConstraintsChangedListener = null;
    int mCurrentConstraintNumber = -1;
    int mCurrentStateId = -1;
    ConstraintSet mDefaultConstraintSet;
    int mDefaultState = -1;
    private SparseArray<State> mStateList = new SparseArray();

    public StateSet(Context context, XmlPullParser xmlPullParser) {
        this.mConstraintSetMap = new SparseArray();
        this.load(context, xmlPullParser);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void load(Context context, XmlPullParser xmlPullParser) {
        int n;
        Object object = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)xmlPullParser), R.styleable.StateSet);
        int n2 = object.getIndexCount();
        for (n = 0; n < n2; ++n) {
            int n3 = object.getIndex(n);
            if (n3 != R.styleable.StateSet_defaultState) continue;
            this.mDefaultState = object.getResourceId(n3, this.mDefaultState);
        }
        object.recycle();
        object = null;
        try {
            n = xmlPullParser.getEventType();
            while (true) {
                Object object2;
                block17: {
                    block18: {
                        block21: {
                            block20: {
                                block19: {
                                    n2 = 1;
                                    if (n == 1) return;
                                    if (n == 0) break block18;
                                    if (n == 2) break block19;
                                    if (n != 3) {
                                        object2 = object;
                                        break block17;
                                    } else {
                                        object2 = object;
                                        if ("StateSet".equals(xmlPullParser.getName())) {
                                            return;
                                        }
                                    }
                                    break block17;
                                }
                                object2 = xmlPullParser.getName();
                                switch (((String)object2).hashCode()) {
                                    default: {
                                        break;
                                    }
                                    case 1901439077: {
                                        if (!((String)object2).equals("Variant")) break;
                                        n = 3;
                                        break block20;
                                    }
                                    case 1382829617: {
                                        if (!((String)object2).equals("StateSet")) break;
                                        n = n2;
                                        break block20;
                                    }
                                    case 1301459538: {
                                        if (!((String)object2).equals("LayoutDescription")) break;
                                        n = 0;
                                        break block20;
                                    }
                                    case 80204913: {
                                        if (!((String)object2).equals("State")) break;
                                        n = 2;
                                        break block20;
                                    }
                                }
                                n = -1;
                            }
                            if (n == 2) break block21;
                            if (n != 3) {
                                object2 = object;
                                break block17;
                            } else {
                                Variant variant = new Variant(context, xmlPullParser);
                                object2 = object;
                                if (object != null) {
                                    ((State)object).add(variant);
                                    object2 = object;
                                }
                            }
                            break block17;
                        }
                        object2 = new State(context, xmlPullParser);
                        this.mStateList.put(((State)object2).mId, object2);
                        break block17;
                    }
                    xmlPullParser.getName();
                    object2 = object;
                }
                n = xmlPullParser.next();
                object = object2;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
    }

    public int convertToConstraintSet(int n, int n2, float f, float f2) {
        State state = (State)this.mStateList.get(n2);
        if (state == null) {
            return n2;
        }
        if (f != -1.0f && f2 != -1.0f) {
            Variant variant = null;
            for (Variant variant2 : state.mVariants) {
                if (!variant2.match(f, f2)) continue;
                if (n == variant2.mConstraintID) {
                    return n;
                }
                variant = variant2;
            }
            if (variant != null) {
                return variant.mConstraintID;
            }
            return state.mConstraintID;
        }
        if (state.mConstraintID == n) {
            return n;
        }
        Iterator<Variant> iterator = state.mVariants.iterator();
        while (iterator.hasNext()) {
            if (n != iterator.next().mConstraintID) continue;
            return n;
        }
        return state.mConstraintID;
    }

    public boolean needsToChange(int n, float f, float f2) {
        int n2 = this.mCurrentStateId;
        if (n2 != n) {
            return true;
        }
        Object object = n == -1 ? this.mStateList.valueAt(0) : this.mStateList.get(n2);
        object = (State)object;
        if (this.mCurrentConstraintNumber != -1 && ((State)object).mVariants.get(this.mCurrentConstraintNumber).match(f, f2)) {
            return false;
        }
        return this.mCurrentConstraintNumber != ((State)object).findMatch(f, f2);
    }

    public void setOnConstraintsChanged(ConstraintsChangedListener constraintsChangedListener) {
        this.mConstraintsChangedListener = constraintsChangedListener;
    }

    public int stateGetConstraintID(int n, int n2, int n3) {
        return this.updateConstraints(-1, n, n2, n3);
    }

    public int updateConstraints(int n, int n2, float f, float f2) {
        if (n == n2) {
            State state = n2 == -1 ? (State)this.mStateList.valueAt(0) : (State)this.mStateList.get(this.mCurrentStateId);
            if (state == null) {
                return -1;
            }
            if (this.mCurrentConstraintNumber != -1 && state.mVariants.get(n).match(f, f2)) {
                return n;
            }
            n2 = state.findMatch(f, f2);
            if (n == n2) {
                return n;
            }
            n = n2 == -1 ? state.mConstraintID : state.mVariants.get((int)n2).mConstraintID;
            return n;
        }
        State state = (State)this.mStateList.get(n2);
        if (state == null) {
            return -1;
        }
        n = state.findMatch(f, f2);
        n = n == -1 ? state.mConstraintID : state.mVariants.get((int)n).mConstraintID;
        return n;
    }

    static class State {
        int mConstraintID = -1;
        int mId;
        boolean mIsLayout = false;
        ArrayList<Variant> mVariants = new ArrayList();

        public State(Context context, XmlPullParser object) {
            TypedArray typedArray = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)object), R.styleable.State);
            int n = typedArray.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = typedArray.getIndex(i);
                if (n2 == R.styleable.State_android_id) {
                    this.mId = typedArray.getResourceId(n2, this.mId);
                    continue;
                }
                if (n2 != R.styleable.State_constraints) continue;
                this.mConstraintID = typedArray.getResourceId(n2, this.mConstraintID);
                object = context.getResources().getResourceTypeName(this.mConstraintID);
                context.getResources().getResourceName(this.mConstraintID);
                if (!"layout".equals(object)) continue;
                this.mIsLayout = true;
            }
            typedArray.recycle();
        }

        void add(Variant variant) {
            this.mVariants.add(variant);
        }

        public int findMatch(float f, float f2) {
            for (int i = 0; i < this.mVariants.size(); ++i) {
                if (!this.mVariants.get(i).match(f, f2)) continue;
                return i;
            }
            return -1;
        }
    }

    static class Variant {
        int mConstraintID = -1;
        int mId;
        boolean mIsLayout = false;
        float mMaxHeight;
        float mMaxWidth;
        float mMinHeight;
        float mMinWidth = Float.NaN;

        public Variant(Context context, XmlPullParser object) {
            this.mMinHeight = Float.NaN;
            this.mMaxWidth = Float.NaN;
            this.mMaxHeight = Float.NaN;
            TypedArray typedArray = context.obtainStyledAttributes(Xml.asAttributeSet((XmlPullParser)object), R.styleable.Variant);
            int n = typedArray.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = typedArray.getIndex(i);
                if (n2 == R.styleable.Variant_constraints) {
                    this.mConstraintID = typedArray.getResourceId(n2, this.mConstraintID);
                    object = context.getResources().getResourceTypeName(this.mConstraintID);
                    context.getResources().getResourceName(this.mConstraintID);
                    if (!"layout".equals(object)) continue;
                    this.mIsLayout = true;
                    continue;
                }
                if (n2 == R.styleable.Variant_region_heightLessThan) {
                    this.mMaxHeight = typedArray.getDimension(n2, this.mMaxHeight);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_heightMoreThan) {
                    this.mMinHeight = typedArray.getDimension(n2, this.mMinHeight);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_widthLessThan) {
                    this.mMaxWidth = typedArray.getDimension(n2, this.mMaxWidth);
                    continue;
                }
                if (n2 == R.styleable.Variant_region_widthMoreThan) {
                    this.mMinWidth = typedArray.getDimension(n2, this.mMinWidth);
                    continue;
                }
                Log.v((String)StateSet.TAG, (String)"Unknown tag");
            }
            typedArray.recycle();
        }

        boolean match(float f, float f2) {
            if (!Float.isNaN(this.mMinWidth) && f < this.mMinWidth) {
                return false;
            }
            if (!Float.isNaN(this.mMinHeight) && f2 < this.mMinHeight) {
                return false;
            }
            if (!Float.isNaN(this.mMaxWidth) && f > this.mMaxWidth) {
                return false;
            }
            return Float.isNaN(this.mMaxHeight) || !(f2 > this.mMaxHeight);
        }
    }
}

