/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.constraintlayout.widget.ConstraintHelper;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;

public abstract class VirtualLayout
extends ConstraintHelper {
    private boolean mApplyElevationOnAttach;
    private boolean mApplyVisibilityOnAttach;

    public VirtualLayout(Context context) {
        super(context);
    }

    public VirtualLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public VirtualLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void applyLayoutFeaturesInConstraintSet(ConstraintLayout constraintLayout) {
        this.applyLayoutFeatures(constraintLayout);
    }

    @Override
    protected void init(AttributeSet attributeSet) {
        super.init(attributeSet);
        if (attributeSet != null) {
            attributeSet = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.ConstraintLayout_Layout);
            int n = attributeSet.getIndexCount();
            for (int i = 0; i < n; ++i) {
                int n2 = attributeSet.getIndex(i);
                if (n2 == R.styleable.ConstraintLayout_Layout_android_visibility) {
                    this.mApplyVisibilityOnAttach = true;
                    continue;
                }
                if (n2 != R.styleable.ConstraintLayout_Layout_android_elevation) continue;
                this.mApplyElevationOnAttach = true;
            }
            attributeSet.recycle();
        }
    }

    @Override
    public void onAttachedToWindow() {
        Object object;
        super.onAttachedToWindow();
        if ((this.mApplyVisibilityOnAttach || this.mApplyElevationOnAttach) && (object = this.getParent()) instanceof ConstraintLayout) {
            object = (ConstraintLayout)((Object)object);
            int n = this.getVisibility();
            float f = Build.VERSION.SDK_INT >= 21 ? this.getElevation() : 0.0f;
            for (int i = 0; i < this.mCount; ++i) {
                View view = ((ConstraintLayout)((Object)object)).getViewById(this.mIds[i]);
                if (view == null) continue;
                if (this.mApplyVisibilityOnAttach) {
                    view.setVisibility(n);
                }
                if (!this.mApplyElevationOnAttach || !(f > 0.0f) || Build.VERSION.SDK_INT < 21) continue;
                view.setTranslationZ(view.getTranslationZ() + f);
            }
        }
    }

    public void onMeasure(androidx.constraintlayout.core.widgets.VirtualLayout virtualLayout, int n, int n2) {
    }

    public void setElevation(float f) {
        super.setElevation(f);
        this.applyLayoutFeatures();
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        this.applyLayoutFeatures();
    }
}

