/*
 * Decompiled with CFR 0.152.
 */
package androidx.coordinatorlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.coordinatorlayout.R;
import androidx.coordinatorlayout.widget.DirectedAcyclicGraph;
import androidx.coordinatorlayout.widget.ViewGroupUtils;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Pools;
import androidx.core.view.GravityCompat;
import androidx.core.view.NestedScrollingParent2;
import androidx.core.view.NestedScrollingParent3;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.customview.view.AbsSavedState;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoordinatorLayout
extends ViewGroup
implements NestedScrollingParent2,
NestedScrollingParent3 {
    static final Class<?>[] CONSTRUCTOR_PARAMS;
    static final int EVENT_NESTED_SCROLL = 1;
    static final int EVENT_PRE_DRAW = 0;
    static final int EVENT_VIEW_REMOVED = 2;
    static final String TAG = "CoordinatorLayout";
    static final Comparator<View> TOP_SORTED_CHILDREN_COMPARATOR;
    private static final int TYPE_ON_INTERCEPT = 0;
    private static final int TYPE_ON_TOUCH = 1;
    static final String WIDGET_PACKAGE_NAME;
    static final ThreadLocal<Map<String, Constructor<Behavior>>> sConstructors;
    private static final Pools.Pool<Rect> sRectPool;
    private OnApplyWindowInsetsListener mApplyWindowInsetsListener;
    private final int[] mBehaviorConsumed;
    private View mBehaviorTouchView;
    private final DirectedAcyclicGraph<View> mChildDag;
    private final List<View> mDependencySortedChildren = new ArrayList<View>();
    private boolean mDisallowInterceptReset;
    private boolean mDrawStatusBarBackground;
    private boolean mIsAttachedToWindow;
    private int[] mKeylines;
    private WindowInsetsCompat mLastInsets;
    private boolean mNeedsPreDrawListener;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;
    private View mNestedScrollingTarget;
    private final int[] mNestedScrollingV2ConsumedCompat;
    ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    private OnPreDrawListener mOnPreDrawListener;
    private Paint mScrimPaint;
    private Drawable mStatusBarBackground;
    private final List<View> mTempDependenciesList;
    private final List<View> mTempList1;

    static {
        Object object = CoordinatorLayout.class.getPackage();
        object = object != null ? ((Package)object).getName() : null;
        WIDGET_PACKAGE_NAME = object;
        TOP_SORTED_CHILDREN_COMPARATOR = Build.VERSION.SDK_INT >= 21 ? new ViewElevationComparator() : null;
        CONSTRUCTOR_PARAMS = new Class[]{Context.class, AttributeSet.class};
        sConstructors = new ThreadLocal();
        sRectPool = new Pools.SynchronizedPool<Rect>(12);
    }

    public CoordinatorLayout(Context context) {
        this(context, null);
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.coordinatorLayoutStyle);
    }

    public CoordinatorLayout(Context object, AttributeSet attributeSet, int n) {
        super(object, attributeSet, n);
        this.mChildDag = new DirectedAcyclicGraph();
        this.mTempList1 = new ArrayList<View>();
        this.mTempDependenciesList = new ArrayList<View>();
        this.mBehaviorConsumed = new int[2];
        this.mNestedScrollingV2ConsumedCompat = new int[2];
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper(this);
        int n2 = 0;
        TypedArray typedArray = n == 0 ? object.obtainStyledAttributes(attributeSet, R.styleable.CoordinatorLayout, 0, R.style.Widget_Support_CoordinatorLayout) : object.obtainStyledAttributes(attributeSet, R.styleable.CoordinatorLayout, n, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            if (n == 0) {
                this.saveAttributeDataForStyleable((Context)object, R.styleable.CoordinatorLayout, attributeSet, typedArray, 0, R.style.Widget_Support_CoordinatorLayout);
            } else {
                this.saveAttributeDataForStyleable((Context)object, R.styleable.CoordinatorLayout, attributeSet, typedArray, n, 0);
            }
        }
        if ((n = typedArray.getResourceId(R.styleable.CoordinatorLayout_keylines, 0)) != 0) {
            object = object.getResources();
            this.mKeylines = object.getIntArray(n);
            float f = object.getDisplayMetrics().density;
            int n3 = this.mKeylines.length;
            for (n = n2; n < n3; ++n) {
                object = this.mKeylines;
                object[n] = (Context)((int)((float)object[n] * f));
            }
        }
        this.mStatusBarBackground = typedArray.getDrawable(R.styleable.CoordinatorLayout_statusBarBackground);
        typedArray.recycle();
        this.setupForInsets();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)new HierarchyChangeListener());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
    }

    private static Rect acquireTempRect() {
        Rect rect;
        Rect rect2 = rect = sRectPool.acquire();
        if (rect == null) {
            rect2 = new Rect();
        }
        return rect2;
    }

    private static int clamp(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    private void constrainChildRect(LayoutParams layoutParams, Rect rect, int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        n3 = Math.max(this.getPaddingLeft() + layoutParams.leftMargin, Math.min(rect.left, n3 - this.getPaddingRight() - n - layoutParams.rightMargin));
        n4 = Math.max(this.getPaddingTop() + layoutParams.topMargin, Math.min(rect.top, n4 - this.getPaddingBottom() - n2 - layoutParams.bottomMargin));
        rect.set(n3, n4, n + n3, n2 + n4);
    }

    private WindowInsetsCompat dispatchApplyWindowInsetsToBehaviors(WindowInsetsCompat windowInsetsCompat) {
        WindowInsetsCompat windowInsetsCompat2;
        if (windowInsetsCompat.isConsumed()) {
            return windowInsetsCompat;
        }
        int n = 0;
        int n2 = this.getChildCount();
        while (true) {
            windowInsetsCompat2 = windowInsetsCompat;
            if (n >= n2) break;
            View view = this.getChildAt(n);
            windowInsetsCompat2 = windowInsetsCompat;
            if (ViewCompat.getFitsSystemWindows(view)) {
                Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
                windowInsetsCompat2 = windowInsetsCompat;
                if (behavior != null) {
                    windowInsetsCompat2 = windowInsetsCompat = behavior.onApplyWindowInsets(this, view, windowInsetsCompat);
                    if (windowInsetsCompat.isConsumed()) {
                        windowInsetsCompat2 = windowInsetsCompat;
                        break;
                    }
                }
            }
            ++n;
            windowInsetsCompat = windowInsetsCompat2;
        }
        return windowInsetsCompat2;
    }

    private void getDesiredAnchoredChildRectWithoutConstraints(View view, int n, Rect rect, Rect rect2, LayoutParams layoutParams, int n2, int n3) {
        int n4 = GravityCompat.getAbsoluteGravity(CoordinatorLayout.resolveAnchoredChildGravity(layoutParams.gravity), n);
        int n5 = GravityCompat.getAbsoluteGravity(CoordinatorLayout.resolveGravity(layoutParams.anchorGravity), n);
        int n6 = n4 & 7;
        int n7 = n4 & 0x70;
        n = n5 & 7;
        n5 &= 0x70;
        n = n != 1 ? (n != 5 ? rect.left : rect.right) : rect.left + rect.width() / 2;
        n5 = n5 != 16 ? (n5 != 80 ? rect.top : rect.bottom) : rect.top + rect.height() / 2;
        if (n6 != 1) {
            n4 = n;
            if (n6 != 5) {
                n4 = n - n2;
            }
        } else {
            n4 = n - n2 / 2;
        }
        if (n7 != 16) {
            n = n5;
            if (n7 != 80) {
                n = n5 - n3;
            }
        } else {
            n = n5 - n3 / 2;
        }
        rect2.set(n4, n, n2 + n4, n3 + n);
    }

    private int getKeyline(int n) {
        Object object = this.mKeylines;
        if (object == null) {
            object = new StringBuilder();
            object.append("No keylines defined for ");
            object.append(this);
            object.append(" - attempted index lookup ");
            object.append(n);
            Log.e((String)TAG, (String)object.toString());
            return 0;
        }
        if (n >= 0 && n < ((int[])object).length) {
            return object[n];
        }
        object = new StringBuilder();
        object.append("Keyline index ");
        object.append(n);
        object.append(" out of range for ");
        object.append(this);
        Log.e((String)TAG, (String)object.toString());
        return 0;
    }

    private void getTopSortedChildren(List<View> list) {
        list.clear();
        boolean bl = this.isChildrenDrawingOrderEnabled();
        int n = this.getChildCount();
        for (int i = n - 1; i >= 0; --i) {
            int n2 = bl ? this.getChildDrawingOrder(n, i) : i;
            list.add(this.getChildAt(n2));
        }
        Comparator<View> comparator = TOP_SORTED_CHILDREN_COMPARATOR;
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    private boolean hasDependencies(View view) {
        return this.mChildDag.hasOutgoingEdges(view);
    }

    private void layoutChild(View view, int n) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        Rect rect = CoordinatorLayout.acquireTempRect();
        rect.set(this.getPaddingLeft() + layoutParams.leftMargin, this.getPaddingTop() + layoutParams.topMargin, this.getWidth() - this.getPaddingRight() - layoutParams.rightMargin, this.getHeight() - this.getPaddingBottom() - layoutParams.bottomMargin);
        if (this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this) && !ViewCompat.getFitsSystemWindows(view)) {
            rect.left += this.mLastInsets.getSystemWindowInsetLeft();
            rect.top += this.mLastInsets.getSystemWindowInsetTop();
            rect.right -= this.mLastInsets.getSystemWindowInsetRight();
            rect.bottom -= this.mLastInsets.getSystemWindowInsetBottom();
        }
        Rect rect2 = CoordinatorLayout.acquireTempRect();
        GravityCompat.apply(CoordinatorLayout.resolveGravity(layoutParams.gravity), view.getMeasuredWidth(), view.getMeasuredHeight(), rect, rect2, n);
        view.layout(rect2.left, rect2.top, rect2.right, rect2.bottom);
        CoordinatorLayout.releaseTempRect(rect);
        CoordinatorLayout.releaseTempRect(rect2);
    }

    private void layoutChildWithAnchor(View view, View view2, int n) {
        Rect rect = CoordinatorLayout.acquireTempRect();
        Rect rect2 = CoordinatorLayout.acquireTempRect();
        try {
            this.getDescendantRect(view2, rect);
            this.getDesiredAnchoredChildRect(view, n, rect, rect2);
            view.layout(rect2.left, rect2.top, rect2.right, rect2.bottom);
            return;
        }
        finally {
            CoordinatorLayout.releaseTempRect(rect);
            CoordinatorLayout.releaseTempRect(rect2);
        }
    }

    private void layoutChildWithKeyline(View view, int n, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n3 = GravityCompat.getAbsoluteGravity(CoordinatorLayout.resolveKeylineGravity(layoutParams.gravity), n2);
        int n4 = n3 & 7;
        int n5 = n3 & 0x70;
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        int n8 = view.getMeasuredWidth();
        int n9 = view.getMeasuredHeight();
        n3 = n;
        if (n2 == 1) {
            n3 = n6 - n;
        }
        n = this.getKeyline(n3) - n8;
        n2 = 0;
        if (n4 != 1) {
            if (n4 == 5) {
                n += n8;
            }
        } else {
            n += n8 / 2;
        }
        if (n5 != 16) {
            if (n5 == 80) {
                n2 = n9 + 0;
            }
        } else {
            n2 = 0 + n9 / 2;
        }
        n = Math.max(this.getPaddingLeft() + layoutParams.leftMargin, Math.min(n, n6 - this.getPaddingRight() - n8 - layoutParams.rightMargin));
        n2 = Math.max(this.getPaddingTop() + layoutParams.topMargin, Math.min(n2, n7 - this.getPaddingBottom() - n9 - layoutParams.bottomMargin));
        view.layout(n, n2, n8 + n, n9 + n2);
    }

    private void offsetChildByInset(View object, Rect rect, int n) {
        if (!ViewCompat.isLaidOut((View)object)) {
            return;
        }
        if (object.getWidth() > 0 && object.getHeight() > 0) {
            LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
            Behavior behavior = layoutParams.getBehavior();
            Rect rect2 = CoordinatorLayout.acquireTempRect();
            Rect rect3 = CoordinatorLayout.acquireTempRect();
            rect3.set(object.getLeft(), object.getTop(), object.getRight(), object.getBottom());
            if (behavior != null && behavior.getInsetDodgeRect(this, object, rect2)) {
                if (!rect3.contains(rect2)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Rect should be within the child's bounds. Rect:");
                    ((StringBuilder)object).append(rect2.toShortString());
                    ((StringBuilder)object).append(" | Bounds:");
                    ((StringBuilder)object).append(rect3.toShortString());
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
            } else {
                rect2.set(rect3);
            }
            CoordinatorLayout.releaseTempRect(rect3);
            if (rect2.isEmpty()) {
                CoordinatorLayout.releaseTempRect(rect2);
                return;
            }
            int n2 = GravityCompat.getAbsoluteGravity(layoutParams.dodgeInsetEdges, n);
            int n3 = 1;
            if ((n2 & 0x30) == 48 && (n = rect2.top - layoutParams.topMargin - layoutParams.mInsetOffsetY) < rect.top) {
                this.setInsetOffsetY((View)object, rect.top - n);
                n = 1;
            } else {
                n = 0;
            }
            int n4 = n;
            if ((n2 & 0x50) == 80) {
                int n5 = this.getHeight() - rect2.bottom - layoutParams.bottomMargin + layoutParams.mInsetOffsetY;
                n4 = n;
                if (n5 < rect.bottom) {
                    this.setInsetOffsetY((View)object, n5 - rect.bottom);
                    n4 = 1;
                }
            }
            if (n4 == 0) {
                this.setInsetOffsetY((View)object, 0);
            }
            if ((n2 & 3) == 3 && (n = rect2.left - layoutParams.leftMargin - layoutParams.mInsetOffsetX) < rect.left) {
                this.setInsetOffsetX((View)object, rect.left - n);
                n = 1;
            } else {
                n = 0;
            }
            if ((n2 & 5) == 5 && (n4 = this.getWidth() - rect2.right - layoutParams.rightMargin + layoutParams.mInsetOffsetX) < rect.right) {
                this.setInsetOffsetX((View)object, n4 - rect.right);
                n = n3;
            }
            if (n == 0) {
                this.setInsetOffsetX((View)object, 0);
            }
            CoordinatorLayout.releaseTempRect(rect2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Behavior parseBehavior(Context object, AttributeSet attributeSet, String hashMap) {
        Constructor<?> constructor;
        Object object2;
        if (TextUtils.isEmpty(hashMap)) {
            return null;
        }
        if (((String)((Object)hashMap)).startsWith(".")) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append(object.getPackageName());
            ((StringBuilder)object2).append((String)((Object)hashMap));
            object2 = ((StringBuilder)object2).toString();
        } else if (((String)((Object)hashMap)).indexOf(46) >= 0) {
            object2 = hashMap;
        } else {
            constructor = WIDGET_PACKAGE_NAME;
            object2 = hashMap;
            if (!TextUtils.isEmpty((CharSequence)((Object)constructor))) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append((String)((Object)constructor));
                ((StringBuilder)object2).append('.');
                ((StringBuilder)object2).append((String)((Object)hashMap));
                object2 = ((StringBuilder)object2).toString();
            }
        }
        try {
            Object object3 = sConstructors;
            constructor = ((ThreadLocal)object3).get();
            hashMap = constructor;
            if (constructor == null) {
                hashMap = new HashMap();
                ((ThreadLocal)object3).set(hashMap);
            }
            object3 = (Constructor)hashMap.get(object2);
            constructor = object3;
            if (object3 == null) {
                constructor = Class.forName((String)object2, false, object.getClassLoader()).getConstructor(CONSTRUCTOR_PARAMS);
                constructor.setAccessible(true);
                hashMap.put(object2, constructor);
            }
            return (Behavior)constructor.newInstance(object, attributeSet);
        }
        catch (Exception exception) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Could not inflate Behavior subclass ");
            ((StringBuilder)object).append((String)object2);
            throw new RuntimeException(((StringBuilder)object).toString(), exception);
        }
    }

    private boolean performIntercept(MotionEvent motionEvent, int n) {
        boolean bl;
        int n2 = motionEvent.getActionMasked();
        List<View> list = this.mTempList1;
        this.getTopSortedChildren(list);
        int n3 = list.size();
        LayoutParams layoutParams = null;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            boolean bl4;
            boolean bl5;
            bl = bl2;
            if (n4 >= n3) break;
            View view = list.get(n4);
            LayoutParams layoutParams2 = (LayoutParams)view.getLayoutParams();
            Behavior behavior = layoutParams2.getBehavior();
            if ((bl2 || bl3) && n2 != 0) {
                layoutParams2 = layoutParams;
                bl5 = bl2;
                bl4 = bl3;
                if (behavior != null) {
                    layoutParams2 = layoutParams;
                    if (layoutParams == null) {
                        long l = SystemClock.uptimeMillis();
                        layoutParams2 = MotionEvent.obtain((long)l, (long)l, (int)3, (float)0.0f, (float)0.0f, (int)0);
                    }
                    if (n != 0) {
                        if (n != 1) {
                            bl5 = bl2;
                            bl4 = bl3;
                        } else {
                            behavior.onTouchEvent(this, view, (MotionEvent)layoutParams2);
                            bl5 = bl2;
                            bl4 = bl3;
                        }
                    } else {
                        behavior.onInterceptTouchEvent(this, view, (MotionEvent)layoutParams2);
                        bl5 = bl2;
                        bl4 = bl3;
                    }
                }
            } else {
                bl = bl2;
                if (!bl2) {
                    bl = bl2;
                    if (behavior != null) {
                        if (n != 0) {
                            if (n == 1) {
                                bl2 = behavior.onTouchEvent(this, view, motionEvent);
                            }
                        } else {
                            bl2 = behavior.onInterceptTouchEvent(this, view, motionEvent);
                        }
                        bl = bl2;
                        if (bl2) {
                            this.mBehaviorTouchView = view;
                            bl = bl2;
                        }
                    }
                }
                bl5 = layoutParams2.didBlockInteraction();
                bl2 = layoutParams2.isBlockingInteractionBelow(this, view);
                bl3 = bl2 && !bl5;
                layoutParams2 = layoutParams;
                bl5 = bl;
                bl4 = bl3;
                if (bl2) {
                    layoutParams2 = layoutParams;
                    bl5 = bl;
                    bl4 = bl3;
                    if (!bl3) break;
                }
            }
            ++n4;
            layoutParams = layoutParams2;
            bl2 = bl5;
            bl3 = bl4;
        }
        list.clear();
        return bl;
    }

    private void prepareChildren() {
        this.mDependencySortedChildren.clear();
        this.mChildDag.clear();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = this.getResolvedLayoutParams(view);
            layoutParams.findAnchorView(this, view);
            this.mChildDag.addNode(view);
            for (int j = 0; j < n; ++j) {
                View view2;
                if (j == i || !layoutParams.dependsOn(this, view, view2 = this.getChildAt(j))) continue;
                if (!this.mChildDag.contains(view2)) {
                    this.mChildDag.addNode(view2);
                }
                this.mChildDag.addEdge(view2, view);
            }
        }
        this.mDependencySortedChildren.addAll(this.mChildDag.getSortedList());
        Collections.reverse(this.mDependencySortedChildren);
    }

    private static void releaseTempRect(Rect rect) {
        rect.setEmpty();
        sRectPool.release(rect);
    }

    private void resetTouchBehaviors(boolean bl) {
        int n;
        int n2 = this.getChildCount();
        for (n = 0; n < n2; ++n) {
            View view = this.getChildAt(n);
            Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
            if (behavior == null) continue;
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)3, (float)0.0f, (float)0.0f, (int)0);
            if (bl) {
                behavior.onInterceptTouchEvent(this, view, motionEvent);
            } else {
                behavior.onTouchEvent(this, view, motionEvent);
            }
            motionEvent.recycle();
        }
        for (n = 0; n < n2; ++n) {
            ((LayoutParams)this.getChildAt(n).getLayoutParams()).resetTouchBehaviorTracking();
        }
        this.mBehaviorTouchView = null;
        this.mDisallowInterceptReset = false;
    }

    private static int resolveAnchoredChildGravity(int n) {
        int n2 = n;
        if (n == 0) {
            n2 = 17;
        }
        return n2;
    }

    private static int resolveGravity(int n) {
        int n2 = n;
        if ((n & 7) == 0) {
            n2 = n | 0x800003;
        }
        n = n2;
        if ((n2 & 0x70) == 0) {
            n = n2 | 0x30;
        }
        return n;
    }

    private static int resolveKeylineGravity(int n) {
        int n2 = n;
        if (n == 0) {
            n2 = 8388661;
        }
        return n2;
    }

    private void setInsetOffsetX(View view, int n) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mInsetOffsetX != n) {
            ViewCompat.offsetLeftAndRight(view, n - layoutParams.mInsetOffsetX);
            layoutParams.mInsetOffsetX = n;
        }
    }

    private void setInsetOffsetY(View view, int n) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mInsetOffsetY != n) {
            ViewCompat.offsetTopAndBottom(view, n - layoutParams.mInsetOffsetY);
            layoutParams.mInsetOffsetY = n;
        }
    }

    private void setupForInsets() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            if (this.mApplyWindowInsetsListener == null) {
                this.mApplyWindowInsetsListener = new OnApplyWindowInsetsListener(){

                    @Override
                    public WindowInsetsCompat onApplyWindowInsets(View view, WindowInsetsCompat windowInsetsCompat) {
                        return CoordinatorLayout.this.setWindowInsets(windowInsetsCompat);
                    }
                };
            }
            ViewCompat.setOnApplyWindowInsetsListener((View)this, this.mApplyWindowInsetsListener);
            this.setSystemUiVisibility(1280);
        } else {
            ViewCompat.setOnApplyWindowInsetsListener((View)this, null);
        }
    }

    void addPreDrawListener() {
        if (this.mIsAttachedToWindow) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = true;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        boolean bl = layoutParams instanceof LayoutParams && super.checkLayoutParams(layoutParams);
        return bl;
    }

    public void dispatchDependentViewsChanged(View view) {
        List list = this.mChildDag.getIncomingEdges(view);
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                View view2 = (View)list.get(i);
                Behavior behavior = ((LayoutParams)view2.getLayoutParams()).getBehavior();
                if (behavior == null) continue;
                behavior.onDependentViewChanged(this, view2, view);
            }
        }
    }

    public boolean doViewsOverlap(View view, View view2) {
        int n = view.getVisibility();
        boolean bl = false;
        if (n == 0 && view2.getVisibility() == 0) {
            boolean bl2;
            Rect rect;
            block5: {
                rect = CoordinatorLayout.acquireTempRect();
                bl2 = view.getParent() != this;
                this.getChildRect(view, bl2, rect);
                view = CoordinatorLayout.acquireTempRect();
                bl2 = view2.getParent() != this;
                this.getChildRect(view2, bl2, (Rect)view);
                bl2 = bl;
                try {
                    if (rect.left > view.right) break block5;
                    bl2 = bl;
                }
                catch (Throwable throwable) {
                    CoordinatorLayout.releaseTempRect(rect);
                    CoordinatorLayout.releaseTempRect((Rect)view);
                    throw throwable;
                }
                if (rect.top > view.bottom) break block5;
                bl2 = bl;
                if (rect.right < view.left) break block5;
                int n2 = rect.bottom;
                n = view.top;
                bl2 = bl;
                if (n2 < n) break block5;
                bl2 = true;
            }
            CoordinatorLayout.releaseTempRect(rect);
            CoordinatorLayout.releaseTempRect((Rect)view);
            return bl2;
        }
        return false;
    }

    protected boolean drawChild(Canvas canvas, View view, long l) {
        float f;
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (layoutParams.mBehavior != null && (f = layoutParams.mBehavior.getScrimOpacity(this, view)) > 0.0f) {
            if (this.mScrimPaint == null) {
                this.mScrimPaint = new Paint();
            }
            this.mScrimPaint.setColor(layoutParams.mBehavior.getScrimColor(this, view));
            this.mScrimPaint.setAlpha(CoordinatorLayout.clamp(Math.round(f * 255.0f), 0, 255));
            int n = canvas.save();
            if (view.isOpaque()) {
                canvas.clipRect((float)view.getLeft(), (float)view.getTop(), (float)view.getRight(), (float)view.getBottom(), Region.Op.DIFFERENCE);
            }
            canvas.drawRect((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()), this.mScrimPaint);
            canvas.restoreToCount(n);
        }
        return super.drawChild(canvas, view, l);
    }

    protected void drawableStateChanged() {
        boolean bl;
        super.drawableStateChanged();
        int[] nArray = this.getDrawableState();
        Drawable drawable2 = this.mStatusBarBackground;
        boolean bl2 = bl = false;
        if (drawable2 != null) {
            bl2 = bl;
            if (drawable2.isStateful()) {
                bl2 = false | drawable2.setState(nArray);
            }
        }
        if (bl2) {
            this.invalidate();
        }
    }

    void ensurePreDrawListener() {
        boolean bl;
        int n = this.getChildCount();
        boolean bl2 = false;
        int n2 = 0;
        while (true) {
            bl = bl2;
            if (n2 >= n) break;
            if (this.hasDependencies(this.getChildAt(n2))) {
                bl = true;
                break;
            }
            ++n2;
        }
        if (bl != this.mNeedsPreDrawListener) {
            if (bl) {
                this.addPreDrawListener();
            } else {
                this.removePreDrawListener();
            }
        }
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)layoutParams);
        }
        return new LayoutParams(layoutParams);
    }

    void getChildRect(View view, boolean bl, Rect rect) {
        if (!view.isLayoutRequested() && view.getVisibility() != 8) {
            if (bl) {
                this.getDescendantRect(view, rect);
            } else {
                rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            }
            return;
        }
        rect.setEmpty();
    }

    public List<View> getDependencies(View object) {
        object = this.mChildDag.getOutgoingEdges((View)object);
        this.mTempDependenciesList.clear();
        if (object != null) {
            this.mTempDependenciesList.addAll((Collection<View>)object);
        }
        return this.mTempDependenciesList;
    }

    final List<View> getDependencySortedChildren() {
        this.prepareChildren();
        return Collections.unmodifiableList(this.mDependencySortedChildren);
    }

    public List<View> getDependents(View object) {
        object = this.mChildDag.getIncomingEdges((View)object);
        this.mTempDependenciesList.clear();
        if (object != null) {
            this.mTempDependenciesList.addAll((Collection<View>)object);
        }
        return this.mTempDependenciesList;
    }

    void getDescendantRect(View view, Rect rect) {
        ViewGroupUtils.getDescendantRect(this, view, rect);
    }

    void getDesiredAnchoredChildRect(View view, int n, Rect rect, Rect rect2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        int n2 = view.getMeasuredWidth();
        int n3 = view.getMeasuredHeight();
        this.getDesiredAnchoredChildRectWithoutConstraints(view, n, rect, rect2, layoutParams, n2, n3);
        this.constrainChildRect(layoutParams, rect2, n2, n3);
    }

    void getLastChildRect(View view, Rect rect) {
        rect.set(((LayoutParams)view.getLayoutParams()).getLastChildRect());
    }

    public final WindowInsetsCompat getLastWindowInsets() {
        return this.mLastInsets;
    }

    @Override
    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    LayoutParams getResolvedLayoutParams(View object) {
        LayoutParams layoutParams = (LayoutParams)object.getLayoutParams();
        if (!layoutParams.mBehaviorResolved) {
            if (object instanceof AttachedBehavior) {
                if ((object = ((AttachedBehavior)object).getBehavior()) == null) {
                    Log.e((String)TAG, (String)"Attached behavior class is null");
                }
                layoutParams.setBehavior((Behavior)object);
                layoutParams.mBehaviorResolved = true;
            } else {
                Object object2;
                Class<?> clazz = object.getClass();
                object = null;
                while (clazz != null) {
                    object = object2 = clazz.getAnnotation(DefaultBehavior.class);
                    if (object2 != null) break;
                    clazz = clazz.getSuperclass();
                    object = object2;
                }
                if (object != null) {
                    try {
                        layoutParams.setBehavior(object.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (Exception exception) {
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("Default behavior class ");
                        ((StringBuilder)object2).append(object.value().getName());
                        ((StringBuilder)object2).append(" could not be instantiated. Did you forget a default constructor?");
                        Log.e((String)TAG, (String)((StringBuilder)object2).toString(), (Throwable)exception);
                    }
                }
                layoutParams.mBehaviorResolved = true;
            }
        }
        return layoutParams;
    }

    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), this.getPaddingTop() + this.getPaddingBottom());
    }

    protected int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), this.getPaddingLeft() + this.getPaddingRight());
    }

    public boolean isPointInChildBounds(View view, int n, int n2) {
        Rect rect = CoordinatorLayout.acquireTempRect();
        this.getDescendantRect(view, rect);
        try {
            boolean bl = rect.contains(n, n2);
            return bl;
        }
        finally {
            CoordinatorLayout.releaseTempRect(rect);
        }
    }

    void offsetChildToAnchor(View view, int n) {
        block6: {
            Behavior behavior;
            int n2;
            int n3;
            int n4;
            Rect rect;
            Rect rect2;
            Rect rect3;
            LayoutParams layoutParams;
            block8: {
                block7: {
                    layoutParams = (LayoutParams)view.getLayoutParams();
                    if (layoutParams.mAnchorView == null) break block6;
                    rect3 = CoordinatorLayout.acquireTempRect();
                    rect2 = CoordinatorLayout.acquireTempRect();
                    rect = CoordinatorLayout.acquireTempRect();
                    this.getDescendantRect(layoutParams.mAnchorView, rect3);
                    n4 = 0;
                    this.getChildRect(view, false, rect2);
                    n3 = view.getMeasuredWidth();
                    n2 = view.getMeasuredHeight();
                    this.getDesiredAnchoredChildRectWithoutConstraints(view, n, rect3, rect, layoutParams, n3, n2);
                    if (rect.left != rect2.left) break block7;
                    n = n4;
                    if (rect.top == rect2.top) break block8;
                }
                n = 1;
            }
            this.constrainChildRect(layoutParams, rect, n3, n2);
            n4 = rect.left - rect2.left;
            n3 = rect.top - rect2.top;
            if (n4 != 0) {
                ViewCompat.offsetLeftAndRight(view, n4);
            }
            if (n3 != 0) {
                ViewCompat.offsetTopAndBottom(view, n3);
            }
            if (n != 0 && (behavior = layoutParams.getBehavior()) != null) {
                behavior.onDependentViewChanged(this, view, layoutParams.mAnchorView);
            }
            CoordinatorLayout.releaseTempRect(rect3);
            CoordinatorLayout.releaseTempRect(rect2);
            CoordinatorLayout.releaseTempRect(rect);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if (this.mLastInsets == null && ViewCompat.getFitsSystemWindows((View)this)) {
            ViewCompat.requestApplyInsets((View)this);
        }
        this.mIsAttachedToWindow = true;
    }

    final void onChildViewsChanged(int n) {
        int n2 = ViewCompat.getLayoutDirection((View)this);
        int n3 = this.mDependencySortedChildren.size();
        Rect rect = CoordinatorLayout.acquireTempRect();
        Rect rect2 = CoordinatorLayout.acquireTempRect();
        Rect rect3 = CoordinatorLayout.acquireTempRect();
        for (int i = 0; i < n3; ++i) {
            View view;
            int n4;
            View view2 = this.mDependencySortedChildren.get(i);
            LayoutParams layoutParams = (LayoutParams)view2.getLayoutParams();
            if (n == 0 && view2.getVisibility() == 8) continue;
            for (n4 = 0; n4 < i; ++n4) {
                view = this.mDependencySortedChildren.get(n4);
                if (layoutParams.mAnchorDirectChild != view) continue;
                this.offsetChildToAnchor(view2, n2);
            }
            this.getChildRect(view2, true, rect2);
            if (layoutParams.insetEdge != 0 && !rect2.isEmpty()) {
                n4 = GravityCompat.getAbsoluteGravity(layoutParams.insetEdge, n2);
                int n5 = n4 & 0x70;
                if (n5 != 48) {
                    if (n5 == 80) {
                        rect.bottom = Math.max(rect.bottom, this.getHeight() - rect2.top);
                    }
                } else {
                    rect.top = Math.max(rect.top, rect2.bottom);
                }
                if ((n4 &= 7) != 3) {
                    if (n4 == 5) {
                        rect.right = Math.max(rect.right, this.getWidth() - rect2.left);
                    }
                } else {
                    rect.left = Math.max(rect.left, rect2.right);
                }
            }
            if (layoutParams.dodgeInsetEdges != 0 && view2.getVisibility() == 0) {
                this.offsetChildByInset(view2, rect, n2);
            }
            if (n != 2) {
                this.getLastChildRect(view2, rect3);
                if (rect3.equals((Object)rect2)) continue;
                this.recordLastChildRect(view2, rect2);
            }
            for (n4 = i + 1; n4 < n3; ++n4) {
                boolean bl;
                view = this.mDependencySortedChildren.get(n4);
                layoutParams = (LayoutParams)view.getLayoutParams();
                Behavior behavior = layoutParams.getBehavior();
                if (behavior == null || !behavior.layoutDependsOn(this, view, view2)) continue;
                if (n == 0 && layoutParams.getChangedAfterNestedScroll()) {
                    layoutParams.resetChangedAfterNestedScroll();
                    continue;
                }
                if (n != 2) {
                    bl = behavior.onDependentViewChanged(this, view, view2);
                } else {
                    behavior.onDependentViewRemoved(this, view, view2);
                    bl = true;
                }
                if (n != 1) continue;
                layoutParams.setChangedAfterNestedScroll(bl);
            }
        }
        CoordinatorLayout.releaseTempRect(rect);
        CoordinatorLayout.releaseTempRect(rect2);
        CoordinatorLayout.releaseTempRect(rect3);
    }

    public void onDetachedFromWindow() {
        View view;
        super.onDetachedFromWindow();
        this.resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener && this.mOnPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if ((view = this.mNestedScrollingTarget) != null) {
            this.onStopNestedScroll(view);
        }
        this.mIsAttachedToWindow = false;
    }

    public void onDraw(Canvas canvas) {
        WindowInsetsCompat windowInsetsCompat;
        int n;
        super.onDraw(canvas);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null && (n = (windowInsetsCompat = this.mLastInsets) != null ? windowInsetsCompat.getSystemWindowInsetTop() : 0) > 0) {
            this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), n);
            this.mStatusBarBackground.draw(canvas);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.resetTouchBehaviors(true);
        }
        boolean bl = this.performIntercept(motionEvent, 0);
        if (n == 1 || n == 3) {
            this.resetTouchBehaviors(true);
        }
        return bl;
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        n2 = ViewCompat.getLayoutDirection((View)this);
        n3 = this.mDependencySortedChildren.size();
        for (n = 0; n < n3; ++n) {
            Behavior behavior;
            View view = this.mDependencySortedChildren.get(n);
            if (view.getVisibility() == 8 || (behavior = ((LayoutParams)view.getLayoutParams()).getBehavior()) != null && behavior.onLayoutChild(this, view, n2)) continue;
            this.onLayoutChild(view, n2);
        }
    }

    public void onLayoutChild(View view, int n) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        if (!layoutParams.checkAnchorChanged()) {
            if (layoutParams.mAnchorView != null) {
                this.layoutChildWithAnchor(view, layoutParams.mAnchorView, n);
            } else if (layoutParams.keyline >= 0) {
                this.layoutChildWithKeyline(view, layoutParams.keyline, n);
            } else {
                this.layoutChild(view, n);
            }
            return;
        }
        throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
    }

    /*
     * Unable to fully structure code
     */
    protected void onMeasure(int var1_1, int var2_2) {
        this.prepareChildren();
        this.ensurePreDrawListener();
        var3_3 = this.getPaddingLeft();
        var4_4 = this.getPaddingTop();
        var5_5 = this.getPaddingRight();
        var6_6 = this.getPaddingBottom();
        var7_7 = ViewCompat.getLayoutDirection((View)this);
        var8_8 = var7_7 == 1;
        var9_9 = View.MeasureSpec.getMode((int)var1_1);
        var10_10 = View.MeasureSpec.getSize((int)var1_1);
        var11_11 = View.MeasureSpec.getMode((int)var2_2);
        var12_12 = View.MeasureSpec.getSize((int)var2_2);
        var13_13 = this.getSuggestedMinimumWidth();
        var14_14 = this.getSuggestedMinimumHeight();
        var15_15 = this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this) != false;
        var16_16 = this.mDependencySortedChildren.size();
        var17_17 = 0;
        var18_18 = 0;
        var19_19 = var3_3;
        while (true) {
            block8: {
                var20_20 = var19_19;
                if (var18_18 >= var16_16) break;
                var21_21 = this.mDependencySortedChildren.get(var18_18);
                if (var21_21.getVisibility() == 8) break block8;
                var22_22 = (LayoutParams)var21_21.getLayoutParams();
                if (var22_22.keyline < 0 || var9_9 == 0) ** GOTO lbl-1000
                var19_19 = this.getKeyline(var22_22.keyline);
                var23_23 = GravityCompat.getAbsoluteGravity(CoordinatorLayout.resolveKeylineGravity(var22_22.gravity), var7_7) & 7;
                if (var23_23 == 3 && !var8_8 || var23_23 == 5 && var8_8) {
                    var19_19 = Math.max(0, var10_10 - var5_5 - var19_19);
                } else if (var23_23 == 5 && !var8_8 || var23_23 == 3 && var8_8) {
                    var19_19 = Math.max(0, var19_19 - var20_20);
                } else lbl-1000:
                // 2 sources

                {
                    var19_19 = 0;
                }
                var24_24 = var17_17;
                if (var15_15 && !ViewCompat.getFitsSystemWindows(var21_21)) {
                    var25_25 = this.mLastInsets.getSystemWindowInsetLeft();
                    var17_17 = this.mLastInsets.getSystemWindowInsetRight();
                    var23_23 = this.mLastInsets.getSystemWindowInsetTop();
                    var26_26 = this.mLastInsets.getSystemWindowInsetBottom();
                    var17_17 = View.MeasureSpec.makeMeasureSpec((int)(var10_10 - (var25_25 + var17_17)), (int)var9_9);
                    var23_23 = View.MeasureSpec.makeMeasureSpec((int)(var12_12 - (var23_23 + var26_26)), (int)var11_11);
                } else {
                    var17_17 = var1_1;
                    var23_23 = var2_2;
                }
                var27_27 = var22_22.getBehavior();
                if (var27_27 == null || !var27_27.onMeasureChild(this, var21_21, var17_17, var19_19, var23_23, 0)) {
                    this.onMeasureChild(var21_21, var17_17, var19_19, var23_23, 0);
                }
                var13_13 = Math.max(var13_13, var3_3 + var5_5 + var21_21.getMeasuredWidth() + var22_22.leftMargin + var22_22.rightMargin);
                var14_14 = Math.max(var14_14, var4_4 + var6_6 + var21_21.getMeasuredHeight() + var22_22.topMargin + var22_22.bottomMargin);
                var17_17 = View.combineMeasuredStates((int)var24_24, (int)var21_21.getMeasuredState());
            }
            ++var18_18;
            var19_19 = var20_20;
        }
        this.setMeasuredDimension(View.resolveSizeAndState((int)var13_13, (int)var1_1, (int)(-16777216 & var17_17)), View.resolveSizeAndState((int)var14_14, (int)var2_2, (int)(var17_17 << 16)));
    }

    public void onMeasureChild(View view, int n, int n2, int n3, int n4) {
        this.measureChildWithMargins(view, n, n2, n3, n4);
    }

    @Override
    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        int n = this.getChildCount();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            boolean bl3;
            View view2 = this.getChildAt(i);
            if (view2.getVisibility() == 8) {
                bl3 = bl2;
            } else {
                Object object = (LayoutParams)view2.getLayoutParams();
                if (!object.isNestedScrollAccepted(0)) {
                    bl3 = bl2;
                } else {
                    object = object.getBehavior();
                    bl3 = bl2;
                    if (object != null) {
                        bl3 = bl2 | ((Behavior)object).onNestedFling(this, view2, view, f, f2, bl);
                    }
                }
            }
            bl2 = bl3;
        }
        if (bl2) {
            this.onChildViewsChanged(1);
        }
        return bl2;
    }

    @Override
    public boolean onNestedPreFling(View view, float f, float f2) {
        int n = this.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            boolean bl2;
            View view2 = this.getChildAt(i);
            if (view2.getVisibility() == 8) {
                bl2 = bl;
            } else {
                Object object = (LayoutParams)view2.getLayoutParams();
                if (!object.isNestedScrollAccepted(0)) {
                    bl2 = bl;
                } else {
                    object = object.getBehavior();
                    bl2 = bl;
                    if (object != null) {
                        bl2 = bl | ((Behavior)object).onNestedPreFling(this, view2, view, f, f2);
                    }
                }
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray) {
        this.onNestedPreScroll(view, n, n2, nArray, 0);
    }

    @Override
    public void onNestedPreScroll(View view, int n, int n2, int[] nArray, int n3) {
        int n4 = this.getChildCount();
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            int n7;
            int n8;
            Object object = this.getChildAt(i);
            if (object.getVisibility() == 8) {
                n8 = n5;
                n7 = n6;
            } else {
                Object object2 = (LayoutParams)object.getLayoutParams();
                if (!object2.isNestedScrollAccepted(n3)) {
                    n8 = n5;
                    n7 = n6;
                } else {
                    Behavior behavior = object2.getBehavior();
                    n8 = n5;
                    n7 = n6;
                    if (behavior != null) {
                        object2 = this.mBehaviorConsumed;
                        object2[0] = (LayoutParams)false;
                        object2[1] = (LayoutParams)false;
                        behavior.onNestedPreScroll(this, object, view, n, n2, (int[])object2, n3);
                        object = this.mBehaviorConsumed;
                        n7 = n > 0 ? Math.max(n5, (int)object[0]) : Math.min(n5, (int)object[0]);
                        n5 = n7;
                        object = this.mBehaviorConsumed;
                        n7 = n2 > 0 ? Math.max(n6, (int)object[1]) : Math.min(n6, (int)object[1]);
                        bl = true;
                        n8 = n5;
                    }
                }
            }
            n5 = n8;
            n6 = n7;
        }
        nArray[0] = n5;
        nArray[1] = n6;
        if (bl) {
            this.onChildViewsChanged(1);
        }
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4) {
        this.onNestedScroll(view, n, n2, n3, n4, 0);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4, int n5) {
        this.onNestedScroll(view, n, n2, n3, n4, 0, this.mNestedScrollingV2ConsumedCompat);
    }

    @Override
    public void onNestedScroll(View view, int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int n6 = this.getChildCount();
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < n6; ++i) {
            int n9;
            int n10;
            Object object = this.getChildAt(i);
            if (object.getVisibility() == 8) {
                n10 = n7;
                n9 = n8;
            } else {
                Object object2 = (LayoutParams)object.getLayoutParams();
                if (!object2.isNestedScrollAccepted(n5)) {
                    n10 = n7;
                    n9 = n8;
                } else {
                    Behavior behavior = object2.getBehavior();
                    n10 = n7;
                    n9 = n8;
                    if (behavior != null) {
                        object2 = this.mBehaviorConsumed;
                        object2[0] = (LayoutParams)false;
                        object2[1] = (LayoutParams)false;
                        behavior.onNestedScroll(this, object, view, n, n2, n3, n4, n5, (int[])object2);
                        object = this.mBehaviorConsumed;
                        n9 = n3 > 0 ? Math.max(n7, (int)object[0]) : Math.min(n7, (int)object[0]);
                        n10 = n9;
                        n9 = n4 > 0 ? Math.max(n8, this.mBehaviorConsumed[1]) : Math.min(n8, this.mBehaviorConsumed[1]);
                        bl = true;
                    }
                }
            }
            n7 = n10;
            n8 = n9;
        }
        nArray[0] = nArray[0] + n7;
        nArray[1] = nArray[1] + n8;
        if (bl) {
            this.onChildViewsChanged(1);
        }
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n) {
        this.onNestedScrollAccepted(view, view2, n, 0);
    }

    @Override
    public void onNestedScrollAccepted(View view, View view2, int n, int n2) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(view, view2, n, n2);
        this.mNestedScrollingTarget = view2;
        int n3 = this.getChildCount();
        for (int i = 0; i < n3; ++i) {
            View view3 = this.getChildAt(i);
            Object object = (LayoutParams)view3.getLayoutParams();
            if (!object.isNestedScrollAccepted(n2) || (object = object.getBehavior()) == null) continue;
            ((Behavior)object).onNestedScrollAccepted(this, view3, view, view2, n, n2);
        }
    }

    protected void onRestoreInstanceState(Parcelable object) {
        if (!(object instanceof SavedState)) {
            super.onRestoreInstanceState((Parcelable)object);
            return;
        }
        object = (SavedState)object;
        super.onRestoreInstanceState(((AbsSavedState)object).getSuperState());
        SparseArray<Parcelable> sparseArray = ((SavedState)object).behaviorStates;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            Parcelable parcelable;
            View view = this.getChildAt(i);
            int n2 = view.getId();
            object = this.getResolvedLayoutParams(view).getBehavior();
            if (n2 == -1 || object == null || (parcelable = (Parcelable)sparseArray.get(n2)) == null) continue;
            ((Behavior)object).onRestoreInstanceState(this, view, parcelable);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        SparseArray sparseArray = new SparseArray();
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            int n2 = view.getId();
            Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
            if (n2 == -1 || behavior == null || (view = behavior.onSaveInstanceState(this, view)) == null) continue;
            sparseArray.append(n2, (Object)view);
        }
        savedState.behaviorStates = sparseArray;
        return savedState;
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n) {
        return this.onStartNestedScroll(view, view2, n, 0);
    }

    @Override
    public boolean onStartNestedScroll(View view, View view2, int n, int n2) {
        int n3 = this.getChildCount();
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            View view3 = this.getChildAt(i);
            if (view3.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view3.getLayoutParams();
            Behavior behavior = layoutParams.getBehavior();
            if (behavior != null) {
                boolean bl2 = behavior.onStartNestedScroll(this, view3, view, view2, n, n2);
                bl |= bl2;
                layoutParams.setNestedScrollAccepted(n2, bl2);
                continue;
            }
            layoutParams.setNestedScrollAccepted(n2, false);
        }
        return bl;
    }

    @Override
    public void onStopNestedScroll(View view) {
        this.onStopNestedScroll(view, 0);
    }

    @Override
    public void onStopNestedScroll(View view, int n) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(view, n);
        int n2 = this.getChildCount();
        for (int i = 0; i < n2; ++i) {
            View view2 = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view2.getLayoutParams();
            if (!layoutParams.isNestedScrollAccepted(n)) continue;
            Behavior behavior = layoutParams.getBehavior();
            if (behavior != null) {
                behavior.onStopNestedScroll(this, view2, view, n);
            }
            layoutParams.resetNestedScroll(n);
            layoutParams.resetChangedAfterNestedScroll();
        }
        this.mNestedScrollingTarget = null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block8: {
            block7: {
                var2_2 = var1_1 /* !! */ .getActionMasked();
                if (this.mBehaviorTouchView != null) break block7;
                var4_4 = var3_3 = this.performIntercept(var1_1 /* !! */ , 1);
                if (!var3_3) ** GOTO lbl-1000
                break block8;
            }
            var3_3 = false;
        }
        var5_5 = ((LayoutParams)this.mBehaviorTouchView.getLayoutParams()).getBehavior();
        var4_4 = var3_3;
        if (var5_5 != null) {
            var6_6 = var5_5.onTouchEvent(this, this.mBehaviorTouchView, var1_1 /* !! */ );
            var4_4 = var3_3;
            var3_3 = var6_6;
        } else lbl-1000:
        // 2 sources

        {
            var3_3 = false;
        }
        var7_7 = this.mBehaviorTouchView;
        var5_5 = null;
        if (var7_7 == null) {
            var6_6 = var3_3 | super.onTouchEvent(var1_1 /* !! */ );
            var1_1 /* !! */  = var5_5;
        } else {
            var6_6 = var3_3;
            var1_1 /* !! */  = var5_5;
            if (var4_4) {
                var8_8 = SystemClock.uptimeMillis();
                var1_1 /* !! */  = MotionEvent.obtain((long)var8_8, (long)var8_8, (int)3, (float)0.0f, (float)0.0f, (int)0);
                super.onTouchEvent(var1_1 /* !! */ );
                var6_6 = var3_3;
            }
        }
        if (var1_1 /* !! */  != null) {
            var1_1 /* !! */ .recycle();
        }
        if (var2_2 == 1 || var2_2 == 3) {
            this.resetTouchBehaviors(false);
        }
        return var6_6;
    }

    void recordLastChildRect(View view, Rect rect) {
        ((LayoutParams)view.getLayoutParams()).setLastChildRect(rect);
    }

    void removePreDrawListener() {
        if (this.mIsAttachedToWindow && this.mOnPreDrawListener != null) {
            this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = false;
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        Behavior behavior = ((LayoutParams)view.getLayoutParams()).getBehavior();
        if (behavior != null && behavior.onRequestChildRectangleOnScreen(this, view, rect, bl)) {
            return true;
        }
        return super.requestChildRectangleOnScreen(view, rect, bl);
    }

    public void requestDisallowInterceptTouchEvent(boolean bl) {
        super.requestDisallowInterceptTouchEvent(bl);
        if (bl && !this.mDisallowInterceptReset) {
            this.resetTouchBehaviors(false);
            this.mDisallowInterceptReset = true;
        }
    }

    public void setFitsSystemWindows(boolean bl) {
        super.setFitsSystemWindows(bl);
        this.setupForInsets();
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void setStatusBarBackground(Drawable drawable2) {
        Drawable drawable3 = this.mStatusBarBackground;
        if (drawable3 != drawable2) {
            Drawable drawable4 = null;
            if (drawable3 != null) {
                drawable3.setCallback(null);
            }
            if (drawable2 != null) {
                drawable4 = drawable2.mutate();
            }
            this.mStatusBarBackground = drawable4;
            if (drawable4 != null) {
                if (drawable4.isStateful()) {
                    this.mStatusBarBackground.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection(this.mStatusBarBackground, ViewCompat.getLayoutDirection((View)this));
                drawable2 = this.mStatusBarBackground;
                boolean bl = this.getVisibility() == 0;
                drawable2.setVisible(bl, false);
                this.mStatusBarBackground.setCallback((Drawable.Callback)this);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setStatusBarBackgroundColor(int n) {
        this.setStatusBarBackground((Drawable)new ColorDrawable(n));
    }

    public void setStatusBarBackgroundResource(int n) {
        Drawable drawable2 = n != 0 ? ContextCompat.getDrawable(this.getContext(), n) : null;
        this.setStatusBarBackground(drawable2);
    }

    public void setVisibility(int n) {
        super.setVisibility(n);
        boolean bl = n == 0;
        Drawable drawable2 = this.mStatusBarBackground;
        if (drawable2 != null && drawable2.isVisible() != bl) {
            this.mStatusBarBackground.setVisible(bl, false);
        }
    }

    final WindowInsetsCompat setWindowInsets(WindowInsetsCompat windowInsetsCompat) {
        WindowInsetsCompat windowInsetsCompat2 = windowInsetsCompat;
        if (!ObjectsCompat.equals(this.mLastInsets, windowInsetsCompat)) {
            this.mLastInsets = windowInsetsCompat;
            boolean bl = true;
            boolean bl2 = windowInsetsCompat != null && windowInsetsCompat.getSystemWindowInsetTop() > 0;
            this.mDrawStatusBarBackground = bl2;
            bl2 = !bl2 && this.getBackground() == null ? bl : false;
            this.setWillNotDraw(bl2);
            windowInsetsCompat2 = this.dispatchApplyWindowInsetsToBehaviors(windowInsetsCompat);
            this.requestLayout();
        }
        return windowInsetsCompat2;
    }

    protected boolean verifyDrawable(Drawable drawable2) {
        boolean bl = super.verifyDrawable(drawable2) || drawable2 == this.mStatusBarBackground;
        return bl;
    }

    public static interface AttachedBehavior {
        public Behavior getBehavior();
    }

    public static abstract class Behavior<V extends View> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attributeSet) {
        }

        public static Object getTag(View view) {
            return ((LayoutParams)view.getLayoutParams()).mBehaviorTag;
        }

        public static void setTag(View view, Object object) {
            ((LayoutParams)view.getLayoutParams()).mBehaviorTag = object;
        }

        public boolean blocksInteractionBelow(CoordinatorLayout coordinatorLayout, V v) {
            boolean bl = this.getScrimOpacity(coordinatorLayout, v) > 0.0f;
            return bl;
        }

        public boolean getInsetDodgeRect(CoordinatorLayout coordinatorLayout, V v, Rect rect) {
            return false;
        }

        public int getScrimColor(CoordinatorLayout coordinatorLayout, V v) {
            return -16777216;
        }

        public float getScrimOpacity(CoordinatorLayout coordinatorLayout, V v) {
            return 0.0f;
        }

        public boolean layoutDependsOn(CoordinatorLayout coordinatorLayout, V v, View view) {
            return false;
        }

        public WindowInsetsCompat onApplyWindowInsets(CoordinatorLayout coordinatorLayout, V v, WindowInsetsCompat windowInsetsCompat) {
            return windowInsetsCompat;
        }

        public void onAttachedToLayoutParams(LayoutParams layoutParams) {
        }

        public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, V v, View view) {
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout coordinatorLayout, V v, View view) {
        }

        public void onDetachedFromLayoutParams() {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int n) {
            return false;
        }

        public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, V v, int n, int n2, int n3, int n4) {
            return false;
        }

        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2, boolean bl) {
            return false;
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2) {
            return false;
        }

        @Deprecated
        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int[] nArray) {
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int[] nArray, int n3) {
            if (n3 == 0) {
                this.onNestedPreScroll(coordinatorLayout, v, view, n, n2, nArray);
            }
        }

        @Deprecated
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int n3, int n4) {
        }

        @Deprecated
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int n3, int n4, int n5) {
            if (n5 == 0) {
                this.onNestedScroll(coordinatorLayout, v, view, n, n2, n3, n4);
            }
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n, int n2, int n3, int n4, int n5, int[] nArray) {
            nArray[0] = nArray[0] + n3;
            nArray[1] = nArray[1] + n4;
            this.onNestedScroll(coordinatorLayout, v, view, n, n2, n3, n4, n5);
        }

        @Deprecated
        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n) {
        }

        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n, int n2) {
            if (n2 == 0) {
                this.onNestedScrollAccepted(coordinatorLayout, v, view, view2, n);
            }
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout coordinatorLayout, V v, Rect rect, boolean bl) {
            return false;
        }

        public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v, Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v) {
            return View.BaseSavedState.EMPTY_STATE;
        }

        @Deprecated
        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n) {
            return false;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int n, int n2) {
            if (n2 == 0) {
                return this.onStartNestedScroll(coordinatorLayout, v, view, view2, n);
            }
            return false;
        }

        @Deprecated
        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view) {
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int n) {
            if (n == 0) {
                this.onStopNestedScroll(coordinatorLayout, v, view);
            }
        }

        public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
            return false;
        }
    }

    @Deprecated
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DefaultBehavior {
        public Class<? extends Behavior> value();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DispatchChangeEvent {
    }

    private class HierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        HierarchyChangeListener() {
        }

        public void onChildViewAdded(View view, View view2) {
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        public void onChildViewRemoved(View view, View view2) {
            CoordinatorLayout.this.onChildViewsChanged(2);
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int anchorGravity = 0;
        public int dodgeInsetEdges = 0;
        public int gravity = 0;
        public int insetEdge = 0;
        public int keyline = -1;
        View mAnchorDirectChild;
        int mAnchorId = -1;
        View mAnchorView;
        Behavior mBehavior;
        boolean mBehaviorResolved = false;
        Object mBehaviorTag;
        private boolean mDidAcceptNestedScrollNonTouch;
        private boolean mDidAcceptNestedScrollTouch;
        private boolean mDidBlockInteraction;
        private boolean mDidChangeAfterNestedScroll;
        int mInsetOffsetX;
        int mInsetOffsetY;
        final Rect mLastChildRect = new Rect();

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        LayoutParams(Context object, AttributeSet attributeSet) {
            super((Context)object, attributeSet);
            boolean bl;
            TypedArray typedArray = object.obtainStyledAttributes(attributeSet, R.styleable.CoordinatorLayout_Layout);
            this.gravity = typedArray.getInteger(R.styleable.CoordinatorLayout_Layout_android_layout_gravity, 0);
            this.mAnchorId = typedArray.getResourceId(R.styleable.CoordinatorLayout_Layout_layout_anchor, -1);
            this.anchorGravity = typedArray.getInteger(R.styleable.CoordinatorLayout_Layout_layout_anchorGravity, 0);
            this.keyline = typedArray.getInteger(R.styleable.CoordinatorLayout_Layout_layout_keyline, -1);
            this.insetEdge = typedArray.getInt(R.styleable.CoordinatorLayout_Layout_layout_insetEdge, 0);
            this.dodgeInsetEdges = typedArray.getInt(R.styleable.CoordinatorLayout_Layout_layout_dodgeInsetEdges, 0);
            this.mBehaviorResolved = bl = typedArray.hasValue(R.styleable.CoordinatorLayout_Layout_layout_behavior);
            if (bl) {
                this.mBehavior = CoordinatorLayout.parseBehavior((Context)object, attributeSet, typedArray.getString(R.styleable.CoordinatorLayout_Layout_layout_behavior));
            }
            typedArray.recycle();
            object = this.mBehavior;
            if (object != null) {
                ((Behavior)object).onAttachedToLayoutParams(this);
            }
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public LayoutParams(LayoutParams layoutParams) {
            super((ViewGroup.MarginLayoutParams)layoutParams);
        }

        private void resolveAnchorView(View view, CoordinatorLayout coordinatorLayout) {
            View view2;
            this.mAnchorView = view2 = coordinatorLayout.findViewById(this.mAnchorId);
            if (view2 != null) {
                if (view2 == coordinatorLayout) {
                    if (coordinatorLayout.isInEditMode()) {
                        this.mAnchorDirectChild = null;
                        this.mAnchorView = null;
                        return;
                    }
                    throw new IllegalStateException("View can not be anchored to the the parent CoordinatorLayout");
                }
                for (ViewParent viewParent = view2.getParent(); viewParent != coordinatorLayout && viewParent != null; viewParent = viewParent.getParent()) {
                    if (viewParent == view) {
                        if (coordinatorLayout.isInEditMode()) {
                            this.mAnchorDirectChild = null;
                            this.mAnchorView = null;
                            return;
                        }
                        throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                    }
                    if (!(viewParent instanceof View)) continue;
                    view2 = (View)viewParent;
                }
                this.mAnchorDirectChild = view2;
                return;
            }
            if (coordinatorLayout.isInEditMode()) {
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Could not find CoordinatorLayout descendant view with id ");
            stringBuilder.append(coordinatorLayout.getResources().getResourceName(this.mAnchorId));
            stringBuilder.append(" to anchor view ");
            stringBuilder.append(view);
            throw new IllegalStateException(stringBuilder.toString());
        }

        private boolean shouldDodge(View view, int n) {
            int n2 = GravityCompat.getAbsoluteGravity(((LayoutParams)view.getLayoutParams()).insetEdge, n);
            boolean bl = n2 != 0 && (GravityCompat.getAbsoluteGravity(this.dodgeInsetEdges, n) & n2) == n2;
            return bl;
        }

        private boolean verifyAnchorView(View view, CoordinatorLayout coordinatorLayout) {
            if (this.mAnchorView.getId() != this.mAnchorId) {
                return false;
            }
            View view2 = this.mAnchorView;
            for (ViewParent viewParent = view2.getParent(); viewParent != coordinatorLayout; viewParent = viewParent.getParent()) {
                if (viewParent != null && viewParent != view) {
                    if (!(viewParent instanceof View)) continue;
                    view2 = (View)viewParent;
                    continue;
                }
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return false;
            }
            this.mAnchorDirectChild = view2;
            return true;
        }

        boolean checkAnchorChanged() {
            boolean bl = this.mAnchorView == null && this.mAnchorId != -1;
            return bl;
        }

        boolean dependsOn(CoordinatorLayout coordinatorLayout, View view, View view2) {
            Behavior behavior;
            boolean bl = view2 == this.mAnchorDirectChild || this.shouldDodge(view2, ViewCompat.getLayoutDirection((View)coordinatorLayout)) || (behavior = this.mBehavior) != null && behavior.layoutDependsOn(coordinatorLayout, view, view2);
            return bl;
        }

        boolean didBlockInteraction() {
            if (this.mBehavior == null) {
                this.mDidBlockInteraction = false;
            }
            return this.mDidBlockInteraction;
        }

        View findAnchorView(CoordinatorLayout coordinatorLayout, View view) {
            if (this.mAnchorId == -1) {
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return null;
            }
            if (this.mAnchorView == null || !this.verifyAnchorView(view, coordinatorLayout)) {
                this.resolveAnchorView(view, coordinatorLayout);
            }
            return this.mAnchorView;
        }

        public int getAnchorId() {
            return this.mAnchorId;
        }

        public Behavior getBehavior() {
            return this.mBehavior;
        }

        boolean getChangedAfterNestedScroll() {
            return this.mDidChangeAfterNestedScroll;
        }

        Rect getLastChildRect() {
            return this.mLastChildRect;
        }

        void invalidateAnchor() {
            this.mAnchorDirectChild = null;
            this.mAnchorView = null;
        }

        boolean isBlockingInteractionBelow(CoordinatorLayout coordinatorLayout, View view) {
            boolean bl = this.mDidBlockInteraction;
            if (bl) {
                return true;
            }
            Behavior behavior = this.mBehavior;
            boolean bl2 = behavior != null ? behavior.blocksInteractionBelow(coordinatorLayout, view) : false;
            this.mDidBlockInteraction = bl2 |= bl;
            return bl2;
        }

        boolean isNestedScrollAccepted(int n) {
            if (n != 0) {
                if (n != 1) {
                    return false;
                }
                return this.mDidAcceptNestedScrollNonTouch;
            }
            return this.mDidAcceptNestedScrollTouch;
        }

        void resetChangedAfterNestedScroll() {
            this.mDidChangeAfterNestedScroll = false;
        }

        void resetNestedScroll(int n) {
            this.setNestedScrollAccepted(n, false);
        }

        void resetTouchBehaviorTracking() {
            this.mDidBlockInteraction = false;
        }

        public void setAnchorId(int n) {
            this.invalidateAnchor();
            this.mAnchorId = n;
        }

        public void setBehavior(Behavior behavior) {
            Behavior behavior2 = this.mBehavior;
            if (behavior2 != behavior) {
                if (behavior2 != null) {
                    behavior2.onDetachedFromLayoutParams();
                }
                this.mBehavior = behavior;
                this.mBehaviorTag = null;
                this.mBehaviorResolved = true;
                if (behavior != null) {
                    behavior.onAttachedToLayoutParams(this);
                }
            }
        }

        void setChangedAfterNestedScroll(boolean bl) {
            this.mDidChangeAfterNestedScroll = bl;
        }

        void setLastChildRect(Rect rect) {
            this.mLastChildRect.set(rect);
        }

        void setNestedScrollAccepted(int n, boolean bl) {
            if (n != 0) {
                if (n == 1) {
                    this.mDidAcceptNestedScrollNonTouch = bl;
                }
            } else {
                this.mDidAcceptNestedScrollTouch = bl;
            }
        }
    }

    class OnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        OnPreDrawListener() {
        }

        public boolean onPreDraw() {
            CoordinatorLayout.this.onChildViewsChanged(0);
            return true;
        }
    }

    protected static class SavedState
    extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }

            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        };
        SparseArray<Parcelable> behaviorStates;

        public SavedState(Parcel parcelableArray, ClassLoader classLoader) {
            super((Parcel)parcelableArray, classLoader);
            int n = parcelableArray.readInt();
            int[] nArray = new int[n];
            parcelableArray.readIntArray(nArray);
            parcelableArray = parcelableArray.readParcelableArray(classLoader);
            this.behaviorStates = new SparseArray(n);
            for (int i = 0; i < n; ++i) {
                this.behaviorStates.append(nArray[i], (Object)parcelableArray[i]);
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            Parcelable[] parcelableArray = this.behaviorStates;
            int n2 = parcelableArray != null ? parcelableArray.size() : 0;
            parcel.writeInt(n2);
            int[] nArray = new int[n2];
            parcelableArray = new Parcelable[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.behaviorStates.keyAt(i);
                parcelableArray[i] = (Parcelable)this.behaviorStates.valueAt(i);
            }
            parcel.writeIntArray(nArray);
            parcel.writeParcelableArray(parcelableArray, n);
        }
    }

    static class ViewElevationComparator
    implements Comparator<View> {
        ViewElevationComparator() {
        }

        @Override
        public int compare(View view, View view2) {
            float f;
            float f2 = ViewCompat.getZ(view);
            if (f2 > (f = ViewCompat.getZ(view2))) {
                return -1;
            }
            if (f2 < f) {
                return 1;
            }
            return 0;
        }
    }
}

