/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Activity;
import android.app.SharedElementCallback;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.LocusId;
import android.content.pm.PackageManager;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.DragEvent;
import android.view.View;
import androidx.core.app.ActivityRecreator;
import androidx.core.app.SharedElementCallback;
import androidx.core.content.ContextCompat;
import androidx.core.content.LocusIdCompat;
import androidx.core.os.BuildCompat;
import androidx.core.view.DragAndDropPermissionsCompat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ActivityCompat
extends ContextCompat {
    private static PermissionCompatDelegate sDelegate;

    protected ActivityCompat() {
    }

    public static void finishAffinity(Activity activity) {
        if (Build.VERSION.SDK_INT >= 16) {
            activity.finishAffinity();
        } else {
            activity.finish();
        }
    }

    public static void finishAfterTransition(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.finishAfterTransition();
        } else {
            activity.finish();
        }
    }

    public static PermissionCompatDelegate getPermissionCompatDelegate() {
        return sDelegate;
    }

    public static Uri getReferrer(Activity object) {
        if (Build.VERSION.SDK_INT >= 22) {
            return object.getReferrer();
        }
        Intent intent = object.getIntent();
        if ((object = (Uri)intent.getParcelableExtra("android.intent.extra.REFERRER")) != null) {
            return object;
        }
        object = intent.getStringExtra("android.intent.extra.REFERRER_NAME");
        if (object != null) {
            return Uri.parse((String)object);
        }
        return null;
    }

    @Deprecated
    public static boolean invalidateOptionsMenu(Activity activity) {
        activity.invalidateOptionsMenu();
        return true;
    }

    public static boolean isLaunchedFromBubble(Activity activity) {
        if (BuildCompat.isAtLeastS()) {
            return Api31Impl.isLaunchedFromBubble(activity);
        }
        int n = Build.VERSION.SDK_INT;
        boolean bl = true;
        boolean bl2 = true;
        if (n == 30) {
            if (activity.getDisplay() == null || activity.getDisplay().getDisplayId() == 0) {
                bl2 = false;
            }
            return bl2;
        }
        if (Build.VERSION.SDK_INT == 29) {
            bl2 = activity.getWindowManager().getDefaultDisplay() != null && activity.getWindowManager().getDefaultDisplay().getDisplayId() != 0 ? bl : false;
            return bl2;
        }
        return false;
    }

    public static void postponeEnterTransition(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.postponeEnterTransition();
        }
    }

    public static void recreate(final Activity activity) {
        if (Build.VERSION.SDK_INT >= 28) {
            activity.recreate();
        } else if (Build.VERSION.SDK_INT <= 23) {
            new Handler(activity.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (!activity.isFinishing() && !ActivityRecreator.recreate(activity)) {
                        activity.recreate();
                    }
                }
            });
        } else if (!ActivityRecreator.recreate(activity)) {
            activity.recreate();
        }
    }

    public static DragAndDropPermissionsCompat requestDragAndDropPermissions(Activity activity, DragEvent dragEvent) {
        return DragAndDropPermissionsCompat.request(activity, dragEvent);
    }

    public static void requestPermissions(Activity object, final String[] stringArray, int n) {
        PermissionCompatDelegate permissionCompatDelegate = sDelegate;
        if (permissionCompatDelegate != null && permissionCompatDelegate.requestPermissions((Activity)object, stringArray, n)) {
            return;
        }
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!TextUtils.isEmpty((CharSequence)stringArray[i])) {
                continue;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Permission request for permissions ");
            ((StringBuilder)object).append(Arrays.toString(stringArray));
            ((StringBuilder)object).append(" must not contain null or empty values");
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (Build.VERSION.SDK_INT >= 23) {
            if (object instanceof RequestPermissionsRequestCodeValidator) {
                ((RequestPermissionsRequestCodeValidator)object).validateRequestPermissionsRequestCode(n);
            }
            object.requestPermissions(stringArray, n);
        } else if (object instanceof OnRequestPermissionsResultCallback) {
            new Handler(Looper.getMainLooper()).post(new Runnable((Activity)object, n){
                final /* synthetic */ Activity val$activity;
                final /* synthetic */ int val$requestCode;
                {
                    this.val$activity = activity;
                    this.val$requestCode = n;
                }

                @Override
                public void run() {
                    int[] nArray = new int[stringArray.length];
                    PackageManager packageManager = this.val$activity.getPackageManager();
                    String string2 = this.val$activity.getPackageName();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        nArray[i] = packageManager.checkPermission(stringArray[i], string2);
                    }
                    ((OnRequestPermissionsResultCallback)this.val$activity).onRequestPermissionsResult(this.val$requestCode, stringArray, nArray);
                }
            });
        }
    }

    public static <T extends View> T requireViewById(Activity activity, int n) {
        if (Build.VERSION.SDK_INT >= 28) {
            return (T)activity.requireViewById(n);
        }
        if ((activity = activity.findViewById(n)) != null) {
            return (T)activity;
        }
        throw new IllegalArgumentException("ID does not reference a View inside this Activity");
    }

    public static void setEnterSharedElementCallback(Activity activity, SharedElementCallback object) {
        if (Build.VERSION.SDK_INT >= 21) {
            object = object != null ? new SharedElementCallback21Impl((SharedElementCallback)object) : null;
            activity.setEnterSharedElementCallback((android.app.SharedElementCallback)object);
        }
    }

    public static void setExitSharedElementCallback(Activity activity, SharedElementCallback object) {
        if (Build.VERSION.SDK_INT >= 21) {
            object = object != null ? new SharedElementCallback21Impl((SharedElementCallback)object) : null;
            activity.setExitSharedElementCallback((android.app.SharedElementCallback)object);
        }
    }

    public static void setLocusContext(Activity activity, LocusIdCompat locusIdCompat, Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 30) {
            Api30Impl.setLocusContext(activity, locusIdCompat, bundle);
        }
    }

    public static void setPermissionCompatDelegate(PermissionCompatDelegate permissionCompatDelegate) {
        sDelegate = permissionCompatDelegate;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String string2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return activity.shouldShowRequestPermissionRationale(string2);
        }
        return false;
    }

    public static void startActivityForResult(Activity activity, Intent intent, int n, Bundle bundle) {
        if (Build.VERSION.SDK_INT >= 16) {
            activity.startActivityForResult(intent, n, bundle);
        } else {
            activity.startActivityForResult(intent, n);
        }
    }

    public static void startIntentSenderForResult(Activity activity, IntentSender intentSender, int n, Intent intent, int n2, int n3, int n4, Bundle bundle) throws IntentSender.SendIntentException {
        if (Build.VERSION.SDK_INT >= 16) {
            activity.startIntentSenderForResult(intentSender, n, intent, n2, n3, n4, bundle);
        } else {
            activity.startIntentSenderForResult(intentSender, n, intent, n2, n3, n4);
        }
    }

    public static void startPostponedEnterTransition(Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.startPostponedEnterTransition();
        }
    }

    static class Api30Impl {
        private Api30Impl() {
        }

        static void setLocusContext(Activity activity, LocusIdCompat locusIdCompat, Bundle bundle) {
            locusIdCompat = locusIdCompat == null ? null : locusIdCompat.toLocusId();
            activity.setLocusContext((LocusId)locusIdCompat, bundle);
        }
    }

    static class Api31Impl {
        private Api31Impl() {
        }

        static boolean isLaunchedFromBubble(Activity activity) {
            return activity.isLaunchedFromBubble();
        }
    }

    public static interface OnRequestPermissionsResultCallback {
        public void onRequestPermissionsResult(int var1, String[] var2, int[] var3);
    }

    public static interface PermissionCompatDelegate {
        public boolean onActivityResult(Activity var1, int var2, int var3, Intent var4);

        public boolean requestPermissions(Activity var1, String[] var2, int var3);
    }

    public static interface RequestPermissionsRequestCodeValidator {
        public void validateRequestPermissionsRequestCode(int var1);
    }

    private static class SharedElementCallback21Impl
    extends android.app.SharedElementCallback {
        private final SharedElementCallback mCallback;

        SharedElementCallback21Impl(SharedElementCallback sharedElementCallback) {
            this.mCallback = sharedElementCallback;
        }

        public Parcelable onCaptureSharedElementSnapshot(View view, Matrix matrix, RectF rectF) {
            return this.mCallback.onCaptureSharedElementSnapshot(view, matrix, rectF);
        }

        public View onCreateSnapshotView(Context context, Parcelable parcelable) {
            return this.mCallback.onCreateSnapshotView(context, parcelable);
        }

        public void onMapSharedElements(List<String> list, Map<String, View> map) {
            this.mCallback.onMapSharedElements(list, map);
        }

        public void onRejectSharedElements(List<View> list) {
            this.mCallback.onRejectSharedElements(list);
        }

        public void onSharedElementEnd(List<String> list, List<View> list2, List<View> list3) {
            this.mCallback.onSharedElementEnd(list, list2, list3);
        }

        public void onSharedElementStart(List<String> list, List<View> list2, List<View> list3) {
            this.mCallback.onSharedElementStart(list, list2, list3);
        }

        public void onSharedElementsArrived(List<String> list, List<View> list2, final SharedElementCallback.OnSharedElementsReadyListener onSharedElementsReadyListener) {
            this.mCallback.onSharedElementsArrived(list, list2, new SharedElementCallback.OnSharedElementsReadyListener(){

                @Override
                public void onSharedElementsReady() {
                    onSharedElementsReadyListener.onSharedElementsReady();
                }
            });
        }
    }
}

