/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Build;
import androidx.core.app.NotificationChannelCompat;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotificationChannelGroupCompat {
    private boolean mBlocked;
    private List<NotificationChannelCompat> mChannels = Collections.emptyList();
    String mDescription;
    final String mId;
    CharSequence mName;

    NotificationChannelGroupCompat(NotificationChannelGroup notificationChannelGroup) {
        this(notificationChannelGroup, Collections.emptyList());
    }

    NotificationChannelGroupCompat(NotificationChannelGroup notificationChannelGroup, List<NotificationChannel> list) {
        this(notificationChannelGroup.getId());
        this.mName = notificationChannelGroup.getName();
        if (Build.VERSION.SDK_INT >= 28) {
            this.mDescription = notificationChannelGroup.getDescription();
        }
        if (Build.VERSION.SDK_INT >= 28) {
            this.mBlocked = notificationChannelGroup.isBlocked();
            this.mChannels = this.getChannelsCompat(notificationChannelGroup.getChannels());
        } else {
            this.mChannels = this.getChannelsCompat(list);
        }
    }

    NotificationChannelGroupCompat(String string2) {
        this.mId = Preconditions.checkNotNull(string2);
    }

    private List<NotificationChannelCompat> getChannelsCompat(List<NotificationChannel> notificationChannel2) {
        ArrayList<NotificationChannelCompat> arrayList = new ArrayList<NotificationChannelCompat>();
        for (NotificationChannel notificationChannel2 : notificationChannel2) {
            if (!this.mId.equals(notificationChannel2.getGroup())) continue;
            arrayList.add(new NotificationChannelCompat(notificationChannel2));
        }
        return arrayList;
    }

    public List<NotificationChannelCompat> getChannels() {
        return this.mChannels;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getId() {
        return this.mId;
    }

    public CharSequence getName() {
        return this.mName;
    }

    NotificationChannelGroup getNotificationChannelGroup() {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        NotificationChannelGroup notificationChannelGroup = new NotificationChannelGroup(this.mId, this.mName);
        if (Build.VERSION.SDK_INT >= 28) {
            notificationChannelGroup.setDescription(this.mDescription);
        }
        return notificationChannelGroup;
    }

    public boolean isBlocked() {
        return this.mBlocked;
    }

    public Builder toBuilder() {
        return new Builder(this.mId).setName(this.mName).setDescription(this.mDescription);
    }

    public static class Builder {
        final NotificationChannelGroupCompat mGroup;

        public Builder(String string2) {
            this.mGroup = new NotificationChannelGroupCompat(string2);
        }

        public NotificationChannelGroupCompat build() {
            return this.mGroup;
        }

        public Builder setDescription(String string2) {
            this.mGroup.mDescription = string2;
            return this;
        }

        public Builder setName(CharSequence charSequence) {
            this.mGroup.mName = charSequence;
            return this;
        }
    }
}

