/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.ProviderInfo;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import androidx.core.content.ContextCompat;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class FileProvider
extends ContentProvider {
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String[] COLUMNS = new String[]{"_display_name", "_size"};
    private static final File DEVICE_ROOT = new File("/");
    private static final String DISPLAYNAME_FIELD = "displayName";
    private static final String META_DATA_FILE_PROVIDER_PATHS = "android.support.FILE_PROVIDER_PATHS";
    private static final String TAG_CACHE_PATH = "cache-path";
    private static final String TAG_EXTERNAL = "external-path";
    private static final String TAG_EXTERNAL_CACHE = "external-cache-path";
    private static final String TAG_EXTERNAL_FILES = "external-files-path";
    private static final String TAG_EXTERNAL_MEDIA = "external-media-path";
    private static final String TAG_FILES_PATH = "files-path";
    private static final String TAG_ROOT_PATH = "root-path";
    private static HashMap<String, PathStrategy> sCache = new HashMap();
    private PathStrategy mStrategy;

    private static File buildPath(File file, String ... stringArray) {
        int n = stringArray.length;
        File file2 = file;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            file = file2;
            if (string2 != null) {
                file = new File(file2, string2);
            }
            file2 = file;
        }
        return file2;
    }

    private static Object[] copyOf(Object[] objectArray, int n) {
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private static String[] copyOf(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        return stringArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PathStrategy getPathStrategy(Context context, String object) {
        HashMap<String, PathStrategy> hashMap = sCache;
        synchronized (hashMap) {
            PathStrategy pathStrategy;
            PathStrategy pathStrategy2 = pathStrategy = sCache.get(object);
            if (pathStrategy == null) {
                try {
                    pathStrategy2 = FileProvider.parsePathStrategy(context, (String)object);
                    sCache.put((String)object, pathStrategy2);
                }
                catch (XmlPullParserException xmlPullParserException) {
                    object = new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", xmlPullParserException);
                    throw object;
                }
                catch (IOException iOException) {
                    object = new IllegalArgumentException("Failed to parse android.support.FILE_PROVIDER_PATHS meta-data", iOException);
                    throw object;
                }
            }
            return pathStrategy2;
        }
    }

    public static Uri getUriForFile(Context context, String string2, File file) {
        return FileProvider.getPathStrategy(context, string2).getUriForFile(file);
    }

    public static Uri getUriForFile(Context context, String string2, File file, String string3) {
        return FileProvider.getUriForFile(context, string2, file).buildUpon().appendQueryParameter(DISPLAYNAME_FIELD, string3).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int modeToMode(String string2) {
        if ("r".equals(string2)) {
            return 0x10000000;
        }
        if ("w".equals(string2)) return 0x2C000000;
        if ("wt".equals(string2)) return 0x2C000000;
        if ("wa".equals(string2)) {
            return 0x2A000000;
        }
        if ("rw".equals(string2)) {
            return 0x38000000;
        }
        if ("rwt".equals(string2)) {
            return 0x3C000000;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid mode: ");
        stringBuilder.append(string2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    private static PathStrategy parsePathStrategy(Context object, String object2) throws IOException, XmlPullParserException {
        SimplePathStrategy simplePathStrategy = new SimplePathStrategy((String)object2);
        ProviderInfo providerInfo = object.getPackageManager().resolveContentProvider((String)object2, 128);
        if (providerInfo != null) {
            XmlResourceParser xmlResourceParser = providerInfo.loadXmlMetaData(object.getPackageManager(), META_DATA_FILE_PROVIDER_PATHS);
            if (xmlResourceParser != null) {
                int n;
                while ((n = xmlResourceParser.next()) != 1) {
                    if (n != 2) continue;
                    File[] fileArray = xmlResourceParser.getName();
                    providerInfo = null;
                    String string2 = xmlResourceParser.getAttributeValue(null, ATTR_NAME);
                    String string3 = xmlResourceParser.getAttributeValue(null, ATTR_PATH);
                    if (TAG_ROOT_PATH.equals(fileArray)) {
                        object2 = DEVICE_ROOT;
                    } else if (TAG_FILES_PATH.equals(fileArray)) {
                        object2 = object.getFilesDir();
                    } else if (TAG_CACHE_PATH.equals(fileArray)) {
                        object2 = object.getCacheDir();
                    } else if (TAG_EXTERNAL.equals(fileArray)) {
                        object2 = Environment.getExternalStorageDirectory();
                    } else if (TAG_EXTERNAL_FILES.equals(fileArray)) {
                        fileArray = ContextCompat.getExternalFilesDirs((Context)object, null);
                        object2 = providerInfo;
                        if (fileArray.length > 0) {
                            object2 = fileArray[0];
                        }
                    } else if (TAG_EXTERNAL_CACHE.equals(fileArray)) {
                        fileArray = ContextCompat.getExternalCacheDirs((Context)object);
                        object2 = providerInfo;
                        if (fileArray.length > 0) {
                            object2 = fileArray[0];
                        }
                    } else {
                        object2 = providerInfo;
                        if (Build.VERSION.SDK_INT >= 21) {
                            object2 = providerInfo;
                            if (TAG_EXTERNAL_MEDIA.equals(fileArray)) {
                                fileArray = object.getExternalMediaDirs();
                                object2 = providerInfo;
                                if (fileArray.length > 0) {
                                    object2 = fileArray[0];
                                }
                            }
                        }
                    }
                    if (object2 == null) continue;
                    simplePathStrategy.addRoot(string2, FileProvider.buildPath((File)object2, string3));
                }
                return simplePathStrategy;
            }
            throw new IllegalArgumentException("Missing android.support.FILE_PROVIDER_PATHS meta-data");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Couldn't find meta-data for provider with authority ");
        ((StringBuilder)object).append((String)object2);
        throw new IllegalArgumentException(((StringBuilder)object).toString());
    }

    public void attachInfo(Context context, ProviderInfo providerInfo) {
        super.attachInfo(context, providerInfo);
        if (!providerInfo.exported) {
            if (providerInfo.grantUriPermissions) {
                this.mStrategy = FileProvider.getPathStrategy(context, providerInfo.authority.split(";")[0]);
                return;
            }
            throw new SecurityException("Provider must grant uri permissions");
        }
        throw new SecurityException("Provider must not be exported");
    }

    public int delete(Uri uri, String string2, String[] stringArray) {
        return this.mStrategy.getFileForUri(uri).delete() ? 1 : 0;
    }

    public String getType(Uri object) {
        int n = ((File)(object = this.mStrategy.getFileForUri((Uri)object))).getName().lastIndexOf(46);
        if (n >= 0) {
            object = ((File)object).getName().substring(n + 1);
            object = MimeTypeMap.getSingleton().getMimeTypeFromExtension((String)object);
            if (object != null) {
                return object;
            }
        }
        return "application/octet-stream";
    }

    public Uri insert(Uri uri, ContentValues contentValues) {
        throw new UnsupportedOperationException("No external inserts");
    }

    public boolean onCreate() {
        return true;
    }

    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return ParcelFileDescriptor.open((File)this.mStrategy.getFileForUri(uri), (int)FileProvider.modeToMode(string2));
    }

    public Cursor query(Uri objectArray, String[] object, String string2, String[] object2, String objectArray2) {
        object2 = this.mStrategy.getFileForUri((Uri)objectArray);
        string2 = objectArray.getQueryParameter(DISPLAYNAME_FIELD);
        objectArray = object;
        if (object == null) {
            objectArray = COLUMNS;
        }
        String[] stringArray = new String[objectArray.length];
        objectArray2 = new Object[objectArray.length];
        int n = objectArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            block7: {
                block6: {
                    block5: {
                        object = objectArray[i];
                        if (!"_display_name".equals(object)) break block5;
                        stringArray[n2] = "_display_name";
                        n3 = n2 + 1;
                        object = string2 == null ? ((File)object2).getName() : string2;
                        objectArray2[n2] = object;
                        n2 = n3;
                        break block6;
                    }
                    n3 = n2;
                    if (!"_size".equals(object)) break block7;
                    stringArray[n2] = "_size";
                    n3 = n2 + 1;
                    objectArray2[n2] = ((File)object2).length();
                    n2 = n3;
                }
                n3 = n2;
            }
            n2 = n3;
        }
        object = FileProvider.copyOf(stringArray, n2);
        objectArray = FileProvider.copyOf(objectArray2, n2);
        object = new MatrixCursor(object, 1);
        object.addRow(objectArray);
        return object;
    }

    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        throw new UnsupportedOperationException("No external updates");
    }

    static interface PathStrategy {
        public File getFileForUri(Uri var1);

        public Uri getUriForFile(File var1);
    }

    static class SimplePathStrategy
    implements PathStrategy {
        private final String mAuthority;
        private final HashMap<String, File> mRoots = new HashMap();

        SimplePathStrategy(String string2) {
            this.mAuthority = string2;
        }

        void addRoot(String charSequence, File file) {
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                try {
                    File file2 = file.getCanonicalFile();
                    this.mRoots.put((String)charSequence, file2);
                }
                catch (IOException iOException) {
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("Failed to resolve canonical path for ");
                    ((StringBuilder)charSequence).append(file);
                    throw new IllegalArgumentException(((StringBuilder)charSequence).toString(), iOException);
                }
                return;
            }
            throw new IllegalArgumentException("Name must not be empty");
        }

        @Override
        public File getFileForUri(Uri object) {
            Object object2 = object.getEncodedPath();
            int n = ((String)object2).indexOf(47, 1);
            Object object3 = Uri.decode((String)((String)object2).substring(1, n));
            object2 = Uri.decode((String)((String)object2).substring(n + 1));
            if ((object3 = this.mRoots.get(object3)) != null) {
                object = new File((File)object3, (String)object2);
                try {
                    object2 = ((File)object).getCanonicalFile();
                    if (((File)object2).getPath().startsWith(((File)object3).getPath())) {
                        return object2;
                    }
                    throw new SecurityException("Resolved path jumped beyond configured root");
                }
                catch (IOException iOException) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Failed to resolve canonical path for ");
                    stringBuilder.append(object);
                    throw new IllegalArgumentException(stringBuilder.toString());
                }
            }
            object3 = new StringBuilder();
            ((StringBuilder)object3).append("Unable to find configured root for ");
            ((StringBuilder)object3).append(object);
            throw new IllegalArgumentException(((StringBuilder)object3).toString());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Uri getUriForFile(File object) {
            CharSequence charSequence;
            try {
                charSequence = ((File)object).getCanonicalPath();
                object = null;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Failed to resolve canonical path for ");
                stringBuilder.append(object);
                throw new IllegalArgumentException(stringBuilder.toString());
            }
            for (Map.Entry<String, File> object2 : this.mRoots.entrySet()) {
                String string2 = object2.getValue().getPath();
                if (!((String)charSequence).startsWith(string2) || object != null && string2.length() <= object.getValue().getPath().length()) continue;
                object = object2;
            }
            if (object != null) {
                void var4_8;
                String iOException = ((File)object.getValue()).getPath();
                if (iOException.endsWith("/")) {
                    String stringBuilder = ((String)charSequence).substring(iOException.length());
                } else {
                    String string3 = ((String)charSequence).substring(iOException.length() + 1);
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(Uri.encode((String)object.getKey()));
                ((StringBuilder)charSequence).append('/');
                ((StringBuilder)charSequence).append(Uri.encode((String)var4_8, (String)"/"));
                object = ((StringBuilder)charSequence).toString();
                return new Uri.Builder().scheme("content").authority(this.mAuthority).encodedPath((String)object).build();
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Failed to find configured root that contains ");
            ((StringBuilder)object).append((String)charSequence);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
    }
}

