/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.core.content.PackageManagerCompat;
import androidx.core.util.Preconditions;

public final class IntentCompat {
    public static final String ACTION_CREATE_REMINDER = "android.intent.action.CREATE_REMINDER";
    public static final String CATEGORY_LEANBACK_LAUNCHER = "android.intent.category.LEANBACK_LAUNCHER";
    public static final String EXTRA_HTML_TEXT = "android.intent.extra.HTML_TEXT";
    public static final String EXTRA_START_PLAYBACK = "android.intent.extra.START_PLAYBACK";
    public static final String EXTRA_TIME = "android.intent.extra.TIME";

    private IntentCompat() {
    }

    public static Intent createManageUnusedAppRestrictionsIntent(Context context, String string2) {
        if (PackageManagerCompat.areUnusedAppRestrictionsAvailable(context.getPackageManager())) {
            if (Build.VERSION.SDK_INT >= 31) {
                return new Intent("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts((String)"package", (String)string2, null));
            }
            string2 = new Intent("android.intent.action.AUTO_REVOKE_PERMISSIONS").setData(Uri.fromParts((String)"package", (String)string2, null));
            if (Build.VERSION.SDK_INT >= 30) {
                return string2;
            }
            return string2.setPackage(Preconditions.checkNotNull(PackageManagerCompat.getPermissionRevocationVerifierApp(context.getPackageManager())));
        }
        throw new UnsupportedOperationException("Unused App Restriction features are not available on this device");
    }

    public static Intent makeMainSelectorActivity(String string2, String string3) {
        if (Build.VERSION.SDK_INT >= 15) {
            return Intent.makeMainSelectorActivity((String)string2, (String)string3);
        }
        string2 = new Intent(string2);
        string2.addCategory(string3);
        return string2;
    }
}

