/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.pm;

import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.content.pm.SigningInfo;
import android.os.Build;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class PackageInfoCompat {
    private PackageInfoCompat() {
    }

    private static boolean byteArrayContains(byte[][] byArray, byte[] byArray2) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (!Arrays.equals(byArray2, byArray[i])) continue;
            return true;
        }
        return false;
    }

    private static byte[] computeSHA256Digest(byte[] byArray) {
        try {
            byArray = MessageDigest.getInstance("SHA256").digest(byArray);
            return byArray;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Device doesn't support SHA256 cert checking", noSuchAlgorithmException);
        }
    }

    public static long getLongVersionCode(PackageInfo packageInfo) {
        if (Build.VERSION.SDK_INT >= 28) {
            return packageInfo.getLongVersionCode();
        }
        return packageInfo.versionCode;
    }

    public static List<Signature> getSignatures(PackageManager signatureArray, String string2) throws PackageManager.NameNotFoundException {
        signatureArray = Build.VERSION.SDK_INT >= 28 ? (Api28Impl.hasMultipleSigners((SigningInfo)(signatureArray = signatureArray.getPackageInfo((String)string2, (int)0x8000000).signingInfo)) ? Api28Impl.getApkContentsSigners((SigningInfo)signatureArray) : Api28Impl.getSigningCertificateHistory((SigningInfo)signatureArray)) : signatureArray.getPackageInfo((String)string2, (int)64).signatures;
        if (signatureArray == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(signatureArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasSignatures(PackageManager object, String object2, Map<byte[], Integer> map, boolean bl) throws PackageManager.NameNotFoundException {
        int n;
        if (map.isEmpty()) {
            return false;
        }
        Object object3 = map.keySet();
        Iterator<byte[]> iterator = object3.iterator();
        while (iterator.hasNext()) {
            byte[] byArray = iterator.next();
            if (byArray != null) {
                Integer n2 = map.get(byArray);
                if (n2 != null) {
                    n = n2;
                    if (n == 0 || n == 1) continue;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unsupported certificate type ");
                    ((StringBuilder)object).append(n2);
                    ((StringBuilder)object).append(" when verifying ");
                    ((StringBuilder)object).append((String)object2);
                    throw new IllegalArgumentException(((StringBuilder)object).toString());
                }
                object = new StringBuilder();
                ((StringBuilder)object).append("Type must be specified for cert when verifying ");
                ((StringBuilder)object).append((String)object2);
                throw new IllegalArgumentException(((StringBuilder)object).toString());
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Cert byte array cannot be null when verifying ");
            ((StringBuilder)object).append((String)object2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        List<Signature> list = PackageInfoCompat.getSignatures((PackageManager)object, (String)object2);
        if (!bl && Build.VERSION.SDK_INT >= 28) {
            Iterator<byte[]> iterator2 = object3.iterator();
            while (iterator2.hasNext()) {
                object3 = iterator2.next();
                if (Api28Impl.hasSigningCertificate((PackageManager)object, (String)object2, (byte[])object3, map.get(object3))) continue;
                return false;
            }
            return true;
        }
        if (list.size() == 0 || map.size() > list.size() || bl && map.size() != list.size()) return false;
        bl = map.containsValue(1);
        object = null;
        if (bl) {
            object2 = new byte[list.size()][];
            n = 0;
            while (true) {
                object = object2;
                if (n >= list.size()) break;
                object2[n] = PackageInfoCompat.computeSHA256Digest(list.get(n).toByteArray());
                ++n;
            }
        }
        if (!(object2 = object3.iterator()).hasNext()) return false;
        object3 = (byte[])object2.next();
        n = (Integer)(object2 = map.get(object3));
        if (n != 0) {
            if (n == 1) {
                if (PackageInfoCompat.byteArrayContains((byte[][])object, (byte[])object3)) return true;
                return false;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Unsupported certificate type ");
            ((StringBuilder)object).append(object2);
            throw new IllegalArgumentException(((StringBuilder)object).toString());
        }
        if (list.contains(new Signature((byte[])object3))) return true;
        return false;
    }

    private static class Api28Impl {
        private Api28Impl() {
        }

        static Signature[] getApkContentsSigners(SigningInfo signingInfo) {
            return signingInfo.getApkContentsSigners();
        }

        static Signature[] getSigningCertificateHistory(SigningInfo signingInfo) {
            return signingInfo.getSigningCertificateHistory();
        }

        static boolean hasMultipleSigners(SigningInfo signingInfo) {
            return signingInfo.hasMultipleSigners();
        }

        static boolean hasSigningCertificate(PackageManager packageManager, String string2, byte[] byArray, int n) {
            return packageManager.hasSigningCertificate(string2, byArray, n);
        }
    }
}

