/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.pm;

import android.app.Person;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.text.TextUtils;
import androidx.core.content.LocusIdCompat;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.net.UriCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ShortcutInfoCompat {
    private static final String EXTRA_LOCUS_ID = "extraLocusId";
    private static final String EXTRA_LONG_LIVED = "extraLongLived";
    private static final String EXTRA_PERSON_ = "extraPerson_";
    private static final String EXTRA_PERSON_COUNT = "extraPersonCount";
    private static final String EXTRA_SLICE_URI = "extraSliceUri";
    ComponentName mActivity;
    Set<String> mCategories;
    Context mContext;
    CharSequence mDisabledMessage;
    int mDisabledReason;
    PersistableBundle mExtras;
    boolean mHasKeyFieldsOnly;
    IconCompat mIcon;
    String mId;
    Intent[] mIntents;
    boolean mIsAlwaysBadged;
    boolean mIsCached;
    boolean mIsDeclaredInManifest;
    boolean mIsDynamic;
    boolean mIsEnabled = true;
    boolean mIsImmutable;
    boolean mIsLongLived;
    boolean mIsPinned;
    CharSequence mLabel;
    long mLastChangedTimestamp;
    LocusIdCompat mLocusId;
    CharSequence mLongLabel;
    String mPackageName;
    androidx.core.app.Person[] mPersons;
    int mRank;
    UserHandle mUser;

    ShortcutInfoCompat() {
    }

    private PersistableBundle buildLegacyExtrasBundle() {
        Object object;
        if (this.mExtras == null) {
            this.mExtras = new PersistableBundle();
        }
        if ((object = this.mPersons) != null && ((androidx.core.app.Person[])object).length > 0) {
            this.mExtras.putInt(EXTRA_PERSON_COUNT, ((androidx.core.app.Person[])object).length);
            int n = 0;
            while (n < this.mPersons.length) {
                object = this.mExtras;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(EXTRA_PERSON_);
                int n2 = n + 1;
                stringBuilder.append(n2);
                object.putPersistableBundle(stringBuilder.toString(), this.mPersons[n].toPersistableBundle());
                n = n2;
            }
        }
        if ((object = this.mLocusId) != null) {
            this.mExtras.putString(EXTRA_LOCUS_ID, ((LocusIdCompat)object).getId());
        }
        this.mExtras.putBoolean(EXTRA_LONG_LIVED, this.mIsLongLived);
        return this.mExtras;
    }

    static List<ShortcutInfoCompat> fromShortcuts(Context context, List<ShortcutInfo> object) {
        ArrayList<ShortcutInfoCompat> arrayList = new ArrayList<ShortcutInfoCompat>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            arrayList.add(new Builder(context, (ShortcutInfo)object.next()).build());
        }
        return arrayList;
    }

    static LocusIdCompat getLocusId(ShortcutInfo shortcutInfo) {
        if (Build.VERSION.SDK_INT >= 29) {
            if (shortcutInfo.getLocusId() == null) {
                return null;
            }
            return LocusIdCompat.toLocusIdCompat(shortcutInfo.getLocusId());
        }
        return ShortcutInfoCompat.getLocusIdFromExtra(shortcutInfo.getExtras());
    }

    private static LocusIdCompat getLocusIdFromExtra(PersistableBundle object) {
        Object var1_1 = null;
        if (object == null) {
            return null;
        }
        object = (object = object.getString(EXTRA_LOCUS_ID)) == null ? var1_1 : new LocusIdCompat((String)object);
        return object;
    }

    static boolean getLongLivedFromExtra(PersistableBundle persistableBundle) {
        if (persistableBundle != null && persistableBundle.containsKey(EXTRA_LONG_LIVED)) {
            return persistableBundle.getBoolean(EXTRA_LONG_LIVED);
        }
        return false;
    }

    static androidx.core.app.Person[] getPersonsFromExtra(PersistableBundle persistableBundle) {
        if (persistableBundle != null && persistableBundle.containsKey(EXTRA_PERSON_COUNT)) {
            int n = persistableBundle.getInt(EXTRA_PERSON_COUNT);
            androidx.core.app.Person[] personArray = new androidx.core.app.Person[n];
            int n2 = 0;
            while (n2 < n) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(EXTRA_PERSON_);
                int n3 = n2 + 1;
                stringBuilder.append(n3);
                personArray[n2] = androidx.core.app.Person.fromPersistableBundle(persistableBundle.getPersistableBundle(stringBuilder.toString()));
                n2 = n3;
            }
            return personArray;
        }
        return null;
    }

    Intent addToIntent(Intent intent) {
        Drawable drawable2 = this.mIntents;
        intent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)drawable2[((Intent[])drawable2).length - 1]).putExtra("android.intent.extra.shortcut.NAME", this.mLabel.toString());
        if (this.mIcon != null) {
            Drawable drawable3 = null;
            Object var4_5 = null;
            if (this.mIsAlwaysBadged) {
                PackageManager packageManager = this.mContext.getPackageManager();
                drawable3 = this.mActivity;
                drawable2 = var4_5;
                if (drawable3 != null) {
                    try {
                        drawable2 = packageManager.getActivityIcon((ComponentName)drawable3);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        drawable2 = var4_5;
                    }
                }
                drawable3 = drawable2;
                if (drawable2 == null) {
                    drawable3 = this.mContext.getApplicationInfo().loadIcon(packageManager);
                }
            }
            this.mIcon.addToShortcutIntent(intent, drawable3, this.mContext);
        }
        return intent;
    }

    public ComponentName getActivity() {
        return this.mActivity;
    }

    public Set<String> getCategories() {
        return this.mCategories;
    }

    public CharSequence getDisabledMessage() {
        return this.mDisabledMessage;
    }

    public int getDisabledReason() {
        return this.mDisabledReason;
    }

    public PersistableBundle getExtras() {
        return this.mExtras;
    }

    public IconCompat getIcon() {
        return this.mIcon;
    }

    public String getId() {
        return this.mId;
    }

    public Intent getIntent() {
        Intent[] intentArray = this.mIntents;
        return intentArray[intentArray.length - 1];
    }

    public Intent[] getIntents() {
        Intent[] intentArray = this.mIntents;
        return Arrays.copyOf(intentArray, intentArray.length);
    }

    public long getLastChangedTimestamp() {
        return this.mLastChangedTimestamp;
    }

    public LocusIdCompat getLocusId() {
        return this.mLocusId;
    }

    public CharSequence getLongLabel() {
        return this.mLongLabel;
    }

    public String getPackage() {
        return this.mPackageName;
    }

    public int getRank() {
        return this.mRank;
    }

    public CharSequence getShortLabel() {
        return this.mLabel;
    }

    public UserHandle getUserHandle() {
        return this.mUser;
    }

    public boolean hasKeyFieldsOnly() {
        return this.mHasKeyFieldsOnly;
    }

    public boolean isCached() {
        return this.mIsCached;
    }

    public boolean isDeclaredInManifest() {
        return this.mIsDeclaredInManifest;
    }

    public boolean isDynamic() {
        return this.mIsDynamic;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public boolean isImmutable() {
        return this.mIsImmutable;
    }

    public boolean isPinned() {
        return this.mIsPinned;
    }

    public ShortcutInfo toShortcutInfo() {
        ShortcutInfo.Builder builder = new ShortcutInfo.Builder(this.mContext, this.mId).setShortLabel(this.mLabel).setIntents(this.mIntents);
        Object object = this.mIcon;
        if (object != null) {
            builder.setIcon(((IconCompat)object).toIcon(this.mContext));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLongLabel)) {
            builder.setLongLabel(this.mLongLabel);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mDisabledMessage)) {
            builder.setDisabledMessage(this.mDisabledMessage);
        }
        if ((object = this.mActivity) != null) {
            builder.setActivity((ComponentName)object);
        }
        if ((object = this.mCategories) != null) {
            builder.setCategories((Set)object);
        }
        builder.setRank(this.mRank);
        object = this.mExtras;
        if (object != null) {
            builder.setExtras((PersistableBundle)object);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            object = this.mPersons;
            if (object != null && ((androidx.core.app.Person[])object).length > 0) {
                int n = ((androidx.core.app.Person[])object).length;
                object = new Person[n];
                for (int i = 0; i < n; ++i) {
                    object[i] = this.mPersons[i].toAndroidPerson();
                }
                builder.setPersons((Person[])object);
            }
            if ((object = this.mLocusId) != null) {
                builder.setLocusId(((LocusIdCompat)object).toLocusId());
            }
            builder.setLongLived(this.mIsLongLived);
        } else {
            builder.setExtras(this.buildLegacyExtrasBundle());
        }
        return builder.build();
    }

    public static class Builder {
        private Map<String, Map<String, List<String>>> mCapabilityBindingParams;
        private Set<String> mCapabilityBindings;
        private final ShortcutInfoCompat mInfo;
        private boolean mIsConversation;
        private Uri mSliceUri;

        public Builder(Context intentArray, ShortcutInfo shortcutInfo) {
            ShortcutInfoCompat shortcutInfoCompat;
            this.mInfo = shortcutInfoCompat = new ShortcutInfoCompat();
            shortcutInfoCompat.mContext = intentArray;
            shortcutInfoCompat.mId = shortcutInfo.getId();
            shortcutInfoCompat.mPackageName = shortcutInfo.getPackage();
            intentArray = shortcutInfo.getIntents();
            shortcutInfoCompat.mIntents = Arrays.copyOf(intentArray, intentArray.length);
            shortcutInfoCompat.mActivity = shortcutInfo.getActivity();
            shortcutInfoCompat.mLabel = shortcutInfo.getShortLabel();
            shortcutInfoCompat.mLongLabel = shortcutInfo.getLongLabel();
            shortcutInfoCompat.mDisabledMessage = shortcutInfo.getDisabledMessage();
            if (Build.VERSION.SDK_INT >= 28) {
                shortcutInfoCompat.mDisabledReason = shortcutInfo.getDisabledReason();
            } else {
                int n = shortcutInfo.isEnabled() ? 0 : 3;
                shortcutInfoCompat.mDisabledReason = n;
            }
            shortcutInfoCompat.mCategories = shortcutInfo.getCategories();
            shortcutInfoCompat.mPersons = ShortcutInfoCompat.getPersonsFromExtra(shortcutInfo.getExtras());
            shortcutInfoCompat.mUser = shortcutInfo.getUserHandle();
            shortcutInfoCompat.mLastChangedTimestamp = shortcutInfo.getLastChangedTimestamp();
            if (Build.VERSION.SDK_INT >= 30) {
                shortcutInfoCompat.mIsCached = shortcutInfo.isCached();
            }
            shortcutInfoCompat.mIsDynamic = shortcutInfo.isDynamic();
            shortcutInfoCompat.mIsPinned = shortcutInfo.isPinned();
            shortcutInfoCompat.mIsDeclaredInManifest = shortcutInfo.isDeclaredInManifest();
            shortcutInfoCompat.mIsImmutable = shortcutInfo.isImmutable();
            shortcutInfoCompat.mIsEnabled = shortcutInfo.isEnabled();
            shortcutInfoCompat.mHasKeyFieldsOnly = shortcutInfo.hasKeyFieldsOnly();
            shortcutInfoCompat.mLocusId = ShortcutInfoCompat.getLocusId(shortcutInfo);
            shortcutInfoCompat.mRank = shortcutInfo.getRank();
            shortcutInfoCompat.mExtras = shortcutInfo.getExtras();
        }

        public Builder(Context context, String string2) {
            ShortcutInfoCompat shortcutInfoCompat;
            this.mInfo = shortcutInfoCompat = new ShortcutInfoCompat();
            shortcutInfoCompat.mContext = context;
            shortcutInfoCompat.mId = string2;
        }

        public Builder(ShortcutInfoCompat shortcutInfoCompat) {
            ShortcutInfoCompat shortcutInfoCompat2;
            this.mInfo = shortcutInfoCompat2 = new ShortcutInfoCompat();
            shortcutInfoCompat2.mContext = shortcutInfoCompat.mContext;
            shortcutInfoCompat2.mId = shortcutInfoCompat.mId;
            shortcutInfoCompat2.mPackageName = shortcutInfoCompat.mPackageName;
            shortcutInfoCompat2.mIntents = Arrays.copyOf(shortcutInfoCompat.mIntents, shortcutInfoCompat.mIntents.length);
            shortcutInfoCompat2.mActivity = shortcutInfoCompat.mActivity;
            shortcutInfoCompat2.mLabel = shortcutInfoCompat.mLabel;
            shortcutInfoCompat2.mLongLabel = shortcutInfoCompat.mLongLabel;
            shortcutInfoCompat2.mDisabledMessage = shortcutInfoCompat.mDisabledMessage;
            shortcutInfoCompat2.mDisabledReason = shortcutInfoCompat.mDisabledReason;
            shortcutInfoCompat2.mIcon = shortcutInfoCompat.mIcon;
            shortcutInfoCompat2.mIsAlwaysBadged = shortcutInfoCompat.mIsAlwaysBadged;
            shortcutInfoCompat2.mUser = shortcutInfoCompat.mUser;
            shortcutInfoCompat2.mLastChangedTimestamp = shortcutInfoCompat.mLastChangedTimestamp;
            shortcutInfoCompat2.mIsCached = shortcutInfoCompat.mIsCached;
            shortcutInfoCompat2.mIsDynamic = shortcutInfoCompat.mIsDynamic;
            shortcutInfoCompat2.mIsPinned = shortcutInfoCompat.mIsPinned;
            shortcutInfoCompat2.mIsDeclaredInManifest = shortcutInfoCompat.mIsDeclaredInManifest;
            shortcutInfoCompat2.mIsImmutable = shortcutInfoCompat.mIsImmutable;
            shortcutInfoCompat2.mIsEnabled = shortcutInfoCompat.mIsEnabled;
            shortcutInfoCompat2.mLocusId = shortcutInfoCompat.mLocusId;
            shortcutInfoCompat2.mIsLongLived = shortcutInfoCompat.mIsLongLived;
            shortcutInfoCompat2.mHasKeyFieldsOnly = shortcutInfoCompat.mHasKeyFieldsOnly;
            shortcutInfoCompat2.mRank = shortcutInfoCompat.mRank;
            if (shortcutInfoCompat.mPersons != null) {
                shortcutInfoCompat2.mPersons = Arrays.copyOf(shortcutInfoCompat.mPersons, shortcutInfoCompat.mPersons.length);
            }
            if (shortcutInfoCompat.mCategories != null) {
                shortcutInfoCompat2.mCategories = new HashSet<String>(shortcutInfoCompat.mCategories);
            }
            if (shortcutInfoCompat.mExtras != null) {
                shortcutInfoCompat2.mExtras = shortcutInfoCompat.mExtras;
            }
        }

        public Builder addCapabilityBinding(String string2) {
            if (this.mCapabilityBindings == null) {
                this.mCapabilityBindings = new HashSet<String>();
            }
            this.mCapabilityBindings.add(string2);
            return this;
        }

        public Builder addCapabilityBinding(String string2, String string3, List<String> list) {
            this.addCapabilityBinding(string2);
            if (!list.isEmpty()) {
                if (this.mCapabilityBindingParams == null) {
                    this.mCapabilityBindingParams = new HashMap<String, Map<String, List<String>>>();
                }
                if (this.mCapabilityBindingParams.get(string2) == null) {
                    this.mCapabilityBindingParams.put(string2, new HashMap());
                }
                this.mCapabilityBindingParams.get(string2).put(string3, list);
            }
            return this;
        }

        public ShortcutInfoCompat build() {
            if (!TextUtils.isEmpty((CharSequence)this.mInfo.mLabel)) {
                if (this.mInfo.mIntents != null && this.mInfo.mIntents.length != 0) {
                    String[] stringArray;
                    if (this.mIsConversation) {
                        if (this.mInfo.mLocusId == null) {
                            stringArray = this.mInfo;
                            stringArray.mLocusId = new LocusIdCompat(stringArray.mId);
                        }
                        this.mInfo.mIsLongLived = true;
                    }
                    if (this.mCapabilityBindings != null) {
                        if (this.mInfo.mCategories == null) {
                            this.mInfo.mCategories = new HashSet<String>();
                        }
                        this.mInfo.mCategories.addAll(this.mCapabilityBindings);
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        if (this.mCapabilityBindingParams != null) {
                            if (this.mInfo.mExtras == null) {
                                this.mInfo.mExtras = new PersistableBundle();
                            }
                            for (String string2 : this.mCapabilityBindingParams.keySet()) {
                                Map<String, List<String>> map = this.mCapabilityBindingParams.get(string2);
                                stringArray = map.keySet();
                                this.mInfo.mExtras.putStringArray(string2, stringArray.toArray(new String[0]));
                                for (String string3 : map.keySet()) {
                                    stringArray = map.get(string3);
                                    PersistableBundle persistableBundle = this.mInfo.mExtras;
                                    CharSequence charSequence = new StringBuilder();
                                    charSequence.append(string2);
                                    charSequence.append("/");
                                    charSequence.append(string3);
                                    charSequence = charSequence.toString();
                                    stringArray = stringArray == null ? new String[]{} : stringArray.toArray(new String[0]);
                                    persistableBundle.putStringArray((String)charSequence, stringArray);
                                }
                            }
                        }
                        if (this.mSliceUri != null) {
                            if (this.mInfo.mExtras == null) {
                                this.mInfo.mExtras = new PersistableBundle();
                            }
                            this.mInfo.mExtras.putString(ShortcutInfoCompat.EXTRA_SLICE_URI, UriCompat.toSafeString(this.mSliceUri));
                        }
                    }
                    return this.mInfo;
                }
                throw new IllegalArgumentException("Shortcut must have an intent");
            }
            throw new IllegalArgumentException("Shortcut must have a non-empty label");
        }

        public Builder setActivity(ComponentName componentName) {
            this.mInfo.mActivity = componentName;
            return this;
        }

        public Builder setAlwaysBadged() {
            this.mInfo.mIsAlwaysBadged = true;
            return this;
        }

        public Builder setCategories(Set<String> set) {
            this.mInfo.mCategories = set;
            return this;
        }

        public Builder setDisabledMessage(CharSequence charSequence) {
            this.mInfo.mDisabledMessage = charSequence;
            return this;
        }

        public Builder setExtras(PersistableBundle persistableBundle) {
            this.mInfo.mExtras = persistableBundle;
            return this;
        }

        public Builder setIcon(IconCompat iconCompat) {
            this.mInfo.mIcon = iconCompat;
            return this;
        }

        public Builder setIntent(Intent intent) {
            return this.setIntents(new Intent[]{intent});
        }

        public Builder setIntents(Intent[] intentArray) {
            this.mInfo.mIntents = intentArray;
            return this;
        }

        public Builder setIsConversation() {
            this.mIsConversation = true;
            return this;
        }

        public Builder setLocusId(LocusIdCompat locusIdCompat) {
            this.mInfo.mLocusId = locusIdCompat;
            return this;
        }

        public Builder setLongLabel(CharSequence charSequence) {
            this.mInfo.mLongLabel = charSequence;
            return this;
        }

        @Deprecated
        public Builder setLongLived() {
            this.mInfo.mIsLongLived = true;
            return this;
        }

        public Builder setLongLived(boolean bl) {
            this.mInfo.mIsLongLived = bl;
            return this;
        }

        public Builder setPerson(androidx.core.app.Person person) {
            return this.setPersons(new androidx.core.app.Person[]{person});
        }

        public Builder setPersons(androidx.core.app.Person[] personArray) {
            this.mInfo.mPersons = personArray;
            return this;
        }

        public Builder setRank(int n) {
            this.mInfo.mRank = n;
            return this;
        }

        public Builder setShortLabel(CharSequence charSequence) {
            this.mInfo.mLabel = charSequence;
            return this;
        }

        public Builder setSliceUri(Uri uri) {
            this.mSliceUri = uri;
            return this;
        }
    }
}

