/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.pm;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import androidx.core.content.pm.ShortcutInfoChangeListener;
import androidx.core.content.pm.ShortcutInfoCompat;
import androidx.core.content.pm.ShortcutInfoCompatSaver;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Preconditions;
import java.io.InputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ShortcutManagerCompat {
    static final String ACTION_INSTALL_SHORTCUT = "com.android.launcher.action.INSTALL_SHORTCUT";
    private static final int DEFAULT_MAX_ICON_DIMENSION_DP = 96;
    private static final int DEFAULT_MAX_ICON_DIMENSION_LOWRAM_DP = 48;
    public static final String EXTRA_SHORTCUT_ID = "android.intent.extra.shortcut.ID";
    public static final int FLAG_MATCH_CACHED = 8;
    public static final int FLAG_MATCH_DYNAMIC = 2;
    public static final int FLAG_MATCH_MANIFEST = 1;
    public static final int FLAG_MATCH_PINNED = 4;
    static final String INSTALL_SHORTCUT_PERMISSION = "com.android.launcher.permission.INSTALL_SHORTCUT";
    private static final String SHORTCUT_LISTENER_INTENT_FILTER_ACTION = "androidx.core.content.pm.SHORTCUT_LISTENER";
    private static final String SHORTCUT_LISTENER_META_DATA_KEY = "androidx.core.content.pm.shortcut_listener_impl";
    private static volatile List<ShortcutInfoChangeListener> sShortcutInfoChangeListeners;
    private static volatile ShortcutInfoCompatSaver<?> sShortcutInfoCompatSaver;

    private ShortcutManagerCompat() {
    }

    public static boolean addDynamicShortcuts(Context object, List<ShortcutInfoCompat> list) {
        if (Build.VERSION.SDK_INT <= 29) {
            ShortcutManagerCompat.convertUriIconsToBitmapIcons((Context)object, list);
        }
        if (Build.VERSION.SDK_INT >= 25) {
            ArrayList<ShortcutInfo> arrayList = new ArrayList<ShortcutInfo>();
            Iterator<ShortcutInfoCompat> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toShortcutInfo());
            }
            if (!((ShortcutManager)object.getSystemService(ShortcutManager.class)).addDynamicShortcuts(arrayList)) {
                return false;
            }
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).addShortcuts(list);
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutAdded(list);
        }
        return true;
    }

    static boolean convertUriIconToBitmapIcon(Context object, ShortcutInfoCompat shortcutInfoCompat) {
        if (shortcutInfoCompat.mIcon == null) {
            return false;
        }
        int n = shortcutInfoCompat.mIcon.mType;
        if (n != 6 && n != 4) {
            return true;
        }
        if ((object = shortcutInfoCompat.mIcon.getUriInputStream((Context)object)) == null) {
            return false;
        }
        if ((object = BitmapFactory.decodeStream((InputStream)object)) == null) {
            return false;
        }
        object = n == 6 ? IconCompat.createWithAdaptiveBitmap((Bitmap)object) : IconCompat.createWithBitmap((Bitmap)object);
        shortcutInfoCompat.mIcon = object;
        return true;
    }

    static void convertUriIconsToBitmapIcons(Context context, List<ShortcutInfoCompat> list) {
        for (ShortcutInfoCompat shortcutInfoCompat : new ArrayList<ShortcutInfoCompat>(list)) {
            if (ShortcutManagerCompat.convertUriIconToBitmapIcon(context, shortcutInfoCompat)) continue;
            list.remove(shortcutInfoCompat);
        }
    }

    public static Intent createShortcutResultIntent(Context object, ShortcutInfoCompat shortcutInfoCompat) {
        object = Build.VERSION.SDK_INT >= 26 ? ((ShortcutManager)object.getSystemService(ShortcutManager.class)).createShortcutResultIntent(shortcutInfoCompat.toShortcutInfo()) : null;
        Context context = object;
        if (object == null) {
            context = new Intent();
        }
        return shortcutInfoCompat.addToIntent((Intent)context);
    }

    public static void disableShortcuts(Context object, List<String> list, CharSequence charSequence) {
        if (Build.VERSION.SDK_INT >= 25) {
            ((ShortcutManager)object.getSystemService(ShortcutManager.class)).disableShortcuts(list, charSequence);
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).removeShortcuts(list);
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutRemoved(list);
        }
    }

    public static void enableShortcuts(Context object, List<ShortcutInfoCompat> list) {
        if (Build.VERSION.SDK_INT >= 25) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            Iterator<ShortcutInfoCompat> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().mId);
            }
            ((ShortcutManager)object.getSystemService(ShortcutManager.class)).enableShortcuts(arrayList);
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).addShortcuts(list);
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutAdded(list);
        }
    }

    public static List<ShortcutInfoCompat> getDynamicShortcuts(Context object) {
        if (Build.VERSION.SDK_INT >= 25) {
            Object object2 = ((ShortcutManager)object.getSystemService(ShortcutManager.class)).getDynamicShortcuts();
            ArrayList<ShortcutInfoCompat> arrayList = new ArrayList<ShortcutInfoCompat>(object2.size());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                arrayList.add(new ShortcutInfoCompat.Builder((Context)object, (ShortcutInfo)object2.next()).build());
            }
            return arrayList;
        }
        try {
            object = ShortcutManagerCompat.getShortcutInfoSaverInstance(object).getShortcuts();
            return object;
        }
        catch (Exception exception) {
            return new ArrayList<ShortcutInfoCompat>();
        }
    }

    private static int getIconDimensionInternal(Context context, boolean bl) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        int n = Build.VERSION.SDK_INT >= 19 && activityManager != null && !activityManager.isLowRamDevice() ? 0 : 1;
        n = n != 0 ? 48 : 96;
        n = Math.max(1, n);
        context = context.getResources().getDisplayMetrics();
        float f = bl ? context.xdpi : context.ydpi;
        return (int)((float)n * (f /= 160.0f));
    }

    public static int getIconMaxHeight(Context context) {
        Preconditions.checkNotNull(context);
        if (Build.VERSION.SDK_INT >= 25) {
            return ((ShortcutManager)context.getSystemService(ShortcutManager.class)).getIconMaxHeight();
        }
        return ShortcutManagerCompat.getIconDimensionInternal(context, false);
    }

    public static int getIconMaxWidth(Context context) {
        Preconditions.checkNotNull(context);
        if (Build.VERSION.SDK_INT >= 25) {
            return ((ShortcutManager)context.getSystemService(ShortcutManager.class)).getIconMaxWidth();
        }
        return ShortcutManagerCompat.getIconDimensionInternal(context, true);
    }

    public static int getMaxShortcutCountPerActivity(Context context) {
        Preconditions.checkNotNull(context);
        if (Build.VERSION.SDK_INT >= 25) {
            return ((ShortcutManager)context.getSystemService(ShortcutManager.class)).getMaxShortcutCountPerActivity();
        }
        return 5;
    }

    static List<ShortcutInfoChangeListener> getShortcutInfoChangeListeners() {
        return sShortcutInfoChangeListeners;
    }

    private static String getShortcutInfoCompatWithLowestRank(List<ShortcutInfoCompat> object) {
        Iterator<ShortcutInfoCompat> iterator = object.iterator();
        int n = -1;
        object = null;
        while (iterator.hasNext()) {
            ShortcutInfoCompat shortcutInfoCompat = iterator.next();
            if (shortcutInfoCompat.getRank() <= n) continue;
            object = shortcutInfoCompat.getId();
            n = shortcutInfoCompat.getRank();
        }
        return object;
    }

    private static List<ShortcutInfoChangeListener> getShortcutInfoListeners(Context context) {
        if (sShortcutInfoChangeListeners == null) {
            ArrayList<ShortcutInfoChangeListener> arrayList = new ArrayList<ShortcutInfoChangeListener>();
            if (Build.VERSION.SDK_INT >= 21) {
                Object object = context.getPackageManager();
                Object object2 = new Intent(SHORTCUT_LISTENER_INTENT_FILTER_ACTION);
                object2.setPackage(context.getPackageName());
                object = object.queryIntentActivities(object2, 128).iterator();
                while (object.hasNext()) {
                    object2 = ((ResolveInfo)object.next()).activityInfo;
                    if (object2 == null || (object2 = object2.metaData) == null || (object2 = object2.getString(SHORTCUT_LISTENER_META_DATA_KEY)) == null) continue;
                    try {
                        arrayList.add((ShortcutInfoChangeListener)Class.forName((String)object2, false, ShortcutManagerCompat.class.getClassLoader()).getMethod("getInstance", Context.class).invoke(null, context));
                    }
                    catch (Exception exception) {}
                }
            }
            if (sShortcutInfoChangeListeners == null) {
                sShortcutInfoChangeListeners = arrayList;
            }
        }
        return sShortcutInfoChangeListeners;
    }

    private static ShortcutInfoCompatSaver<?> getShortcutInfoSaverInstance(Context context) {
        if (sShortcutInfoCompatSaver == null) {
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    sShortcutInfoCompatSaver = (ShortcutInfoCompatSaver)Class.forName("androidx.sharetarget.ShortcutInfoCompatSaverImpl", false, ShortcutManagerCompat.class.getClassLoader()).getMethod("getInstance", Context.class).invoke(null, context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sShortcutInfoCompatSaver == null) {
                sShortcutInfoCompatSaver = new ShortcutInfoCompatSaver.NoopImpl();
            }
        }
        return sShortcutInfoCompatSaver;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ShortcutInfoCompat> getShortcuts(Context object, int n) {
        void var1_3;
        if (Build.VERSION.SDK_INT >= 30) {
            return ShortcutInfoCompat.fromShortcuts(object, ((ShortcutManager)object.getSystemService(ShortcutManager.class)).getShortcuts((int)var1_3));
        }
        if (Build.VERSION.SDK_INT >= 25) {
            ShortcutManager shortcutManager = (ShortcutManager)object.getSystemService(ShortcutManager.class);
            ArrayList<ShortcutInfo> arrayList = new ArrayList<ShortcutInfo>();
            if ((var1_3 & 1) != 0) {
                arrayList.addAll(shortcutManager.getManifestShortcuts());
            }
            if ((var1_3 & 2) != 0) {
                arrayList.addAll(shortcutManager.getDynamicShortcuts());
            }
            if ((var1_3 & 4) == 0) return ShortcutInfoCompat.fromShortcuts(object, arrayList);
            arrayList.addAll(shortcutManager.getPinnedShortcuts());
            return ShortcutInfoCompat.fromShortcuts(object, arrayList);
        }
        if ((var1_3 & 2) == 0) return Collections.emptyList();
        try {
            return ShortcutManagerCompat.getShortcutInfoSaverInstance(object).getShortcuts();
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    public static boolean isRateLimitingActive(Context context) {
        Preconditions.checkNotNull(context);
        if (Build.VERSION.SDK_INT >= 25) {
            return ((ShortcutManager)context.getSystemService(ShortcutManager.class)).isRateLimitingActive();
        }
        boolean bl = ShortcutManagerCompat.getShortcuts(context, 3).size() == ShortcutManagerCompat.getMaxShortcutCountPerActivity(context);
        return bl;
    }

    public static boolean isRequestPinShortcutSupported(Context object) {
        if (Build.VERSION.SDK_INT >= 26) {
            return ((ShortcutManager)object.getSystemService(ShortcutManager.class)).isRequestPinShortcutSupported();
        }
        if (ContextCompat.checkSelfPermission(object, INSTALL_SHORTCUT_PERMISSION) != 0) {
            return false;
        }
        Iterator iterator = object.getPackageManager().queryBroadcastReceivers(new Intent(ACTION_INSTALL_SHORTCUT), 0).iterator();
        while (iterator.hasNext()) {
            object = ((ResolveInfo)iterator.next()).activityInfo.permission;
            if (!TextUtils.isEmpty((CharSequence)object) && !INSTALL_SHORTCUT_PERMISSION.equals(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean pushDynamicShortcut(Context context, ShortcutInfoCompat shortcutInfoCompat) {
        Object object;
        Object object2;
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(shortcutInfoCompat);
        int n = ShortcutManagerCompat.getMaxShortcutCountPerActivity(context);
        if (n == 0) {
            return false;
        }
        if (Build.VERSION.SDK_INT <= 29) {
            ShortcutManagerCompat.convertUriIconToBitmapIcon(context, shortcutInfoCompat);
        }
        if (Build.VERSION.SDK_INT >= 30) {
            ((ShortcutManager)context.getSystemService(ShortcutManager.class)).pushDynamicShortcut(shortcutInfoCompat.toShortcutInfo());
        } else if (Build.VERSION.SDK_INT >= 25) {
            object2 = (ShortcutManager)context.getSystemService(ShortcutManager.class);
            if (object2.isRateLimitingActive()) {
                return false;
            }
            object = object2.getDynamicShortcuts();
            if (object.size() >= n) {
                object2.removeDynamicShortcuts(Arrays.asList(Api25Impl.getShortcutInfoWithLowestRank((List<ShortcutInfo>)object)));
            }
            object2.addDynamicShortcuts(Arrays.asList(shortcutInfoCompat.toShortcutInfo()));
        }
        object = ShortcutManagerCompat.getShortcutInfoSaverInstance(context);
        try {
            object2 = ((ShortcutInfoCompatSaver)object).getShortcuts();
            if (object2.size() >= n) {
                ((ShortcutInfoCompatSaver)object).removeShortcuts(Arrays.asList(ShortcutManagerCompat.getShortcutInfoCompatWithLowestRank((List<ShortcutInfoCompat>)object2)));
            }
            ((ShortcutInfoCompatSaver)object).addShortcuts(Arrays.asList(shortcutInfoCompat));
            object = ShortcutManagerCompat.getShortcutInfoListeners(context).iterator();
        }
        catch (Throwable throwable) {
            object = ShortcutManagerCompat.getShortcutInfoListeners(context).iterator();
            while (object.hasNext()) {
                ((ShortcutInfoChangeListener)object.next()).onShortcutAdded(Collections.singletonList(shortcutInfoCompat));
            }
            ShortcutManagerCompat.reportShortcutUsed(context, shortcutInfoCompat.getId());
            throw throwable;
        }
        catch (Exception exception) {
            Iterator<ShortcutInfoChangeListener> iterator = ShortcutManagerCompat.getShortcutInfoListeners(context).iterator();
            while (iterator.hasNext()) {
                iterator.next().onShortcutAdded(Collections.singletonList(shortcutInfoCompat));
            }
            ShortcutManagerCompat.reportShortcutUsed(context, shortcutInfoCompat.getId());
            return false;
        }
        while (object.hasNext()) {
            object.next().onShortcutAdded(Collections.singletonList(shortcutInfoCompat));
        }
        ShortcutManagerCompat.reportShortcutUsed(context, shortcutInfoCompat.getId());
        return true;
    }

    public static void removeAllDynamicShortcuts(Context object) {
        if (Build.VERSION.SDK_INT >= 25) {
            ((ShortcutManager)object.getSystemService(ShortcutManager.class)).removeAllDynamicShortcuts();
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).removeAllShortcuts();
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onAllShortcutsRemoved();
        }
    }

    public static void removeDynamicShortcuts(Context object, List<String> list) {
        if (Build.VERSION.SDK_INT >= 25) {
            ((ShortcutManager)object.getSystemService(ShortcutManager.class)).removeDynamicShortcuts(list);
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).removeShortcuts(list);
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutRemoved(list);
        }
    }

    public static void removeLongLivedShortcuts(Context object, List<String> list) {
        if (Build.VERSION.SDK_INT < 30) {
            ShortcutManagerCompat.removeDynamicShortcuts((Context)object, list);
            return;
        }
        ((ShortcutManager)object.getSystemService(ShortcutManager.class)).removeLongLivedShortcuts(list);
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).removeShortcuts(list);
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutRemoved(list);
        }
    }

    public static void reportShortcutUsed(Context object, String string2) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(string2);
        if (Build.VERSION.SDK_INT >= 25) {
            ((ShortcutManager)object.getSystemService(ShortcutManager.class)).reportShortcutUsed(string2);
        }
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutUsageReported(Collections.singletonList(string2));
        }
    }

    public static boolean requestPinShortcut(Context context, ShortcutInfoCompat shortcutInfoCompat, final IntentSender intentSender) {
        if (Build.VERSION.SDK_INT >= 26) {
            return ((ShortcutManager)context.getSystemService(ShortcutManager.class)).requestPinShortcut(shortcutInfoCompat.toShortcutInfo(), intentSender);
        }
        if (!ShortcutManagerCompat.isRequestPinShortcutSupported(context)) {
            return false;
        }
        shortcutInfoCompat = shortcutInfoCompat.addToIntent(new Intent(ACTION_INSTALL_SHORTCUT));
        if (intentSender == null) {
            context.sendBroadcast((Intent)shortcutInfoCompat);
            return true;
        }
        context.sendOrderedBroadcast((Intent)shortcutInfoCompat, null, new BroadcastReceiver(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onReceive(Context context, Intent intent) {
                try {
                    intentSender.sendIntent(context, 0, null, null, null);
                    return;
                }
                catch (IntentSender.SendIntentException sendIntentException) {
                    return;
                }
            }
        }, null, -1, null, null);
        return true;
    }

    public static boolean setDynamicShortcuts(Context object, List<ShortcutInfoCompat> list) {
        Preconditions.checkNotNull(object);
        Preconditions.checkNotNull(list);
        if (Build.VERSION.SDK_INT >= 25) {
            ArrayList<ShortcutInfo> arrayList = new ArrayList<ShortcutInfo>(list.size());
            Iterator<ShortcutInfoCompat> object2 = list.iterator();
            while (object2.hasNext()) {
                arrayList.add(object2.next().toShortcutInfo());
            }
            if (!((ShortcutManager)object.getSystemService(ShortcutManager.class)).setDynamicShortcuts(arrayList)) {
                return false;
            }
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).removeAllShortcuts();
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).addShortcuts(list);
        for (ShortcutInfoChangeListener shortcutInfoChangeListener : ShortcutManagerCompat.getShortcutInfoListeners((Context)object)) {
            shortcutInfoChangeListener.onAllShortcutsRemoved();
            shortcutInfoChangeListener.onShortcutAdded(list);
        }
        return true;
    }

    static void setShortcutInfoChangeListeners(List<ShortcutInfoChangeListener> list) {
        sShortcutInfoChangeListeners = list;
    }

    static void setShortcutInfoCompatSaver(ShortcutInfoCompatSaver<Void> shortcutInfoCompatSaver) {
        sShortcutInfoCompatSaver = shortcutInfoCompatSaver;
    }

    public static boolean updateShortcuts(Context object, List<ShortcutInfoCompat> list) {
        if (Build.VERSION.SDK_INT <= 29) {
            ShortcutManagerCompat.convertUriIconsToBitmapIcons((Context)object, list);
        }
        if (Build.VERSION.SDK_INT >= 25) {
            ArrayList<ShortcutInfo> arrayList = new ArrayList<ShortcutInfo>();
            Iterator<ShortcutInfoCompat> iterator = list.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next().toShortcutInfo());
            }
            if (!((ShortcutManager)object.getSystemService(ShortcutManager.class)).updateShortcuts(arrayList)) {
                return false;
            }
        }
        ShortcutManagerCompat.getShortcutInfoSaverInstance((Context)object).addShortcuts(list);
        object = ShortcutManagerCompat.getShortcutInfoListeners((Context)object).iterator();
        while (object.hasNext()) {
            ((ShortcutInfoChangeListener)object.next()).onShortcutUpdated(list);
        }
        return true;
    }

    private static class Api25Impl {
        private Api25Impl() {
        }

        static String getShortcutInfoWithLowestRank(List<ShortcutInfo> object) {
            Iterator<ShortcutInfo> iterator = object.iterator();
            int n = -1;
            object = null;
            while (iterator.hasNext()) {
                ShortcutInfo shortcutInfo = iterator.next();
                if (shortcutInfo.getRank() <= n) continue;
                object = shortcutInfo.getId();
                n = shortcutInfo.getRank();
            }
            return object;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShortcutMatchFlags {
    }
}

