/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import androidx.core.content.res.CamUtils;
import androidx.core.content.res.ViewingConditions;
import androidx.core.graphics.ColorUtils;

class CamColor {
    private static final float CHROMA_SEARCH_ENDPOINT = 0.4f;
    private static final float DE_MAX = 1.0f;
    private static final float DL_MAX = 0.2f;
    private static final float LIGHTNESS_SEARCH_ENDPOINT = 0.01f;
    private final float mAstar;
    private final float mBstar;
    private final float mChroma;
    private final float mHue;
    private final float mJ;
    private final float mJstar;
    private final float mM;
    private final float mQ;
    private final float mS;

    CamColor(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.mHue = f;
        this.mChroma = f2;
        this.mJ = f3;
        this.mQ = f4;
        this.mM = f5;
        this.mS = f6;
        this.mJstar = f7;
        this.mAstar = f8;
        this.mBstar = f9;
    }

    private static CamColor findCamByJ(float f, float f2, float f3) {
        CamColor camColor;
        float f4 = 1000.0f;
        CamColor camColor2 = null;
        float f5 = 1000.0f;
        float f6 = 100.0f;
        float f7 = 0.0f;
        while (true) {
            camColor = camColor2;
            if (!(Math.abs(f7 - f6) > 0.01f)) break;
            float f8 = (f6 - f7) / 2.0f + f7;
            int n = CamColor.fromJch(f8, f2, f).viewedInSrgb();
            float f9 = CamUtils.lStarFromInt(n);
            float f10 = Math.abs(f3 - f9);
            float f11 = f4;
            float f12 = f5;
            camColor = camColor2;
            if (f10 < 0.2f) {
                CamColor camColor3 = CamColor.fromColor(n);
                float f13 = camColor3.distance(CamColor.fromJch(camColor3.getJ(), camColor3.getChroma(), f));
                f11 = f4;
                f12 = f5;
                camColor = camColor2;
                if (f13 <= 1.0f) {
                    camColor = camColor3;
                    f11 = f10;
                    f12 = f13;
                }
            }
            if (f11 == 0.0f && f12 == 0.0f) break;
            if (f9 < f3) {
                f7 = f8;
                f4 = f11;
                f5 = f12;
                camColor2 = camColor;
                continue;
            }
            f6 = f8;
            f4 = f11;
            f5 = f12;
            camColor2 = camColor;
        }
        return camColor;
    }

    static CamColor fromColor(int n) {
        return CamColor.fromColorInViewingConditions(n, ViewingConditions.DEFAULT);
    }

    static CamColor fromColorInViewingConditions(int n, ViewingConditions viewingConditions) {
        float[] fArray = CamUtils.xyzFromInt(n);
        float[][] fArray2 = CamUtils.XYZ_TO_CAM16RGB;
        float f = fArray[0];
        float f2 = fArray2[0][0];
        float f3 = fArray[1];
        float f4 = fArray2[0][1];
        float f5 = fArray[2];
        float f6 = fArray2[0][2];
        float f7 = fArray[0];
        float f8 = fArray2[1][0];
        float f9 = fArray[1];
        float f10 = fArray2[1][1];
        float f11 = fArray[2];
        float f12 = fArray2[1][2];
        float f13 = fArray[0];
        float f14 = fArray2[2][0];
        float f15 = fArray[1];
        float f16 = fArray2[2][1];
        float f17 = fArray[2];
        float f18 = fArray2[2][2];
        f6 = viewingConditions.getRgbD()[0] * (f * f2 + f3 * f4 + f5 * f6);
        f12 = viewingConditions.getRgbD()[1] * (f7 * f8 + f9 * f10 + f11 * f12);
        f13 = viewingConditions.getRgbD()[2] * (f13 * f14 + f15 * f16 + f17 * f18);
        f15 = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(f6)) / 100.0, 0.42);
        f16 = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(f12)) / 100.0, 0.42);
        f14 = (float)Math.pow((double)(viewingConditions.getFl() * Math.abs(f13)) / 100.0, 0.42);
        f15 = Math.signum(f6) * 400.0f * f15 / (f15 + 27.13f);
        f18 = Math.signum(f12) * 400.0f * f16 / (f16 + 27.13f);
        f13 = Math.signum(f13) * 400.0f * f14 / (f14 + 27.13f);
        double d = f15;
        double d2 = f18;
        double d3 = f13;
        f14 = (float)(d * 11.0 + d2 * -12.0 + d3) / 11.0f;
        f16 = (float)((double)(f15 + f18) - d3 * 2.0) / 9.0f;
        f9 = (f15 * 20.0f + (f18 *= 20.0f) + 21.0f * f13) / 20.0f;
        f17 = (f15 * 40.0f + f18 + f13) / 20.0f;
        f13 = (float)Math.atan2(f16, f14) * 180.0f / (float)Math.PI;
        if (f13 < 0.0f) {
            f15 = f13 + 360.0f;
        } else {
            f15 = f13;
            if (f13 >= 360.0f) {
                f15 = f13 - 360.0f;
            }
        }
        f18 = (float)Math.PI * f15 / 180.0f;
        f11 = (float)Math.pow(f17 * viewingConditions.getNbb() / viewingConditions.getAw(), viewingConditions.getC() * viewingConditions.getZ()) * 100.0f;
        f12 = 4.0f / viewingConditions.getC();
        f10 = (float)Math.sqrt(f11 / 100.0f);
        f7 = viewingConditions.getAw();
        f17 = viewingConditions.getFlRoot();
        f13 = (double)f15 < 20.14 ? 360.0f + f15 : f15;
        f13 = (float)(Math.cos((double)f13 * Math.PI / 180.0 + 2.0) + 3.8) * 0.25f * 3846.1538f * viewingConditions.getNc() * viewingConditions.getNcb() * (float)Math.sqrt(f14 * f14 + f16 * f16) / (f9 + 0.305f);
        f16 = (float)Math.pow(1.64 - Math.pow(0.29, viewingConditions.getN()), 0.73) * (float)Math.pow(f13, 0.9);
        f13 = f16 * (float)Math.sqrt((double)f11 / 100.0);
        f14 = f13 * viewingConditions.getFlRoot();
        f8 = (float)Math.sqrt(f16 * viewingConditions.getC() / (viewingConditions.getAw() + 4.0f));
        f9 = 1.7f * f11 / (0.007f * f11 + 1.0f);
        f16 = (float)Math.log(0.0228f * f14 + 1.0f) * 43.85965f;
        d3 = f18;
        return new CamColor(f15, f13, f11, f17 * (f12 * f10 * (f7 + 4.0f)), f14, f8 * 50.0f, f9, f16 * (float)Math.cos(d3), f16 * (float)Math.sin(d3));
    }

    private static CamColor fromJch(float f, float f2, float f3) {
        return CamColor.fromJchInFrame(f, f2, f3, ViewingConditions.DEFAULT);
    }

    private static CamColor fromJchInFrame(float f, float f2, float f3, ViewingConditions viewingConditions) {
        float f4 = 4.0f / viewingConditions.getC();
        double d = (double)f / 100.0;
        float f5 = (float)Math.sqrt(d);
        float f6 = viewingConditions.getAw();
        float f7 = viewingConditions.getFlRoot();
        float f8 = f2 * viewingConditions.getFlRoot();
        float f9 = (float)Math.sqrt(f2 / (float)Math.sqrt(d) * viewingConditions.getC() / (viewingConditions.getAw() + 4.0f));
        float f10 = (float)Math.PI * f3 / 180.0f;
        float f11 = 1.7f * f / (0.007f * f + 1.0f);
        float f12 = (float)Math.log((double)f8 * 0.0228 + 1.0) * 43.85965f;
        d = f10;
        return new CamColor(f3, f2, f, f4 * f5 * (f6 + 4.0f) * f7, f8, f9 * 50.0f, f11, f12 * (float)Math.cos(d), f12 * (float)Math.sin(d));
    }

    static int toColor(float f, float f2, float f3) {
        return CamColor.toColor(f, f2, f3, ViewingConditions.DEFAULT);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int toColor(float f, float f2, float f3, ViewingConditions viewingConditions) {
        if ((double)f2 < 1.0) return CamUtils.intFromLStar(f3);
        if ((double)Math.round(f3) <= 0.0) return CamUtils.intFromLStar(f3);
        if ((double)Math.round(f3) >= 100.0) {
            return CamUtils.intFromLStar(f3);
        }
        float f4 = f < 0.0f ? 0.0f : Math.min(360.0f, f);
        f = f2;
        CamColor camColor = null;
        float f5 = 0.0f;
        boolean bl = true;
        while (true) {
            if (!(Math.abs(f5 - f2) >= 0.4f)) {
                if (camColor != null) return camColor.viewed(viewingConditions);
                return CamUtils.intFromLStar(f3);
            }
            CamColor camColor2 = CamColor.findCamByJ(f4, f, f3);
            if (bl) {
                if (camColor2 != null) {
                    return camColor2.viewed(viewingConditions);
                }
                bl = false;
            } else if (camColor2 == null) {
                f2 = f;
            } else {
                camColor = camColor2;
                f5 = f;
            }
            f = (f2 - f5) / 2.0f + f5;
        }
    }

    float distance(CamColor camColor) {
        float f = this.getJStar() - camColor.getJStar();
        float f2 = this.getAStar() - camColor.getAStar();
        float f3 = this.getBStar() - camColor.getBStar();
        return (float)(Math.pow(Math.sqrt(f * f + f2 * f2 + f3 * f3), 0.63) * 1.41);
    }

    float getAStar() {
        return this.mAstar;
    }

    float getBStar() {
        return this.mBstar;
    }

    float getChroma() {
        return this.mChroma;
    }

    float getHue() {
        return this.mHue;
    }

    float getJ() {
        return this.mJ;
    }

    float getJStar() {
        return this.mJstar;
    }

    float getM() {
        return this.mM;
    }

    float getQ() {
        return this.mQ;
    }

    float getS() {
        return this.mS;
    }

    int viewed(ViewingConditions object) {
        float f = (double)this.getChroma() != 0.0 && (double)this.getJ() != 0.0 ? this.getChroma() / (float)Math.sqrt((double)this.getJ() / 100.0) : 0.0f;
        Object object2 = (float)Math.pow((double)f / Math.pow(1.64 - Math.pow(0.29, ((ViewingConditions)object).getN()), 0.73), 1.1111111111111112);
        double d = this.getHue() * (float)Math.PI / 180.0f;
        Object object3 = (float)(Math.cos(2.0 + d) + 3.8);
        Object object4 = ((ViewingConditions)object).getAw();
        f = (float)Math.pow((double)this.getJ() / 100.0, 1.0 / (double)((ViewingConditions)object).getC() / (double)((ViewingConditions)object).getZ());
        Object object5 = ((ViewingConditions)object).getNc();
        float f2 = ((ViewingConditions)object).getNcb();
        f = object4 * f / ((ViewingConditions)object).getNbb();
        object4 = (float)Math.sin(d);
        Object object6 = (float)Math.cos(d);
        object5 = (0.305f + f) * 23.0f * object2 / (object3 * 0.25f * 3846.1538f * object5 * f2 * 23.0f + 11.0f * object2 * object6 + object2 * 108.0f * object4);
        f2 = object6 * object5;
        object2 = f * 460.0f;
        f = (451.0f * f2 + object2 + 288.0f * (object5 *= object4)) / 1403.0f;
        object4 = (object2 - 891.0f * f2 - 261.0f * object5) / 1403.0f;
        object3 = (object2 - f2 * 220.0f - object5 * 6300.0f) / 1403.0f;
        object5 = (float)Math.max(0.0, (double)Math.abs(f) * 27.13 / (400.0 - (double)Math.abs(f)));
        f = Math.signum(f);
        f2 = 100.0f / ((ViewingConditions)object).getFl();
        object5 = (float)Math.pow(object5, 2.380952380952381);
        object6 = (float)Math.max(0.0, (double)Math.abs(object4) * 27.13 / (400.0 - (double)Math.abs(object4)));
        object4 = Math.signum(object4);
        object2 = 100.0f / ((ViewingConditions)object).getFl();
        object6 = (float)Math.pow(object6, 2.380952380952381);
        Object object7 = (float)Math.max(0.0, (double)Math.abs(object3) * 27.13 / (400.0 - (double)Math.abs(object3)));
        Object object8 = Math.signum(object3);
        object3 = 100.0f / ((ViewingConditions)object).getFl();
        object7 = (float)Math.pow(object7, 2.380952380952381);
        f = f * f2 * object5 / ((ViewingConditions)object).getRgbD()[0];
        f2 = object4 * object2 * object6 / ((ViewingConditions)object).getRgbD()[1];
        float f3 = object8 * object3 * object7 / ((ViewingConditions)object).getRgbD()[2];
        object = CamUtils.CAM16RGB_TO_XYZ;
        object8 = object[0][0];
        Object object9 = object[0][1];
        object4 = object[0][2];
        object3 = object[1][0];
        object2 = object[1][1];
        object7 = object[1][2];
        object6 = object[2][0];
        object5 = object[2][1];
        Object object10 = object[2][2];
        return ColorUtils.XYZToColor(object8 * f + object9 * f2 + object4 * f3, object3 * f + object2 * f2 + object7 * f3, f * object6 + f2 * object5 + f3 * object10);
    }

    int viewedInSrgb() {
        return this.viewed(ViewingConditions.DEFAULT);
    }
}

