/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import android.util.Log;
import android.util.StateSet;
import android.util.TypedValue;
import android.util.Xml;
import androidx.core.R;
import androidx.core.content.res.CamColor;
import androidx.core.content.res.GrowingArrayUtils;
import androidx.core.math.MathUtils;
import androidx.core.os.BuildCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ColorStateListInflaterCompat {
    private static final ThreadLocal<TypedValue> sTempTypedValue = new ThreadLocal();

    private ColorStateListInflaterCompat() {
    }

    public static ColorStateList createFromXml(Resources resources, XmlPullParser xmlPullParser, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n;
        AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)xmlPullParser);
        while ((n = xmlPullParser.next()) != 2 && n != 1) {
        }
        if (n == 2) {
            return ColorStateListInflaterCompat.createFromXmlInner(resources, xmlPullParser, attributeSet, theme);
        }
        throw new XmlPullParserException("No start tag found");
    }

    public static ColorStateList createFromXmlInner(Resources object, XmlPullParser xmlPullParser, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        String string2 = xmlPullParser.getName();
        if (string2.equals("selector")) {
            return ColorStateListInflaterCompat.inflate((Resources)object, xmlPullParser, attributeSet, theme);
        }
        object = new StringBuilder();
        ((StringBuilder)object).append(xmlPullParser.getPositionDescription());
        ((StringBuilder)object).append(": invalid color state list tag ");
        ((StringBuilder)object).append(string2);
        throw new XmlPullParserException(((StringBuilder)object).toString());
    }

    private static TypedValue getTypedValue() {
        TypedValue typedValue;
        ThreadLocal<TypedValue> threadLocal = sTempTypedValue;
        TypedValue typedValue2 = typedValue = threadLocal.get();
        if (typedValue == null) {
            typedValue2 = new TypedValue();
            threadLocal.set(typedValue2);
        }
        return typedValue2;
    }

    public static ColorStateList inflate(Resources resources, int n, Resources.Theme theme) {
        try {
            resources = ColorStateListInflaterCompat.createFromXml(resources, (XmlPullParser)resources.getXml(n), theme);
            return resources;
        }
        catch (Exception exception) {
            Log.e((String)"CSLCompat", (String)"Failed to inflate ColorStateList.", (Throwable)exception);
            return null;
        }
    }

    private static ColorStateList inflate(Resources object, XmlPullParser object2, AttributeSet attributeSet, Resources.Theme theme) throws XmlPullParserException, IOException {
        int n = object2.getDepth() + 1;
        int[][] nArrayArray = new int[20][];
        int[] nArray = new int[20];
        int n2 = 0;
        while (true) {
            int n3;
            Resources resources = object;
            int n4 = object2.next();
            if (n4 == 1 || (n3 = object2.getDepth()) < n && n4 == 3) break;
            int[] nArray2 = nArray;
            Object object3 = nArrayArray;
            int n5 = n2;
            if (n4 == 2) {
                nArray2 = nArray;
                object3 = nArrayArray;
                n5 = n2;
                if (n3 <= n) {
                    if (!object2.getName().equals("item")) {
                        nArray2 = nArray;
                        object3 = nArrayArray;
                        n5 = n2;
                    } else {
                        object3 = ColorStateListInflaterCompat.obtainAttributes(resources, theme, attributeSet, R.styleable.ColorStateListItem);
                        n5 = object3.getResourceId(R.styleable.ColorStateListItem_android_color, -1);
                        if (n5 != -1 && !ColorStateListInflaterCompat.isColorInt(resources, n5)) {
                            try {
                                n5 = ColorStateListInflaterCompat.createFromXml(resources, (XmlPullParser)resources.getXml(n5), theme).getDefaultColor();
                            }
                            catch (Exception exception) {
                                n5 = object3.getColor(R.styleable.ColorStateListItem_android_color, -65281);
                            }
                        } else {
                            n5 = object3.getColor(R.styleable.ColorStateListItem_android_color, -65281);
                        }
                        float f = 1.0f;
                        if (object3.hasValue(R.styleable.ColorStateListItem_android_alpha)) {
                            f = object3.getFloat(R.styleable.ColorStateListItem_android_alpha, 1.0f);
                        } else if (object3.hasValue(R.styleable.ColorStateListItem_alpha)) {
                            f = object3.getFloat(R.styleable.ColorStateListItem_alpha, 1.0f);
                        }
                        float f2 = BuildCompat.isAtLeastS() && object3.hasValue(R.styleable.ColorStateListItem_android_lStar) ? object3.getFloat(R.styleable.ColorStateListItem_android_lStar, -1.0f) : object3.getFloat(R.styleable.ColorStateListItem_lStar, -1.0f);
                        object3.recycle();
                        int n6 = attributeSet.getAttributeCount();
                        object3 = new int[n6];
                        n4 = 0;
                        for (n3 = 0; n3 < n6; ++n3) {
                            int n7 = attributeSet.getAttributeNameResource(n3);
                            int n8 = n4;
                            if (n7 != 16843173) {
                                n8 = n4;
                                if (n7 != 16843551) {
                                    n8 = n4;
                                    if (n7 != R.attr.alpha) {
                                        n8 = n4;
                                        if (n7 != R.attr.lStar) {
                                            n8 = attributeSet.getAttributeBooleanValue(n3, false) ? n7 : -n7;
                                            object3[n4] = (int[])n8;
                                            n8 = n4 + 1;
                                        }
                                    }
                                }
                            }
                            n4 = n8;
                        }
                        object3 = StateSet.trimStateSet((int[])object3, (int)n4);
                        nArray2 = GrowingArrayUtils.append(nArray, n2, ColorStateListInflaterCompat.modulateColorAlpha(n5, f, f2));
                        object3 = (int[][])GrowingArrayUtils.append(nArrayArray, n2, object3);
                        n5 = n2 + 1;
                    }
                }
            }
            nArray = nArray2;
            nArrayArray = object3;
            n2 = n5;
        }
        object2 = new int[n2];
        object = new int[n2][];
        System.arraycopy(nArray, 0, object2, 0, n2);
        System.arraycopy(nArrayArray, 0, object, 0, n2);
        return new ColorStateList((int[][])object, (int[])object2);
    }

    private static boolean isColorInt(Resources resources, int n) {
        TypedValue typedValue = ColorStateListInflaterCompat.getTypedValue();
        boolean bl = true;
        resources.getValue(n, typedValue, true);
        if (typedValue.type < 28 || typedValue.type > 31) {
            bl = false;
        }
        return bl;
    }

    private static int modulateColorAlpha(int n, float f, float f2) {
        boolean bl = f2 >= 0.0f && f2 <= 100.0f;
        if (f == 1.0f && !bl) {
            return n;
        }
        int n2 = MathUtils.clamp((int)((float)Color.alpha((int)n) * f + 0.5f), 0, 255);
        int n3 = n;
        if (bl) {
            CamColor camColor = CamColor.fromColor(n);
            n3 = CamColor.toColor(camColor.getHue(), camColor.getChroma(), f2);
        }
        return n3 & 0xFFFFFF | n2 << 24;
    }

    private static TypedArray obtainAttributes(Resources resources, Resources.Theme theme, AttributeSet attributeSet, int[] nArray) {
        resources = theme == null ? resources.obtainAttributes(attributeSet, nArray) : theme.obtainStyledAttributes(attributeSet, nArray, 0, 0);
        return resources;
    }
}

