/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.util.SparseArray;
import android.util.TypedValue;
import androidx.core.content.res.ColorStateListInflaterCompat;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ResourcesCompat {
    public static final int ID_NULL = 0;
    private static final String TAG = "ResourcesCompat";
    private static final Object sColorStateCacheLock;
    private static final WeakHashMap<ColorStateListCacheKey, SparseArray<ColorStateListCacheEntry>> sColorStateCaches;
    private static final ThreadLocal<TypedValue> sTempTypedValue;

    static {
        sTempTypedValue = new ThreadLocal();
        sColorStateCaches = new WeakHashMap(0);
        sColorStateCacheLock = new Object();
    }

    private ResourcesCompat() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addColorStateListToCache(ColorStateListCacheKey colorStateListCacheKey, int n, ColorStateList colorStateList) {
        Object object = sColorStateCacheLock;
        synchronized (object) {
            Object object2;
            WeakHashMap<ColorStateListCacheKey, SparseArray<ColorStateListCacheEntry>> weakHashMap = sColorStateCaches;
            SparseArray sparseArray = object2 = weakHashMap.get(colorStateListCacheKey);
            if (object2 == null) {
                sparseArray = new SparseArray();
                weakHashMap.put(colorStateListCacheKey, (SparseArray<ColorStateListCacheEntry>)sparseArray);
            }
            object2 = new ColorStateListCacheEntry(colorStateList, colorStateListCacheKey.mResources.getConfiguration());
            sparseArray.append(n, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ColorStateList getCachedColorStateList(ColorStateListCacheKey colorStateListCacheKey, int n) {
        Object object = sColorStateCacheLock;
        synchronized (object) {
            SparseArray<ColorStateListCacheEntry> sparseArray = sColorStateCaches.get(colorStateListCacheKey);
            if (sparseArray == null) return null;
            if (sparseArray.size() <= 0) return null;
            ColorStateListCacheEntry colorStateListCacheEntry = (ColorStateListCacheEntry)sparseArray.get(n);
            if (colorStateListCacheEntry == null) return null;
            if (colorStateListCacheEntry.mConfiguration.equals(colorStateListCacheKey.mResources.getConfiguration())) {
                return colorStateListCacheEntry.mValue;
            }
            sparseArray.remove(n);
            return null;
        }
    }

    public static Typeface getCachedFont(Context context, int n) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, n, new TypedValue(), 0, null, null, false, true);
    }

    public static int getColor(Resources resources, int n, Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 23) {
            return resources.getColor(n, theme);
        }
        return resources.getColor(n);
    }

    public static ColorStateList getColorStateList(Resources resources, int n, Resources.Theme theme) throws Resources.NotFoundException {
        ColorStateListCacheKey colorStateListCacheKey = new ColorStateListCacheKey(resources, theme);
        ColorStateList colorStateList = ResourcesCompat.getCachedColorStateList(colorStateListCacheKey, n);
        if (colorStateList != null) {
            return colorStateList;
        }
        colorStateList = ResourcesCompat.inflateColorStateList(resources, n, theme);
        if (colorStateList != null) {
            ResourcesCompat.addColorStateListToCache(colorStateListCacheKey, n, colorStateList);
            return colorStateList;
        }
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.getColorStateList(resources, n, theme);
        }
        return resources.getColorStateList(n);
    }

    public static Drawable getDrawable(Resources resources, int n, Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return resources.getDrawable(n, theme);
        }
        return resources.getDrawable(n);
    }

    public static Drawable getDrawableForDensity(Resources resources, int n, int n2, Resources.Theme theme) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return resources.getDrawableForDensity(n, n2, theme);
        }
        if (Build.VERSION.SDK_INT >= 15) {
            return resources.getDrawableForDensity(n, n2);
        }
        return resources.getDrawable(n);
    }

    public static float getFloat(Resources object, int n) {
        if (Build.VERSION.SDK_INT >= 29) {
            return ImplApi29.getFloat((Resources)object, n);
        }
        TypedValue typedValue = ResourcesCompat.getTypedValue();
        object.getValue(n, typedValue, true);
        if (typedValue.type == 4) {
            return typedValue.getFloat();
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("Resource ID #0x");
        ((StringBuilder)object).append(Integer.toHexString(n));
        ((StringBuilder)object).append(" type #0x");
        ((StringBuilder)object).append(Integer.toHexString(typedValue.type));
        ((StringBuilder)object).append(" is not valid");
        throw new Resources.NotFoundException(((StringBuilder)object).toString());
    }

    public static Typeface getFont(Context context, int n) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, n, new TypedValue(), 0, null, null, false, false);
    }

    public static Typeface getFont(Context context, int n, TypedValue typedValue, int n2, FontCallback fontCallback) throws Resources.NotFoundException {
        if (context.isRestricted()) {
            return null;
        }
        return ResourcesCompat.loadFont(context, n, typedValue, n2, fontCallback, null, true, false);
    }

    public static void getFont(Context context, int n, FontCallback fontCallback, Handler handler) throws Resources.NotFoundException {
        Preconditions.checkNotNull(fontCallback);
        if (context.isRestricted()) {
            fontCallback.callbackFailAsync(-4, handler);
            return;
        }
        ResourcesCompat.loadFont(context, n, new TypedValue(), 0, fontCallback, handler, false, false);
    }

    private static TypedValue getTypedValue() {
        TypedValue typedValue;
        ThreadLocal<TypedValue> threadLocal = sTempTypedValue;
        TypedValue typedValue2 = typedValue = threadLocal.get();
        if (typedValue == null) {
            typedValue2 = new TypedValue();
            threadLocal.set(typedValue2);
        }
        return typedValue2;
    }

    private static ColorStateList inflateColorStateList(Resources resources, int n, Resources.Theme theme) {
        if (ResourcesCompat.isColorInt(resources, n)) {
            return null;
        }
        XmlResourceParser xmlResourceParser = resources.getXml(n);
        try {
            resources = ColorStateListInflaterCompat.createFromXml(resources, (XmlPullParser)xmlResourceParser, theme);
            return resources;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Failed to inflate ColorStateList, leaving it to the framework", (Throwable)exception);
            return null;
        }
    }

    private static boolean isColorInt(Resources resources, int n) {
        TypedValue typedValue = ResourcesCompat.getTypedValue();
        boolean bl = true;
        resources.getValue(n, typedValue, true);
        if (typedValue.type < 28 || typedValue.type > 31) {
            bl = false;
        }
        return bl;
    }

    private static Typeface loadFont(Context object, int n, TypedValue typedValue, int n2, FontCallback fontCallback, Handler handler, boolean bl, boolean bl2) {
        Resources resources = object.getResources();
        resources.getValue(n, typedValue, true);
        object = ResourcesCompat.loadFont((Context)object, resources, typedValue, n, n2, fontCallback, handler, bl, bl2);
        if (object == null && fontCallback == null && !bl2) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Font resource ID #0x");
            ((StringBuilder)object).append(Integer.toHexString(n));
            ((StringBuilder)object).append(" could not be retrieved.");
            throw new Resources.NotFoundException(((StringBuilder)object).toString());
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Typeface loadFont(Context object, Resources object2, TypedValue object3, int n, int n2, FontCallback fontCallback, Handler handler, boolean bl, boolean bl2) {
        if (((TypedValue)object3).string == null) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Resource \"");
            ((StringBuilder)object).append(object2.getResourceName(n));
            ((StringBuilder)object).append("\" (");
            ((StringBuilder)object).append(Integer.toHexString(n));
            ((StringBuilder)object).append(") is not a Font: ");
            ((StringBuilder)object).append(object3);
            throw new Resources.NotFoundException(((StringBuilder)object).toString());
        }
        object3 = ((TypedValue)object3).string.toString();
        if (!((String)object3).startsWith("res/")) {
            if (fontCallback == null) return null;
            fontCallback.callbackFailAsync(-3, handler);
            return null;
        }
        Typeface typeface = TypefaceCompat.findFromCache((Resources)object2, n, n2);
        if (typeface != null) {
            if (fontCallback == null) return typeface;
            fontCallback.callbackSuccessAsync(typeface, handler);
            return typeface;
        }
        if (bl2) {
            return null;
        }
        try {
            if (((String)object3).toLowerCase().endsWith(".xml")) {
                FontResourcesParserCompat.FamilyResourceEntry familyResourceEntry = FontResourcesParserCompat.parse((XmlPullParser)object2.getXml(n), (Resources)object2);
                if (familyResourceEntry != null) return TypefaceCompat.createFromResourcesFamilyXml((Context)object, familyResourceEntry, (Resources)object2, n, n2, fontCallback, handler, bl);
                Log.e((String)TAG, (String)"Failed to find font-family tag");
                if (fontCallback == null) return null;
                fontCallback.callbackFailAsync(-3, handler);
                return null;
            }
            object = TypefaceCompat.createFromResourcesFontFile((Context)object, (Resources)object2, n, (String)object3, n2);
            if (fontCallback == null) return object;
            if (object != null) {
                fontCallback.callbackSuccessAsync((Typeface)object, handler);
                return object;
            }
            fontCallback.callbackFailAsync(-3, handler);
            return object;
        }
        catch (IOException iOException) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Failed to read xml resource ");
            ((StringBuilder)object2).append((String)object3);
            Log.e((String)TAG, (String)((StringBuilder)object2).toString(), (Throwable)iOException);
        }
        catch (XmlPullParserException xmlPullParserException) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Failed to parse xml resource ");
            ((StringBuilder)object2).append((String)object3);
            Log.e((String)TAG, (String)((StringBuilder)object2).toString(), (Throwable)xmlPullParserException);
        }
        if (fontCallback == null) return null;
        fontCallback.callbackFailAsync(-3, handler);
        return null;
    }

    static class Api23Impl {
        private Api23Impl() {
        }

        static ColorStateList getColorStateList(Resources resources, int n, Resources.Theme theme) {
            return resources.getColorStateList(n, theme);
        }
    }

    private static class ColorStateListCacheEntry {
        final Configuration mConfiguration;
        final ColorStateList mValue;

        ColorStateListCacheEntry(ColorStateList colorStateList, Configuration configuration) {
            this.mValue = colorStateList;
            this.mConfiguration = configuration;
        }
    }

    private static final class ColorStateListCacheKey {
        final Resources mResources;
        final Resources.Theme mTheme;

        ColorStateListCacheKey(Resources resources, Resources.Theme theme) {
            this.mResources = resources;
            this.mTheme = theme;
        }

        public boolean equals(Object object) {
            boolean bl = true;
            if (this == object) {
                return true;
            }
            if (object != null && this.getClass() == object.getClass()) {
                object = (ColorStateListCacheKey)object;
                if (!this.mResources.equals(((ColorStateListCacheKey)object).mResources) || !ObjectsCompat.equals(this.mTheme, ((ColorStateListCacheKey)object).mTheme)) {
                    bl = false;
                }
                return bl;
            }
            return false;
        }

        public int hashCode() {
            return ObjectsCompat.hash(this.mResources, this.mTheme);
        }
    }

    public static abstract class FontCallback {
        public static Handler getHandler(Handler handler) {
            Handler handler2 = handler;
            if (handler == null) {
                handler2 = new Handler(Looper.getMainLooper());
            }
            return handler2;
        }

        public final void callbackFailAsync(final int n, Handler handler) {
            FontCallback.getHandler(handler).post(new Runnable(){

                @Override
                public void run() {
                    FontCallback.this.onFontRetrievalFailed(n);
                }
            });
        }

        public final void callbackSuccessAsync(final Typeface typeface, Handler handler) {
            FontCallback.getHandler(handler).post(new Runnable(){

                @Override
                public void run() {
                    FontCallback.this.onFontRetrieved(typeface);
                }
            });
        }

        public abstract void onFontRetrievalFailed(int var1);

        public abstract void onFontRetrieved(Typeface var1);
    }

    static class ImplApi29 {
        private ImplApi29() {
        }

        static float getFloat(Resources resources, int n) {
            return resources.getFloat(n);
        }
    }

    public static final class ThemeCompat {
        private ThemeCompat() {
        }

        public static void rebase(Resources.Theme theme) {
            if (Build.VERSION.SDK_INT >= 29) {
                ImplApi29.rebase(theme);
            } else if (Build.VERSION.SDK_INT >= 23) {
                ImplApi23.rebase(theme);
            }
        }

        static class ImplApi23 {
            private static Method sRebaseMethod;
            private static boolean sRebaseMethodFetched;
            private static final Object sRebaseMethodLock;

            static {
                sRebaseMethodLock = new Object();
            }

            private ImplApi23() {
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static void rebase(Resources.Theme theme) {
                Object object = sRebaseMethodLock;
                synchronized (object) {
                    block9: {
                        Method method;
                        boolean bl = sRebaseMethodFetched;
                        if (!bl) {
                            try {
                                sRebaseMethod = method = Resources.Theme.class.getDeclaredMethod("rebase", new Class[0]);
                                method.setAccessible(true);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                Log.i((String)ResourcesCompat.TAG, (String)"Failed to retrieve rebase() method", (Throwable)noSuchMethodException);
                            }
                            sRebaseMethodFetched = true;
                        }
                        if ((method = sRebaseMethod) != null) {
                            void var0_3;
                            try {
                                method.invoke((Object)theme, new Object[0]);
                                break block9;
                            }
                            catch (InvocationTargetException invocationTargetException) {
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                // empty catch block
                            }
                            Log.i((String)ResourcesCompat.TAG, (String)"Failed to invoke rebase() method via reflection", (Throwable)var0_3);
                            sRebaseMethod = null;
                        }
                    }
                    return;
                }
            }
        }

        static class ImplApi29 {
            private ImplApi29() {
            }

            static void rebase(Resources.Theme theme) {
                theme.rebase();
            }
        }
    }
}

