/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import androidx.collection.LruCache;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.TypefaceCompatApi21Impl;
import androidx.core.graphics.TypefaceCompatApi24Impl;
import androidx.core.graphics.TypefaceCompatApi26Impl;
import androidx.core.graphics.TypefaceCompatApi28Impl;
import androidx.core.graphics.TypefaceCompatApi29Impl;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import androidx.core.provider.FontsContractCompat;

public class TypefaceCompat {
    private static final LruCache<String, Typeface> sTypefaceCache;
    private static final TypefaceCompatBaseImpl sTypefaceCompatImpl;

    static {
        sTypefaceCompatImpl = Build.VERSION.SDK_INT >= 29 ? new TypefaceCompatApi29Impl() : (Build.VERSION.SDK_INT >= 28 ? new TypefaceCompatApi28Impl() : (Build.VERSION.SDK_INT >= 26 ? new TypefaceCompatApi26Impl() : (Build.VERSION.SDK_INT >= 24 && TypefaceCompatApi24Impl.isUsable() ? new TypefaceCompatApi24Impl() : (Build.VERSION.SDK_INT >= 21 ? new TypefaceCompatApi21Impl() : new TypefaceCompatBaseImpl()))));
        sTypefaceCache = new LruCache(16);
    }

    private TypefaceCompat() {
    }

    public static void clearCache() {
        sTypefaceCache.evictAll();
    }

    public static Typeface create(Context context, Typeface typeface, int n) {
        if (context != null) {
            if (Build.VERSION.SDK_INT < 21 && (context = TypefaceCompat.getBestFontFromFamily(context, typeface, n)) != null) {
                return context;
            }
            return Typeface.create((Typeface)typeface, (int)n);
        }
        throw new IllegalArgumentException("Context cannot be null");
    }

    public static Typeface createFromFontInfo(Context context, CancellationSignal cancellationSignal, FontsContractCompat.FontInfo[] fontInfoArray, int n) {
        return sTypefaceCompatImpl.createFromFontInfo(context, cancellationSignal, fontInfoArray, n);
    }

    public static Typeface createFromResourcesFamilyXml(Context object, FontResourcesParserCompat.FamilyResourceEntry familyResourceEntry, Resources resources, int n, int n2, ResourcesCompat.FontCallback object2, Handler handler, boolean bl) {
        if (familyResourceEntry instanceof FontResourcesParserCompat.ProviderResourceEntry) {
            Typeface typeface = TypefaceCompat.getSystemFontFamily(((FontResourcesParserCompat.ProviderResourceEntry)(familyResourceEntry = (FontResourcesParserCompat.ProviderResourceEntry)familyResourceEntry)).getSystemFontFamilyName());
            if (typeface != null) {
                if (object2 != null) {
                    ((ResourcesCompat.FontCallback)object2).callbackSuccessAsync(typeface, handler);
                }
                return typeface;
            }
            boolean bl2 = bl ? ((FontResourcesParserCompat.ProviderResourceEntry)familyResourceEntry).getFetchStrategy() == 0 : object2 == null;
            int n3 = bl ? ((FontResourcesParserCompat.ProviderResourceEntry)familyResourceEntry).getTimeout() : -1;
            handler = ResourcesCompat.FontCallback.getHandler(handler);
            object2 = new ResourcesCallbackAdapter((ResourcesCompat.FontCallback)object2);
            object = FontsContractCompat.requestFont(object, ((FontResourcesParserCompat.ProviderResourceEntry)familyResourceEntry).getRequest(), n2, bl2, n3, handler, (FontsContractCompat.FontRequestCallback)object2);
        } else {
            familyResourceEntry = sTypefaceCompatImpl.createFromFontFamilyFilesResourceEntry((Context)object, (FontResourcesParserCompat.FontFamilyFilesResourceEntry)familyResourceEntry, resources, n2);
            object = familyResourceEntry;
            if (object2 != null) {
                if (familyResourceEntry != null) {
                    ((ResourcesCompat.FontCallback)object2).callbackSuccessAsync((Typeface)familyResourceEntry, handler);
                    object = familyResourceEntry;
                } else {
                    ((ResourcesCompat.FontCallback)object2).callbackFailAsync(-3, handler);
                    object = familyResourceEntry;
                }
            }
        }
        if (object != null) {
            sTypefaceCache.put(TypefaceCompat.createResourceUid(resources, n, n2), (Typeface)object);
        }
        return object;
    }

    public static Typeface createFromResourcesFontFile(Context context, Resources object, int n, String string2, int n2) {
        if ((context = sTypefaceCompatImpl.createFromResourcesFontFile(context, (Resources)object, n, string2, n2)) != null) {
            object = TypefaceCompat.createResourceUid(object, n, n2);
            sTypefaceCache.put((String)object, (Typeface)context);
        }
        return context;
    }

    private static String createResourceUid(Resources resources, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(resources.getResourcePackageName(n));
        stringBuilder.append("-");
        stringBuilder.append(n);
        stringBuilder.append("-");
        stringBuilder.append(n2);
        return stringBuilder.toString();
    }

    public static Typeface findFromCache(Resources resources, int n, int n2) {
        return sTypefaceCache.get(TypefaceCompat.createResourceUid(resources, n, n2));
    }

    private static Typeface getBestFontFromFamily(Context context, Typeface object, int n) {
        TypefaceCompatBaseImpl typefaceCompatBaseImpl = sTypefaceCompatImpl;
        if ((object = typefaceCompatBaseImpl.getFontFamily((Typeface)object)) == null) {
            return null;
        }
        return typefaceCompatBaseImpl.createFromFontFamilyFilesResourceEntry(context, (FontResourcesParserCompat.FontFamilyFilesResourceEntry)object, context.getResources(), n);
    }

    private static Typeface getSystemFontFamily(String string2) {
        String string3;
        String string4 = string3 = null;
        if (string2 != null) {
            if (string2.isEmpty()) {
                string4 = string3;
            } else {
                string2 = Typeface.create((String)string2, (int)0);
                Typeface typeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
                string4 = string3;
                if (string2 != null) {
                    string4 = string3;
                    if (!string2.equals((Object)typeface)) {
                        string4 = string2;
                    }
                }
            }
        }
        return string4;
    }

    public static class ResourcesCallbackAdapter
    extends FontsContractCompat.FontRequestCallback {
        private ResourcesCompat.FontCallback mFontCallback;

        public ResourcesCallbackAdapter(ResourcesCompat.FontCallback fontCallback) {
            this.mFontCallback = fontCallback;
        }

        @Override
        public void onTypefaceRequestFailed(int n) {
            ResourcesCompat.FontCallback fontCallback = this.mFontCallback;
            if (fontCallback != null) {
                fontCallback.onFontRetrievalFailed(n);
            }
        }

        @Override
        public void onTypefaceRetrieved(Typeface typeface) {
            ResourcesCompat.FontCallback fontCallback = this.mFontCallback;
            if (fontCallback != null) {
                fontCallback.onFontRetrieved(typeface);
            }
        }
    }
}

