/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.location.GnssStatus;
import android.os.Build;
import androidx.core.location.GnssStatusCompat;
import androidx.core.util.Preconditions;

class GnssStatusWrapper
extends GnssStatusCompat {
    private final GnssStatus mWrapped;

    GnssStatusWrapper(GnssStatus gnssStatus) {
        this.mWrapped = Preconditions.checkNotNull(gnssStatus);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof GnssStatusWrapper)) {
            return false;
        }
        object = (GnssStatusWrapper)object;
        return this.mWrapped.equals((Object)((GnssStatusWrapper)object).mWrapped);
    }

    @Override
    public float getAzimuthDegrees(int n) {
        return this.mWrapped.getAzimuthDegrees(n);
    }

    @Override
    public float getBasebandCn0DbHz(int n) {
        if (Build.VERSION.SDK_INT >= 30) {
            return this.mWrapped.getBasebandCn0DbHz(n);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float getCarrierFrequencyHz(int n) {
        if (Build.VERSION.SDK_INT >= 26) {
            return this.mWrapped.getCarrierFrequencyHz(n);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float getCn0DbHz(int n) {
        return this.mWrapped.getCn0DbHz(n);
    }

    @Override
    public int getConstellationType(int n) {
        return this.mWrapped.getConstellationType(n);
    }

    @Override
    public float getElevationDegrees(int n) {
        return this.mWrapped.getElevationDegrees(n);
    }

    @Override
    public int getSatelliteCount() {
        return this.mWrapped.getSatelliteCount();
    }

    @Override
    public int getSvid(int n) {
        return this.mWrapped.getSvid(n);
    }

    @Override
    public boolean hasAlmanacData(int n) {
        return this.mWrapped.hasAlmanacData(n);
    }

    @Override
    public boolean hasBasebandCn0DbHz(int n) {
        if (Build.VERSION.SDK_INT >= 30) {
            return this.mWrapped.hasBasebandCn0DbHz(n);
        }
        return false;
    }

    @Override
    public boolean hasCarrierFrequencyHz(int n) {
        if (Build.VERSION.SDK_INT >= 26) {
            return this.mWrapped.hasCarrierFrequencyHz(n);
        }
        return false;
    }

    @Override
    public boolean hasEphemerisData(int n) {
        return this.mWrapped.hasEphemerisData(n);
    }

    public int hashCode() {
        return this.mWrapped.hashCode();
    }

    @Override
    public boolean usedInFix(int n) {
        return this.mWrapped.usedInFix(n);
    }
}

