/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public final class LocationCompat {
    public static final String EXTRA_BEARING_ACCURACY = "bearingAccuracy";
    public static final String EXTRA_IS_MOCK = "mockLocation";
    public static final String EXTRA_SPEED_ACCURACY = "speedAccuracy";
    public static final String EXTRA_VERTICAL_ACCURACY = "verticalAccuracy";
    private static Method sSetIsFromMockProviderMethod;

    private LocationCompat() {
    }

    public static float getBearingAccuracyDegrees(Location location) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getBearingAccuracyDegrees(location);
        }
        if ((location = location.getExtras()) == null) {
            return 0.0f;
        }
        return location.getFloat(EXTRA_BEARING_ACCURACY, 0.0f);
    }

    public static long getElapsedRealtimeMillis(Location location) {
        if (Build.VERSION.SDK_INT >= 17) {
            return TimeUnit.NANOSECONDS.toMillis(Api17Impl.getElapsedRealtimeNanos(location));
        }
        long l = System.currentTimeMillis() - location.getTime();
        long l2 = SystemClock.elapsedRealtime();
        if (l < 0L) {
            return l2;
        }
        if (l > l2) {
            return 0L;
        }
        return l2 - l;
    }

    public static long getElapsedRealtimeNanos(Location location) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Api17Impl.getElapsedRealtimeNanos(location);
        }
        return TimeUnit.MILLISECONDS.toNanos(LocationCompat.getElapsedRealtimeMillis(location));
    }

    private static Method getSetIsFromMockProviderMethod() throws NoSuchMethodException {
        if (sSetIsFromMockProviderMethod == null) {
            Method method;
            sSetIsFromMockProviderMethod = method = Location.class.getDeclaredMethod("setIsFromMockProvider", Boolean.TYPE);
            method.setAccessible(true);
        }
        return sSetIsFromMockProviderMethod;
    }

    public static float getSpeedAccuracyMetersPerSecond(Location location) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getSpeedAccuracyMetersPerSecond(location);
        }
        if ((location = location.getExtras()) == null) {
            return 0.0f;
        }
        return location.getFloat(EXTRA_SPEED_ACCURACY, 0.0f);
    }

    public static float getVerticalAccuracyMeters(Location location) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getVerticalAccuracyMeters(location);
        }
        if ((location = location.getExtras()) == null) {
            return 0.0f;
        }
        return location.getFloat(EXTRA_VERTICAL_ACCURACY, 0.0f);
    }

    public static boolean hasBearingAccuracy(Location location) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.hasBearingAccuracy(location);
        }
        if ((location = location.getExtras()) == null) {
            return false;
        }
        return location.containsKey(EXTRA_BEARING_ACCURACY);
    }

    public static boolean hasSpeedAccuracy(Location location) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.hasSpeedAccuracy(location);
        }
        if ((location = location.getExtras()) == null) {
            return false;
        }
        return location.containsKey(EXTRA_SPEED_ACCURACY);
    }

    public static boolean hasVerticalAccuracy(Location location) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.hasVerticalAccuracy(location);
        }
        if ((location = location.getExtras()) == null) {
            return false;
        }
        return location.containsKey(EXTRA_VERTICAL_ACCURACY);
    }

    public static boolean isMock(Location location) {
        if (Build.VERSION.SDK_INT >= 18) {
            return Api18Impl.isMock(location);
        }
        if ((location = location.getExtras()) == null) {
            return false;
        }
        return location.getBoolean(EXTRA_IS_MOCK, false);
    }

    public static void setBearingAccuracyDegrees(Location location, float f) {
        if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setBearingAccuracyDegrees(location, f);
        } else {
            Bundle bundle;
            Bundle bundle2 = bundle = location.getExtras();
            if (bundle == null) {
                location.setExtras(new Bundle());
                bundle2 = location.getExtras();
            }
            bundle2.putFloat(EXTRA_BEARING_ACCURACY, f);
        }
    }

    public static void setMock(Location location, boolean bl) {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                LocationCompat.getSetIsFromMockProviderMethod().invoke((Object)location, bl);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessError illegalAccessError = new IllegalAccessError();
                illegalAccessError.initCause(illegalAccessException);
                throw illegalAccessError;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                NoSuchMethodError noSuchMethodError = new NoSuchMethodError();
                noSuchMethodError.initCause(noSuchMethodException);
                throw noSuchMethodError;
            }
        } else {
            Bundle bundle = location.getExtras();
            if (bundle == null) {
                if (bl) {
                    bundle = new Bundle();
                    bundle.putBoolean(EXTRA_IS_MOCK, true);
                    location.setExtras(bundle);
                }
            } else if (bl) {
                bundle.putBoolean(EXTRA_IS_MOCK, true);
            } else {
                bundle.remove(EXTRA_IS_MOCK);
                if (bundle.isEmpty()) {
                    location.setExtras(null);
                }
            }
        }
    }

    public static void setSpeedAccuracyMetersPerSecond(Location location, float f) {
        if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setSpeedAccuracyMetersPerSecond(location, f);
        } else {
            Bundle bundle;
            Bundle bundle2 = bundle = location.getExtras();
            if (bundle == null) {
                location.setExtras(new Bundle());
                bundle2 = location.getExtras();
            }
            bundle2.putFloat(EXTRA_SPEED_ACCURACY, f);
        }
    }

    public static void setVerticalAccuracyMeters(Location location, float f) {
        if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setVerticalAccuracyMeters(location, f);
        } else {
            Bundle bundle;
            Bundle bundle2 = bundle = location.getExtras();
            if (bundle == null) {
                location.setExtras(new Bundle());
                bundle2 = location.getExtras();
            }
            bundle2.putFloat(EXTRA_VERTICAL_ACCURACY, f);
        }
    }

    private static class Api17Impl {
        private Api17Impl() {
        }

        static long getElapsedRealtimeNanos(Location location) {
            return location.getElapsedRealtimeNanos();
        }
    }

    private static class Api18Impl {
        private Api18Impl() {
        }

        static boolean isMock(Location location) {
            return location.isFromMockProvider();
        }
    }

    private static class Api26Impl {
        private Api26Impl() {
        }

        static float getBearingAccuracyDegrees(Location location) {
            return location.getBearingAccuracyDegrees();
        }

        static float getSpeedAccuracyMetersPerSecond(Location location) {
            return location.getSpeedAccuracyMetersPerSecond();
        }

        static float getVerticalAccuracyMeters(Location location) {
            return location.getVerticalAccuracyMeters();
        }

        static boolean hasBearingAccuracy(Location location) {
            return location.hasBearingAccuracy();
        }

        static boolean hasSpeedAccuracy(Location location) {
            return location.hasSpeedAccuracy();
        }

        static boolean hasVerticalAccuracy(Location location) {
            return location.hasVerticalAccuracy();
        }

        static void setBearingAccuracyDegrees(Location location, float f) {
            location.setBearingAccuracyDegrees(f);
        }

        static void setSpeedAccuracyMetersPerSecond(Location location, float f) {
            location.setSpeedAccuracyMetersPerSecond(f);
        }

        static void setVerticalAccuracyMeters(Location location, float f) {
            location.setVerticalAccuracyMeters(f);
        }
    }
}

