/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.content.ContentResolver;
import android.content.Context;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.collection.SimpleArrayMap;
import androidx.core.location.GnssStatusCompat;
import androidx.core.location.LocationCompat;
import androidx.core.location.LocationListenerCompat;
import androidx.core.location.LocationManagerCompat$$ExternalSyntheticLambda0;
import androidx.core.location.LocationManagerCompat$$ExternalSyntheticLambda1;
import androidx.core.location.LocationManagerCompat$Api30Impl$$ExternalSyntheticLambda0;
import androidx.core.location.LocationManagerCompat$CancellableLocationListener$$ExternalSyntheticLambda0;
import androidx.core.location.LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda0;
import androidx.core.location.LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda1;
import androidx.core.location.LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda2;
import androidx.core.location.LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda3;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda0;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda1;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda2;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda3;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda4;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda5;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda6;
import androidx.core.location.LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda7;
import androidx.core.location.LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda0;
import androidx.core.location.LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda1;
import androidx.core.location.LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda2;
import androidx.core.location.LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda3;
import androidx.core.location.LocationRequestCompat;
import androidx.core.os.CancellationSignal;
import androidx.core.os.ExecutorCompat;
import androidx.core.util.Consumer;
import androidx.core.util.ObjectsCompat;
import androidx.core.util.Preconditions;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class LocationManagerCompat {
    private static final long GET_CURRENT_LOCATION_TIMEOUT_MS = 30000L;
    private static final long MAX_CURRENT_LOCATION_AGE_MS = 10000L;
    private static final long PRE_N_LOOPER_TIMEOUT_S = 5L;
    private static Field sContextField;
    static final WeakHashMap<LocationListener, List<WeakReference<LocationListenerTransport>>> sLocationListeners;
    private static Method sRequestLocationUpdatesExecutorMethod;
    private static Method sRequestLocationUpdatesLooperMethod;

    static {
        sLocationListeners = new WeakHashMap();
    }

    private LocationManagerCompat() {
    }

    public static void getCurrentLocation(LocationManager locationManager, String string2, CancellationSignal cancellationSignal, Executor object, Consumer<Location> consumer) {
        Location location;
        if (Build.VERSION.SDK_INT >= 30) {
            Api30Impl.getCurrentLocation(locationManager, string2, cancellationSignal, (Executor)object, consumer);
            return;
        }
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if ((location = locationManager.getLastKnownLocation(string2)) != null && SystemClock.elapsedRealtime() - LocationCompat.getElapsedRealtimeMillis(location) < 10000L) {
            object.execute(new LocationManagerCompat$$ExternalSyntheticLambda0(consumer, location));
            return;
        }
        object = new CancellableLocationListener(locationManager, (Executor)object, consumer);
        locationManager.requestLocationUpdates(string2, 0L, 0.0f, (LocationListener)object, Looper.getMainLooper());
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(new CancellationSignal.OnCancelListener((CancellableLocationListener)object){
                final /* synthetic */ CancellableLocationListener val$listener;
                {
                    this.val$listener = cancellableLocationListener;
                }

                @Override
                public void onCancel() {
                    this.val$listener.cancel();
                }
            });
        }
        ((CancellableLocationListener)object).startTimeout(30000L);
    }

    public static String getGnssHardwareModelName(LocationManager locationManager) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getGnssHardwareModelName(locationManager);
        }
        return null;
    }

    public static int getGnssYearOfHardware(LocationManager locationManager) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getGnssYearOfHardware(locationManager);
        }
        return 0;
    }

    public static boolean hasProvider(LocationManager locationManager, String string2) {
        if (Build.VERSION.SDK_INT >= 31) {
            return Api31Impl.hasProvider(locationManager, string2);
        }
        boolean bl = locationManager.getAllProviders().contains(string2);
        boolean bl2 = true;
        if (bl) {
            return true;
        }
        try {
            locationManager = locationManager.getProvider(string2);
            if (locationManager == null) {
                bl2 = false;
            }
            return bl2;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isLocationEnabled(LocationManager locationManager) {
        boolean bl;
        block15: {
            block14: {
                boolean bl2;
                block12: {
                    if (Build.VERSION.SDK_INT >= 28) {
                        return Api28Impl.isLocationEnabled(locationManager);
                    }
                    int n = Build.VERSION.SDK_INT;
                    bl2 = false;
                    bl = false;
                    if (n <= 19) {
                        Field field;
                        block13: {
                            if (sContextField == null) {
                                sContextField = field = LocationManager.class.getDeclaredField("mContext");
                                field.setAccessible(true);
                            }
                            if ((field = (Context)sContextField.get(locationManager)) == null) break block12;
                            if (Build.VERSION.SDK_INT != 19) break block13;
                            if (Settings.Secure.getInt((ContentResolver)field.getContentResolver(), (String)"location_mode", (int)0) != 0) {
                                bl = true;
                            }
                            return bl;
                        }
                        try {
                            bl = TextUtils.isEmpty((CharSequence)Settings.Secure.getString((ContentResolver)field.getContentResolver(), (String)"location_providers_allowed"));
                            return bl ^ true;
                        }
                        catch (ClassCastException | IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                            // empty catch block
                        }
                    }
                }
                if (locationManager.isProviderEnabled("network")) break block14;
                bl = bl2;
                if (!locationManager.isProviderEnabled("gps")) break block15;
            }
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ void lambda$getCurrentLocation$0(Consumer consumer, Location location) {
        consumer.accept(location);
    }

    static /* synthetic */ Boolean lambda$registerGnssStatusCallback$1(LocationManager locationManager, GpsStatusTransport gpsStatusTransport) throws Exception {
        return locationManager.addGpsStatusListener((GpsStatus.Listener)gpsStatusTransport);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    private static boolean registerGnssStatusCallback(LocationManager var0, Handler var1_14, Executor var2_15, GnssStatusCompat.Callback var3_16) {
        var4_19 = Build.VERSION.SDK_INT;
        var5_20 = 1;
        var6_21 = 1;
        var7_22 = 1;
        if (var4_19 >= 30) {
            var8_23 = GnssLazyLoader.sGnssStatusListeners;
            synchronized (var8_23) {
                var1_16 /* !! */  = var9_26 = (GnssStatusTransport)GnssLazyLoader.sGnssStatusListeners.get(var3_18);
                if (var9_26 == null) {
                    var1_16 /* !! */  = new GnssStatusTransport((GnssStatusCompat.Callback)var3_18);
                }
                if (var0.registerGnssStatusCallback((Executor)var2_17, (GnssStatus.Callback)var1_16 /* !! */ )) {
                    GnssLazyLoader.sGnssStatusListeners.put(var3_18, (Object)var1_16 /* !! */ );
                    return true;
                }
                return false;
                catch (Throwable var0_1) {}
                {
                    throw var0_1;
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 24) {
            var10_29 = var1_16 /* !! */  != null;
            Preconditions.checkArgument(var10_29);
            var8_24 = GnssLazyLoader.sGnssStatusListeners;
            synchronized (var8_24) {
                var9_27 = (PreRGnssStatusTransport)GnssLazyLoader.sGnssStatusListeners.get(var3_18);
                if (var9_27 == null) {
                    var9_27 = new PreRGnssStatusTransport((GnssStatusCompat.Callback)var3_18);
                } else {
                    var9_27.unregister();
                }
                var9_27.register((Executor)var2_17);
                if (var0.registerGnssStatusCallback((GnssStatus.Callback)var9_27, (Handler)var1_16 /* !! */ )) {
                    GnssLazyLoader.sGnssStatusListeners.put(var3_18, (Object)var9_27);
                    return true;
                }
                return false;
                catch (Throwable var0_2) {}
                {
                    throw var0_2;
                }
            }
        }
        var10_30 = var1_16 /* !! */  != null;
        Preconditions.checkArgument(var10_30);
        var8_25 = GnssLazyLoader.sGnssStatusListeners;
        synchronized (var8_25) {
            block41: {
                block39: {
                    var9_28 = (GpsStatusTransport)GnssLazyLoader.sGnssStatusListeners.get(var3_18);
                    if (var9_28 == null) {
                        var9_28 = new GpsStatusTransport((LocationManager)var0, (GnssStatusCompat.Callback)var3_18);
                    } else {
                        var9_28.unregister();
                    }
                    var9_28.register((Executor)var2_17);
                    var11_31 = new LocationManagerCompat$$ExternalSyntheticLambda1((LocationManager)var0, var9_28);
                    var2_17 = new FutureTask(var11_31);
                    if (Looper.myLooper() == var1_16 /* !! */ .getLooper()) {
                        var2_17.run();
                        break block39;
                    }
                    var10_30 = var1_16 /* !! */ .post((Runnable)var2_17);
                    if (!var10_30) ** GOTO lbl138
                }
                try {
                    var12_32 = TimeUnit.SECONDS.toNanos(5L);
                    var14_33 = System.nanoTime();
                    var4_19 = 0;
                    var16_34 = var12_32;
                }
                catch (Throwable var0_9) {
                    var4_19 = 0;
                    break block41;
                }
                catch (TimeoutException var0_10) {
                    var7_22 = 0;
                }
                while (true) {
                    if (!((Boolean)var2_17.get(var16_34, TimeUnit.NANOSECONDS)).booleanValue()) ** GOTO lbl71
                    GnssLazyLoader.sGnssStatusListeners.put(var3_18, var9_28);
                    if (var4_19 == 0) ** GOTO lbl70
                    Thread.currentThread().interrupt();
lbl70:
                    // 2 sources

                    return true;
lbl71:
                    // 1 sources

                    if (var4_19 != 0) {
                        Thread.currentThread().interrupt();
                    }
                    return false;
                    catch (Throwable var0_3) {
                    }
                    catch (TimeoutException var0_4) {
                        var7_22 = var4_19;
                        break;
                    }
                    catch (ExecutionException var0_5) {
                        var7_22 = var4_19;
                        ** GOTO lbl118
                    }
                    catch (InterruptedException var0_6) {
                        var4_19 = var6_21;
                        try {
                            var16_34 = System.nanoTime();
                            var16_34 = var14_33 + var12_32 - var16_34;
                            var4_19 = 1;
                        }
                        catch (TimeoutException var0_7) {
                            break;
                        }
                        catch (ExecutionException var0_8) {
                            var7_22 = var5_20;
                            ** GOTO lbl118
                        }
                    }
                }
                var4_19 = var7_22;
                var4_19 = var7_22;
                var4_19 = var7_22;
                var3_18 = new StringBuilder();
                var4_19 = var7_22;
                var3_18.append((Object)var1_16 /* !! */ );
                var4_19 = var7_22;
                var3_18.append(" appears to be blocked, please run registerGnssStatusCallback() directly on a Looper thread or ensure the main Looper is not blocked by this thread");
                var4_19 = var7_22;
                var2_17 = new IllegalStateException(var3_18.toString(), (Throwable)var0_11);
                var4_19 = var7_22;
                throw var2_17;
                catch (ExecutionException var0_12) {
                    var7_22 = 0;
                }
lbl118:
                // 3 sources

                var4_19 = var7_22;
                if (!(var0_13.getCause() instanceof RuntimeException)) {
                    var4_19 = var7_22;
                    if (var0_13.getCause() instanceof Error) {
                        var4_19 = var7_22;
                        throw (Error)var0_13.getCause();
                    }
                    var4_19 = var7_22;
                    var4_19 = var7_22;
                    var1_16 /* !! */  = new IllegalStateException((Throwable)var0_13);
                    var4_19 = var7_22;
                    throw var1_16 /* !! */ ;
                }
                var4_19 = var7_22;
                throw (RuntimeException)var0_13.getCause();
                {
                    catch (Throwable var0_14) {
                        // empty catch block
                    }
                }
            }
            if (var4_19 == 0) ** GOTO lbl137
            Thread.currentThread().interrupt();
lbl137:
            // 2 sources

            throw var0;
lbl138:
            // 1 sources

            var0 = new StringBuilder();
            var0.append((Object)var1_16 /* !! */ );
            var0.append(" is shutting down");
            var2_17 = new IllegalStateException(var0.toString());
            throw var2_17;
            catch (Throwable var0_15) {}
            {
                throw var0_15;
            }
        }
    }

    public static boolean registerGnssStatusCallback(LocationManager locationManager, GnssStatusCompat.Callback callback, Handler handler) {
        if (Build.VERSION.SDK_INT >= 30) {
            return LocationManagerCompat.registerGnssStatusCallback(locationManager, ExecutorCompat.create(handler), callback);
        }
        return LocationManagerCompat.registerGnssStatusCallback(locationManager, new InlineHandlerExecutor(handler), callback);
    }

    public static boolean registerGnssStatusCallback(LocationManager locationManager, Executor executor, GnssStatusCompat.Callback callback) {
        Looper looper;
        if (Build.VERSION.SDK_INT >= 30) {
            return LocationManagerCompat.registerGnssStatusCallback(locationManager, null, executor, callback);
        }
        Looper looper2 = looper = Looper.myLooper();
        if (looper == null) {
            looper2 = Looper.getMainLooper();
        }
        return LocationManagerCompat.registerGnssStatusCallback(locationManager, new Handler(looper2), executor, callback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeUpdates(LocationManager locationManager, LocationListenerCompat locationListenerCompat) {
        WeakHashMap<LocationListener, List<WeakReference<LocationListenerTransport>>> weakHashMap = sLocationListeners;
        synchronized (weakHashMap) {
            Object object = weakHashMap.remove(locationListenerCompat);
            if (object != null) {
                Iterator<WeakReference<LocationListenerTransport>> iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (LocationListenerTransport)iterator.next().get();
                    if (object == null || !((LocationListenerTransport)object).unregister()) continue;
                    locationManager.removeUpdates((LocationListener)object);
                }
            }
        }
        locationManager.removeUpdates((LocationListener)locationListenerCompat);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void requestLocationUpdates(LocationManager locationManager, String string2, LocationRequestCompat locationRequestCompat, LocationListenerCompat locationListenerCompat, Looper looper) {
        block8: {
            if (Build.VERSION.SDK_INT >= 31) {
                Api31Impl.requestLocationUpdates(locationManager, string2, locationRequestCompat.toLocationRequest(), ExecutorCompat.create(new Handler(looper)), locationListenerCompat);
                return;
            }
            if (Build.VERSION.SDK_INT >= 19) {
                Object object;
                block7: {
                    if (sRequestLocationUpdatesLooperMethod != null) break block7;
                    object = LocationManager.class.getDeclaredMethod("requestLocationUpdates", LocationRequest.class, LocationListener.class, Looper.class);
                    sRequestLocationUpdatesLooperMethod = object;
                    ((Method)object).setAccessible(true);
                }
                object = locationRequestCompat.toLocationRequest(string2);
                if (object != null) {
                    sRequestLocationUpdatesLooperMethod.invoke((Object)locationManager, object, locationListenerCompat, looper);
                    return;
                }
                break block8;
                catch (IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {}
                break block8;
                catch (IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {}
            }
        }
        locationManager.requestLocationUpdates(string2, locationRequestCompat.getIntervalMillis(), locationRequestCompat.getMinUpdateDistanceMeters(), (LocationListener)locationListenerCompat, looper);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void requestLocationUpdates(LocationManager locationManager, String string2, LocationRequestCompat locationRequestCompat, Executor object, LocationListenerCompat object2) {
        block15: {
            Object object3;
            if (Build.VERSION.SDK_INT >= 31) {
                Api31Impl.requestLocationUpdates(locationManager, string2, locationRequestCompat.toLocationRequest(), (Executor)object, (LocationListener)object2);
                return;
            }
            if (Build.VERSION.SDK_INT >= 30) {
                try {
                    if (sRequestLocationUpdatesExecutorMethod == null) {
                        object3 = LocationManager.class.getDeclaredMethod("requestLocationUpdates", LocationRequest.class, Executor.class, LocationListener.class);
                        sRequestLocationUpdatesExecutorMethod = object3;
                        ((Method)object3).setAccessible(true);
                    }
                    if ((object3 = locationRequestCompat.toLocationRequest(string2)) != null) {
                        sRequestLocationUpdatesExecutorMethod.invoke((Object)locationManager, object3, object, object2);
                        return;
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
            object = new LocationListenerTransport((LocationListenerCompat)object2, (Executor)object);
            if (Build.VERSION.SDK_INT >= 19) {
                try {
                    if (sRequestLocationUpdatesLooperMethod == null) {
                        sRequestLocationUpdatesLooperMethod = object2 = LocationManager.class.getDeclaredMethod("requestLocationUpdates", LocationRequest.class, LocationListener.class, Looper.class);
                        ((Method)object2).setAccessible(true);
                    }
                    if ((object3 = locationRequestCompat.toLocationRequest(string2)) == null) break block15;
                    object2 = sLocationListeners;
                    synchronized (object2) {
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | UnsupportedOperationException | InvocationTargetException exception) {
                    break block15;
                }
                {
                    sRequestLocationUpdatesLooperMethod.invoke((Object)locationManager, object3, object, Looper.getMainLooper());
                    ((LocationListenerTransport)object).register();
                    return;
                }
            }
        }
        object2 = sLocationListeners;
        synchronized (object2) {
            locationManager.requestLocationUpdates(string2, locationRequestCompat.getIntervalMillis(), locationRequestCompat.getMinUpdateDistanceMeters(), (LocationListener)object, Looper.getMainLooper());
            ((LocationListenerTransport)object).register();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void unregisterGnssStatusCallback(LocationManager locationManager, GnssStatusCompat.Callback object) {
        if (Build.VERSION.SDK_INT >= 30) {
            SimpleArrayMap<Object, Object> simpleArrayMap = GnssLazyLoader.sGnssStatusListeners;
            synchronized (simpleArrayMap) {
                object = (GnssStatusTransport)((Object)GnssLazyLoader.sGnssStatusListeners.remove(object));
                if (object == null) return;
                locationManager.unregisterGnssStatusCallback((GnssStatus.Callback)object);
                return;
            }
        }
        if (Build.VERSION.SDK_INT >= 24) {
            SimpleArrayMap<Object, Object> simpleArrayMap = GnssLazyLoader.sGnssStatusListeners;
            synchronized (simpleArrayMap) {
                object = (PreRGnssStatusTransport)((Object)GnssLazyLoader.sGnssStatusListeners.remove(object));
                if (object == null) return;
                ((PreRGnssStatusTransport)((Object)object)).unregister();
                locationManager.unregisterGnssStatusCallback((GnssStatus.Callback)object);
                return;
            }
        }
        SimpleArrayMap<Object, Object> simpleArrayMap = GnssLazyLoader.sGnssStatusListeners;
        synchronized (simpleArrayMap) {
            object = (GpsStatusTransport)GnssLazyLoader.sGnssStatusListeners.remove(object);
            if (object == null) return;
            ((GpsStatusTransport)object).unregister();
            locationManager.removeGpsStatusListener((GpsStatus.Listener)object);
            return;
        }
    }

    private static class Api28Impl {
        private Api28Impl() {
        }

        static String getGnssHardwareModelName(LocationManager locationManager) {
            return locationManager.getGnssHardwareModelName();
        }

        static int getGnssYearOfHardware(LocationManager locationManager) {
            return locationManager.getGnssYearOfHardware();
        }

        static boolean isLocationEnabled(LocationManager locationManager) {
            return locationManager.isLocationEnabled();
        }
    }

    private static class Api30Impl {
        private Api30Impl() {
        }

        static void getCurrentLocation(LocationManager locationManager, String string2, CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
            cancellationSignal = cancellationSignal != null ? (android.os.CancellationSignal)cancellationSignal.getCancellationSignalObject() : null;
            Objects.requireNonNull(consumer);
            locationManager.getCurrentLocation(string2, (android.os.CancellationSignal)cancellationSignal, executor, (java.util.function.Consumer)new LocationManagerCompat$Api30Impl$$ExternalSyntheticLambda0(consumer));
        }
    }

    private static class Api31Impl {
        private Api31Impl() {
        }

        static boolean hasProvider(LocationManager locationManager, String string2) {
            return locationManager.hasProvider(string2);
        }

        static void requestLocationUpdates(LocationManager locationManager, String string2, LocationRequest locationRequest, Executor executor, LocationListener locationListener) {
            locationManager.requestLocationUpdates(string2, locationRequest, executor, locationListener);
        }
    }

    private static final class CancellableLocationListener
    implements LocationListener {
        private Consumer<Location> mConsumer;
        private final Executor mExecutor;
        private final LocationManager mLocationManager;
        private final Handler mTimeoutHandler;
        Runnable mTimeoutRunnable;
        private boolean mTriggered;

        CancellableLocationListener(LocationManager locationManager, Executor executor, Consumer<Location> consumer) {
            this.mLocationManager = locationManager;
            this.mExecutor = executor;
            this.mTimeoutHandler = new Handler(Looper.getMainLooper());
            this.mConsumer = consumer;
        }

        private void cleanup() {
            this.mConsumer = null;
            this.mLocationManager.removeUpdates((LocationListener)this);
            Runnable runnable = this.mTimeoutRunnable;
            if (runnable != null) {
                this.mTimeoutHandler.removeCallbacks(runnable);
                this.mTimeoutRunnable = null;
            }
        }

        static /* synthetic */ void lambda$onLocationChanged$0(Consumer consumer, Location location) {
            consumer.accept(location);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void cancel() {
            synchronized (this) {
                if (this.mTriggered) {
                    return;
                }
                this.mTriggered = true;
            }
            this.cleanup();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onLocationChanged(Location location) {
            synchronized (this) {
                if (this.mTriggered) {
                    return;
                }
                this.mTriggered = true;
            }
            Consumer<Location> consumer = this.mConsumer;
            this.mExecutor.execute(new LocationManagerCompat$CancellableLocationListener$$ExternalSyntheticLambda0(consumer, location));
            this.cleanup();
        }

        public void onProviderDisabled(String string2) {
            string2 = null;
            this.onLocationChanged(null);
        }

        public void onProviderEnabled(String string2) {
        }

        public void onStatusChanged(String string2, int n, Bundle bundle) {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void startTimeout(long l) {
            synchronized (this) {
                Runnable runnable;
                if (this.mTriggered) {
                    return;
                }
                this.mTimeoutRunnable = runnable = new Runnable(){

                    @Override
                    public void run() {
                        CancellableLocationListener.this.mTimeoutRunnable = null;
                        CancellableLocationListener cancellableLocationListener = CancellableLocationListener.this;
                        Location location = null;
                        cancellableLocationListener.onLocationChanged(null);
                    }
                };
                this.mTimeoutHandler.postDelayed(runnable, l);
                return;
            }
        }
    }

    private static class GnssLazyLoader {
        static final SimpleArrayMap<Object, Object> sGnssStatusListeners = new SimpleArrayMap();

        private GnssLazyLoader() {
        }
    }

    private static class GnssStatusTransport
    extends GnssStatus.Callback {
        final GnssStatusCompat.Callback mCallback;

        GnssStatusTransport(GnssStatusCompat.Callback callback) {
            boolean bl = callback != null;
            Preconditions.checkArgument(bl, "invalid null callback");
            this.mCallback = callback;
        }

        public void onFirstFix(int n) {
            this.mCallback.onFirstFix(n);
        }

        public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
            this.mCallback.onSatelliteStatusChanged(GnssStatusCompat.wrap(gnssStatus));
        }

        public void onStarted() {
            this.mCallback.onStarted();
        }

        public void onStopped() {
            this.mCallback.onStopped();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class GpsStatusTransport
    implements GpsStatus.Listener {
        final GnssStatusCompat.Callback mCallback;
        volatile Executor mExecutor;
        private final LocationManager mLocationManager;

        GpsStatusTransport(LocationManager locationManager, GnssStatusCompat.Callback callback) {
            boolean bl = callback != null;
            Preconditions.checkArgument(bl, "invalid null callback");
            this.mLocationManager = locationManager;
            this.mCallback = callback;
        }

        public /* synthetic */ void lambda$onGpsStatusChanged$0$androidx-core-location-LocationManagerCompat$GpsStatusTransport(Executor executor) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onStarted();
        }

        public /* synthetic */ void lambda$onGpsStatusChanged$1$androidx-core-location-LocationManagerCompat$GpsStatusTransport(Executor executor) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onStopped();
        }

        public /* synthetic */ void lambda$onGpsStatusChanged$2$androidx-core-location-LocationManagerCompat$GpsStatusTransport(Executor executor, int n) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onFirstFix(n);
        }

        public /* synthetic */ void lambda$onGpsStatusChanged$3$androidx-core-location-LocationManagerCompat$GpsStatusTransport(Executor executor, GnssStatusCompat gnssStatusCompat) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onSatelliteStatusChanged(gnssStatusCompat);
        }

        public void onGpsStatusChanged(int n) {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            if (n != 1) {
                if (n != 2) {
                    if (n != 3) {
                        GpsStatus gpsStatus;
                        if (n == 4 && (gpsStatus = this.mLocationManager.getGpsStatus(null)) != null) {
                            executor.execute(new LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda3(this, executor, GnssStatusCompat.wrap(gpsStatus)));
                        }
                    } else {
                        GpsStatus gpsStatus = this.mLocationManager.getGpsStatus(null);
                        if (gpsStatus != null) {
                            executor.execute(new LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda2(this, executor, gpsStatus.getTimeToFirstFix()));
                        }
                    }
                } else {
                    executor.execute(new LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda1(this, executor));
                }
            } else {
                executor.execute(new LocationManagerCompat$GpsStatusTransport$$ExternalSyntheticLambda0(this, executor));
            }
        }

        public void register(Executor executor) {
            boolean bl = this.mExecutor == null;
            Preconditions.checkState(bl);
            this.mExecutor = executor;
        }

        public void unregister() {
            this.mExecutor = null;
        }
    }

    private static final class InlineHandlerExecutor
    implements Executor {
        private final Handler mHandler;

        InlineHandlerExecutor(Handler handler) {
            this.mHandler = Preconditions.checkNotNull(handler);
        }

        @Override
        public void execute(Runnable object) {
            block4: {
                block3: {
                    block2: {
                        if (Looper.myLooper() != this.mHandler.getLooper()) break block2;
                        object.run();
                        break block3;
                    }
                    if (!this.mHandler.post(Preconditions.checkNotNull(object))) break block4;
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.mHandler);
            ((StringBuilder)object).append(" is shutting down");
            throw new RejectedExecutionException(((StringBuilder)object).toString());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class LocationListenerTransport
    implements LocationListener {
        final Executor mExecutor;
        volatile LocationListenerCompat mListener;

        LocationListenerTransport(LocationListenerCompat locationListenerCompat, Executor executor) {
            this.mListener = ObjectsCompat.requireNonNull(locationListenerCompat, "invalid null listener");
            this.mExecutor = executor;
        }

        static /* synthetic */ boolean lambda$register$0(WeakReference weakReference) {
            boolean bl = weakReference.get() == null;
            return bl;
        }

        static /* synthetic */ boolean lambda$unregister$1(WeakReference weakReference) {
            boolean bl = weakReference.get() == null;
            return bl;
        }

        public /* synthetic */ void lambda$onFlushComplete$4$androidx-core-location-LocationManagerCompat$LocationListenerTransport(LocationListenerCompat locationListenerCompat, int n) {
            if (this.mListener != locationListenerCompat) {
                return;
            }
            locationListenerCompat.onFlushComplete(n);
        }

        public /* synthetic */ void lambda$onLocationChanged$2$androidx-core-location-LocationManagerCompat$LocationListenerTransport(LocationListenerCompat locationListenerCompat, Location location) {
            if (this.mListener != locationListenerCompat) {
                return;
            }
            locationListenerCompat.onLocationChanged(location);
        }

        public /* synthetic */ void lambda$onLocationChanged$3$androidx-core-location-LocationManagerCompat$LocationListenerTransport(LocationListenerCompat locationListenerCompat, List list) {
            if (this.mListener != locationListenerCompat) {
                return;
            }
            locationListenerCompat.onLocationChanged(list);
        }

        public /* synthetic */ void lambda$onProviderDisabled$7$androidx-core-location-LocationManagerCompat$LocationListenerTransport(LocationListenerCompat locationListenerCompat, String string2) {
            if (this.mListener != locationListenerCompat) {
                return;
            }
            locationListenerCompat.onProviderDisabled(string2);
        }

        public /* synthetic */ void lambda$onProviderEnabled$6$androidx-core-location-LocationManagerCompat$LocationListenerTransport(LocationListenerCompat locationListenerCompat, String string2) {
            if (this.mListener != locationListenerCompat) {
                return;
            }
            locationListenerCompat.onProviderEnabled(string2);
        }

        public /* synthetic */ void lambda$onStatusChanged$5$androidx-core-location-LocationManagerCompat$LocationListenerTransport(LocationListenerCompat locationListenerCompat, String string2, int n, Bundle bundle) {
            if (this.mListener != locationListenerCompat) {
                return;
            }
            locationListenerCompat.onStatusChanged(string2, n, bundle);
        }

        public void onFlushComplete(int n) {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return;
            }
            this.mExecutor.execute(new LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda0(this, locationListenerCompat, n));
        }

        public void onLocationChanged(Location location) {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return;
            }
            this.mExecutor.execute(new LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda1(this, locationListenerCompat, location));
        }

        public void onLocationChanged(List<Location> list) {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return;
            }
            this.mExecutor.execute(new LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda5(this, locationListenerCompat, list));
        }

        public void onProviderDisabled(String string2) {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return;
            }
            this.mExecutor.execute(new LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda2(this, locationListenerCompat, string2));
        }

        public void onProviderEnabled(String string2) {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return;
            }
            this.mExecutor.execute(new LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda3(this, locationListenerCompat, string2));
        }

        public void onStatusChanged(String string2, int n, Bundle bundle) {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return;
            }
            this.mExecutor.execute(new LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda4(this, locationListenerCompat, string2, n, bundle));
        }

        public void register() {
            List<Object> list;
            List<WeakReference<LocationListenerTransport>> list2 = sLocationListeners.get(this.mListener);
            if (list2 == null) {
                list = new ArrayList(1);
                sLocationListeners.put(this.mListener, list);
            } else if (Build.VERSION.SDK_INT >= 24) {
                list2.removeIf(LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda6.INSTANCE);
                list = list2;
            } else {
                Iterator<WeakReference<LocationListenerTransport>> iterator = list2.iterator();
                while (true) {
                    list = list2;
                    if (!iterator.hasNext()) break;
                    if (iterator.next().get() != null) continue;
                    iterator.remove();
                }
            }
            list.add(new WeakReference<LocationListenerTransport>(this));
        }

        public boolean unregister() {
            LocationListenerCompat locationListenerCompat = this.mListener;
            if (locationListenerCompat == null) {
                return false;
            }
            this.mListener = null;
            List<WeakReference<LocationListenerTransport>> list = sLocationListeners.get(locationListenerCompat);
            if (list != null) {
                if (Build.VERSION.SDK_INT >= 24) {
                    list.removeIf(LocationManagerCompat$LocationListenerTransport$$ExternalSyntheticLambda7.INSTANCE);
                } else {
                    Iterator<WeakReference<LocationListenerTransport>> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        if (iterator.next().get() != null) continue;
                        iterator.remove();
                    }
                }
                if (list.isEmpty()) {
                    sLocationListeners.remove(locationListenerCompat);
                }
            }
            return true;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class PreRGnssStatusTransport
    extends GnssStatus.Callback {
        final GnssStatusCompat.Callback mCallback;
        volatile Executor mExecutor;

        PreRGnssStatusTransport(GnssStatusCompat.Callback callback) {
            boolean bl = callback != null;
            Preconditions.checkArgument(bl, "invalid null callback");
            this.mCallback = callback;
        }

        public /* synthetic */ void lambda$onFirstFix$2$androidx-core-location-LocationManagerCompat$PreRGnssStatusTransport(Executor executor, int n) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onFirstFix(n);
        }

        public /* synthetic */ void lambda$onSatelliteStatusChanged$3$androidx-core-location-LocationManagerCompat$PreRGnssStatusTransport(Executor executor, GnssStatus gnssStatus) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onSatelliteStatusChanged(GnssStatusCompat.wrap(gnssStatus));
        }

        public /* synthetic */ void lambda$onStarted$0$androidx-core-location-LocationManagerCompat$PreRGnssStatusTransport(Executor executor) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onStarted();
        }

        public /* synthetic */ void lambda$onStopped$1$androidx-core-location-LocationManagerCompat$PreRGnssStatusTransport(Executor executor) {
            if (this.mExecutor != executor) {
                return;
            }
            this.mCallback.onStopped();
        }

        public void onFirstFix(int n) {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(new LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda2(this, executor, n));
        }

        public void onSatelliteStatusChanged(GnssStatus gnssStatus) {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(new LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda3(this, executor, gnssStatus));
        }

        public void onStarted() {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(new LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda0(this, executor));
        }

        public void onStopped() {
            Executor executor = this.mExecutor;
            if (executor == null) {
                return;
            }
            executor.execute(new LocationManagerCompat$PreRGnssStatusTransport$$ExternalSyntheticLambda1(this, executor));
        }

        public void register(Executor executor) {
            boolean bl = true;
            boolean bl2 = executor != null;
            Preconditions.checkArgument(bl2, "invalid null executor");
            bl2 = this.mExecutor == null ? bl : false;
            Preconditions.checkState(bl2);
            this.mExecutor = executor;
        }

        public void unregister() {
            this.mExecutor = null;
        }
    }
}

