/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.location;

import android.location.LocationRequest;
import android.os.Build;
import androidx.core.util.Preconditions;
import androidx.core.util.TimeUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class LocationRequestCompat {
    private static final long IMPLICIT_MIN_UPDATE_INTERVAL = -1L;
    public static final long PASSIVE_INTERVAL = Long.MAX_VALUE;
    public static final int QUALITY_BALANCED_POWER_ACCURACY = 102;
    public static final int QUALITY_HIGH_ACCURACY = 100;
    public static final int QUALITY_LOW_POWER = 104;
    private static Method sCreateFromDeprecatedProviderMethod;
    private static Method sSetExpireInMethod;
    private static Method sSetFastestIntervalMethod;
    private static Method sSetNumUpdatesMethod;
    private static Method sSetQualityMethod;
    final long mDurationMillis;
    final long mIntervalMillis;
    final long mMaxUpdateDelayMillis;
    final int mMaxUpdates;
    final float mMinUpdateDistanceMeters;
    final long mMinUpdateIntervalMillis;
    final int mQuality;

    LocationRequestCompat(long l, int n, long l2, int n2, long l3, float f, long l4) {
        this.mIntervalMillis = l;
        this.mQuality = n;
        this.mMinUpdateIntervalMillis = l3;
        this.mDurationMillis = l2;
        this.mMaxUpdates = n2;
        this.mMinUpdateDistanceMeters = f;
        this.mMaxUpdateDelayMillis = l4;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this == object) {
            return true;
        }
        if (!(object instanceof LocationRequestCompat)) {
            return false;
        }
        object = (LocationRequestCompat)object;
        if (this.mQuality != ((LocationRequestCompat)object).mQuality || this.mIntervalMillis != ((LocationRequestCompat)object).mIntervalMillis || this.mMinUpdateIntervalMillis != ((LocationRequestCompat)object).mMinUpdateIntervalMillis || this.mDurationMillis != ((LocationRequestCompat)object).mDurationMillis || this.mMaxUpdates != ((LocationRequestCompat)object).mMaxUpdates || Float.compare(((LocationRequestCompat)object).mMinUpdateDistanceMeters, this.mMinUpdateDistanceMeters) != 0 || this.mMaxUpdateDelayMillis != ((LocationRequestCompat)object).mMaxUpdateDelayMillis) {
            bl = false;
        }
        return bl;
    }

    public long getDurationMillis() {
        return this.mDurationMillis;
    }

    public long getIntervalMillis() {
        return this.mIntervalMillis;
    }

    public long getMaxUpdateDelayMillis() {
        return this.mMaxUpdateDelayMillis;
    }

    public int getMaxUpdates() {
        return this.mMaxUpdates;
    }

    public float getMinUpdateDistanceMeters() {
        return this.mMinUpdateDistanceMeters;
    }

    public long getMinUpdateIntervalMillis() {
        long l;
        long l2 = l = this.mMinUpdateIntervalMillis;
        if (l == -1L) {
            l2 = this.mIntervalMillis;
        }
        return l2;
    }

    public int getQuality() {
        return this.mQuality;
    }

    public int hashCode() {
        int n = this.mQuality;
        long l = this.mIntervalMillis;
        int n2 = (int)(l ^ l >>> 32);
        l = this.mMinUpdateIntervalMillis;
        return (n * 31 + n2) * 31 + (int)(l ^ l >>> 32);
    }

    public LocationRequest toLocationRequest() {
        return new LocationRequest.Builder(this.mIntervalMillis).setQuality(this.mQuality).setMinUpdateIntervalMillis(this.mMinUpdateIntervalMillis).setDurationMillis(this.mDurationMillis).setMaxUpdates(this.mMaxUpdates).setMinUpdateDistanceMeters(this.mMinUpdateDistanceMeters).setMaxUpdateDelayMillis(this.mMaxUpdateDelayMillis).build();
    }

    public LocationRequest toLocationRequest(String string2) {
        Method method;
        block12: {
            if (Build.VERSION.SDK_INT >= 31) {
                return this.toLocationRequest();
            }
            if (sCreateFromDeprecatedProviderMethod == null) {
                sCreateFromDeprecatedProviderMethod = method = LocationRequest.class.getDeclaredMethod("createFromDeprecatedProvider", String.class, Long.TYPE, Float.TYPE, Boolean.TYPE);
                method.setAccessible(true);
            }
            if ((string2 = (LocationRequest)sCreateFromDeprecatedProviderMethod.invoke(null, string2, this.mIntervalMillis, Float.valueOf(this.mMinUpdateDistanceMeters), false)) != null) break block12;
            return null;
        }
        try {
            if (sSetQualityMethod == null) {
                sSetQualityMethod = method = LocationRequest.class.getDeclaredMethod("setQuality", Integer.TYPE);
                method.setAccessible(true);
            }
            sSetQualityMethod.invoke((Object)string2, this.mQuality);
            if (this.getMinUpdateIntervalMillis() != this.mIntervalMillis) {
                if (sSetFastestIntervalMethod == null) {
                    sSetFastestIntervalMethod = method = LocationRequest.class.getDeclaredMethod("setFastestInterval", Long.TYPE);
                    method.setAccessible(true);
                }
                sSetFastestIntervalMethod.invoke((Object)string2, this.mMinUpdateIntervalMillis);
            }
            if (this.mMaxUpdates < Integer.MAX_VALUE) {
                if (sSetNumUpdatesMethod == null) {
                    sSetNumUpdatesMethod = method = LocationRequest.class.getDeclaredMethod("setNumUpdates", Integer.TYPE);
                    method.setAccessible(true);
                }
                sSetNumUpdatesMethod.invoke((Object)string2, this.mMaxUpdates);
            }
            if (this.mDurationMillis < Long.MAX_VALUE) {
                if (sSetExpireInMethod == null) {
                    sSetExpireInMethod = method = LocationRequest.class.getDeclaredMethod("setExpireIn", Long.TYPE);
                    method.setAccessible(true);
                }
                sSetExpireInMethod.invoke((Object)string2, this.mDurationMillis);
            }
            return string2;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public String toString() {
        long l;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Request[");
        if (this.mIntervalMillis != Long.MAX_VALUE) {
            stringBuilder.append("@");
            TimeUtils.formatDuration(this.mIntervalMillis, stringBuilder);
            int n = this.mQuality;
            if (n != 100) {
                if (n != 102) {
                    if (n == 104) {
                        stringBuilder.append(" LOW_POWER");
                    }
                } else {
                    stringBuilder.append(" BALANCED");
                }
            } else {
                stringBuilder.append(" HIGH_ACCURACY");
            }
        } else {
            stringBuilder.append("PASSIVE");
        }
        if (this.mDurationMillis != Long.MAX_VALUE) {
            stringBuilder.append(", duration=");
            TimeUtils.formatDuration(this.mDurationMillis, stringBuilder);
        }
        if (this.mMaxUpdates != Integer.MAX_VALUE) {
            stringBuilder.append(", maxUpdates=");
            stringBuilder.append(this.mMaxUpdates);
        }
        if ((l = this.mMinUpdateIntervalMillis) != -1L && l < this.mIntervalMillis) {
            stringBuilder.append(", minUpdateInterval=");
            TimeUtils.formatDuration(this.mMinUpdateIntervalMillis, stringBuilder);
        }
        if ((double)this.mMinUpdateDistanceMeters > 0.0) {
            stringBuilder.append(", minUpdateDistance=");
            stringBuilder.append(this.mMinUpdateDistanceMeters);
        }
        if (this.mMaxUpdateDelayMillis / 2L > this.mIntervalMillis) {
            stringBuilder.append(", maxUpdateDelay=");
            TimeUtils.formatDuration(this.mMaxUpdateDelayMillis, stringBuilder);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static final class Builder {
        private long mDurationMillis;
        private long mIntervalMillis;
        private long mMaxUpdateDelayMillis;
        private int mMaxUpdates;
        private float mMinUpdateDistanceMeters;
        private long mMinUpdateIntervalMillis;
        private int mQuality;

        public Builder(long l) {
            this.setIntervalMillis(l);
            this.mQuality = 102;
            this.mDurationMillis = Long.MAX_VALUE;
            this.mMaxUpdates = Integer.MAX_VALUE;
            this.mMinUpdateIntervalMillis = -1L;
            this.mMinUpdateDistanceMeters = 0.0f;
            this.mMaxUpdateDelayMillis = 0L;
        }

        public Builder(LocationRequestCompat locationRequestCompat) {
            this.mIntervalMillis = locationRequestCompat.mIntervalMillis;
            this.mQuality = locationRequestCompat.mQuality;
            this.mDurationMillis = locationRequestCompat.mDurationMillis;
            this.mMaxUpdates = locationRequestCompat.mMaxUpdates;
            this.mMinUpdateIntervalMillis = locationRequestCompat.mMinUpdateIntervalMillis;
            this.mMinUpdateDistanceMeters = locationRequestCompat.mMinUpdateDistanceMeters;
            this.mMaxUpdateDelayMillis = locationRequestCompat.mMaxUpdateDelayMillis;
        }

        public LocationRequestCompat build() {
            boolean bl = this.mIntervalMillis != Long.MAX_VALUE || this.mMinUpdateIntervalMillis != -1L;
            Preconditions.checkState(bl, "passive location requests must have an explicit minimum update interval");
            long l = this.mIntervalMillis;
            return new LocationRequestCompat(l, this.mQuality, this.mDurationMillis, this.mMaxUpdates, Math.min(this.mMinUpdateIntervalMillis, l), this.mMinUpdateDistanceMeters, this.mMaxUpdateDelayMillis);
        }

        public Builder clearMinUpdateIntervalMillis() {
            this.mMinUpdateIntervalMillis = -1L;
            return this;
        }

        public Builder setDurationMillis(long l) {
            this.mDurationMillis = Preconditions.checkArgumentInRange(l, 1L, Long.MAX_VALUE, "durationMillis");
            return this;
        }

        public Builder setIntervalMillis(long l) {
            this.mIntervalMillis = Preconditions.checkArgumentInRange(l, 0L, Long.MAX_VALUE, "intervalMillis");
            return this;
        }

        public Builder setMaxUpdateDelayMillis(long l) {
            this.mMaxUpdateDelayMillis = l;
            this.mMaxUpdateDelayMillis = Preconditions.checkArgumentInRange(l, 0L, Long.MAX_VALUE, "maxUpdateDelayMillis");
            return this;
        }

        public Builder setMaxUpdates(int n) {
            this.mMaxUpdates = Preconditions.checkArgumentInRange(n, 1, Integer.MAX_VALUE, "maxUpdates");
            return this;
        }

        public Builder setMinUpdateDistanceMeters(float f) {
            this.mMinUpdateDistanceMeters = f;
            this.mMinUpdateDistanceMeters = Preconditions.checkArgumentInRange(f, 0.0f, Float.MAX_VALUE, "minUpdateDistanceMeters");
            return this;
        }

        public Builder setMinUpdateIntervalMillis(long l) {
            this.mMinUpdateIntervalMillis = Preconditions.checkArgumentInRange(l, 0L, Long.MAX_VALUE, "minUpdateIntervalMillis");
            return this;
        }

        public Builder setQuality(int n) {
            boolean bl = n == 104 || n == 102 || n == 100;
            Preconditions.checkArgument(bl, "quality must be a defined QUALITY constant, not %d", n);
            this.mQuality = n;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Quality {
    }
}

