/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.net;

import android.net.Uri;
import androidx.core.net.ParseException;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class MailTo {
    private static final String BCC = "bcc";
    private static final String BODY = "body";
    private static final String CC = "cc";
    private static final String MAILTO = "mailto";
    public static final String MAILTO_SCHEME = "mailto:";
    private static final String SUBJECT = "subject";
    private static final String TO = "to";
    private HashMap<String, String> mHeaders = new HashMap();

    private MailTo() {
    }

    public static boolean isMailTo(Uri uri) {
        boolean bl = uri != null && MAILTO.equals(uri.getScheme());
        return bl;
    }

    public static boolean isMailTo(String string2) {
        boolean bl = string2 != null && string2.startsWith(MAILTO_SCHEME);
        return bl;
    }

    public static MailTo parse(Uri uri) throws ParseException {
        return MailTo.parse(uri.toString());
    }

    public static MailTo parse(String string2) throws ParseException {
        Preconditions.checkNotNull(string2);
        if (MailTo.isMailTo(string2)) {
            String string3;
            int n = string2.indexOf(35);
            CharSequence charSequence = string2;
            if (n != -1) {
                charSequence = string2.substring(0, n);
            }
            if ((n = ((String)charSequence).indexOf(63)) == -1) {
                string2 = Uri.decode((String)((String)charSequence).substring(7));
                charSequence = null;
            } else {
                string2 = Uri.decode((String)((String)charSequence).substring(7, n));
                charSequence = ((String)charSequence).substring(n + 1);
            }
            MailTo mailTo = new MailTo();
            if (charSequence != null) {
                String[] stringArray = ((String)charSequence).split("&");
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    charSequence = stringArray[n].split("=", 2);
                    if (((CharSequence)charSequence).length == 0) continue;
                    string3 = Uri.decode((String)charSequence[0]).toLowerCase(Locale.ROOT);
                    charSequence = ((CharSequence)charSequence).length > 1 ? Uri.decode((String)charSequence[1]) : null;
                    mailTo.mHeaders.put(string3, (String)charSequence);
                }
            }
            string3 = mailTo.getTo();
            charSequence = string2;
            if (string3 != null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(string3);
                charSequence = ((StringBuilder)charSequence).toString();
            }
            mailTo.mHeaders.put(TO, (String)charSequence);
            return mailTo;
        }
        throw new ParseException("Not a mailto scheme");
    }

    public String getBcc() {
        return this.mHeaders.get(BCC);
    }

    public String getBody() {
        return this.mHeaders.get(BODY);
    }

    public String getCc() {
        return this.mHeaders.get(CC);
    }

    public Map<String, String> getHeaders() {
        return this.mHeaders;
    }

    public String getSubject() {
        return this.mHeaders.get(SUBJECT);
    }

    public String getTo() {
        return this.mHeaders.get(TO);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(MAILTO_SCHEME);
        stringBuilder.append('?');
        for (Map.Entry<String, String> entry : this.mHeaders.entrySet()) {
            stringBuilder.append(Uri.encode((String)entry.getKey()));
            stringBuilder.append('=');
            stringBuilder.append(Uri.encode((String)entry.getValue()));
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }
}

