/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Handler;
import androidx.core.util.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public final class ExecutorCompat {
    private ExecutorCompat() {
    }

    public static Executor create(Handler handler) {
        return new HandlerExecutor(handler);
    }

    private static class HandlerExecutor
    implements Executor {
        private final Handler mHandler;

        HandlerExecutor(Handler handler) {
            this.mHandler = Preconditions.checkNotNull(handler);
        }

        @Override
        public void execute(Runnable object) {
            if (this.mHandler.post(Preconditions.checkNotNull(object))) {
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(this.mHandler);
            ((StringBuilder)object).append(" is shutting down");
            throw new RejectedExecutionException(((StringBuilder)object).toString());
        }
    }
}

