/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;

public final class HandlerCompat {
    private static final String TAG = "HandlerCompat";

    private HandlerCompat() {
    }

    /*
     * WARNING - void declaration
     */
    public static Handler createAsync(Looper looper) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.createAsync(looper);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            void var1_7;
            try {
                Handler handler = (Handler)Handler.class.getDeclaredConstructor(Looper.class, Handler.Callback.class, Boolean.TYPE).newInstance(looper, null, true);
                return handler;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (!(throwable instanceof RuntimeException)) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                throw (RuntimeException)throwable;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Log.w((String)TAG, (String)"Unable to invoke Handler(Looper, Callback, boolean) constructor", (Throwable)var1_7);
        }
        return new Handler(looper);
    }

    /*
     * WARNING - void declaration
     */
    public static Handler createAsync(Looper looper, Handler.Callback callback) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.createAsync(looper, callback);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            void var2_8;
            try {
                Handler handler = (Handler)Handler.class.getDeclaredConstructor(Looper.class, Handler.Callback.class, Boolean.TYPE).newInstance(looper, callback, true);
                return handler;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (!(throwable instanceof RuntimeException)) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                throw (RuntimeException)throwable;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            Log.w((String)TAG, (String)"Unable to invoke Handler(Looper, Callback, boolean) constructor", (Throwable)var2_8);
        }
        return new Handler(looper, callback);
    }

    public static boolean hasCallbacks(Handler handler, Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 29) {
            return Api29Impl.hasCallbacks(handler, runnable);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            try {
                boolean bl = (Boolean)Handler.class.getMethod("hasCallbacks", Runnable.class).invoke((Object)handler, runnable);
                return bl;
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (!(throwable instanceof RuntimeException)) {
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
                throw (RuntimeException)throwable;
            }
        } else {
            handler = null;
        }
        throw new UnsupportedOperationException("Failed to call Handler.hasCallbacks(), but there is no safe failure mode for this method. Raising exception.", (Throwable)handler);
    }

    public static boolean postDelayed(Handler handler, Runnable runnable, Object object, long l) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.postDelayed(handler, runnable, object, l);
        }
        runnable = Message.obtain((Handler)handler, (Runnable)runnable);
        ((Message)runnable).obj = object;
        return handler.sendMessageDelayed((Message)runnable, l);
    }

    private static class Api28Impl {
        private Api28Impl() {
        }

        public static Handler createAsync(Looper looper) {
            return Handler.createAsync((Looper)looper);
        }

        public static Handler createAsync(Looper looper, Handler.Callback callback) {
            return Handler.createAsync((Looper)looper, (Handler.Callback)callback);
        }

        public static boolean postDelayed(Handler handler, Runnable runnable, Object object, long l) {
            return handler.postDelayed(runnable, object, l);
        }
    }

    private static class Api29Impl {
        private Api29Impl() {
        }

        public static boolean hasCallbacks(Handler handler, Runnable runnable) {
            return handler.hasCallbacks(runnable);
        }
    }
}

