/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Message;

public final class MessageCompat {
    private static boolean sTryIsAsynchronous = true;
    private static boolean sTrySetAsynchronous = true;

    private MessageCompat() {
    }

    public static boolean isAsynchronous(Message message) {
        if (Build.VERSION.SDK_INT >= 22) {
            return message.isAsynchronous();
        }
        if (sTryIsAsynchronous && Build.VERSION.SDK_INT >= 16) {
            try {
                boolean bl = message.isAsynchronous();
                return bl;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                sTryIsAsynchronous = false;
            }
        }
        return false;
    }

    public static void setAsynchronous(Message message, boolean bl) {
        if (Build.VERSION.SDK_INT >= 22) {
            message.setAsynchronous(bl);
            return;
        }
        if (sTrySetAsynchronous && Build.VERSION.SDK_INT >= 16) {
            try {
                message.setAsynchronous(bl);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                sTrySetAsynchronous = false;
            }
        }
    }
}

