/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import java.lang.reflect.Method;

public final class ProcessCompat {
    private ProcessCompat() {
    }

    public static boolean isApplicationUid(int n) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.isApplicationUid(n);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return Api17Impl.isApplicationUid(n);
        }
        if (Build.VERSION.SDK_INT == 16) {
            return Api16Impl.isApplicationUid(n);
        }
        return true;
    }

    static class Api16Impl {
        private static Method sMethodUserIdIsAppMethod;
        private static boolean sResolved;
        private static final Object sResolvedLock;

        static {
            sResolvedLock = new Object();
        }

        private Api16Impl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static boolean isApplicationUid(int n) {
            block8: {
                Object object = sResolvedLock;
                // MONITORENTER : object
                if (sResolved) break block8;
                sResolved = true;
                sMethodUserIdIsAppMethod = Class.forName("android.os.UserId").getDeclaredMethod("isApp", Integer.TYPE);
            }
            // MONITOREXIT : object
            try {
                Object object = sMethodUserIdIsAppMethod;
                if (object == null) return true;
                if ((object = (Boolean)((Method)object).invoke(null, n)) != null) {
                    return (Boolean)object;
                }
                object = new NullPointerException();
                throw object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
    }

    static class Api17Impl {
        private static Method sMethodUserHandleIsAppMethod;
        private static boolean sResolved;
        private static final Object sResolvedLock;

        static {
            sResolvedLock = new Object();
        }

        private Api17Impl() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        static boolean isApplicationUid(int n) {
            Object object;
            block8: {
                object = sResolvedLock;
                // MONITORENTER : object
                if (sResolved) break block8;
                sResolved = true;
                sMethodUserHandleIsAppMethod = UserHandle.class.getDeclaredMethod("isApp", Integer.TYPE);
            }
            // MONITOREXIT : object
            try {
                object = sMethodUserHandleIsAppMethod;
                if (object == null) return true;
                if ((Boolean)((Method)object).invoke(null, n) != null) {
                    return true;
                }
                object = new NullPointerException();
                throw object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
    }

    static class Api24Impl {
        private Api24Impl() {
        }

        static boolean isApplicationUid(int n) {
            return Process.isApplicationUid((int)n);
        }
    }
}

