/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.UserHandle;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UserHandleCompat {
    private static Method sGetUserIdMethod;
    private static Constructor<UserHandle> sUserHandleConstructor;

    private UserHandleCompat() {
    }

    private static Method getGetUserIdMethod() throws NoSuchMethodException {
        if (sGetUserIdMethod == null) {
            Method method;
            sGetUserIdMethod = method = UserHandle.class.getDeclaredMethod("getUserId", Integer.TYPE);
            method.setAccessible(true);
        }
        return sGetUserIdMethod;
    }

    private static Constructor<UserHandle> getUserHandleConstructor() throws NoSuchMethodException {
        if (sUserHandleConstructor == null) {
            Constructor constructor = UserHandle.class.getDeclaredConstructor(Integer.TYPE);
            sUserHandleConstructor = constructor;
            constructor.setAccessible(true);
        }
        return sUserHandleConstructor;
    }

    public static UserHandle getUserHandleForUid(int n) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.getUserHandleForUid(n);
        }
        try {
            Integer n2 = (Integer)UserHandleCompat.getGetUserIdMethod().invoke(null, n);
            n2 = UserHandleCompat.getUserHandleConstructor().newInstance(n2);
            return n2;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (InstantiationException instantiationException) {
            InstantiationError instantiationError = new InstantiationError();
            instantiationError.initCause(instantiationException);
            throw instantiationError;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessError illegalAccessError = new IllegalAccessError();
            illegalAccessError.initCause(illegalAccessException);
            throw illegalAccessError;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NoSuchMethodError noSuchMethodError = new NoSuchMethodError();
            noSuchMethodError.initCause(noSuchMethodException);
            throw noSuchMethodError;
        }
    }

    private static class Api24Impl {
        private Api24Impl() {
        }

        static UserHandle getUserHandleForUid(int n) {
            return UserHandle.getUserHandleForUid((int)n);
        }
    }
}

