/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import java.io.FileNotFoundException;

public final class DocumentsContractCompat {
    private static final String PATH_TREE = "tree";

    private DocumentsContractCompat() {
    }

    public static Uri buildChildDocumentsUri(String string2, String string3) {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.buildChildDocumentsUri(string2, string3);
        }
        return null;
    }

    public static Uri buildChildDocumentsUriUsingTree(Uri uri, String string2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.buildChildDocumentsUriUsingTree(uri, string2);
        }
        return null;
    }

    public static Uri buildDocumentUri(String string2, String string3) {
        if (Build.VERSION.SDK_INT >= 19) {
            return DocumentsContractApi19Impl.buildDocumentUri(string2, string3);
        }
        return null;
    }

    public static Uri buildDocumentUriUsingTree(Uri uri, String string2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.buildDocumentUriUsingTree(uri, string2);
        }
        return null;
    }

    public static Uri buildTreeDocumentUri(String string2, String string3) {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.buildTreeDocumentUri(string2, string3);
        }
        return null;
    }

    public static Uri createDocument(ContentResolver contentResolver, Uri uri, String string2, String string3) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.createDocument(contentResolver, uri, string2, string3);
        }
        return null;
    }

    public static String getDocumentId(Uri uri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return DocumentsContractApi19Impl.getDocumentId(uri);
        }
        return null;
    }

    public static String getTreeDocumentId(Uri uri) {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.getTreeDocumentId(uri);
        }
        return null;
    }

    public static boolean isDocumentUri(Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19) {
            return DocumentsContractApi19Impl.isDocumentUri(context, uri);
        }
        return false;
    }

    public static boolean isTreeUri(Uri object) {
        int n = Build.VERSION.SDK_INT;
        boolean bl = false;
        if (n < 21) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 24) {
            object = object.getPathSegments();
            boolean bl2 = bl;
            if (object.size() >= 2) {
                bl2 = bl;
                if (PATH_TREE.equals(object.get(0))) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        return DocumentsContractApi24Impl.isTreeUri((Uri)object);
    }

    public static boolean removeDocument(ContentResolver contentResolver, Uri uri, Uri uri2) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 24) {
            return DocumentsContractApi24Impl.removeDocument(contentResolver, uri, uri2);
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return DocumentsContractApi19Impl.deleteDocument(contentResolver, uri);
        }
        return false;
    }

    public static Uri renameDocument(ContentResolver contentResolver, Uri uri, String string2) throws FileNotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return DocumentsContractApi21Impl.renameDocument(contentResolver, uri, string2);
        }
        return null;
    }

    public static final class DocumentCompat {
        public static final int FLAG_VIRTUAL_DOCUMENT = 512;

        private DocumentCompat() {
        }
    }

    private static class DocumentsContractApi19Impl {
        private DocumentsContractApi19Impl() {
        }

        public static Uri buildDocumentUri(String string2, String string3) {
            return DocumentsContract.buildDocumentUri((String)string2, (String)string3);
        }

        static boolean deleteDocument(ContentResolver contentResolver, Uri uri) throws FileNotFoundException {
            return DocumentsContract.deleteDocument((ContentResolver)contentResolver, (Uri)uri);
        }

        static String getDocumentId(Uri uri) {
            return DocumentsContract.getDocumentId((Uri)uri);
        }

        static boolean isDocumentUri(Context context, Uri uri) {
            return DocumentsContract.isDocumentUri((Context)context, (Uri)uri);
        }
    }

    private static class DocumentsContractApi21Impl {
        private DocumentsContractApi21Impl() {
        }

        static Uri buildChildDocumentsUri(String string2, String string3) {
            return DocumentsContract.buildChildDocumentsUri((String)string2, (String)string3);
        }

        static Uri buildChildDocumentsUriUsingTree(Uri uri, String string2) {
            return DocumentsContract.buildChildDocumentsUriUsingTree((Uri)uri, (String)string2);
        }

        static Uri buildDocumentUriUsingTree(Uri uri, String string2) {
            return DocumentsContract.buildDocumentUriUsingTree((Uri)uri, (String)string2);
        }

        public static Uri buildTreeDocumentUri(String string2, String string3) {
            return DocumentsContract.buildTreeDocumentUri((String)string2, (String)string3);
        }

        static Uri createDocument(ContentResolver contentResolver, Uri uri, String string2, String string3) throws FileNotFoundException {
            return DocumentsContract.createDocument((ContentResolver)contentResolver, (Uri)uri, (String)string2, (String)string3);
        }

        static String getTreeDocumentId(Uri uri) {
            return DocumentsContract.getTreeDocumentId((Uri)uri);
        }

        static Uri renameDocument(ContentResolver contentResolver, Uri uri, String string2) throws FileNotFoundException {
            return DocumentsContract.renameDocument((ContentResolver)contentResolver, (Uri)uri, (String)string2);
        }
    }

    private static class DocumentsContractApi24Impl {
        private DocumentsContractApi24Impl() {
        }

        static boolean isTreeUri(Uri uri) {
            return DocumentsContract.isTreeUri((Uri)uri);
        }

        static boolean removeDocument(ContentResolver contentResolver, Uri uri, Uri uri2) throws FileNotFoundException {
            return DocumentsContract.removeDocument((ContentResolver)contentResolver, (Uri)uri, (Uri)uri2);
        }
    }
}

