/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class FontProvider {
    private static final Comparator<byte[]> sByteArrayComparator = new Comparator<byte[]>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int compare(byte[] byArray, byte[] byArray2) {
            int n;
            int n2;
            if (byArray.length != byArray2.length) {
                n2 = byArray.length;
                n = byArray2.length;
                return n2 - n;
            }
            for (n2 = 0; n2 < byArray.length; ++n2) {
                if (byArray[n2] == byArray2[n2]) continue;
                int n3 = byArray[n2];
                n = byArray2[n2];
                n2 = n3;
                return n2 - n;
            }
            return 0;
        }
    };

    private FontProvider() {
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatureArray) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i < signatureArray.length; ++i) {
            arrayList.add(signatureArray[i].toByteArray());
        }
        return arrayList;
    }

    private static boolean equalsByteArrayList(List<byte[]> list, List<byte[]> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (Arrays.equals(list.get(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<List<byte[]>> getCertificates(FontRequest fontRequest, Resources resources) {
        if (fontRequest.getCertificates() != null) {
            return fontRequest.getCertificates();
        }
        return FontResourcesParserCompat.readCerts(resources, fontRequest.getCertificatesArrayResId());
    }

    static FontsContractCompat.FontFamilyResult getFontFamilyResult(Context context, FontRequest fontRequest, CancellationSignal cancellationSignal) throws PackageManager.NameNotFoundException {
        ProviderInfo providerInfo = FontProvider.getProvider(context.getPackageManager(), fontRequest, context.getResources());
        if (providerInfo == null) {
            return FontsContractCompat.FontFamilyResult.create(1, null);
        }
        return FontsContractCompat.FontFamilyResult.create(0, FontProvider.query(context, fontRequest, providerInfo.authority, cancellationSignal));
    }

    static ProviderInfo getProvider(PackageManager object, FontRequest object2, Resources object3) throws PackageManager.NameNotFoundException {
        String string2 = ((FontRequest)object2).getProviderAuthority();
        ProviderInfo providerInfo = object.resolveContentProvider(string2, 0);
        if (providerInfo != null) {
            if (providerInfo.packageName.equals(((FontRequest)object2).getProviderPackage())) {
                object = FontProvider.convertToByteArrayList(object.getPackageInfo((String)providerInfo.packageName, (int)64).signatures);
                Collections.sort(object, sByteArrayComparator);
                object2 = FontProvider.getCertificates((FontRequest)object2, object3);
                for (int i = 0; i < object2.size(); ++i) {
                    object3 = new ArrayList((Collection)object2.get(i));
                    Collections.sort(object3, sByteArrayComparator);
                    if (!FontProvider.equalsByteArrayList((List<byte[]>)object, (List<byte[]>)object3)) continue;
                    return providerInfo;
                }
                return null;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append("Found content provider ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(", but package was not ");
            ((StringBuilder)object).append(((FontRequest)object2).getProviderPackage());
            throw new PackageManager.NameNotFoundException(((StringBuilder)object).toString());
        }
        object = new StringBuilder();
        ((StringBuilder)object).append("No package found for authority: ");
        ((StringBuilder)object).append(string2);
        throw new PackageManager.NameNotFoundException(((StringBuilder)object).toString());
    }

    static FontsContractCompat.FontInfo[] query(Context context, FontRequest object, String string2, CancellationSignal object2) {
        block35: {
            Uri uri;
            Uri uri2;
            Object object3;
            block34: {
                String[] stringArray;
                Object var7_8;
                block33: {
                    object3 = new ArrayList();
                    uri2 = new Uri.Builder().scheme("content").authority(string2).build();
                    uri = new Uri.Builder().scheme("content").authority(string2).appendPath("file").build();
                    var7_8 = null;
                    string2 = var7_8;
                    stringArray = new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"};
                    string2 = var7_8;
                    if (Build.VERSION.SDK_INT <= 16) break block33;
                    string2 = var7_8;
                    context = context.getContentResolver().query(uri2, stringArray, "query = ?", new String[]{((FontRequest)object).getQuery()}, null, (CancellationSignal)object2);
                    break block34;
                }
                string2 = var7_8;
                try {
                    context = context.getContentResolver().query(uri2, stringArray, "query = ?", new String[]{((FontRequest)object).getQuery()}, null);
                }
                catch (Throwable throwable) {
                    if (string2 != null) {
                        string2.close();
                    }
                    throw throwable;
                }
            }
            object = object3;
            if (context != null) {
                object = object3;
                string2 = context;
                if (context.getCount() <= 0) break block35;
                string2 = context;
                int n = context.getColumnIndex("result_code");
                string2 = context;
                string2 = context;
                object2 = new ArrayList();
                string2 = context;
                int n2 = context.getColumnIndex("_id");
                string2 = context;
                int n3 = context.getColumnIndex("file_id");
                string2 = context;
                int n4 = context.getColumnIndex("font_ttc_index");
                string2 = context;
                int n5 = context.getColumnIndex("font_weight");
                string2 = context;
                int n6 = context.getColumnIndex("font_italic");
                while (true) {
                    boolean bl;
                    int n7;
                    int n8;
                    int n9;
                    block39: {
                        block38: {
                            block37: {
                                block36: {
                                    string2 = context;
                                    if (!context.moveToNext()) break;
                                    if (n == -1) break block36;
                                    string2 = context;
                                    n9 = context.getInt(n);
                                    break block37;
                                }
                                n9 = 0;
                            }
                            if (n4 != -1) {
                                string2 = context;
                                n8 = context.getInt(n4);
                            } else {
                                n8 = 0;
                            }
                            if (n3 == -1) {
                                string2 = context;
                                object = ContentUris.withAppendedId((Uri)uri2, (long)context.getLong(n2));
                            } else {
                                string2 = context;
                                object = ContentUris.withAppendedId((Uri)uri, (long)context.getLong(n3));
                            }
                            if (n5 != -1) {
                                string2 = context;
                                n7 = context.getInt(n5);
                            } else {
                                n7 = 400;
                            }
                            if (n6 != -1) {
                                string2 = context;
                                if (context.getInt(n6) != 1) break block38;
                                bl = true;
                                break block39;
                            }
                        }
                        bl = false;
                    }
                    string2 = context;
                    ((ArrayList)object2).add(FontsContractCompat.FontInfo.create((Uri)object, n8, n7, bl, n9));
                    continue;
                    break;
                }
                object = object2;
            }
        }
        if (context != null) {
            context.close();
        }
        return ((ArrayList)object).toArray(new FontsContractCompat.FontInfo[0]);
    }
}

