/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.provider.CallbackWithHandler;
import androidx.core.provider.FontProvider;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import androidx.core.provider.RequestExecutor;
import androidx.core.util.Consumer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class FontRequestWorker {
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE;
    static final Object LOCK;
    static final SimpleArrayMap<String, ArrayList<Consumer<TypefaceResult>>> PENDING_REPLIES;
    static final LruCache<String, Typeface> sTypefaceCache;

    static {
        sTypefaceCache = new LruCache(16);
        DEFAULT_EXECUTOR_SERVICE = RequestExecutor.createDefaultExecutor("fonts-androidx", 10, 10000);
        LOCK = new Object();
        PENDING_REPLIES = new SimpleArrayMap();
    }

    private FontRequestWorker() {
    }

    private static String createCacheId(FontRequest fontRequest, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(fontRequest.getId());
        stringBuilder.append("-");
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    private static int getFontFamilyResultStatus(FontsContractCompat.FontFamilyResult fontInfoArray) {
        int n = fontInfoArray.getStatusCode();
        int n2 = -3;
        int n3 = 1;
        if (n != 0) {
            if (fontInfoArray.getStatusCode() != 1) {
                return -3;
            }
            return -2;
        }
        fontInfoArray = fontInfoArray.getFonts();
        n = n3;
        if (fontInfoArray != null) {
            if (fontInfoArray.length == 0) {
                n = n3;
            } else {
                int n4 = fontInfoArray.length;
                int n5 = 0;
                n3 = 0;
                while (true) {
                    n = n5;
                    if (n3 >= n4) break;
                    n = fontInfoArray[n3].getResultCode();
                    if (n != 0) {
                        if (n < 0) {
                            n = n2;
                        }
                        return n;
                    }
                    ++n3;
                }
            }
        }
        return n;
    }

    static TypefaceResult getFontSync(String string2, Context context, FontRequest object, int n) {
        LruCache<String, Typeface> lruCache = sTypefaceCache;
        Typeface typeface = lruCache.get(string2);
        if (typeface != null) {
            return new TypefaceResult(typeface);
        }
        try {
            object = FontProvider.getFontFamilyResult(context, (FontRequest)object, null);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return new TypefaceResult(-1);
        }
        int n2 = FontRequestWorker.getFontFamilyResultStatus((FontsContractCompat.FontFamilyResult)object);
        if (n2 != 0) {
            return new TypefaceResult(n2);
        }
        if ((context = TypefaceCompat.createFromFontInfo(context, null, ((FontsContractCompat.FontFamilyResult)object).getFonts(), n)) != null) {
            lruCache.put(string2, (Typeface)context);
            return new TypefaceResult((Typeface)context);
        }
        return new TypefaceResult(-3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Typeface requestFontAsync(final Context object, FontRequest object2, int n, Executor executor, CallbackWithHandler object3) {
        final String string2 = FontRequestWorker.createCacheId((FontRequest)object2, n);
        Object object4 = sTypefaceCache.get(string2);
        if (object4 != null) {
            ((CallbackWithHandler)object3).onTypefaceResult(new TypefaceResult((Typeface)object4));
            return object4;
        }
        object4 = new Consumer<TypefaceResult>((CallbackWithHandler)object3){
            final /* synthetic */ CallbackWithHandler val$callback;
            {
                this.val$callback = callbackWithHandler;
            }

            @Override
            public void accept(TypefaceResult typefaceResult) {
                TypefaceResult typefaceResult2 = typefaceResult;
                if (typefaceResult == null) {
                    typefaceResult2 = new TypefaceResult(-3);
                }
                this.val$callback.onTypefaceResult(typefaceResult2);
            }
        };
        object3 = LOCK;
        synchronized (object3) {
            SimpleArrayMap<String, ArrayList<Consumer<TypefaceResult>>> simpleArrayMap = PENDING_REPLIES;
            ArrayList<Typeface> arrayList = simpleArrayMap.get(string2);
            if (arrayList != null) {
                arrayList.add((Typeface)object4);
                return null;
            }
            arrayList = new ArrayList<Typeface>();
            arrayList.add((Typeface)object4);
            simpleArrayMap.put(string2, arrayList);
        }
        object2 = new Callable<TypefaceResult>((FontRequest)object2, n){
            final /* synthetic */ FontRequest val$request;
            final /* synthetic */ int val$style;
            {
                this.val$request = fontRequest;
                this.val$style = n;
            }

            @Override
            public TypefaceResult call() {
                try {
                    TypefaceResult typefaceResult = FontRequestWorker.getFontSync(string2, object, this.val$request, this.val$style);
                    return typefaceResult;
                }
                catch (Throwable throwable) {
                    return new TypefaceResult(-3);
                }
            }
        };
        object = executor;
        if (executor == null) {
            object = DEFAULT_EXECUTOR_SERVICE;
        }
        RequestExecutor.execute((Executor)object, object2, new Consumer<TypefaceResult>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void accept(TypefaceResult typefaceResult) {
                ArrayList<Consumer<TypefaceResult>> arrayList;
                Object object = LOCK;
                synchronized (object) {
                    arrayList = PENDING_REPLIES.get(string2);
                    if (arrayList == null) {
                        return;
                    }
                    PENDING_REPLIES.remove(string2);
                }
                int n = 0;
                while (n < arrayList.size()) {
                    arrayList.get(n).accept(typefaceResult);
                    ++n;
                }
                return;
            }
        });
        return null;
    }

    static Typeface requestFontSync(final Context object, final FontRequest fontRequest, CallbackWithHandler callbackWithHandler, final int n, int n2) {
        final String string2 = FontRequestWorker.createCacheId(fontRequest, n);
        Typeface typeface = sTypefaceCache.get(string2);
        if (typeface != null) {
            callbackWithHandler.onTypefaceResult(new TypefaceResult(typeface));
            return typeface;
        }
        if (n2 == -1) {
            object = FontRequestWorker.getFontSync(string2, object, fontRequest, n);
            callbackWithHandler.onTypefaceResult((TypefaceResult)object);
            return object.mTypeface;
        }
        object = new Callable<TypefaceResult>(){

            @Override
            public TypefaceResult call() {
                return FontRequestWorker.getFontSync(string2, object, fontRequest, n);
            }
        };
        try {
            object = (TypefaceResult)RequestExecutor.submit(DEFAULT_EXECUTOR_SERVICE, object, n2);
            callbackWithHandler.onTypefaceResult((TypefaceResult)object);
            object = object.mTypeface;
            return object;
        }
        catch (InterruptedException interruptedException) {
            callbackWithHandler.onTypefaceResult(new TypefaceResult(-3));
            return null;
        }
    }

    static void resetTypefaceCache() {
        sTypefaceCache.evictAll();
    }

    static final class TypefaceResult {
        final int mResult;
        final Typeface mTypeface;

        TypefaceResult(int n) {
            this.mTypeface = null;
            this.mResult = n;
        }

        TypefaceResult(Typeface typeface) {
            this.mTypeface = typeface;
            this.mResult = 0;
        }

        boolean isSuccess() {
            boolean bl = this.mResult == 0;
            return bl;
        }
    }
}

