/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.telephony;

import android.os.Build;
import android.telephony.SubscriptionManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class SubscriptionManagerCompat {
    private static Method sGetSlotIndexMethod;

    private SubscriptionManagerCompat() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getSlotIndex(int n) {
        Integer n2;
        if (n == -1) {
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return Api29Impl.getSlotIndex(n);
        }
        if (sGetSlotIndexMethod == null) {
            sGetSlotIndexMethod = Build.VERSION.SDK_INT >= 26 ? SubscriptionManager.class.getDeclaredMethod("getSlotIndex", Integer.TYPE) : SubscriptionManager.class.getDeclaredMethod("getSlotId", Integer.TYPE);
            sGetSlotIndexMethod.setAccessible(true);
        }
        if ((n2 = (Integer)sGetSlotIndexMethod.invoke(null, n)) == null) return -1;
        try {
            return n2;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return -1;
        }
    }

    private static class Api29Impl {
        private Api29Impl() {
        }

        static int getSlotIndex(int n) {
            return SubscriptionManager.getSlotIndex((int)n);
        }
    }
}

