/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.telephony;

import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.core.telephony.SubscriptionManagerCompat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TelephonyManagerCompat {
    private static Method sGetDeviceIdMethod;
    private static Method sGetSubIdMethod;

    private TelephonyManagerCompat() {
    }

    public static String getImei(TelephonyManager object) {
        int n;
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getImei(object);
        }
        if (Build.VERSION.SDK_INT >= 22 && (n = TelephonyManagerCompat.getSubscriptionId(object)) != Integer.MAX_VALUE && n != -1) {
            n = SubscriptionManagerCompat.getSlotIndex(n);
            if (Build.VERSION.SDK_INT >= 23) {
                return Api23Impl.getDeviceId(object, n);
            }
            try {
                if (sGetDeviceIdMethod == null) {
                    Method method;
                    sGetDeviceIdMethod = method = TelephonyManager.class.getDeclaredMethod("getDeviceId", Integer.TYPE);
                    method.setAccessible(true);
                }
                object = (String)sGetDeviceIdMethod.invoke(object, n);
                return object;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                return null;
            }
        }
        return object.getDeviceId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getSubscriptionId(TelephonyManager object) {
        if (Build.VERSION.SDK_INT >= 30) {
            return Api30Impl.getSubscriptionId((TelephonyManager)object);
        }
        if (Build.VERSION.SDK_INT < 22) return Integer.MAX_VALUE;
        if (sGetSubIdMethod == null) {
            Method method;
            sGetSubIdMethod = method = TelephonyManager.class.getDeclaredMethod("getSubId", new Class[0]);
            method.setAccessible(true);
        }
        if ((object = (Integer)sGetSubIdMethod.invoke(object, new Object[0])) == null) return Integer.MAX_VALUE;
        try {
            if ((Integer)object == -1) return Integer.MAX_VALUE;
            return (Integer)object;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return Integer.MAX_VALUE;
        }
    }

    private static class Api23Impl {
        private Api23Impl() {
        }

        static String getDeviceId(TelephonyManager telephonyManager, int n) {
            return telephonyManager.getDeviceId(n);
        }
    }

    private static class Api26Impl {
        private Api26Impl() {
        }

        static String getImei(TelephonyManager telephonyManager) {
            return telephonyManager.getImei();
        }
    }

    private static class Api30Impl {
        private Api30Impl() {
        }

        static int getSubscriptionId(TelephonyManager telephonyManager) {
            return telephonyManager.getSubscriptionId();
        }
    }
}

